/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.doomsday;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.stats.StatBase;
import tragicneko.tragicmc.TragicAchievements;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.doomsday.Doomsday;
import tragicneko.tragicmc.doomsday.DoomsdayManager;
import tragicneko.tragicmc.properties.PropertyDoom;

public class DoomsdayEffect {
    public final Doomsday dday;
    public final EntityPlayer player;
    public int timeBetweenUpdates;
    public final boolean isInstant;
    public final boolean isCommandActivated;
    public final PropertyDoom doom;
    public boolean isActive;
    public boolean crucMoment;
    public int iterations;
    public int inheritedCooldown;
    public final Random rand;
    public List utilityList;
    public Entity utilityEntity;
    public boolean utilityFlag;
    public int utilityInt;
    public int sneakTicks;

    public DoomsdayEffect(int id, PropertyDoom doom) {
        this(id, doom, false);
    }

    public DoomsdayEffect(int id, PropertyDoom doom, boolean commandActive) {
        this.dday = Doomsday.getDoomsdayFromId(id);
        this.rand = Doomsday.rand;
        this.doom = doom;
        this.player = doom.getPlayer();
        this.isInstant = !(this.dday instanceof Doomsday.IExtendedDoomsday);
        this.timeBetweenUpdates = this.dday instanceof Doomsday.IExtendedDoomsday ? ((Doomsday.IExtendedDoomsday)((Object)this.dday)).getWaitTime() : 0;
        this.isActive = true;
        this.crucMoment = false;
        this.isCommandActivated = commandActive;
        this.iterations = 0;
        this.utilityList = new ArrayList();
        this.utilityFlag = false;
        this.utilityEntity = null;
        this.utilityInt = 0;
    }

    public DoomsdayEffect inheritCooldown(DoomsdayEffect ext, DoomsdayEffect ins) {
        this.inheritedCooldown = ext.iterations * ext.dday.getScaledCooldown(this.player.field_70170_p.field_73013_u) + ins.dday.cooldown;
        return this;
    }

    public void onDoomsdayUpdate() {
        if (this.iterations >= (this.dday instanceof Doomsday.IExtendedDoomsday ? ((Doomsday.IExtendedDoomsday)((Object)this.dday)).getMaxIterations() : 1) || this.player == null || this.player.func_110143_aJ() <= 0.0f) {
            this.isActive = false;
            return;
        }
        if (this.sneakTicks >= 10) {
            this.isActive = false;
        }
        if (this.doom.getPlayer().func_70093_af() && !this.isInstant) {
            ++this.sneakTicks;
            return;
        }
        if (this.sneakTicks > 0) {
            this.sneakTicks = 0;
        }
        if (this.timeBetweenUpdates > 0 && !this.isInstant) {
            --this.timeBetweenUpdates;
        }
        if (this.timeBetweenUpdates == 0) {
            if (TragicConfig.allowCrucialMoments) {
                boolean bl = this.crucMoment = this.rand.nextInt(100) <= TragicConfig.crucialMomentChance;
            }
            if (TragicConfig.allowAchievements && this.crucMoment) {
                this.player.func_71029_a((StatBase)TragicAchievements.doomCritical);
            }
            try {
                if (this.iterations == 0) {
                    this.dday.doInitialEffects(this, this.doom, this.player, this.crucMoment);
                }
                if (this.isCommandActivated) {
                    this.dday.useDoomsday(this, this.doom, this.player, this.crucMoment);
                    ++this.iterations;
                    this.timeBetweenUpdates = this.dday instanceof Doomsday.IExtendedDoomsday ? ((Doomsday.IExtendedDoomsday)((Object)this.dday)).getWaitTime() : 0;
                } else if (this.dday.doesCurrentDoomMeetRequirement(this.doom)) {
                    this.dday.useDoomsday(this, this.doom, this.player, this.crucMoment);
                    if (this.isInstant) {
                        this.isActive = false;
                    }
                    ++this.iterations;
                    this.timeBetweenUpdates = this.dday instanceof Doomsday.IExtendedDoomsday ? ((Doomsday.IExtendedDoomsday)((Object)this.dday)).getWaitTime() : 0;
                } else {
                    this.isActive = false;
                }
            }
            catch (Exception e) {
                DoomsdayManager.logger.info("Exception thrown while updating a DoomsdayEffect for Doomsday: " + this.dday + ", it has been aborted to prevent a crash. Displaying stack trace.");
                DoomsdayManager.logger.catching((Throwable)e);
                this.isActive = false;
            }
        }
    }

    public boolean equals(DoomsdayEffect effect) {
        return this.equals(effect) || effect.dday == this.dday;
    }
}

