/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.client;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundCategory;
import net.minecraft.server.gui.IUpdatePlayerListBox;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.client.event.sound.PlaySoundEvent17;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.dimension.SynapseWorldProvider;
import tragicneko.tragicmc.dimension.TragicWorldProvider;
import tragicneko.tragicmc.entity.alpha.EntityOverlordCore;

public class TragicMusicTicker
implements IUpdatePlayerListBox {
    private final Minecraft mc;
    private Random rand = new Random();
    private ISound currentTrack;
    private int buffer = 100;
    public static TragicMusic collisionTrack = new TragicMusic(new ResourceLocation("tragicmc:music.dimension.bog"), 200, 800);
    public static TragicMusic collisionCreative = new TragicMusic(new ResourceLocation("tragicmc:music.dimension.catacombs"), 1200, 3600);
    public static TragicMusic synapseTrack = new TragicMusic(new ResourceLocation("tragicmc:music.dimension.sanctuary"), 200, 600);
    public static TragicMusic synapseOverlord = new TragicMusic(new ResourceLocation("tragicmc:music.dimension.prime"), 0, 0);

    public TragicMusicTicker(Minecraft mc) {
        this.mc = mc;
    }

    public void func_73660_a() {
        MusicTicker.MusicType musictype = this.mc.func_147109_W();
        if (this.mc.field_71441_e != null) {
            WorldProvider prov = this.mc.field_71441_e.field_73011_w;
            TragicMusic music = null;
            if (TragicConfig.allowDimensionalMusic) {
                if (prov instanceof TragicWorldProvider) {
                    music = musictype == MusicTicker.MusicType.GAME ? collisionTrack : collisionCreative;
                } else if (prov instanceof SynapseWorldProvider) {
                    TragicMusic tragicMusic = this.mc.field_71439_g != null && !this.mc.field_71441_e.func_72872_a(EntityOverlordCore.class, this.mc.field_71439_g.field_70121_D.func_72314_b(120.0, 128.0, 120.0)).isEmpty() ? synapseOverlord : (music = musictype == MusicTicker.MusicType.GAME ? synapseTrack : collisionCreative);
                }
            }
            if (music == null) {
                return;
            }
            if (this.currentTrack != null) {
                if (!this.currentTrack.func_147650_b().equals((Object)music.loc)) {
                    this.mc.func_147118_V().func_147683_b(this.currentTrack);
                    this.buffer = MathHelper.func_76136_a((Random)this.rand, (int)0, (int)(music.min / 2));
                }
                if (!this.mc.func_147118_V().func_147692_c(this.currentTrack)) {
                    this.currentTrack = null;
                    this.buffer = Math.min(MathHelper.func_76136_a((Random)this.rand, (int)music.min, (int)music.max), this.buffer);
                }
            }
            if (this.currentTrack == null && this.buffer-- <= 0 && this.mc.field_71474_y.func_151438_a(SoundCategory.MUSIC) > 0.0f && this.mc.field_71474_y.func_151438_a(SoundCategory.MASTER) > 0.0f) {
                this.currentTrack = PositionedSoundRecord.func_147673_a((ResourceLocation)music.loc);
                this.mc.func_147118_V().func_147682_a(this.currentTrack);
                this.buffer = Integer.MAX_VALUE;
            }
        }
    }

    @SubscribeEvent
    public void overrideSound(PlaySoundEvent17 event) {
        MusicTicker.MusicType musictype = this.mc.func_147109_W();
        if (event.sound.func_147650_b().equals((Object)musictype.func_148635_a()) && this.mc.field_71441_e != null && (this.mc.field_71441_e.field_73011_w instanceof TragicWorldProvider || this.mc.field_71441_e.field_73011_w instanceof SynapseWorldProvider)) {
            event.result = null;
        }
    }

    public static class TragicMusic {
        public final ResourceLocation loc;
        public final int min;
        public final int max;

        public TragicMusic(ResourceLocation loc, int minBuf, int maxBuf) {
            this.loc = loc;
            this.min = minBuf;
            this.max = maxBuf;
        }
    }
}

