/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.adinferos.worldgen;

import com.superdextor.adinferos.blocks.BlockNetherLeaf;
import com.superdextor.adinferos.blocks.BlockNetherLog;
import com.superdextor.adinferos.blocks.BlockNetherPlanks;
import com.superdextor.adinferos.init.NetherBlocks;
import com.superdextor.thinkbigcore.worldgen.IOverridable;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;

public class WorldGenAshTree
extends WorldGenAbstractTree
implements IOverridable {
    private static final IBlockState log = NetherBlocks.log.func_176223_P().func_177226_a(BlockNetherLog.VARIANT, (Comparable)((Object)BlockNetherPlanks.EnumType.ASH));
    private static final IBlockState leaves = NetherBlocks.leaves.func_176223_P().func_177226_a(BlockNetherLeaf.VARIANT, (Comparable)((Object)BlockNetherPlanks.EnumType.ASH)).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
    private int hasLeaves = -1;
    public boolean doOverride = false;

    public WorldGenAshTree(boolean notify, boolean hasLeaves) {
        super(notify);
        this.hasLeaves = hasLeaves ? 1 : 0;
    }

    public WorldGenAshTree(boolean notify) {
        super(notify);
        this.hasLeaves = -1;
    }

    public void doOverride() {
        this.doOverride = true;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        int i = rand.nextInt(3) + 5;
        int hasLeaves = this.hasLeaves;
        if (hasLeaves == -1) {
            hasLeaves = rand.nextInt(2);
        }
        boolean flag = true;
        if (!this.doOverride || position.func_177956_o() >= 1 && position.func_177956_o() + i + 1 <= 256) {
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + i; ++j) {
                int k = 1;
                if (j == position.func_177956_o()) {
                    k = 0;
                }
                if (j >= position.func_177956_o() + 1 + i - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.func_72800_K()) {
                            if (this.isReplaceable(worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!this.doOverride && !flag) {
                return false;
            }
            BlockPos down = position.func_177977_b();
            IBlockState state = worldIn.func_180495_p(down);
            Block block = state.func_177230_c();
            if (!this.doOverride && block != Blocks.field_150424_aL && block != Blocks.field_150425_aM && block != NetherBlocks.darkstone && block != NetherBlocks.dark_sand && block != NetherBlocks.gold_ore && block != NetherBlocks.dimensional_ore && block != NetherBlocks.netherite_ore && block != NetherBlocks.wither_ore && block != Blocks.field_150449_bY) {
                return false;
            }
            if (this.doOverride || position.func_177956_o() < worldIn.func_72800_K() - i - 1) {
                state.func_177230_c().onPlantGrow(state, worldIn, down, position);
                if (hasLeaves == 1) {
                    for (int i2 = position.func_177956_o() - 3 + i; i2 <= position.func_177956_o() + i; ++i2) {
                        int k2 = i2 - (position.func_177956_o() + i);
                        int l2 = 1 - k2 / 2;
                        for (int i3 = position.func_177958_n() - l2; i3 <= position.func_177958_n() + l2; ++i3) {
                            int j1 = i3 - position.func_177958_n();
                            for (int k1 = position.func_177952_p() - l2; k1 <= position.func_177952_p() + l2; ++k1) {
                                BlockPos blockpos;
                                IBlockState state2;
                                int l1 = k1 - position.func_177952_p();
                                if (Math.abs(j1) == l2 && Math.abs(l1) == l2 && (rand.nextInt(2) == 0 || k2 == 0) || !(state2 = worldIn.func_180495_p(blockpos = new BlockPos(i3, i2, k1))).func_177230_c().isAir(state2, (IBlockAccess)worldIn, blockpos) && !state2.func_177230_c().isAir(state2, (IBlockAccess)worldIn, blockpos)) continue;
                                this.func_175903_a(worldIn, blockpos, leaves);
                            }
                        }
                    }
                } else {
                    for (int s = rand.nextInt(4); s > 0; --s) {
                        IBlockState sideLog;
                        int h = i - rand.nextInt(3) - 1;
                        if (rand.nextBoolean()) {
                            sideLog = log.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Z);
                            this.func_175903_a(worldIn, position.func_177982_a(0, h, rand.nextBoolean() ? 1 : -1), sideLog);
                            continue;
                        }
                        sideLog = log.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.X);
                        this.func_175903_a(worldIn, position.func_177982_a(rand.nextBoolean() ? 1 : -1, h, 0), sideLog);
                    }
                }
                for (int j2 = 0; j2 < i; ++j2) {
                    BlockPos upN = position.func_177981_b(j2);
                    IBlockState state2 = worldIn.func_180495_p(upN);
                    if (!state2.func_177230_c().isAir(state2, (IBlockAccess)worldIn, upN) && !state2.func_177230_c().isLeaves(state2, (IBlockAccess)worldIn, upN)) continue;
                    this.func_175903_a(worldIn, position.func_177981_b(j2), log);
                }
                this.doOverride = false;
                return true;
            }
            return false;
        }
        return false;
    }
}

