/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.adinferos.world;

import com.superdextor.adinferos.config.NetherConfig;
import com.superdextor.adinferos.entity.monster.EntityBlackWidow;
import com.superdextor.adinferos.entity.monster.EntityCurse;
import com.superdextor.adinferos.entity.monster.EntityGhost;
import com.superdextor.adinferos.entity.monster.EntityGlowstoneSkeleton;
import com.superdextor.adinferos.entity.monster.EntityHerobrine;
import com.superdextor.adinferos.entity.monster.EntityInfernumAvis;
import com.superdextor.adinferos.entity.monster.EntityObsidianSheepman;
import com.superdextor.adinferos.entity.monster.EntityPhantom;
import com.superdextor.adinferos.entity.monster.EntityReaper;
import com.superdextor.adinferos.entity.monster.EntitySkeletonHorse;
import com.superdextor.adinferos.entity.other.EntityInfernalChicken;
import com.superdextor.adinferos.worldgen.WorldGenBigPurpleMushroom;
import com.superdextor.adinferos.worldgen.WorldGenInfernoTree;
import com.superdextor.adinferos.worldgen.WorldGenPiggyHouse;
import com.superdextor.adinferos.worldgen.WorldGenPurpleMushrooms;
import java.util.Random;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenFire;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BiomeGenNether
extends BiomeGenBase {
    public BiomeGenNether() {
        super(new BiomeGenBase.BiomeProperties("Overworld Nether").func_185396_a().func_185402_a(0xFF007F));
        this.field_76752_A = Blocks.field_150424_aL.func_176223_P();
        this.field_76753_B = Blocks.field_150424_aL.func_176223_P();
        this.field_76761_J.clear();
        this.field_76762_K.clear();
        this.field_76755_L.clear();
        this.field_82914_M.clear();
        this.field_76760_I.field_76808_K = false;
        this.field_76760_I.field_76832_z = -999;
        this.field_76760_I.field_76802_A = -999;
        this.field_76760_I.field_76803_B = -999;
        this.field_76760_I.field_76801_G = -999;
        this.field_76760_I.field_76805_H = -999;
        this.field_76760_I.field_76806_I = -999;
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityGhast.class, 10, 4, 4));
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityPigZombie.class, 50, 4, 4));
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityMagmaCube.class, 10, 4, 4));
        if (NetherConfig.blackWidowSpawnWeight > 0 && NetherConfig.blackWidowBiomes.contains("OVERWORLDN")) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityBlackWidow.class, NetherConfig.blackWidowSpawnWeight, 1, 3));
        }
        if (NetherConfig.curseSpawnWeight > 0 && NetherConfig.curseBiomes.contains("OVERWORLDN")) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityCurse.class, NetherConfig.curseSpawnWeight, 1, 2));
        }
        if (NetherConfig.ghostSpawnWeight > 0 && NetherConfig.ghostBiomes.contains("OVERWORLDN")) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityGhost.class, NetherConfig.ghostSpawnWeight, 1, 3));
        }
        if (NetherConfig.glowstoneSkeletonSpawnWeight > 0 && NetherConfig.glowstoneSkeletonBiomes.contains("OVERWORLDN")) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityGlowstoneSkeleton.class, NetherConfig.glowstoneSkeletonSpawnWeight, 4, 4));
        }
        if (NetherConfig.herobrineSpawnWeight > 0 && NetherConfig.herobrineBiomes.contains("OVERWORLDN")) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityHerobrine.class, NetherConfig.herobrineSpawnWeight, 1, 1));
        }
        if (NetherConfig.infernumAvisSpawnWeight > 0 && NetherConfig.infernumAvisBiomes.contains("OVERWORLDN")) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityInfernumAvis.class, NetherConfig.infernumAvisSpawnWeight, 1, 1));
        }
        if (NetherConfig.infernalChickenSpawnWeight > 0 && NetherConfig.infernalChickenBiomes.contains("OVERWORLDN")) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityInfernalChicken.class, NetherConfig.infernalChickenSpawnWeight, 1, 4));
        }
        if (NetherConfig.phantomSpawnWeight > 0 && NetherConfig.phantomBiomes.contains("OVERWORLDN")) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityPhantom.class, NetherConfig.phantomSpawnWeight, 6, 10));
        }
        if (NetherConfig.reaperSpawnWeight > 0 && NetherConfig.reaperBiomes.contains("OVERWORLDN")) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityReaper.class, NetherConfig.reaperSpawnWeight, 1, 1));
        }
        if (NetherConfig.sheepmanSpawnWeight > 0 && NetherConfig.sheepmanBiomes.contains("OVERWORLDN")) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityObsidianSheepman.class, NetherConfig.sheepmanSpawnWeight, 6, 16));
        }
        if (NetherConfig.skeletonHorseSpawnWeight > 0 && NetherConfig.skeletonHorseBiomes.contains("OVERWORLDN")) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntitySkeletonHorse.class, NetherConfig.skeletonHorseSpawnWeight, 4, 7));
        }
    }

    public void func_180624_a(World world, Random rand, BlockPos pos) {
        int i;
        int k;
        NetherConfig.printDebugInfo("Overworld Nether: Providing Chuck: " + pos.func_177958_n() / 16 + "/" + pos.func_177952_p() / 16);
        if (NetherConfig.genInfernoTreesChance > 0.0f) {
            k = (int)(10.0f * NetherConfig.genInfernoTreesChance);
            for (i = 0; i < k; ++i) {
                new WorldGenInfernoTree(false).func_180709_b(world, rand, pos.func_177982_a(rand.nextInt(16), 40 + rand.nextInt(30), rand.nextInt(16)));
            }
        }
        if (rand.nextFloat() < NetherConfig.genPurpleMushroomChance) {
            new WorldGenPurpleMushrooms().func_180709_b(world, rand, pos.func_177982_a(rand.nextInt(16), 40 + rand.nextInt(30), rand.nextInt(16)));
        }
        if (NetherConfig.genLargePurpleMushroomChance > 0.0f) {
            k = (int)(10.0f * NetherConfig.genLargePurpleMushroomChance);
            for (i = 0; i < k; ++i) {
                new WorldGenBigPurpleMushroom().func_180709_b(world, rand, pos.func_177982_a(rand.nextInt(16), 40 + rand.nextInt(30), rand.nextInt(16)));
            }
        }
        if (NetherConfig.genPiggyHouseChance > 0.0f) {
            k = (int)(10.0f * NetherConfig.genPiggyHouseChance);
            for (i = 0; i < k; ++i) {
                new WorldGenPiggyHouse().func_180709_b(world, rand, pos.func_177982_a(rand.nextInt(16), 40 + rand.nextInt(30), rand.nextInt(16)));
            }
        }
        int k2 = pos.func_177958_n();
        int l = pos.func_177952_p();
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int j = 0; j < 4; ++j) {
                if (!(rand.nextFloat() < 0.02f)) continue;
                k2 = i2 * 4 + 1 + 8 + rand.nextInt(3);
                l = j * 4 + 1 + 8 + rand.nextInt(3);
                BlockPos blockpos1 = world.func_175645_m(pos.func_177982_a(k2, 0, l));
                WorldGenFire tree = new WorldGenFire();
                tree.func_180709_b(world, rand, blockpos1);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180627_b(BlockPos p_180627_1_) {
        return 8334095;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180625_c(BlockPos p_180625_1_) {
        return 8334095;
    }

    public int getWaterColorMultiplier() {
        return 0xFF007F;
    }

    public int getModdedBiomeGrassColor(int original) {
        return 8334095;
    }

    public int getModdedBiomeFoliageColor(int original) {
        return 8334095;
    }
}

