/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.adinferos.proxy;

import com.google.common.base.Predicate;
import com.superdextor.adinferos.AdInferosCore;
import com.superdextor.adinferos.AdInferosSounds;
import com.superdextor.adinferos.config.NetherConfig;
import com.superdextor.adinferos.entity.monster.EntityBlackWidow;
import com.superdextor.adinferos.entity.monster.EntityCurse;
import com.superdextor.adinferos.entity.monster.EntityGhost;
import com.superdextor.adinferos.entity.monster.EntityGlowstoneSkeleton;
import com.superdextor.adinferos.entity.monster.EntityHerobrine;
import com.superdextor.adinferos.entity.monster.EntityHerobrineClone;
import com.superdextor.adinferos.entity.monster.EntityInfernumAvis;
import com.superdextor.adinferos.entity.monster.EntityObsidianSheepman;
import com.superdextor.adinferos.entity.monster.EntityPhantom;
import com.superdextor.adinferos.entity.monster.EntityReaper;
import com.superdextor.adinferos.entity.monster.EntitySkeletonHorse;
import com.superdextor.adinferos.entity.monster.EntitySummoner;
import com.superdextor.adinferos.entity.other.EntityInfernalChicken;
import com.superdextor.adinferos.entity.other.EntityNetherArrow;
import com.superdextor.adinferos.init.NetherBlocks;
import com.superdextor.adinferos.init.NetherItems;
import com.superdextor.adinferos.proxy.CommonProxy;
import com.superdextor.adinferos.proxy.NetherModelManager;
import com.superdextor.adinferos.render.RenderBlackWidow;
import com.superdextor.adinferos.render.RenderCurse;
import com.superdextor.adinferos.render.RenderGhost;
import com.superdextor.adinferos.render.RenderGlowstoneSkeleton;
import com.superdextor.adinferos.render.RenderHerobrine;
import com.superdextor.adinferos.render.RenderHerobrineClone;
import com.superdextor.adinferos.render.RenderInfernalChicken;
import com.superdextor.adinferos.render.RenderInfernumAvis;
import com.superdextor.adinferos.render.RenderNetherArrow;
import com.superdextor.adinferos.render.RenderObsidianSheepman;
import com.superdextor.adinferos.render.RenderPhantom;
import com.superdextor.adinferos.render.RenderReaper;
import com.superdextor.adinferos.render.RenderSkeletonHorse;
import com.superdextor.adinferos.render.RenderSummoner;
import com.superdextor.adinferos.render.layer.LayerDemonPlayer;
import com.superdextor.adinferos.world.WorldProviderAbyss;
import com.superdextor.thinkbigcore.ThinkBigCore;
import com.superdextor.thinkbigcore.proxy.CustomMusicTicker;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelChicken;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

public class ClientProxy
extends CommonProxy {
    public boolean isFightingAvis = false;
    public boolean isFightingHerobrine = false;
    private boolean hasUpdatedModel = false;

    @Override
    public void preInit() {
        super.preInit();
        NetherModelManager.INSTANCE.registerAllModels();
        RenderingRegistry.registerEntityRenderingHandler(EntityBlackWidow.class, (IRenderFactory)new BlackWidowRenderer());
        RenderingRegistry.registerEntityRenderingHandler(EntityReaper.class, (IRenderFactory)new ReaperRenderer());
        RenderingRegistry.registerEntityRenderingHandler(EntityObsidianSheepman.class, (IRenderFactory)new ObsidianSheepmanRenderer());
        RenderingRegistry.registerEntityRenderingHandler(EntityCurse.class, (IRenderFactory)new CurseRenderer());
        RenderingRegistry.registerEntityRenderingHandler(EntityGlowstoneSkeleton.class, (IRenderFactory)new GlowstoneSkeletonRenderer());
        RenderingRegistry.registerEntityRenderingHandler(EntitySkeletonHorse.class, (IRenderFactory)new SkeletonHorseRenderer());
        RenderingRegistry.registerEntityRenderingHandler(EntityPhantom.class, (IRenderFactory)new PhantomRenderer());
        RenderingRegistry.registerEntityRenderingHandler(EntityNetherArrow.class, (IRenderFactory)new NetherArrowRenderer());
        RenderingRegistry.registerEntityRenderingHandler(EntityInfernumAvis.class, (IRenderFactory)new InfernumAvisRenderer());
        RenderingRegistry.registerEntityRenderingHandler(EntityHerobrine.class, (IRenderFactory)new HerobrineRenderer());
        RenderingRegistry.registerEntityRenderingHandler(EntityHerobrineClone.class, (IRenderFactory)new HerobrineCloneRenderer());
        RenderingRegistry.registerEntityRenderingHandler(EntitySummoner.class, (IRenderFactory)new SummonerRenderer());
        RenderingRegistry.registerEntityRenderingHandler(EntityInfernalChicken.class, (IRenderFactory)new InfernalChinkenRenderer());
        RenderingRegistry.registerEntityRenderingHandler(EntityGhost.class, (IRenderFactory)new GhostRenderer());
        NetherConfig.printDebugInfo("Registered Renderers");
    }

    @Override
    public void init() {
        super.init();
    }

    @Override
    public void postInit() {
        super.postInit();
        this.registerBlockVariants();
        this.registerItemVariants();
        Minecraft.func_71410_x().getItemColors().func_186730_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                return tintIndex == 0 ? -1 : NetherItems.tribe_headband.func_82814_b(stack);
            }
        }, new Item[]{NetherItems.tribe_headband});
        Minecraft.func_71410_x().getItemColors().func_186730_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                return tintIndex == 0 ? -1 : NetherItems.amulet.getColor(stack);
            }
        }, new Item[]{NetherItems.amulet});
        CustomMusicTicker.register((CustomMusicTicker.MusicEntry)new CustomMusicTicker.MusicEntry((SoundEvent)AdInferosSounds.music_infernum_avis, 20, 20){

            public boolean shouldSelect(Minecraft mc) {
                return ThinkBigCore.proxy.getClientPlayer().func_70089_S() && AdInferosCore.proxy.isFightingAvis();
            }
        });
        CustomMusicTicker.register((CustomMusicTicker.MusicEntry)new CustomMusicTicker.MusicEntry((SoundEvent)AdInferosSounds.music_herobrine, 20, 20){

            public boolean shouldSelect(Minecraft mc) {
                return ThinkBigCore.proxy.getClientPlayer().func_70089_S() && AdInferosCore.proxy.isFightingHerobrine();
            }
        });
        CustomMusicTicker.register((CustomMusicTicker.MusicEntry)new CustomMusicTicker.MusicEntry((SoundEvent)AdInferosSounds.music_abyss, 1200, 3600){

            public boolean shouldSelect(Minecraft mc) {
                return mc.field_71441_e.field_73011_w instanceof WorldProviderAbyss;
            }
        });
    }

    @Override
    public boolean isFightingAvis() {
        return this.isFightingAvis;
    }

    @Override
    public boolean isFightingHerobrine() {
        return this.isFightingHerobrine;
    }

    @Override
    public void doUpdate() {
        EntityPlayer playerIn = ThinkBigCore.proxy.getClientPlayer();
        World worldIn = playerIn.field_70170_p;
        if (!playerIn.func_70089_S() && (this.isFightingAvis || this.isFightingHerobrine)) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184370_a((SoundEvent)AdInferosSounds.music_death));
            this.isFightingAvis = false;
            this.isFightingHerobrine = false;
            return;
        }
        Iterator iterator = worldIn.func_175644_a(EntityHerobrine.class, (Predicate)new Predicate<EntityHerobrine>(){

            public boolean apply(EntityHerobrine herobrine) {
                return herobrine.isAttacking() && herobrine.func_70089_S();
            }
        }).iterator();
        if (iterator.hasNext()) {
            EntityHerobrine herobrine = (EntityHerobrine)iterator.next();
            this.isFightingAvis = false;
            this.isFightingHerobrine = true;
            return;
        }
        for (EntityInfernumAvis infernumAvis : worldIn.func_175644_a(EntityInfernumAvis.class, (Predicate)new Predicate<EntityInfernumAvis>(){

            public boolean apply(EntityInfernumAvis infernumAvis) {
                return !infernumAvis.isSleeping() && infernumAvis.func_70089_S();
            }
        })) {
            if (!(infernumAvis.func_70068_e((Entity)playerIn) < 800.0)) continue;
            this.isFightingHerobrine = false;
            this.isFightingAvis = true;
            return;
        }
        this.isFightingAvis = false;
        this.isFightingHerobrine = false;
    }

    @Override
    public void updatePlayerModel() {
        if (this.hasUpdatedModel) {
            return;
        }
        this.hasUpdatedModel = true;
        RenderManager manager = Minecraft.func_71410_x().func_175598_ae();
        Render render = null;
        try {
            render = manager.func_78713_a((Entity)Minecraft.func_71410_x().field_71439_g);
        }
        catch (Exception exception) {
            logger.warn("[pre] Failed to get the Player Renderer");
            return;
        }
        if (render instanceof RenderPlayer) {
            RenderPlayer renderPlayer = (RenderPlayer)render;
            renderPlayer.func_177094_a((LayerRenderer)new LayerDemonPlayer(renderPlayer));
            logger.info("[init] Player Model was updated");
        } else {
            logger.warn("[post] Failed to get the Player Renderer");
        }
    }

    private void registerBlockVariants() {
        int j;
        ResourceLocation[] netheriteTypes = new ResourceLocation[2];
        ResourceLocation[] witherTypes = new ResourceLocation[2];
        ResourceLocation[] witherBlockTypes = new ResourceLocation[2];
        ResourceLocation[] logTypes = new ResourceLocation[4];
        ResourceLocation[] plankTypes = new ResourceLocation[4];
        ResourceLocation[] slabTypes = new ResourceLocation[4];
        ResourceLocation[] leaveTypes = new ResourceLocation[4];
        ResourceLocation[] saplingTypes = new ResourceLocation[4];
        ResourceLocation[] stoneSlabTypes = new ResourceLocation[2];
        ResourceLocation[] craftingTableTypes = new ResourceLocation[4];
        String[] oreValues = new String[]{"", "_darkstone"};
        String[] blockValues = new String[]{"", "_gem"};
        String[] woodValues = new String[]{"", "magma_", "phantom_", "ash_"};
        String[] stoneSlabValues = new String[]{"", "_obsidian"};
        for (j = 0; j < 2; ++j) {
            netheriteTypes[j] = new ResourceLocation("adinferos", "netherite_ore" + oreValues[j]);
            witherTypes[j] = new ResourceLocation("adinferos", "wither_ore" + oreValues[j]);
            witherBlockTypes[j] = new ResourceLocation("adinferos", "wither_block" + blockValues[j]);
            stoneSlabTypes[j] = new ResourceLocation("adinferos", "stone_slab" + stoneSlabValues[j]);
            Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(Item.func_150898_a((Block)NetherBlocks.netherite_ore), j, new ModelResourceLocation("adinferos:netherite_ore" + oreValues[j], "inventory"));
            Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(Item.func_150898_a((Block)NetherBlocks.wither_ore), j, new ModelResourceLocation("adinferos:wither_ore" + oreValues[j], "inventory"));
            Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(Item.func_150898_a((Block)NetherBlocks.wither_block), j, new ModelResourceLocation("adinferos:wither_block" + blockValues[j], "inventory"));
            Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(Item.func_150898_a((Block)NetherBlocks.stone_slab), j, new ModelResourceLocation("adinferos:stone_slab" + stoneSlabValues[j], "inventory"));
            Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(Item.func_150898_a((Block)NetherBlocks.double_stone_slab), j, new ModelResourceLocation("adinferos:double_stone_slab" + stoneSlabValues[j], "inventory"));
        }
        for (j = 0; j < 4; ++j) {
            logTypes[j] = new ResourceLocation("adinferos", woodValues[j] + "log");
            plankTypes[j] = new ResourceLocation("adinferos", woodValues[j] + "planks");
            slabTypes[j] = new ResourceLocation("adinferos", woodValues[j] + "wooden_slab");
            leaveTypes[j] = new ResourceLocation("adinferos", woodValues[j] + "leaves");
            saplingTypes[j] = new ResourceLocation("adinferos", woodValues[j] + "sapling");
            craftingTableTypes[j] = new ResourceLocation("adinferos", woodValues[j] + "crafting_table");
            Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(Item.func_150898_a((Block)NetherBlocks.log), j, new ModelResourceLocation("adinferos:" + woodValues[j] + "log", "inventory"));
            Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(Item.func_150898_a((Block)NetherBlocks.planks), j, new ModelResourceLocation("adinferos:" + woodValues[j] + "planks", "inventory"));
            Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(Item.func_150898_a((Block)NetherBlocks.double_wooden_slab), j, new ModelResourceLocation("adinferos:" + woodValues[j] + "planks", "inventory"));
            Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(Item.func_150898_a((Block)NetherBlocks.wooden_slab), j, new ModelResourceLocation("adinferos:" + woodValues[j] + "wooden_slab", "inventory"));
            Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(Item.func_150898_a((Block)NetherBlocks.leaves), j, new ModelResourceLocation("adinferos:" + woodValues[j] + "leaves", "inventory"));
            Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(Item.func_150898_a((Block)NetherBlocks.sapling), j, new ModelResourceLocation("adinferos:" + woodValues[j] + "sapling", "inventory"));
            Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(Item.func_150898_a((Block)NetherBlocks.crafting_table), j, new ModelResourceLocation("adinferos:" + woodValues[j] + "crafting_table", "inventory"));
        }
        ModelBakery.registerItemVariants((Item)Item.func_150898_a((Block)NetherBlocks.netherite_ore), (ResourceLocation[])netheriteTypes);
        ModelBakery.registerItemVariants((Item)Item.func_150898_a((Block)NetherBlocks.wither_ore), (ResourceLocation[])witherTypes);
        ModelBakery.registerItemVariants((Item)Item.func_150898_a((Block)NetherBlocks.wither_block), (ResourceLocation[])witherBlockTypes);
        ModelBakery.registerItemVariants((Item)Item.func_150898_a((Block)NetherBlocks.log), (ResourceLocation[])logTypes);
        ModelBakery.registerItemVariants((Item)Item.func_150898_a((Block)NetherBlocks.planks), (ResourceLocation[])plankTypes);
        ModelBakery.registerItemVariants((Item)Item.func_150898_a((Block)NetherBlocks.wooden_slab), (ResourceLocation[])slabTypes);
        ModelBakery.registerItemVariants((Item)Item.func_150898_a((Block)NetherBlocks.leaves), (ResourceLocation[])leaveTypes);
        ModelBakery.registerItemVariants((Item)Item.func_150898_a((Block)NetherBlocks.sapling), (ResourceLocation[])saplingTypes);
        ModelBakery.registerItemVariants((Item)Item.func_150898_a((Block)NetherBlocks.stone_slab), (ResourceLocation[])stoneSlabTypes);
        ModelBakery.registerItemVariants((Item)Item.func_150898_a((Block)NetherBlocks.crafting_table), (ResourceLocation[])craftingTableTypes);
    }

    private void registerItemVariants() {
        int i;
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a((Item)NetherItems.amulet, 1, new ModelResourceLocation("adinferos:amulet", "inventory"));
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a((Item)NetherItems.amulet, 2, new ModelResourceLocation("adinferos:amulet", "inventory"));
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a((Item)NetherItems.amulet, 3, new ModelResourceLocation("adinferos:amulet", "inventory"));
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a((Item)NetherItems.amulet, 4, new ModelResourceLocation("adinferos:amulet", "inventory"));
        ResourceLocation[] bloodBucketTypes = new ResourceLocation[2];
        ResourceLocation[] upgradeTypes = new ResourceLocation[21];
        String[] bucketValues = new String[]{"", "_ghost"};
        String[] upgradeValues = new String[]{"", "_radius", "_radius", "_radius", "_speed", "_speed", "_speed", "_speed", "_speed", "_rules", "_blood", "_blood", "_blood", "_blood", "_blood", "_count", "_count", "_count", "_maxcount", "_maxcount", "_maxcount"};
        for (i = 0; i < 2; ++i) {
            bloodBucketTypes[i] = new ResourceLocation("adinferos", "golden_bucket_blood" + bucketValues[i]);
            Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(NetherItems.golden_bucket_blood, i, new ModelResourceLocation("adinferos:golden_bucket_blood" + bucketValues[i], "inventory"));
        }
        for (i = 0; i < 21; ++i) {
            upgradeTypes[i] = new ResourceLocation("adinferos", "spawner_upgrade" + upgradeValues[i]);
            Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(NetherItems.spawner_upgrade, i, new ModelResourceLocation("adinferos:spawner_upgrade" + upgradeValues[i], "inventory"));
        }
        ModelBakery.registerItemVariants((Item)NetherItems.golden_bucket_blood, (ResourceLocation[])bloodBucketTypes);
        ModelBakery.registerItemVariants((Item)NetherItems.spawner_upgrade, (ResourceLocation[])upgradeTypes);
    }

    private class GhostRenderer
    implements IRenderFactory<EntityGhost> {
        private GhostRenderer() {
        }

        public Render createRenderFor(RenderManager manager) {
            return new RenderGhost(manager);
        }
    }

    private class InfernalChinkenRenderer
    implements IRenderFactory<EntityInfernalChicken> {
        private InfernalChinkenRenderer() {
        }

        public Render createRenderFor(RenderManager manager) {
            return new RenderInfernalChicken(manager, (ModelBase)new ModelChicken(), 0.3f);
        }
    }

    private class SummonerRenderer
    implements IRenderFactory<EntitySummoner> {
        private SummonerRenderer() {
        }

        public Render createRenderFor(RenderManager manager) {
            return new RenderSummoner(manager);
        }
    }

    private class HerobrineCloneRenderer
    implements IRenderFactory<EntityHerobrineClone> {
        private HerobrineCloneRenderer() {
        }

        public Render createRenderFor(RenderManager manager) {
            return new RenderHerobrineClone(manager);
        }
    }

    private class HerobrineRenderer
    implements IRenderFactory<EntityHerobrine> {
        private HerobrineRenderer() {
        }

        public Render createRenderFor(RenderManager manager) {
            return new RenderHerobrine(manager);
        }
    }

    private class InfernumAvisRenderer
    implements IRenderFactory<EntityInfernumAvis> {
        private InfernumAvisRenderer() {
        }

        public Render createRenderFor(RenderManager manager) {
            return new RenderInfernumAvis(manager);
        }
    }

    private class NetherArrowRenderer
    implements IRenderFactory<EntityNetherArrow> {
        private NetherArrowRenderer() {
        }

        public Render createRenderFor(RenderManager manager) {
            return new RenderNetherArrow(manager);
        }
    }

    private class PhantomRenderer
    implements IRenderFactory<EntityPhantom> {
        private PhantomRenderer() {
        }

        public Render createRenderFor(RenderManager manager) {
            return new RenderPhantom(manager);
        }
    }

    private class SkeletonHorseRenderer
    implements IRenderFactory<EntitySkeletonHorse> {
        private SkeletonHorseRenderer() {
        }

        public Render createRenderFor(RenderManager manager) {
            return new RenderSkeletonHorse(manager);
        }
    }

    private class GlowstoneSkeletonRenderer
    implements IRenderFactory<EntityGlowstoneSkeleton> {
        private GlowstoneSkeletonRenderer() {
        }

        public Render createRenderFor(RenderManager manager) {
            return new RenderGlowstoneSkeleton(manager);
        }
    }

    private class CurseRenderer
    implements IRenderFactory<EntityCurse> {
        private CurseRenderer() {
        }

        public Render createRenderFor(RenderManager manager) {
            return new RenderCurse(manager);
        }
    }

    private class ObsidianSheepmanRenderer
    implements IRenderFactory<EntityObsidianSheepman> {
        private ObsidianSheepmanRenderer() {
        }

        public Render createRenderFor(RenderManager manager) {
            return new RenderObsidianSheepman(manager);
        }
    }

    private class ReaperRenderer
    implements IRenderFactory<EntityReaper> {
        private ReaperRenderer() {
        }

        public Render createRenderFor(RenderManager manager) {
            return new RenderReaper(manager);
        }
    }

    private class BlackWidowRenderer
    implements IRenderFactory<EntityBlackWidow> {
        private BlackWidowRenderer() {
        }

        public Render createRenderFor(RenderManager manager) {
            return new RenderBlackWidow(manager);
        }
    }
}

