/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.adinferos.items;

import com.superdextor.adinferos.entity.monster.EntityGhost;
import com.superdextor.adinferos.init.NetherItems;
import com.superdextor.adinferos.inventory.ExtractorRecipes;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;

public class ItemSoul
extends Item {
    public String func_77653_i(ItemStack stack) {
        String s = ItemSoul.getSoulName(stack);
        if (s.isEmpty()) {
            return super.func_77653_i(stack);
        }
        return super.func_77653_i(stack) + " of " + s;
    }

    public static int getSoulRepairAmount(ItemStack stack) {
        if (stack != null && stack.func_77942_o()) {
            return stack.func_77978_p().func_74762_e("SoulRepairAmount");
        }
        return 999;
    }

    public static boolean hasSoul(ItemStack stack) {
        return stack != null && stack.func_77942_o() && !stack.func_77978_p().func_74779_i("Soul").isEmpty();
    }

    public static String getSoulID(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74779_i("Soul");
        }
        return "";
    }

    public static String getSoulName(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74779_i("SoulName");
        }
        return "";
    }

    public static ItemStack removeSoul(ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            return stack;
        }
        compound.func_74778_a("Soul", "");
        compound.func_74778_a("SoulName", "");
        return stack;
    }

    public static ItemStack extractSoulFromItem(ItemStack stack) {
        if (ItemSoul.hasSoul(stack)) {
            ItemStack soul = new ItemStack(NetherItems.soul);
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("Soul", stack.func_77978_p().func_74779_i("Soul"));
            compound.func_74778_a("SoulName", stack.func_77978_p().func_74779_i("SoulName"));
            soul.func_77982_d(compound);
            ItemSoul.removeSoul(stack);
            return soul;
        }
        return null;
    }

    public static ItemStack createSoulFromEntity(ItemStack stack, EntityLiving entityIn) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound compound = stack.func_77978_p();
        String soulId = null;
        if (entityIn.getClass() == EntityGhost.class) {
            soulId = ((EntityGhost)entityIn).getSoul();
            compound.func_74778_a("Soul", soulId);
            compound.func_74778_a("SoulName", ((EntityGhost)entityIn).getSoulName());
        } else {
            soulId = EntityList.func_75621_b((Entity)entityIn);
            compound.func_74778_a("Soul", soulId);
            compound.func_74778_a("SoulName", entityIn.func_70005_c_());
        }
        ExtractorRecipes.ExtractorRecipe extractorRecipes = ExtractorRecipes.getRecipe(soulId);
        if (extractorRecipes == null) {
            LogManager.getLogger().warn("Failed to find recipe for " + soulId);
            compound.func_74768_a("SoulRepairAmount", 6);
        } else {
            compound.func_74768_a("SoulRepairAmount", extractorRecipes.soulsRequired);
        }
        return stack;
    }

    public static ItemStack createSoulFromEntity(EntityLiving entityIn) {
        ItemStack stack = new ItemStack(NetherItems.soul);
        NBTTagCompound compound = new NBTTagCompound();
        if (entityIn.getClass() == EntityGhost.class) {
            compound.func_74778_a("Soul", ((EntityGhost)entityIn).getSoul());
            compound.func_74778_a("SoulName", ((EntityGhost)entityIn).getSoulName());
        } else {
            compound.func_74778_a("Soul", EntityList.func_75621_b((Entity)entityIn));
            compound.func_74778_a("SoulName", entityIn.func_70005_c_());
        }
        stack.func_77982_d(compound);
        return stack;
    }

    public static EntityLiving createEntityFromSoul(ItemStack stack, World world, BlockPos pos) {
        EntityLiving entityLiving = null;
        if (stack.func_77942_o()) {
            Entity entity1;
            NBTTagCompound compound = stack.func_77978_p();
            String s = compound.func_74779_i("Soul");
            String s1 = compound.func_74779_i("SoulName");
            if (!s.isEmpty() && (entity1 = EntityList.func_75620_a((String)s, (World)world)) instanceof EntityLiving) {
                entityLiving = (EntityLiving)entity1;
                entityLiving.func_70012_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0f, 0.0f);
                if (!s1.isEmpty() && s1 != entityLiving.func_70005_c_()) {
                    entityLiving.func_96094_a(s1);
                }
                entityLiving.func_180482_a(world.func_175649_E(pos), null);
                world.func_72838_d((Entity)entityLiving);
            }
        }
        return entityLiving;
    }
}

