/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.adinferos.inventory;

import com.superdextor.adinferos.blocks.BlockNetherFurnace;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.SlotFurnaceFuel;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityNetherFurnace
extends TileEntityFurnace {
    private static final int[] slotsTop = new int[]{0};
    private static final int[] slotsBottom = new int[]{2, 1};
    private static final int[] slotsSides = new int[]{1};
    private ItemStack[] furnaceItemStacks = new ItemStack[3];
    private int furnaceBurnTime;
    private int currentItemBurnTime;
    private float cookTime;
    private int totalCookTime;
    private String furnaceCustomName;
    private boolean hasFireSource;

    public int func_70302_i_() {
        return this.furnaceItemStacks.length;
    }

    public ItemStack func_70301_a(int index) {
        return this.furnaceItemStacks[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a((ItemStack[])this.furnaceItemStacks, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a((ItemStack[])this.furnaceItemStacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        boolean flag = stack != null && stack.func_77969_a(this.furnaceItemStacks[index]) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)this.furnaceItemStacks[index]);
        this.furnaceItemStacks[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        if (index == 0 && !flag) {
            this.totalCookTime = this.func_174904_a(stack);
            this.cookTime = 0.0f;
            this.func_70296_d();
        }
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.furnaceCustomName : "container.netherrack_furnace";
    }

    public boolean func_145818_k_() {
        return this.furnaceCustomName != null && !this.furnaceCustomName.isEmpty();
    }

    public void func_145951_a(String nameIn) {
        this.furnaceCustomName = nameIn;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
        this.furnaceItemStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            byte j = nbttagcompound.func_74771_c("Slot");
            if (j < 0 || j >= this.furnaceItemStacks.length) continue;
            this.furnaceItemStacks[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound);
        }
        this.furnaceBurnTime = compound.func_74762_e("BurnTime");
        this.cookTime = compound.func_74762_e("CookTime");
        this.totalCookTime = compound.func_74762_e("CookTimeTotal");
        this.currentItemBurnTime = TileEntityNetherFurnace.func_145952_a((ItemStack)this.furnaceItemStacks[1]);
        if (compound.func_150297_b("CustomName", 8)) {
            this.furnaceCustomName = compound.func_74779_i("CustomName");
        }
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74768_a("BurnTime", this.furnaceBurnTime);
        compound.func_74768_a("CookTime", (int)this.cookTime);
        compound.func_74768_a("CookTimeTotal", this.totalCookTime);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.furnaceItemStacks.length; ++i) {
            if (this.furnaceItemStacks[i] == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            this.furnaceItemStacks[i].func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("Items", (NBTBase)nbttaglist);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.furnaceCustomName);
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    @Deprecated
    public boolean func_145950_i() {
        return this.furnaceBurnTime > 0;
    }

    public boolean isBurning(boolean fuelOnly) {
        if (fuelOnly) {
            return this.furnaceBurnTime > 0;
        }
        return this.furnaceBurnTime > 0 || this.hasFireSource;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isBurning(IInventory p_174903_0_) {
        return p_174903_0_.func_174887_a_(0) > 0;
    }

    public void func_73660_a() {
        boolean flag = this.isBurning(false);
        boolean flag1 = false;
        if (this.isBurning(true)) {
            --this.furnaceBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.hasFireSource = this.field_145850_b.func_180495_p(this.func_174877_v().func_177984_a()).func_185904_a().equals(Material.field_151581_o);
            if (!(this.isBurning(false) || this.furnaceItemStacks[1] != null && this.furnaceItemStacks[0] != null)) {
                if (!this.isBurning(false) && this.cookTime > 0.0f) {
                    this.cookTime = MathHelper.func_76125_a((int)((int)(this.cookTime - 2.0f)), (int)0, (int)this.totalCookTime);
                }
            } else {
                if (!this.isBurning(true) && this.canSmelt()) {
                    this.currentItemBurnTime = this.furnaceBurnTime = TileEntityNetherFurnace.func_145952_a((ItemStack)this.furnaceItemStacks[1]);
                    if (this.isBurning(true)) {
                        flag1 = true;
                        if (this.furnaceItemStacks[1] != null) {
                            --this.furnaceItemStacks[1].field_77994_a;
                            if (this.furnaceItemStacks[1].field_77994_a == 0) {
                                this.furnaceItemStacks[1] = this.furnaceItemStacks[1].func_77973_b().getContainerItem(this.furnaceItemStacks[1]);
                            }
                        }
                    }
                }
                if (this.isBurning(false) && this.canSmelt()) {
                    if (this.furnaceBurnTime > 0) {
                        this.cookTime += 1.7f;
                    }
                    if (this.hasFireSource) {
                        this.cookTime += 0.3f;
                    }
                    if (this.cookTime >= (float)this.totalCookTime) {
                        this.cookTime = 0.0f;
                        this.totalCookTime = this.func_174904_a(this.furnaceItemStacks[0]);
                        this.func_145949_j();
                        flag1 = true;
                    }
                } else {
                    this.cookTime = 0.0f;
                }
            }
            if (flag != this.isBurning(false)) {
                flag1 = true;
                BlockNetherFurnace.setState(this.isBurning(false), this.field_145850_b, this.field_174879_c);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public int func_174904_a(ItemStack stack) {
        return 200;
    }

    private boolean canSmelt() {
        if (this.furnaceItemStacks[0] == null) {
            return false;
        }
        ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.furnaceItemStacks[0]);
        if (itemstack == null) {
            return false;
        }
        if (this.furnaceItemStacks[2] == null) {
            return true;
        }
        if (!this.furnaceItemStacks[2].func_77969_a(itemstack)) {
            return false;
        }
        int result = this.furnaceItemStacks[2].field_77994_a + itemstack.field_77994_a;
        return result <= this.func_70297_j_() && result <= this.furnaceItemStacks[2].func_77976_d();
    }

    public void func_145949_j() {
        if (this.canSmelt()) {
            ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.furnaceItemStacks[0]);
            if (this.furnaceItemStacks[2] == null) {
                this.furnaceItemStacks[2] = itemstack.func_77946_l();
            } else if (this.furnaceItemStacks[2].func_77973_b() == itemstack.func_77973_b()) {
                this.furnaceItemStacks[2].field_77994_a += itemstack.field_77994_a;
            }
            if (this.furnaceItemStacks[0].func_77973_b() == Item.func_150898_a((Block)Blocks.field_150360_v) && this.furnaceItemStacks[0].func_77960_j() == 1 && this.furnaceItemStacks[1] != null && this.furnaceItemStacks[1].func_77973_b() == Items.field_151133_ar) {
                this.furnaceItemStacks[1] = new ItemStack(Items.field_151131_as);
            }
            --this.furnaceItemStacks[0].field_77994_a;
            if (this.furnaceItemStacks[0].field_77994_a <= 0) {
                this.furnaceItemStacks[0] = null;
            }
        }
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 2) {
            return false;
        }
        if (index != 1) {
            return true;
        }
        ItemStack itemstack = this.furnaceItemStacks[1];
        return TileEntityNetherFurnace.func_145954_b((ItemStack)stack) || SlotFurnaceFuel.func_178173_c_((ItemStack)stack) && (itemstack == null || itemstack.func_77973_b() != Items.field_151133_ar);
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? slotsBottom : (side == EnumFacing.UP ? slotsTop : slotsSides);
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        Item item;
        return direction != EnumFacing.DOWN || index != 1 || (item = stack.func_77973_b()) == Items.field_151131_as || item == Items.field_151133_ar;
    }

    public String func_174875_k() {
        return "adinfernos:nether_furnace";
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.furnaceBurnTime;
            }
            case 1: {
                return this.currentItemBurnTime;
            }
            case 2: {
                return (int)this.cookTime;
            }
            case 3: {
                return this.totalCookTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.furnaceBurnTime = value;
                break;
            }
            case 1: {
                this.currentItemBurnTime = value;
                break;
            }
            case 2: {
                this.cookTime = value;
                break;
            }
            case 3: {
                this.totalCookTime = value;
            }
        }
    }

    public int func_174890_g() {
        return 4;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.furnaceItemStacks.length; ++i) {
            this.furnaceItemStacks[i] = null;
        }
    }
}

