/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.adinferos.inventory;

import com.superdextor.adinferos.init.NetherItems;
import com.superdextor.adinferos.inventory.ContainerExtractor;
import com.superdextor.adinferos.inventory.ExtractorRecipes;
import com.superdextor.adinferos.items.ItemBloodBucket;
import com.superdextor.adinferos.items.ItemSoul;
import com.superdextor.thinkbigcore.helpers.EffectHelper;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntityExtractor
extends TileEntityLockable
implements ITickable,
ISidedInventory {
    private static final int[] slotsTop = new int[]{3};
    private static final int[] slotsBottom = new int[]{3, 1};
    private static final int[] slotsSides = new int[]{0};
    private ItemStack[] extractorItemStacks = new ItemStack[4];
    private int extractorBlood;
    private int burnTime;
    private int burnedSoulCount;
    private int requiredSoulCount;
    private String extractorCustomName;
    private final Random rand = new Random();
    IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    IItemHandler handlerSide = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);

    public int func_70302_i_() {
        return this.extractorItemStacks.length;
    }

    public ItemStack func_70301_a(int index) {
        return this.extractorItemStacks[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a((ItemStack[])this.extractorItemStacks, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a((ItemStack[])this.extractorItemStacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        boolean flag = stack != null && stack.func_77969_a(this.extractorItemStacks[index]) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)this.extractorItemStacks[index]);
        this.extractorItemStacks[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        if (index == 0 && !flag) {
            this.requiredSoulCount = ItemSoul.getSoulRepairAmount(this.extractorItemStacks[0]);
            this.burnTime = 0;
            this.func_70296_d();
        }
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.extractorCustomName : "container.extractor";
    }

    public boolean func_145818_k_() {
        return this.extractorCustomName != null && !this.extractorCustomName.isEmpty();
    }

    public void setCustomInventoryName(String value) {
        this.extractorCustomName = value;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
        this.extractorItemStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            byte j = nbttagcompound.func_74771_c("Slot");
            if (j < 0 || j >= this.extractorItemStacks.length) continue;
            this.extractorItemStacks[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound);
        }
        this.extractorBlood = compound.func_74762_e("Blood");
        this.burnTime = compound.func_74762_e("BurnTime");
        this.burnedSoulCount = compound.func_74762_e("BurnedSoulCount");
        this.requiredSoulCount = ItemSoul.getSoulRepairAmount(this.extractorItemStacks[0]);
        if (compound.func_150297_b("CustomName", 8)) {
            this.extractorCustomName = compound.func_74779_i("CustomName");
        }
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74768_a("Blood", this.extractorBlood);
        compound.func_74768_a("BurnTime", this.burnTime);
        compound.func_74768_a("BurnedSoulCount", this.burnedSoulCount);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.extractorItemStacks.length; ++i) {
            if (this.extractorItemStacks[i] == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            this.extractorItemStacks[i].func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("Items", (NBTBase)nbttaglist);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.extractorCustomName);
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    public int getRequiredBlood(ItemStack stack) {
        if (stack == null || !ItemSoul.hasSoul(stack)) {
            return 999;
        }
        ExtractorRecipes.ExtractorRecipe recipe = ExtractorRecipes.getRecipe(ItemSoul.getSoulID(stack));
        if (recipe != null) {
            return recipe.bloodRequired;
        }
        return 75;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isBurning(IInventory inventory) {
        return inventory.func_174887_a_(1) > 0;
    }

    public void func_73660_a() {
        boolean shouldUpdate = false;
        if (this.isBurning()) {
            --this.burnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.isBurning() && this.rand.nextDouble() < 0.06) {
                EffectHelper.playSound((World)this.field_145850_b, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (SoundEvent)SoundEvents.field_187646_bt, (SoundCategory)SoundCategory.BLOCKS, (float)0.7f, (float)1.2f);
            }
            if (ItemBloodBucket.hasBlood(this.extractorItemStacks[3])) {
                shouldUpdate = true;
                this.extractorBlood += ItemBloodBucket.getBlood(this.extractorItemStacks[3]);
                ItemBloodBucket.setBlood(this.extractorItemStacks[3], 0);
                if (this.extractorItemStacks[3].func_77973_b().equals(NetherItems.golden_bucket_blood)) {
                    this.extractorItemStacks[3] = this.extractorItemStacks[3].func_77960_j() > 0 ? null : new ItemStack(NetherItems.golden_bucket);
                }
                EffectHelper.playSound((World)this.field_145850_b, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (SoundEvent)SoundEvents.field_187621_J, (SoundCategory)SoundCategory.BLOCKS, (float)1.4f, (float)0.7f);
            }
            if (this.canExtract()) {
                if (!this.isBurning()) {
                    if (this.burnedSoulCount >= this.requiredSoulCount) {
                        shouldUpdate = true;
                        this.extractSoul();
                    } else if (this.hasSouls()) {
                        shouldUpdate = true;
                        this.burnTime = 130;
                        if (this.extractorItemStacks[1] != null) {
                            --this.extractorItemStacks[1].field_77994_a;
                            if (this.extractorItemStacks[1].field_77994_a == 0) {
                                this.extractorItemStacks[1] = this.extractorItemStacks[1].func_77973_b().getContainerItem(this.extractorItemStacks[1]);
                            }
                        }
                    }
                } else if (this.burnTime == 1) {
                    ++this.burnedSoulCount;
                    if (this.burnedSoulCount == this.requiredSoulCount) {
                        this.burnTime = 65;
                    }
                }
            } else if (!this.isBurning() && this.burnedSoulCount > 0) {
                --this.burnedSoulCount;
            }
        }
        if (shouldUpdate) {
            this.func_70296_d();
        }
    }

    private boolean canExtract() {
        if (this.extractorItemStacks[0] == null || !ItemSoul.hasSoul(this.extractorItemStacks[0]) || this.extractorItemStacks[2] != null) {
            return false;
        }
        if (!this.isBurning() && !this.hasSouls()) {
            return false;
        }
        return this.extractorBlood >= this.getRequiredBlood(this.extractorItemStacks[0]);
    }

    private boolean hasSouls() {
        return this.extractorItemStacks[1] != null && this.extractorItemStacks[1].func_77973_b() == NetherItems.soul_fragment;
    }

    private void extractSoul() {
        ItemStack soul;
        this.burnedSoulCount = 0;
        this.extractorBlood -= this.getRequiredBlood(this.extractorItemStacks[0]);
        this.extractorItemStacks[2] = soul = ItemSoul.extractSoulFromItem(this.extractorItemStacks[0]);
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 0 && ItemSoul.hasSoul(stack)) {
            return true;
        }
        if (index == 1 && stack != null && stack.func_77973_b() == NetherItems.soul_fragment) {
            return true;
        }
        return index == 3 && ItemBloodBucket.hasBlood(stack);
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? slotsBottom : (side == EnumFacing.UP ? slotsTop : slotsSides);
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index != 3 || !ItemBloodBucket.hasBlood(stack);
    }

    public String func_174875_k() {
        return "adinferos:extractor";
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerExtractor(playerInventory, (IInventory)this);
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.extractorBlood;
            }
            case 1: {
                return this.burnTime;
            }
            case 2: {
                return this.burnedSoulCount > this.requiredSoulCount ? 0 : this.burnedSoulCount;
            }
            case 3: {
                return this.requiredSoulCount;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.extractorBlood = value;
                break;
            }
            case 1: {
                this.burnTime = value;
                break;
            }
            case 2: {
                this.burnedSoulCount = value;
                break;
            }
            case 3: {
                this.requiredSoulCount = value;
            }
        }
    }

    public int func_174890_g() {
        return 4;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.extractorItemStacks.length; ++i) {
            this.extractorItemStacks[i] = null;
        }
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
            return (T)this.handlerSide;
        }
        return (T)super.getCapability(capability, facing);
    }
}

