/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.adinferos.inventory;

import com.superdextor.adinferos.blocks.BlockSpawner;
import com.superdextor.adinferos.config.NetherConfig;
import com.superdextor.adinferos.entity.monster.EntityBlackWidow;
import com.superdextor.adinferos.entity.monster.EntityCurse;
import com.superdextor.adinferos.entity.monster.EntityGlowstoneSkeleton;
import com.superdextor.adinferos.entity.monster.EntityObsidianSheepman;
import com.superdextor.adinferos.entity.monster.EntityPhantom;
import com.superdextor.adinferos.entity.monster.EntitySkeletonHorse;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;

public class ExtractorRecipes {
    public static final ArrayList<ExtractorRecipe> recipes = new ArrayList();

    public static void register() {
        ExtractorRecipes.addRecipe("Creeper", 14, 800, 18);
        ExtractorRecipes.addRecipe("Skeleton", 14, 800, 16);
        ExtractorRecipes.addRecipe("Spider", 14, 800, 14);
        ExtractorRecipes.addRecipe("Zombie", 14, 800, 10);
        ExtractorRecipes.addRecipe("Slime", 16, 900, 30);
        ExtractorRecipes.addRecipe("Ghast", 20, 1400, 90);
        ExtractorRecipes.addRecipe("PigZombie", 18, 1200, 26);
        ExtractorRecipes.addRecipe("Enderman", 24, 1800, 80);
        ExtractorRecipes.addRecipe("CaveSpider", 12, 600, 12);
        ExtractorRecipes.addRecipe("Silverfish", 6, 400, 5);
        ExtractorRecipes.addRecipe("Blaze", 20, 1800, 80);
        ExtractorRecipes.addRecipe("LavaSlime", 24, 1800, 100);
        ExtractorRecipes.addRecipe("Bat", 6, 400, 5);
        ExtractorRecipes.addRecipe("Witch", 20, 1200, 38);
        ExtractorRecipes.addRecipe("Endermite", 6, 400, 5);
        ExtractorRecipes.addRecipe("Guardian", 20, 1800, 100);
        ExtractorRecipes.addRecipe("Shulker", 8, 500, 6);
        ExtractorRecipes.addRecipe("Pig", 16, 1800, 60);
        ExtractorRecipes.addRecipe("Sheep", 16, 1800, 60);
        ExtractorRecipes.addRecipe("Cow", 16, 1800, 60);
        ExtractorRecipes.addRecipe("Chicken", 16, 1800, 60);
        ExtractorRecipes.addRecipe("Squid", 12, 900, 40);
        ExtractorRecipes.addRecipe("Rabbit", 16, 1800, 60);
        ExtractorRecipes.addRecipe(EntityBlackWidow.class, 20, 1200, 26);
        ExtractorRecipes.addRecipe(EntityCurse.class, 24, 1500, 46);
        ExtractorRecipes.addRecipe(EntityGlowstoneSkeleton.class, 18, 1400, 46);
        ExtractorRecipes.addRecipe(EntityObsidianSheepman.class, 26, 1800, 64);
        ExtractorRecipes.addRecipe(EntityPhantom.class, 28, 2400, 140);
        ExtractorRecipes.addRecipe(EntitySkeletonHorse.class, 12, 1200, 58);
        NetherConfig.printDebugInfo("Registered Extractor Recipes");
    }

    public static void addRecipe(Class<? extends Entity> clazz, int soulsRequired, int bloodRequired, int blood4Spawn) {
        ExtractorRecipes.addRecipe(EntityList.func_188430_a(clazz), soulsRequired, bloodRequired, blood4Spawn);
    }

    public static void addRecipe(String soulId, int soulsRequired, int bloodRequired, int blood4Spawn) {
        if (NetherConfig.allowExtractor) {
            ExtractorRecipe recipe = new ExtractorRecipe(soulId, soulsRequired, bloodRequired, blood4Spawn);
            recipes.add(recipe);
        }
    }

    public static ExtractorRecipe getRecipe(String soulId) {
        for (ExtractorRecipe recipe : recipes) {
            if (recipe.soulId != soulId) continue;
            return recipe;
        }
        return null;
    }

    public static boolean isValidEntity(Entity entityIn) {
        String s;
        return entityIn instanceof EntityLiving && entityIn.func_184222_aU() && !BlockSpawner.isSpawnerEntity(entityIn) && ExtractorRecipes.getRecipe(s = EntityList.func_75621_b((Entity)entityIn)) != null;
    }

    public static class ExtractorRecipe {
        public final String soulId;
        public final int soulsRequired;
        public final int bloodRequired;
        public final int bloodForSpawn;

        public ExtractorRecipe(String soulIn, int souls, int blood, int blood4Spawn) {
            this.soulId = soulIn;
            this.soulsRequired = souls;
            this.bloodRequired = blood;
            this.bloodForSpawn = blood4Spawn;
        }

        public String toString() {
            return "[" + this.soulId + "," + this.soulsRequired + "," + this.bloodRequired + ", " + this.bloodForSpawn + "]";
        }
    }
}

