/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.adinferos.entity.monster;

import com.google.common.base.Predicate;
import com.superdextor.adinferos.AdInferosCore;
import com.superdextor.adinferos.AdInferosSounds;
import com.superdextor.adinferos.config.NetherConfig;
import com.superdextor.adinferos.entity.ISoulEntity;
import com.superdextor.adinferos.entity.NetherMob;
import com.superdextor.adinferos.entity.monster.EntityGhost;
import com.superdextor.adinferos.init.NetherItems;
import com.superdextor.adinferos.inventory.AdInferosLootTables;
import com.superdextor.thinkbigcore.entity.IFearedEntity;
import java.util.Calendar;
import java.util.Iterator;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EntityReaper
extends EntityMob
implements NetherMob,
IFearedEntity,
ISoulEntity {
    private static final UUID attackingSpeedBoostModifierUUID = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
    private static final AttributeModifier attackingSpeedBoostModifier = new AttributeModifier(attackingSpeedBoostModifierUUID, "Attacking speed boost", (double)0.15f, 0).func_111168_a(false);
    private static final UUID babySpeedBoostUUID = UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D836");
    private static final AttributeModifier babySpeedBoostModifier = new AttributeModifier(babySpeedBoostUUID, "Baby speed boost", 0.5, 1);
    private static final DataParameter<Boolean> IS_BABY = EntityDataManager.func_187226_a(EntityReaper.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SCREAMING = EntityDataManager.func_187226_a(EntityReaper.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> ALPHA = EntityDataManager.func_187226_a(EntityReaper.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> EYE_BRIGHTNESS = EntityDataManager.func_187226_a(EntityReaper.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> CLOAKING = EntityDataManager.func_187226_a(EntityReaper.class, (DataSerializer)DataSerializers.field_187198_h);
    private int cloakingTimer = 0;
    private EntityLivingBase savedTarget = null;
    private int timeSinceLastTarget = 0;

    public EntityReaper(World worldIn) {
        super(worldIn);
        this.field_70138_W = 1.0f;
        this.field_70728_aV = 20;
        this.field_70178_ae = true;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 10, true, false, (Predicate)new Predicate<EntityPlayer>(){

            public boolean apply(final EntityPlayer input) {
                if (input.func_70644_a(MobEffects.field_188425_z)) {
                    return false;
                }
                Iterator iterator = input.field_70170_p.func_175644_a(EntityReaper.class, (Predicate)new Predicate<EntityReaper>(){

                    public boolean apply(EntityReaper reaper) {
                        return reaper.func_70089_S() && reaper.func_70638_az() == input;
                    }
                }).iterator();
                if (iterator.hasNext()) {
                    EntityReaper reaper = (EntityReaper)iterator.next();
                    return false;
                }
                return true;
            }
        }));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityIronGolem.class, true));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityAnimal.class, 10, true, false, (Predicate)new Predicate<EntityAnimal>(){

            public boolean apply(EntityAnimal input) {
                return !(input instanceof NetherMob);
            }
        }));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(IS_BABY, (Object)false);
        this.func_184212_Q().func_187214_a(SCREAMING, (Object)false);
        this.func_184212_Q().func_187214_a(ALPHA, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(EYE_BRIGHTNESS, (Object)0);
        this.func_184212_Q().func_187214_a(CLOAKING, (Object)false);
    }

    public boolean func_70631_g_() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_BABY);
    }

    public void setChild(boolean value) {
        this.func_184212_Q().func_187227_b(IS_BABY, (Object)value);
        this.func_70105_a(0.4f, 0.3f);
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
            iattributeinstance.func_111124_b(babySpeedBoostModifier);
            if (value) {
                iattributeinstance.func_111121_a(babySpeedBoostModifier);
            }
        }
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        if (this.func_70631_g_()) {
            tagCompound.func_74757_a("IsBaby", true);
        }
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        if (tagCompund.func_74767_n("IsBaby")) {
            this.setChild(true);
        }
    }

    private boolean shouldAttackTarget(EntityLivingBase entity) {
        Vec3d vec3 = entity.func_70676_i(1.0f).func_72432_b();
        Vec3d vec31 = new Vec3d(this.field_70165_t - entity.field_70165_t, this.func_174813_aQ().field_72338_b + (double)(this.field_70131_O / 2.0f) - (entity.field_70163_u + (double)entity.func_70047_e()), this.field_70161_v - entity.field_70161_v);
        double d0 = vec31.func_72433_c();
        double d1 = vec3.func_72430_b(vec31 = vec31.func_72432_b());
        return d1 > 1.0 - 0.025 / d0 ? entity.func_70685_l((Entity)this) : false;
    }

    public float func_70047_e() {
        float f = 1.74f;
        if (this.func_70631_g_()) {
            f = (float)((double)f - 0.81);
        }
        return f;
    }

    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70093_af()) {
                this.setAlpha(0.0f);
                this.func_70095_a(false);
            }
            if (this.getAlpha() < 1.0f) {
                this.setAlpha(this.getAlpha() + 0.03f);
            }
        }
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 4; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SUSPENDED_DEPTH, this.field_70165_t + this.field_70146_Z.nextDouble() - 0.5, this.field_70163_u + this.field_70146_Z.nextDouble() + this.field_70146_Z.nextDouble() + 0.05, this.field_70161_v + this.field_70146_Z.nextDouble() - 0.5, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, new int[0]);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            if (this.func_70638_az() != null) {
                this.timeSinceLastTarget = 2000;
                this.setScreaming(true);
                if (this.getEyeBrightness() < 12000 && !this.isCloaking()) {
                    this.setEyeBrightness(this.getEyeBrightness() + 30);
                }
                if (this.shouldAttackTarget(this.func_70638_az()) && !this.isCloaking()) {
                    if (this.getEyeBrightness() >= 12000) {
                        this.func_184609_a(EnumHand.MAIN_HAND);
                        this.func_184609_a(EnumHand.OFF_HAND);
                        this.func_70638_az().func_70690_d(new PotionEffect(MobEffects.field_76440_q, 15, 0));
                        this.func_184185_a((SoundEvent)AdInferosSounds.reaper_cloak, 2.0f, 0.2f);
                        this.cloakingTimer = 160 * this.getDiffculityFactor();
                        this.setCloaking(true);
                    } else if (this.func_70638_az().func_70068_e((Entity)this) < 16.0) {
                        if (this.field_70146_Z.nextFloat() < 0.2f * (float)this.getDiffculityFactor()) {
                            this.teleportRandomly();
                        } else {
                            this.setEyeBrightness(this.getEyeBrightness() + 40 * this.getDiffculityFactor());
                        }
                    }
                }
                if (this.func_70068_e((Entity)this.func_70638_az()) > 500.0) {
                    this.teleportToEntity((Entity)this.func_70638_az());
                }
            } else {
                if (this.timeSinceLastTarget > 1) {
                    --this.timeSinceLastTarget;
                }
                this.setScreaming(false);
                this.setEyeBrightness(0);
            }
            if (this.isCloaking()) {
                if (this.cloakingTimer > 0) {
                    --this.cloakingTimer;
                } else {
                    this.setCloaking(false);
                    this.setEyeBrightness(0);
                }
            }
        }
        super.func_70636_d();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if ((this.getAlpha() < 0.7f || this.isCloaking() && this.field_70146_Z.nextFloat() < 0.3f * (float)this.getDiffculityFactor()) && !source.func_76357_e() && !source.func_180136_u()) {
            this.func_184185_a(AdInferosSounds.reaper_dodge.getSound(), 1.2f, 0.7f);
            this.cloakingTimer -= 40;
            if (this.cloakingTimer < 0) {
                this.cloakingTimer = 0;
            }
            return false;
        }
        if (this.func_70090_H() || this.func_180799_ab() && this.field_70146_Z.nextBoolean()) {
            this.teleportRandomly();
        }
        this.setAlpha(0.4f);
        return super.func_70097_a(source, amount);
    }

    protected boolean func_70692_ba() {
        return this.func_70638_az() == null && this.timeSinceLastTarget < 1;
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
        if (wasRecentlyHit) {
            this.func_70099_a(new ItemStack(NetherItems.golden_bucket_blood, 1, 1), 0.0f);
        }
        super.func_82160_b(wasRecentlyHit, lootingModifier);
    }

    protected boolean teleportRandomly() {
        double k2;
        double k1;
        double k0;
        double d0 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        double d1 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(64) - 32);
        double d2 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        if (this.func_70638_az() != null && (k0 = d0 - this.func_70638_az().field_70165_t) * k0 + (k1 = d1 - this.func_70638_az().field_70163_u) * k1 + (k2 = d2 - this.func_70638_az().field_70161_v) * k2 > 400.0) {
            return this.teleportToEntity((Entity)this.func_70638_az());
        }
        return this.teleportTo(d0, d1, d2);
    }

    protected boolean teleportToEntity(Entity p_70816_1_) {
        Vec3d vec3d = new Vec3d(this.field_70165_t - p_70816_1_.field_70165_t, this.func_174813_aQ().field_72338_b + (double)(this.field_70131_O / 2.0f) - p_70816_1_.field_70163_u + (double)p_70816_1_.func_70047_e(), this.field_70161_v - p_70816_1_.field_70161_v);
        vec3d = vec3d.func_72432_b();
        double d0 = 16.0;
        double d1 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3d.field_72450_a * d0;
        double d2 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(16) - 8) - vec3d.field_72448_b * d0;
        double d3 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3d.field_72449_c * d0;
        return this.teleportTo(d1, d2, d3);
    }

    private boolean teleportTo(double x, double y, double z) {
        if (this.cloakingTimer > 0) {
            this.cloakingTimer -= 60;
            if (this.cloakingTimer < 0) {
                this.cloakingTimer = 0;
            }
        }
        double soundX = this.field_70165_t;
        double soundY = this.field_70163_u;
        double soundZ = this.field_70161_v;
        EnderTeleportEvent event = new EnderTeleportEvent((EntityLivingBase)this, x, y, z, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        boolean flag = this.func_184595_k(event.getTargetX(), event.getTargetY(), event.getTargetZ());
        if (flag) {
            this.field_70170_p.func_184148_a((EntityPlayer)null, soundX, soundY, soundZ, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
            this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
            this.setAlpha(0.0f);
        }
        return flag;
    }

    protected SoundEvent func_184639_G() {
        return this.isScreaming() ? AdInferosSounds.reaper_angry.getSound() : AdInferosSounds.reaper_idle.getSound();
    }

    protected SoundEvent func_184601_bQ() {
        return AdInferosSounds.reaper_hurt.getSound();
    }

    protected SoundEvent func_184615_bR() {
        return AdInferosSounds.reaper_death.getSound();
    }

    protected ResourceLocation func_184647_J() {
        return AdInferosLootTables.ENTITIES_REAPER;
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(NetherItems.scythe));
        this.func_184642_a(EntityEquipmentSlot.MAINHAND, 0.0f);
    }

    public boolean func_70601_bi() {
        if (this.field_70170_p.field_73011_w.getDimension() == -1 && !AdInferosCore.proxy.isDarkNether()) {
            return false;
        }
        return super.func_70601_bi();
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData idata) {
        Calendar calendar;
        idata = super.func_180482_a(difficulty, idata);
        this.func_180481_a(difficulty);
        this.func_180483_b(difficulty);
        if (this.field_70146_Z.nextFloat() < 0.01f) {
            this.setChild(true);
        }
        this.func_98053_h(this.field_70146_Z.nextFloat() < 0.55f * difficulty.func_180170_c());
        if (this.func_184582_a(EntityEquipmentSlot.HEAD) == null && (calendar = this.field_70170_p.func_83015_S()).get(2) + 1 == 10 && calendar.get(5) == 31 && this.field_70146_Z.nextFloat() < 0.25f) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(this.field_70146_Z.nextFloat() < 0.1f ? Blocks.field_150428_aP : Blocks.field_150423_aK));
            this.field_184655_bs[EntityEquipmentSlot.HEAD.func_188454_b()] = 0.0f;
        }
        NetherConfig.printDebugInfo(this.func_70005_c_() + " was spawned at " + this.func_180425_c());
        return idata;
    }

    public void func_70645_a(DamageSource cause) {
        if (cause.func_76346_g() instanceof EntityPlayer && this.canMakeGhost()) {
            EntityGhost.createGhost(this.field_70170_p, (EntityLiving)this, this);
        }
        super.func_70645_a(cause);
    }

    public boolean isScreaming() {
        return (Boolean)this.func_184212_Q().func_187225_a(SCREAMING);
    }

    public void setScreaming(boolean value) {
        this.func_184212_Q().func_187227_b(SCREAMING, (Object)value);
    }

    public float getAlpha() {
        return ((Float)this.func_184212_Q().func_187225_a(ALPHA)).floatValue();
    }

    public void setAlpha(float value) {
        this.func_184212_Q().func_187227_b(ALPHA, (Object)Float.valueOf(value));
    }

    public int getEyeBrightness() {
        return (Integer)this.func_184212_Q().func_187225_a(EYE_BRIGHTNESS);
    }

    public void setEyeBrightness(int value) {
        this.func_184212_Q().func_187227_b(EYE_BRIGHTNESS, (Object)value);
    }

    public boolean isCloaking() {
        return (Boolean)this.func_184212_Q().func_187225_a(CLOAKING);
    }

    public void setCloaking(boolean value) {
        this.func_184212_Q().func_187227_b(CLOAKING, (Object)value);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public boolean func_70652_k(Entity target) {
        if (super.func_70652_k(target)) {
            if (target instanceof EntityLivingBase) {
                ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76440_q, 12, 0));
            }
            return true;
        }
        return false;
    }

    public EntityLivingBase func_70638_az() {
        return super.func_70638_az() == null ? this.savedTarget : super.func_70638_az();
    }

    public void func_70624_b(EntityLivingBase entitylivingbaseIn) {
        if (this.func_70638_az() != null && entitylivingbaseIn == null) {
            this.savedTarget = this.func_70638_az().func_70089_S() ? this.func_70638_az() : entitylivingbaseIn;
        } else if (entitylivingbaseIn != null) {
            this.savedTarget = entitylivingbaseIn;
        }
        super.func_70624_b(entitylivingbaseIn);
    }

    @Override
    public boolean canMakeGhost() {
        return NetherConfig.ghostSpawnFromEntities && !this.func_70631_g_() && this.field_70146_Z.nextBoolean();
    }

    @Override
    public String getTexture() {
        return "adinferos:textures/entity/reaper.png";
    }

    @Override
    public void onCreateGhost(EntityGhost ghost) {
        ghost.func_184611_a(EnumHand.MAIN_HAND, this.func_184614_ca());
        ghost.func_184642_a(EntityEquipmentSlot.MAINHAND, 1.0f);
    }

    @Override
    public boolean isDarkfireResistant() {
        return true;
    }

    @Override
    public boolean isCurseResistant() {
        return true;
    }

    @Override
    public boolean isWitherResistant() {
        return true;
    }

    @Override
    public boolean isAcidResistant() {
        return true;
    }

    @Override
    public boolean isSpikeResistant() {
        return true;
    }

    private int getDiffculityFactor() {
        switch (this.field_70170_p.func_175659_aa()) {
            default: {
                return 0;
            }
            case EASY: {
                return 1;
            }
            case NORMAL: {
                return 2;
            }
            case HARD: 
        }
        return 3;
    }

    public int getFearDelay() {
        return 10;
    }

    public int getFearAmount() {
        return 13;
    }

    public double getFearRange() {
        return 900.0;
    }

    public PotionEffect getFearEffect() {
        return new PotionEffect(MobEffects.field_76431_k, 90, 0, false, false);
    }

    public double getEffectRange() {
        return 80.0;
    }

    public boolean effectOnTargetOnly() {
        return true;
    }
}

