/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.adinferos.entity.monster;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.superdextor.adinferos.AdInferosSounds;
import com.superdextor.adinferos.blocks.BlockSpawner;
import com.superdextor.adinferos.config.NetherConfig;
import com.superdextor.adinferos.entity.EntityAIObsidianSheepmanTarget;
import com.superdextor.adinferos.entity.ISoulEntity;
import com.superdextor.adinferos.entity.NetherMob;
import com.superdextor.adinferos.entity.monster.EntityGhost;
import com.superdextor.adinferos.init.NetherItems;
import com.superdextor.adinferos.inventory.AdInferosLootTables;
import com.superdextor.adinferos.items.ItemTribeHeadband;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAIZombieAttack;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityObsidianSheepman
extends EntityZombie
implements NetherMob,
ISoulEntity {
    private static final UUID ATTACK_SPEED_BOOST_MODIFIER_UUID = UUID.fromString("49455A49-7EC5-45BA-B886-3B90B23A1718");
    private static final AttributeModifier ATTACK_SPEED_BOOST_MODIFIER = new AttributeModifier(ATTACK_SPEED_BOOST_MODIFIER_UUID, "Attacking speed boost", 0.05, 0).func_111168_a(false);
    private static final DataParameter<Integer> TRIBE_STATE = EntityDataManager.func_187226_a(EntityObsidianSheepman.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TRIBE_COLOR = EntityDataManager.func_187226_a(EntityObsidianSheepman.class, (DataSerializer)DataSerializers.field_187192_b);
    private ObsidianSheepmenTribe tribe = null;
    private UUID tribeUUID = null;
    private int randomSoundDelay;

    public EntityObsidianSheepman(World worldIn) {
        super(worldIn);
        this.fixTargetTask();
        this.field_70178_ae = true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(TRIBE_STATE, (Object)0);
        this.field_70180_af.func_187214_a(TRIBE_COLOR, (Object)EnumDyeColor.WHITE.func_176767_b());
    }

    protected void func_175456_n() {
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIFollowLeader(this, 1.2));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new AIHurtByAggressor(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIObsidianSheepmanTarget(this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(field_110186_bp).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.23500000417232514);
    }

    private void fixTargetTask() {
        for (EntityAITasks.EntityAITaskEntry task : this.field_70714_bg.field_75782_a) {
            if (!(task.field_75733_a instanceof EntityAIZombieAttack)) continue;
            this.field_70714_bg.func_85156_a(task.field_75733_a);
            break;
        }
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AITargetAggressor(this));
    }

    protected void func_70619_bc() {
        if (this.hasTribe() && this.getTribe().isDirty() && this.isLeader()) {
            this.getTribe().initTribe(this.field_70170_p);
        }
        if (this.randomSoundDelay > 0 && --this.randomSoundDelay == 0) {
            this.func_184185_a((SoundEvent)AdInferosSounds.obsidiansheepman_angry, this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) * 1.3f);
        }
        IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (this.func_70638_az() != null) {
            if (!this.func_70631_g_() && !iattributeinstance.func_180374_a(ATTACK_SPEED_BOOST_MODIFIER)) {
                iattributeinstance.func_111121_a(ATTACK_SPEED_BOOST_MODIFIER);
            }
        } else if (iattributeinstance.func_180374_a(ATTACK_SPEED_BOOST_MODIFIER)) {
            iattributeinstance.func_111124_b(ATTACK_SPEED_BOOST_MODIFIER);
        }
        int i = 1200;
        int j = 1200;
        int k = 6000;
        int l = 2;
        if ((this.field_70173_aa + this.func_145782_y()) % 10 == 0) {
            for (EntityPlayerMP entityplayermp : this.field_70170_p.func_175661_b(EntityPlayerMP.class, (Predicate)new Predicate<EntityPlayerMP>(){

                public boolean apply(EntityPlayerMP player) {
                    return EntityObsidianSheepman.this.func_70685_l((Entity)player) && EntityObsidianSheepman.this.func_70068_e((Entity)player) < 80.0 && player.field_71134_c.func_180239_c();
                }
            })) {
                boolean flag = false;
                if (entityplayermp.func_184614_ca() != null && (entityplayermp.func_184614_ca().func_77973_b().equals(Items.field_179561_bm) || entityplayermp.func_184614_ca().func_77973_b().equals(Items.field_179557_bn))) {
                    flag = true;
                }
                if (entityplayermp.func_184592_cb() != null && (entityplayermp.func_184592_cb().func_77973_b().equals(Items.field_179561_bm) || entityplayermp.func_184592_cb().func_77973_b().equals(Items.field_179557_bn))) {
                    flag = true;
                }
                if (!flag) continue;
                this.func_70624_b((EntityLivingBase)entityplayermp);
            }
        }
        if (!this.hasTribe() && (this.field_70173_aa + this.func_145782_y()) % 100 == 0 && !this.isLeader()) {
            this.joinTribe();
        }
        super.func_70619_bc();
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    public boolean func_70058_J() {
        return this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ());
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74757_a("IsLeader", this.isLeader());
        if (this.hasTribe()) {
            tagCompound.func_186854_a("TribeUUID", this.getTribe().tribeUUID);
            if (this.isLeader()) {
                NBTTagCompound tribeInfo = new NBTTagCompound();
                this.tribe.writeToNBT(tribeInfo);
                tagCompound.func_74782_a("TribeInfo", (NBTBase)tribeInfo);
            }
        }
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        if (tagCompund.func_74767_n("IsLeader")) {
            this.setLeader(true);
            if (tagCompund.func_74764_b("TribeInfo")) {
                NBTTagCompound tribeInfo = tagCompund.func_74775_l("TribeInfo");
                this.createTribe(tribeInfo);
            } else {
                this.createTribe(null);
            }
        }
        this.tribeUUID = tagCompund.func_186857_a("TribeUUID");
    }

    protected SoundEvent func_184639_G() {
        return AdInferosSounds.obsidiansheepman_idle.getSound();
    }

    protected SoundEvent func_184601_bQ() {
        return AdInferosSounds.obsidiansheepman_hurt.getSound();
    }

    protected SoundEvent func_184615_bR() {
        return AdInferosSounds.obsidiansheepman_death.getSound();
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        this.func_184185_a(SoundEvents.field_187605_cG, 0.15f, 1.0f);
    }

    protected ResourceLocation func_184647_J() {
        return AdInferosLootTables.ENTITIES_OBSIDIAN_SHEEPMAN;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand p_184645_2_, ItemStack stack) {
        return false;
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(NetherItems.obsidian_sword));
        this.fixArmor();
    }

    private void fixArmor() {
        ItemStack armor = this.func_184582_a(EntityEquipmentSlot.HEAD);
        Item item = null;
        Item newArmor = null;
        if (armor != null) {
            item = armor.func_77973_b();
            newArmor = item.equals(Items.field_151161_ac) || item.equals(Items.field_151028_Y) ? NetherItems.netherite_helmet : NetherItems.obsidian_helmet;
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(newArmor));
        }
        if ((armor = this.func_184582_a(EntityEquipmentSlot.CHEST)) != null) {
            item = armor.func_77973_b();
            newArmor = item.equals(Items.field_151163_ad) || item.equals(Items.field_151030_Z) ? NetherItems.netherite_chestplate : NetherItems.obsidian_chestplate;
            this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(newArmor));
        }
        if ((armor = this.func_184582_a(EntityEquipmentSlot.LEGS)) != null) {
            item = armor.func_77973_b();
            newArmor = item.equals(Items.field_151173_ae) || item.equals(Items.field_151165_aa) ? NetherItems.netherite_leggings : NetherItems.obsidian_leggings;
            this.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack(newArmor));
        }
        if ((armor = this.func_184582_a(EntityEquipmentSlot.FEET)) != null) {
            item = armor.func_77973_b();
            newArmor = item.equals(Items.field_151175_af) || item.equals(Items.field_151167_ab) ? NetherItems.netherite_boots : NetherItems.obsidian_boots;
            this.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack(newArmor));
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        super.func_180482_a(difficulty, livingdata);
        this.func_184732_df();
        this.func_146070_a(true);
        if (!this.func_70631_g_() && ObsidianSheepmenTribe.isColorAvailable() && this.field_70146_Z.nextFloat() < 0.1f) {
            this.setLeader(true);
            this.createTribe(null);
            this.func_70606_j(this.func_110138_aP());
            this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(NetherItems.obsidian_sword));
            this.func_184201_a(EntityEquipmentSlot.HEAD, null);
        }
        NetherConfig.printDebugInfo(this.func_70005_c_() + " was spawned at " + this.func_180425_c());
        return livingdata;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76346_g() instanceof EntityLivingBase && this.hasTribe()) {
            this.getTribe().blackListEntity((EntityLivingBase)source.func_76346_g());
            this.doAngrySound();
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70645_a(DamageSource cause) {
        if (cause.func_76346_g() instanceof EntityPlayer && this.canMakeGhost()) {
            EntityGhost.createGhost(this.field_70170_p, (EntityLiving)this, this);
        }
        if (this.hasTribe()) {
            if (cause.func_76346_g() instanceof EntityLivingBase && this.hasTribe()) {
                this.getTribe().blackListEntity((EntityLivingBase)cause.func_76346_g());
                if (this.isLeader() && this.hasTribe() && this.getTribe().hasMembers() && cause.func_76346_g() instanceof EntityPlayer) {
                    ItemStack stack = new ItemStack((Item)NetherItems.tribe_headband);
                    this.getTribe().setPlayerControlled((EntityPlayer)cause.func_76346_g());
                    ItemTribeHeadband.setTribeIn(stack, this.getTribe());
                    this.func_70099_a(stack, 0.0f);
                }
            }
            this.getTribe().removeMember(this);
        }
        super.func_70645_a(cause);
    }

    public void func_70106_y() {
        if (this.hasTribe()) {
            this.getTribe().removeMember(this);
        }
        super.func_70106_y();
    }

    protected boolean func_70692_ba() {
        if (this.hasTribe() && this.getTribe().isPlayerControlled()) {
            return false;
        }
        return super.func_70692_ba();
    }

    public EnumDyeColor getTribeColor() {
        return EnumDyeColor.func_176766_a((int)((Integer)this.field_70180_af.func_187225_a(TRIBE_COLOR) & 0xF));
    }

    public void setTribeColor(EnumDyeColor collarcolor) {
        this.field_70180_af.func_187227_b(TRIBE_COLOR, (Object)collarcolor.func_176767_b());
    }

    public boolean isLeader() {
        return (Integer)this.func_184212_Q().func_187225_a(TRIBE_STATE) == 2;
    }

    public void setLeader(boolean value) {
        this.func_184212_Q().func_187227_b(TRIBE_STATE, (Object)(value ? 2 : 0));
        if (value) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(60.0);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
        }
    }

    public boolean isMember() {
        return (Integer)this.func_184212_Q().func_187225_a(TRIBE_STATE) == 1;
    }

    public void setMember(boolean value) {
        this.func_184212_Q().func_187227_b(TRIBE_STATE, (Object)(value ? 1 : 0));
    }

    private void joinTribe() {
        block2: {
            block1: {
                if (this.tribeUUID == null) break block1;
                ObsidianSheepmenTribe tribe = ObsidianSheepmenTribe.getTribeFromUUID(this.tribeUUID);
                if (tribe == null) break block2;
                this.setTribe(tribe);
                break block2;
            }
            for (EntityObsidianSheepman sheepMan : this.field_70170_p.func_175644_a(EntityObsidianSheepman.class, (Predicate)new Predicate<EntityObsidianSheepman>(){

                public boolean apply(EntityObsidianSheepman sheepMan) {
                    return sheepMan.isLeader() && sheepMan.hasTribe() && sheepMan.func_70089_S();
                }
            })) {
                if (!(sheepMan.func_70068_e((Entity)this) < 80.0)) continue;
                sheepMan.getTribe().addMember(this);
                break;
            }
        }
    }

    private void createTribe(NBTTagCompound data) {
        if (this.hasTribe()) {
            this.getTribe().removeMember(this);
        }
        if (data != null) {
            this.setTribe(ObsidianSheepmenTribe.createFromNBT(this.func_110124_au(), this, data));
        } else {
            this.setTribe(new ObsidianSheepmenTribe(this.func_110124_au(), this, ObsidianSheepmenTribe.getRandomColor(this.field_70146_Z)));
        }
    }

    public boolean hasTribe() {
        return this.tribe != null;
    }

    public ObsidianSheepmenTribe getTribe() {
        return this.tribe;
    }

    public void setTribe(ObsidianSheepmenTribe tribeIn) {
        if (!this.isLeader()) {
            this.setMember(tribeIn != null);
        }
        this.tribe = tribeIn;
        if (tribeIn != null) {
            this.tribeUUID = tribeIn.tribeUUID;
            this.setTribeColor(tribeIn.tribeColor);
        } else {
            this.tribeUUID = null;
            this.setTribeColor(EnumDyeColor.WHITE);
        }
    }

    public void doAngrySound() {
        this.randomSoundDelay = this.field_70146_Z.nextInt(40);
    }

    @Override
    public boolean canMakeGhost() {
        return NetherConfig.ghostSpawnFromEntities && !this.func_70631_g_() && !this.isLeader() && !BlockSpawner.isSpawnerEntity((Entity)this) && this.field_70146_Z.nextInt(30) == 0;
    }

    @Override
    public String getTexture() {
        return "adinferos:textures/entity/obsidian_sheepman/main.png";
    }

    @Override
    public void onCreateGhost(EntityGhost ghost) {
    }

    @Override
    public boolean isDarkfireResistant() {
        return false;
    }

    @Override
    public boolean isCurseResistant() {
        return false;
    }

    @Override
    public boolean isWitherResistant() {
        return false;
    }

    @Override
    public boolean isAcidResistant() {
        return true;
    }

    @Override
    public boolean isSpikeResistant() {
        return false;
    }

    static class AIHurtByAggressor
    extends EntityAIHurtByTarget {
        private final EntityObsidianSheepman entitySheepman;

        public AIHurtByAggressor(EntityObsidianSheepman entity) {
            super((EntityCreature)entity, false, new Class[0]);
            this.entitySheepman = entity;
        }

        protected boolean func_75296_a(EntityLivingBase target, boolean includeInvincibles) {
            if (this.entitySheepman.hasTribe() && this.entitySheepman.getTribe().isAlly(target)) {
                return false;
            }
            return super.func_75296_a(target, includeInvincibles);
        }
    }

    static class AITargetAggressor
    extends EntityAIZombieAttack {
        private final EntityObsidianSheepman sheepMan;

        public AITargetAggressor(EntityObsidianSheepman entity) {
            super((EntityZombie)entity, 1.0, false);
            this.sheepMan = entity;
        }

        public boolean func_75250_a() {
            if (this.sheepMan.func_70638_az() == null) {
                return false;
            }
            if (this.sheepMan.hasTribe() && this.sheepMan.getTribe().isAlly(this.sheepMan.func_70638_az())) {
                return false;
            }
            return super.func_75250_a();
        }

        public boolean func_75253_b() {
            if (this.sheepMan.hasTribe() && this.sheepMan.getTribe().isAlly(this.sheepMan.func_70638_az())) {
                this.sheepMan.field_70717_bb = null;
                this.sheepMan.func_130011_c((Entity)((EntityLivingBase)null));
                this.sheepMan.func_70604_c(null);
                this.sheepMan.func_70661_as().func_75484_a(null, 0.0);
                this.sheepMan.func_70624_b(null);
                return false;
            }
            return super.func_75253_b();
        }
    }

    public static class AIFollowLeader
    extends EntityAIBase {
        EntityObsidianSheepman taskOwner;
        EntityLivingBase tribeLeader;
        double moveSpeed;
        private int delayCounter;

        public AIFollowLeader(EntityObsidianSheepman entityIn, double speed) {
            this.taskOwner = entityIn;
            this.moveSpeed = speed;
        }

        public boolean func_75250_a() {
            if (!this.taskOwner.hasTribe()) {
                return false;
            }
            if (this.taskOwner.getTribe().getLeader() == null) {
                return false;
            }
            this.tribeLeader = this.taskOwner.getTribe().getLeader();
            double d0 = this.taskOwner.func_70068_e((Entity)this.tribeLeader);
            return !(d0 < 140.0) && this.taskOwner.func_70638_az() == null && this.taskOwner.func_70661_as().func_75500_f();
        }

        public boolean func_75253_b() {
            if (!this.taskOwner.hasTribe()) {
                return false;
            }
            if (!this.tribeLeader.func_70089_S()) {
                return false;
            }
            if (this.taskOwner.func_70068_e((Entity)this.tribeLeader) < 80.0) {
                this.taskOwner.func_70661_as().func_75484_a(null, 0.0);
                return false;
            }
            return true;
        }

        public void func_75249_e() {
            this.delayCounter = 0;
        }

        public void func_75251_c() {
            this.tribeLeader = null;
        }

        public void func_75246_d() {
            if (--this.delayCounter <= 0) {
                this.delayCounter = 10;
                this.taskOwner.func_70661_as().func_75497_a((Entity)this.tribeLeader, this.moveSpeed);
            }
        }
    }

    public static class ObsidianSheepmenTribe {
        private EntityLivingBase leader;
        private final ArrayList<EntityObsidianSheepman> members;
        private final ArrayList<UUID> blackListedEntities;
        private UUID tribeUUID = null;
        private EnumDyeColor tribeColor = EnumDyeColor.WHITE;
        private static final Map<UUID, ObsidianSheepmenTribe> tribes = Maps.newHashMap();
        private static final ArrayList<EnumDyeColor> colors = ObsidianSheepmenTribe.buildColorList();
        private boolean markDirty = false;

        public ObsidianSheepmenTribe(UUID uuid, EntityObsidianSheepman leaderIn, EnumDyeColor color) {
            this.leader = leaderIn;
            this.members = new ArrayList();
            this.blackListedEntities = new ArrayList();
            this.tribeUUID = uuid;
            this.tribeColor = color;
            tribes.put(uuid, this);
            colors.remove(color);
        }

        public boolean isDirty() {
            return this.markDirty;
        }

        public void initTribe(World world) {
            for (EntityObsidianSheepman sheepMan : world.func_175644_a(EntityObsidianSheepman.class, (Predicate)new Predicate<EntityObsidianSheepman>(){

                public boolean apply(EntityObsidianSheepman sheepMan) {
                    return sheepMan != null && !sheepMan.isLeader() && !sheepMan.hasTribe() && sheepMan.tribeUUID != null && sheepMan.tribeUUID.equals(ObsidianSheepmenTribe.this.tribeUUID);
                }
            })) {
                this.addMember(sheepMan);
            }
            this.markDirty = false;
        }

        public void addMember(EntityObsidianSheepman sheepMan) {
            this.members.add(sheepMan);
            sheepMan.setTribe(this);
        }

        public void removeMember(EntityObsidianSheepman sheepMan) {
            this.members.remove(sheepMan);
            sheepMan.setTribe(null);
            if (sheepMan.equals(this.leader)) {
                this.disband();
            }
        }

        public void disband() {
            for (EntityObsidianSheepman member : this.members) {
                member.setTribe(null);
            }
            if (this.leader instanceof EntityObsidianSheepman) {
                ((EntityObsidianSheepman)this.leader).setLeader(false);
            }
            this.leader = null;
            this.members.clear();
            this.blackListedEntities.clear();
            tribes.remove(this.tribeUUID);
            colors.add(this.tribeColor);
        }

        public void blackListEntity(EntityLivingBase entity) {
            if (!this.isAlly(entity)) {
                this.blackListedEntities.add(entity.func_110124_au());
            }
        }

        public boolean isEntityBlackListed(EntityLivingBase entity) {
            if (this.isAlly(entity)) {
                return false;
            }
            return this.blackListedEntities.contains(entity.func_110124_au());
        }

        public boolean isAlly(EntityLivingBase entity) {
            if (this.getLeader() != null && entity != null && entity.func_110124_au() == this.getLeader().func_110124_au()) {
                return true;
            }
            return this.members.contains(entity);
        }

        public void setLeader(EntityLivingBase leader) {
            this.leader = leader;
            if (this.blackListedEntities.contains(this.leader.func_110124_au())) {
                this.blackListedEntities.remove(this.leader.func_110124_au());
            }
            for (EntityObsidianSheepman member : this.members) {
                member.func_70624_b(null);
            }
        }

        public EntityLivingBase getLeader() {
            if (this.leader instanceof EntityPlayer) {
                if (this.leader.func_184582_a(EntityEquipmentSlot.HEAD) != null) {
                    ItemStack stack = this.leader.func_184582_a(EntityEquipmentSlot.HEAD);
                    if (!ItemTribeHeadband.getTribeUUID(stack).equals(this.tribeUUID)) {
                        return null;
                    }
                } else {
                    return null;
                }
            }
            return this.leader;
        }

        public EntityLivingBase theLeader() {
            return this.leader;
        }

        public UUID getUUID() {
            return this.tribeUUID;
        }

        public EnumDyeColor getColor() {
            return this.tribeColor;
        }

        public ArrayList<EntityObsidianSheepman> getMembers() {
            return this.members;
        }

        public boolean isPlayerControlled() {
            return this.theLeader() instanceof EntityPlayer;
        }

        public boolean hasMembers() {
            return this.members.size() > 0;
        }

        public void setPlayerControlled(EntityPlayer leader) {
            this.leader = leader;
            tribes.remove(this.tribeUUID);
            this.tribeUUID = leader.func_110124_au();
            tribes.put(this.tribeUUID, this);
            if (this.blackListedEntities.contains(this.leader.func_110124_au())) {
                this.blackListedEntities.remove(this.tribeUUID);
            }
            for (EntityObsidianSheepman member : this.members) {
                member.func_70624_b(null);
            }
        }

        public void writeToNBT(NBTTagCompound tagCompound) {
            tagCompound.func_74774_a("Color", (byte)this.tribeColor.func_176767_b());
            NBTTagList enemies = new NBTTagList();
            for (UUID enemy : this.blackListedEntities) {
                NBTTagCompound enemyNBT = new NBTTagCompound();
                enemyNBT.func_186854_a("UUID", enemy);
                enemies.func_74742_a((NBTBase)enemyNBT);
            }
            tagCompound.func_74782_a("Enemies", (NBTBase)enemies);
        }

        public static ObsidianSheepmenTribe createFromNBT(UUID uuidIn, EntityObsidianSheepman leader, NBTTagCompound tagCompound) {
            EnumDyeColor color = EnumDyeColor.WHITE;
            if (tagCompound.func_150297_b("Color", 99)) {
                color = EnumDyeColor.func_176766_a((int)tagCompound.func_74771_c("Color"));
            }
            ObsidianSheepmenTribe tribe = new ObsidianSheepmenTribe(uuidIn, leader, color);
            tribe.markDirty = true;
            if (tagCompound.func_74764_b("Enemies")) {
                NBTTagList enemies = tagCompound.func_150295_c("Enemies", 10);
                for (int i = 0; i < enemies.func_74745_c(); ++i) {
                    NBTTagCompound enemy = enemies.func_150305_b(i);
                    UUID uuid = enemy.func_186857_a("UUID");
                    tribe.blackListedEntities.add(uuid);
                }
            }
            return tribe;
        }

        public static EnumDyeColor getRandomColor(Random rand) {
            if (colors.size() < 1) {
                return EnumDyeColor.WHITE;
            }
            return colors.get(rand.nextInt(colors.size()));
        }

        public static boolean isColorAvailable() {
            return colors.size() > 0;
        }

        public static ObsidianSheepmenTribe getTribeFromUUID(UUID uuid) {
            return tribes.get(uuid);
        }

        public static ObsidianSheepmenTribe getTribeFromEntity(Entity entity) {
            return tribes.get(entity.func_110124_au());
        }

        private static ArrayList<EnumDyeColor> buildColorList() {
            ArrayList<EnumDyeColor> list = new ArrayList<EnumDyeColor>();
            list.add(EnumDyeColor.ORANGE);
            list.add(EnumDyeColor.MAGENTA);
            list.add(EnumDyeColor.LIGHT_BLUE);
            list.add(EnumDyeColor.YELLOW);
            list.add(EnumDyeColor.LIME);
            list.add(EnumDyeColor.PINK);
            list.add(EnumDyeColor.GRAY);
            list.add(EnumDyeColor.SILVER);
            list.add(EnumDyeColor.CYAN);
            list.add(EnumDyeColor.PURPLE);
            list.add(EnumDyeColor.BLUE);
            list.add(EnumDyeColor.BROWN);
            list.add(EnumDyeColor.GREEN);
            list.add(EnumDyeColor.RED);
            return list;
        }
    }
}

