/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.adinferos.entity.monster;

import com.superdextor.adinferos.AdInferosSounds;
import com.superdextor.adinferos.config.NetherConfig;
import com.superdextor.adinferos.entity.ISoulEntity;
import com.superdextor.adinferos.entity.NetherMob;
import com.superdextor.adinferos.entity.monster.EntityGhost;
import com.superdextor.adinferos.entity.monster.EntityGlowstoneSkeleton;
import com.superdextor.adinferos.entity.monster.EntityHerobrineClone;
import com.superdextor.adinferos.init.NetherBlocks;
import com.superdextor.adinferos.init.NetherItems;
import com.superdextor.adinferos.inventory.AdInferosLootTables;
import com.superdextor.thinkbigcore.entity.IFearedEntity;
import com.superdextor.thinkbigcore.entity.ai.EntityAIBreakblocks;
import com.superdextor.thinkbigcore.items.IEntityUsable;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentFrostWalker;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EntityHerobrine
extends EntityMob
implements IRangedAttackMob,
NetherMob,
IFearedEntity,
ISoulEntity {
    private static final DataParameter<Boolean> IS_CLOAKING = EntityDataManager.func_187226_a(EntityHerobrine.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_ATTACKING = EntityDataManager.func_187226_a(EntityHerobrine.class, (DataSerializer)DataSerializers.field_187198_h);
    private EntityAIAttackRanged aiArrowAttack = new EntityAIAttackRanged((IRangedAttackMob)this, 1.25, 7, 10.0f);
    private EntityAIAttackMelee aiAttackOnCollide = new EntityAIAttackMelee((EntityCreature)this, 1.2, false);
    private int cooldown = 20;
    private int attackUpdateTimer = 0;
    private int specialCooldown = 300;
    private int randomTeleportCooldown = 120;
    private int angerCounter = 0;

    public EntityHerobrine(World worldIn) {
        super(worldIn);
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.func_184644_a(PathNodeType.DOOR_WOOD_CLOSED, 0.0f);
        this.func_184644_a(PathNodeType.LAVA, 0.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
        this.func_184644_a(PathNodeType.BLOCKED, 8.0f);
        this.func_184644_a(PathNodeType.FENCE, 0.0f);
        this.field_70728_aV = 100;
        this.field_70178_ae = true;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        ArrayList<Block> unbreakable = new ArrayList<Block>();
        unbreakable.add(NetherBlocks.hardened_lava);
        unbreakable.add(Blocks.field_185778_de);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIBreakblocks((EntityCreature)this, 80.0f, true, false, true, unbreakable));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityGolem.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(300.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.46);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(80.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(3.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(IS_CLOAKING, (Object)false);
        this.func_184212_Q().func_187214_a(IS_ATTACKING, (Object)false);
    }

    protected SoundEvent func_184639_G() {
        return null;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187517_aG;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187860_ff;
    }

    protected float func_70647_i() {
        return super.func_70647_i() * 0.7f;
    }

    protected ResourceLocation func_184647_J() {
        return AdInferosLootTables.ENTITIES_HEROBRINE;
    }

    public void setCombatTask() {
        this.func_184642_a(EntityEquipmentSlot.MAINHAND, 2.0f);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiArrowAttack);
        this.cooldown = 20;
        ItemStack newStack = new ItemStack(Items.field_151055_y);
        switch (this.field_70146_Z.nextInt(5)) {
            case 0: {
                newStack = new ItemStack(NetherItems.scythe, 1, 0);
                this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiAttackOnCollide);
                break;
            }
            case 1: {
                newStack = new ItemStack(NetherItems.inferno_staff, 1, 0);
                this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiArrowAttack);
                break;
            }
            case 2: {
                newStack = new ItemStack(NetherItems.glowstone_sword, 1, 0);
                this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiArrowAttack);
                break;
            }
            case 3: {
                newStack = new ItemStack(NetherItems.wither_staff, 1, 0);
                this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiArrowAttack);
                break;
            }
            case 4: {
                newStack = new ItemStack(NetherItems.wither_bow, 1, 0);
                this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiArrowAttack);
            }
        }
        this.func_184611_a(EnumHand.MAIN_HAND, newStack);
        this.func_184185_a(SoundEvents.field_187719_p, 2.0f, 0.8f);
    }

    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K) {
            ItemStack heldItem = this.func_184614_ca();
            if (this.func_70638_az() != null) {
                if (this.attackUpdateTimer <= 0) {
                    this.setCombatTask();
                    this.attackUpdateTimer = 100 + this.field_70146_Z.nextInt(70);
                } else {
                    --this.attackUpdateTimer;
                }
                if (this.cooldown > 0) {
                    --this.cooldown;
                }
                if (heldItem != null) {
                    if (this.cooldown == 50 && heldItem.func_77973_b() == NetherItems.wither_staff) {
                        this.func_184185_a(SoundEvents.field_187925_gy, 1.3f, 0.9f);
                    }
                    if (this.cooldown == 50 && heldItem.func_77973_b() == NetherItems.inferno_staff) {
                        this.func_184185_a(SoundEvents.field_187555_bJ, 1.3f, 0.9f);
                    }
                }
                if (this.specialCooldown < 1) {
                    this.specialAttack(this.field_70146_Z.nextInt(2));
                } else {
                    --this.specialCooldown;
                }
                if (this.func_70068_e((Entity)this.func_70638_az()) > 400.0) {
                    this.teleportToEntity((Entity)this.func_70638_az());
                }
                if (!this.isCloaking()) {
                    --this.randomTeleportCooldown;
                    if (this.randomTeleportCooldown < 0) {
                        this.randomTeleportCooldown = 230 + this.field_70146_Z.nextInt(201);
                        this.teleportRandomly();
                    }
                }
            } else {
                if (this.angerCounter > 0) {
                    --this.angerCounter;
                    if (this.angerCounter < 1) {
                        this.angerCounter = 0;
                        this.setAttacking(false);
                    }
                }
                if (heldItem != null) {
                    this.func_184611_a(EnumHand.MAIN_HAND, null);
                    this.setCloaking(false);
                    this.cooldown = 20;
                    this.attackUpdateTimer = 0;
                    this.specialCooldown = 400 + this.field_70146_Z.nextInt(200);
                    this.randomTeleportCooldown = 120;
                }
            }
        }
        super.func_70636_d();
    }

    public boolean func_70058_J() {
        return this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ());
    }

    protected void specialAttack(int attackID) {
        switch (attackID) {
            default: {
                EntityHerobrineClone clone = null;
                int k = this.field_70146_Z.nextInt(5) + 7;
                for (int x = 0; x < k; ++x) {
                    EntityHerobrineClone entityclone = new EntityHerobrineClone(this.field_70170_p);
                    entityclone.setOwner(this, this.func_70638_az());
                    entityclone.func_184611_a(EnumHand.MAIN_HAND, this.func_184614_ca());
                    this.spawnMob((EntityLiving)entityclone, 5);
                    clone = entityclone;
                    entityclone.teleportRandomly();
                }
                if (this.func_70638_az() instanceof EntityLiving) {
                    ((EntityLiving)this.func_70638_az()).func_70624_b(clone);
                }
                this.func_184185_a((SoundEvent)AdInferosSounds.reaper_cloak, 1.6f, 0.8f);
                this.func_184185_a(SoundEvents.field_187534_aX, 1.6f, 1.3f);
                this.setCloaking(true);
                this.teleportRandomly();
                break;
            }
            case 1: {
                EntityGlowstoneSkeleton glowstoneSkeleton = new EntityGlowstoneSkeleton(this.field_70170_p);
                glowstoneSkeleton.func_70624_b(this.func_70638_az());
                glowstoneSkeleton.setDimstoneSkeleton(true);
                glowstoneSkeleton.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(NetherItems.wither_staff));
                glowstoneSkeleton.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(NetherItems.wither_helmet));
                glowstoneSkeleton.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(NetherItems.wither_chestplate));
                glowstoneSkeleton.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack(NetherItems.wither_leggings));
                glowstoneSkeleton.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack(NetherItems.wither_boots));
                this.spawnMob((EntityLiving)glowstoneSkeleton, 2);
                this.func_184185_a(SoundEvents.field_187594_A, 1.6f, 1.0f);
            }
        }
        this.specialCooldown = 800 + this.field_70146_Z.nextInt(200);
    }

    public void func_70098_U() {
        super.func_70098_U();
        if (this.func_184187_bx() instanceof EntityCreature) {
            EntityCreature entitycreature = (EntityCreature)this.func_184187_bx();
            this.field_70761_aq = entitycreature.field_70761_aq;
        }
    }

    private void spawnMob(EntityLiving entity, int radius) {
        entity.func_70012_b(this.field_70165_t - (double)(2 + radius) + (double)this.field_70146_Z.nextInt(5 + radius), this.field_70163_u, this.field_70161_v - (double)(2 + radius) + (double)this.field_70146_Z.nextInt(5 + radius), 0.0f, 0.0f);
        for (int x = 0; x < 10 && entity.func_70094_T(); ++x) {
            entity.field_70163_u += 1.0;
        }
        this.field_70170_p.func_72838_d((Entity)entity);
    }

    protected boolean teleportRandomly() {
        double k2;
        double k1;
        double k0;
        double d0 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        double d1 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(64) - 32);
        double d2 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        if (this.func_70638_az() != null && (k0 = d0 - this.func_70638_az().field_70165_t) * k0 + (k1 = d1 - this.func_70638_az().field_70163_u) * k1 + (k2 = d2 - this.func_70638_az().field_70161_v) * k2 > 400.0) {
            return this.teleportToEntity((Entity)this.func_70638_az());
        }
        return this.teleportTo(d0, d1, d2);
    }

    protected boolean teleportToEntity(Entity p_70816_1_) {
        Vec3d vec3d = new Vec3d(this.field_70165_t - p_70816_1_.field_70165_t, this.func_174813_aQ().field_72338_b + (double)(this.field_70131_O / 2.0f) - p_70816_1_.field_70163_u + (double)p_70816_1_.func_70047_e(), this.field_70161_v - p_70816_1_.field_70161_v);
        vec3d = vec3d.func_72432_b();
        double d0 = 16.0;
        double d1 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3d.field_72450_a * d0;
        double d2 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(16) - 8) - vec3d.field_72448_b * d0;
        double d3 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3d.field_72449_c * d0;
        return this.teleportTo(d1, d2, d3);
    }

    private boolean teleportTo(double x, double y, double z) {
        double soundX = this.field_70165_t;
        double soundY = this.field_70163_u;
        double soundZ = this.field_70161_v;
        EnderTeleportEvent event = new EnderTeleportEvent((EntityLivingBase)this, x, y, z, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        boolean flag = this.func_184595_k(event.getTargetX(), event.getTargetY(), event.getTargetZ());
        if (flag) {
            this.field_70170_p.func_184148_a((EntityPlayer)null, soundX, soundY, soundZ, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
            this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        }
        return flag;
    }

    protected boolean func_70692_ba() {
        return !this.isAttacking();
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> cls) {
        return cls != EntityGlowstoneSkeleton.class && super.func_70686_a(cls);
    }

    public void func_70624_b(EntityLivingBase entitylivingbaseIn) {
        super.func_70624_b(entitylivingbaseIn);
        if (entitylivingbaseIn != null) {
            this.setAttacking(true);
            this.angerCounter = 120;
        }
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source == DamageSource.field_82727_n) {
            return false;
        }
        if (source.func_76346_g() != null && source.func_76346_g().equals((Object)this)) {
            return false;
        }
        if (source.func_76346_g() instanceof EntityLivingBase) {
            this.setCloaking(false);
        }
        return super.func_70097_a(source, damage);
    }

    public void func_70645_a(DamageSource cause) {
        this.func_184185_a((SoundEvent)AdInferosSounds.music_victory, 1.0f, 1.0f);
        if (cause.func_76346_g() instanceof EntityPlayer && this.canMakeGhost()) {
            EntityGhost.createGhost(this.field_70170_p, (EntityLiving)this, this);
        }
        super.func_70645_a(cause);
    }

    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            ItemStack heldItem = this.func_184586_b(EnumHand.MAIN_HAND);
            if (entity instanceof EntityLivingBase && this.func_70638_az() != null && heldItem != null && heldItem.func_77973_b() instanceof IEntityUsable && entity instanceof EntityLivingBase) {
                ((IEntityUsable)heldItem.func_77973_b()).onMeleeAttack((EntityLiving)this, (EntityLivingBase)entity, heldItem);
            }
            return true;
        }
        return false;
    }

    public void func_82196_d(EntityLivingBase entity, float f) {
        ItemStack heldItem = this.func_184586_b(EnumHand.MAIN_HAND);
        Item item = null;
        boolean flag = false;
        if (heldItem != null) {
            item = heldItem.func_77973_b();
            flag = true;
            if (item.equals(NetherItems.wither_bow)) {
                boolean bl = flag = this.cooldown < 1;
            }
            if (item.equals(NetherItems.inferno_staff)) {
                boolean bl = flag = this.cooldown < 40;
            }
            if (item.equals(NetherItems.wither_staff)) {
                boolean bl = flag = this.cooldown < 30;
            }
        }
        if (flag && heldItem.func_77973_b() instanceof IEntityUsable) {
            ((IEntityUsable)item).onRangedAttack((EntityLiving)this, entity, heldItem, true);
            if (this.cooldown < 1) {
                if (item == NetherItems.inferno_staff) {
                    this.cooldown = 120;
                } else if (item == NetherItems.wither_staff) {
                    this.cooldown = 120;
                }
                if (item == NetherItems.quartz_bow) {
                    this.cooldown = 8;
                }
            }
        }
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74757_a("isCloaking", this.isCloaking());
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        if (tagCompund.func_150297_b("isCloaking", 1)) {
            this.setCloaking(tagCompund.func_74767_n("isCloaking"));
        }
    }

    public void func_70612_e(float strafe, float forward) {
        super.func_70612_e(strafe, forward);
        EntityHerobrine.hardenLava((EntityLivingBase)this, this.field_70170_p, this.func_180425_c(), 2);
        EnchantmentFrostWalker.func_185266_a((EntityLivingBase)this, (World)this.field_70170_p, (BlockPos)this.func_180425_c(), (int)2);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        NetherConfig.printDebugInfo(this.func_70005_c_() + " was spawned at " + this.func_180425_c());
        return super.func_180482_a(difficulty, livingdata);
    }

    public static void hardenLava(EntityLivingBase entityIn, World worldIn, BlockPos posIn, int range) {
        if (entityIn.field_70122_E) {
            float f = Math.min(16, 2 + range);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(0, 0, 0);
            for (BlockPos.MutableBlockPos blockpos$mutableblockpos1 : BlockPos.func_177975_b((BlockPos)posIn.func_177963_a((double)(-f), -1.0, (double)(-f)), (BlockPos)posIn.func_177963_a((double)f, -1.0, (double)f))) {
                IBlockState iblockstate1;
                if (!(blockpos$mutableblockpos1.func_177957_d(entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v) <= (double)(f * f))) continue;
                blockpos$mutableblockpos.func_181079_c(blockpos$mutableblockpos1.func_177958_n(), blockpos$mutableblockpos1.func_177956_o() + 1, blockpos$mutableblockpos1.func_177952_p());
                IBlockState iblockstate = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos);
                if (iblockstate.func_177230_c() != Blocks.field_150350_a || (iblockstate1 = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos1)).func_185904_a() != Material.field_151587_i || (Integer)iblockstate1.func_177229_b((IProperty)BlockLiquid.field_176367_b) != 0 || !worldIn.func_175716_a(NetherBlocks.hardened_lava, (BlockPos)blockpos$mutableblockpos1, false, EnumFacing.DOWN, (Entity)null, (ItemStack)null)) continue;
                worldIn.func_175656_a((BlockPos)blockpos$mutableblockpos1, NetherBlocks.hardened_lava.func_176203_a(1));
                worldIn.func_175684_a(blockpos$mutableblockpos1.func_185334_h(), NetherBlocks.hardened_lava, MathHelper.func_76136_a((Random)entityIn.func_70681_au(), (int)60, (int)120));
            }
        }
    }

    public boolean isCloaking() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_CLOAKING);
    }

    protected void setCloaking(boolean value) {
        this.func_184212_Q().func_187227_b(IS_CLOAKING, (Object)value);
    }

    public boolean isAttacking() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_ATTACKING);
    }

    public void setAttacking(boolean value) {
        this.func_184212_Q().func_187227_b(IS_ATTACKING, (Object)value);
    }

    public boolean func_184222_aU() {
        return false;
    }

    public int func_70641_bl() {
        return 1;
    }

    @Override
    public boolean canMakeGhost() {
        return NetherConfig.ghostSpawnFromEntities;
    }

    @Override
    public String getTexture() {
        return "adinferos:textures/entity/herobrine.png";
    }

    @Override
    public void onCreateGhost(EntityGhost ghost) {
    }

    @Override
    public boolean isDarkfireResistant() {
        return true;
    }

    @Override
    public boolean isCurseResistant() {
        return true;
    }

    @Override
    public boolean isWitherResistant() {
        return true;
    }

    @Override
    public boolean isAcidResistant() {
        return true;
    }

    @Override
    public boolean isSpikeResistant() {
        return true;
    }

    public int getFearDelay() {
        return 7;
    }

    public int getFearAmount() {
        return 15;
    }

    public double getFearRange() {
        return 900.0;
    }

    public PotionEffect getFearEffect() {
        return null;
    }

    public double getEffectRange() {
        return 0.0;
    }

    public boolean effectOnTargetOnly() {
        return false;
    }
}

