/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.adinferos.entity.monster;

import com.google.common.base.Predicate;
import com.superdextor.adinferos.AdInferosSounds;
import com.superdextor.adinferos.blocks.BlockSpawner;
import com.superdextor.adinferos.config.NetherConfig;
import com.superdextor.adinferos.entity.ISoulEntity;
import com.superdextor.adinferos.entity.NetherMob;
import com.superdextor.adinferos.entity.monster.EntityGhost;
import com.superdextor.adinferos.entity.monster.EntityHerobrine;
import com.superdextor.adinferos.init.NetherItems;
import com.superdextor.adinferos.inventory.AdInferosLootTables;
import com.superdextor.adinferos.world.WorldProviderAbyss;
import com.superdextor.thinkbigcore.helpers.EntityHelper;
import java.util.Calendar;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityGlowstoneSkeleton
extends EntityMob
implements IRangedAttackMob,
NetherMob,
ISoulEntity {
    private static final DataParameter<Boolean> IS_BABY = EntityDataManager.func_187226_a(EntityGlowstoneSkeleton.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_DIM = EntityDataManager.func_187226_a(EntityGlowstoneSkeleton.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_USING_RANGE = EntityDataManager.func_187226_a(EntityGlowstoneSkeleton.class, (DataSerializer)DataSerializers.field_187198_h);
    private EntityAIAttackRanged aiShootFlame = new EntityAIAttackRanged((IRangedAttackMob)this, 1.25, 7, 10.0f);
    private EntityAIAttackRanged aiShootSkull = new EntityAIAttackRanged((IRangedAttackMob)this, 1.25, 50, 10.0f);
    private EntityAIAttackMelee aiAttackOnCollide = new EntityAIAttackMelee((EntityCreature)this, 1.2, false);
    private static final UUID babySpeedBoostUUID = UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D836");
    private static final AttributeModifier babySpeedBoostModifier = new AttributeModifier(babySpeedBoostUUID, "Baby speed boost", 0.5, 1);

    public EntityGlowstoneSkeleton(World world) {
        super(world);
        if (NetherConfig.glowstoneSkeletonFireResistant) {
            this.field_70178_ae = true;
        }
        this.func_70105_a(0.4f, 1.8f);
        this.field_70728_aV = NetherConfig.glowstoneSkeletonEXP;
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 10, true, false, (Predicate)new Predicate<EntityPlayer>(){

            public boolean apply(EntityPlayer input) {
                return !input.func_70644_a(MobEffects.field_188425_z);
            }
        }));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityIronGolem.class, true));
        if (world != null && !world.field_72995_K) {
            this.setCombatTask();
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)NetherConfig.glowstoneSkeletonHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)NetherConfig.glowstoneSkeletonDamage);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)NetherConfig.glowstoneSkeletonSpeed);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(IS_BABY, (Object)false);
        this.func_184212_Q().func_187214_a(IS_DIM, (Object)false);
        this.func_184212_Q().func_187214_a(IS_USING_RANGE, (Object)false);
    }

    public float func_70047_e() {
        float f = 1.74f;
        if (this.func_70631_g_()) {
            f = (float)((double)f - 0.81);
        }
        return f;
    }

    public double func_70033_W() {
        return this.func_70631_g_() ? 0.0 : -0.35;
    }

    public boolean func_70631_g_() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_BABY);
    }

    public void setChild(boolean value) {
        this.func_184212_Q().func_187227_b(IS_BABY, (Object)value);
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
            iattributeinstance.func_111124_b(babySpeedBoostModifier);
            if (value) {
                iattributeinstance.func_111121_a(babySpeedBoostModifier);
            }
        }
    }

    public boolean isDimstoneSkeleton() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_DIM);
    }

    public void setDimstoneSkeleton(boolean value) {
        this.func_184212_Q().func_187227_b(IS_DIM, (Object)value);
    }

    protected SoundEvent func_184639_G() {
        return AdInferosSounds.glowstoneskeleton_idle.getSound();
    }

    protected SoundEvent func_184601_bQ() {
        return AdInferosSounds.glowstoneskeleton_hurt.getSound();
    }

    protected SoundEvent func_184615_bR() {
        return AdInferosSounds.glowstoneskeleton_death.getSound();
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187868_fj, 0.15f, 1.0f);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70631_g_()) {
            this.func_70105_a(0.3f, 0.7f);
        }
        if (!this.field_70170_p.field_72995_K && !this.isDimstoneSkeleton() && this.field_70173_aa % 300 == 0) {
            this.setCombatTask();
        }
    }

    protected ResourceLocation func_184647_J() {
        return this.isDimstoneSkeleton() ? AdInferosLootTables.ENTITIES_DIMSTONE_SKELETON : AdInferosLootTables.ENTITIES_GLOWSTONE_SKELETON;
    }

    protected void func_184610_a(boolean playerKill, int looting, DamageSource source) {
        if (NetherConfig.glowstoneSkeletonDrops) {
            super.func_184610_a(playerKill, looting, source);
        }
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        ItemStack stack = new ItemStack(NetherItems.glowstone_sword);
        if (this.isDimstoneSkeleton()) {
            stack = this.field_70146_Z.nextBoolean() ? new ItemStack(NetherItems.wither_staff) : new ItemStack(NetherItems.wither_sword);
        }
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, stack);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        Calendar calendar;
        livingdata = super.func_180482_a(difficulty, livingdata);
        if (this.field_70170_p.field_73011_w instanceof WorldProviderAbyss) {
            this.setDimstoneSkeleton(true);
        }
        this.func_180481_a(difficulty);
        this.func_180483_b(difficulty);
        if (this.field_70146_Z.nextFloat() < NetherConfig.glowstoneSkeletonBaby) {
            this.setChild(true);
        }
        this.func_98053_h(this.field_70146_Z.nextFloat() < 0.55f * difficulty.func_180170_c());
        if (this.func_184582_a(EntityEquipmentSlot.HEAD) == null && (calendar = this.field_70170_p.func_83015_S()).get(2) + 1 == 10 && calendar.get(5) == 31 && this.field_70146_Z.nextFloat() < 0.25f) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(this.field_70146_Z.nextFloat() < 0.1f ? Blocks.field_150428_aP : Blocks.field_150423_aK));
            this.field_184655_bs[EntityEquipmentSlot.HEAD.func_188454_b()] = 0.0f;
        }
        NetherConfig.printDebugInfo(this.func_70005_c_() + " was spawned at " + this.func_180425_c());
        return livingdata;
    }

    public void setCombatTask() {
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiShootFlame);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiShootSkull);
        boolean ranged = this.field_70146_Z.nextBoolean();
        ItemStack stack = this.func_184614_ca();
        if (stack == null) {
            ranged = false;
        } else if (this.isDimstoneSkeleton()) {
            ranged = stack.func_77973_b() == NetherItems.wither_staff;
        }
        if (ranged) {
            if (this.isDimstoneSkeleton()) {
                this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiShootSkull);
            } else {
                this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiShootFlame);
            }
        } else {
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiAttackOnCollide);
        }
        this.setUsingRange(ranged);
    }

    public void func_82196_d(EntityLivingBase target, float f) {
        EntityHelper.tryRangedAttack((ItemStack)this.func_184614_ca(), (EntityLiving)this, (EntityLivingBase)target, (boolean)true);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74767_n("IsBaby")) {
            this.setChild(true);
        }
        if (compound.func_74767_n("IsDimstone")) {
            this.setDimstoneSkeleton(true);
        }
        this.setCombatTask();
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.func_70631_g_()) {
            compound.func_74757_a("IsBaby", true);
        }
        if (this.isDimstoneSkeleton()) {
            compound.func_74757_a("IsDimstone", true);
        }
    }

    public void func_184201_a(EntityEquipmentSlot slotIn, ItemStack stack) {
        super.func_184201_a(slotIn, stack);
        if (!this.field_70170_p.field_72995_K && slotIn == EntityEquipmentSlot.MAINHAND) {
            this.setCombatTask();
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_82727_n && this.isWitherResistant()) {
            return false;
        }
        if (source.func_76346_g() instanceof EntityHerobrine) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70645_a(DamageSource cause) {
        if (cause.func_76346_g() instanceof EntityPlayer && this.canMakeGhost()) {
            EntityGhost.createGhost(this.field_70170_p, (EntityLiving)this, this);
        }
        super.func_70645_a(cause);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float partialTicks) {
        return this.isDimstoneSkeleton() ? super.func_70070_b(partialTicks) : 0xF000F0;
    }

    public float func_70013_c(float partialTicks) {
        return this.isDimstoneSkeleton() ? super.func_70013_c(partialTicks) : 1.0f;
    }

    public void setUsingRange(boolean value) {
        this.func_184212_Q().func_187227_b(IS_USING_RANGE, (Object)value);
    }

    public boolean IsUsingRange() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_USING_RANGE);
    }

    @Override
    public boolean canMakeGhost() {
        return NetherConfig.ghostSpawnFromEntities && !this.func_70631_g_() && !BlockSpawner.isSpawnerEntity((Entity)this) && this.field_70146_Z.nextInt(30) == 0;
    }

    @Override
    public String getTexture() {
        return this.isDimstoneSkeleton() ? "adinferos:textures/entity/glowstone_skeleton/dimstone.png" : "adinferos:textures/entity/glowstone_skeleton/default.png";
    }

    @Override
    public void onCreateGhost(EntityGhost ghost) {
    }

    @Override
    public boolean isDarkfireResistant() {
        return this.isDimstoneSkeleton() ? true : NetherConfig.glowstoneSkeletonDarkfireResistant;
    }

    @Override
    public boolean isCurseResistant() {
        return NetherConfig.glowstoneSkeletonCurseResistant;
    }

    @Override
    public boolean isWitherResistant() {
        return this.isDimstoneSkeleton() ? true : NetherConfig.glowstoneSkeletonWitherResistant;
    }

    @Override
    public boolean isAcidResistant() {
        return NetherConfig.glowstoneSkeletonAcidResistant;
    }

    @Override
    public boolean isSpikeResistant() {
        return false;
    }
}

