/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.adinferos.entity.monster;

import com.superdextor.adinferos.AdInferosCore;
import com.superdextor.adinferos.AdInferosSounds;
import com.superdextor.adinferos.config.NetherConfig;
import com.superdextor.adinferos.entity.NetherMob;
import com.superdextor.adinferos.inventory.AdInferosLootTables;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityBlackWidow
extends EntitySpider
implements NetherMob {
    private static final DataParameter<Integer> SIZE = EntityDataManager.func_187226_a(EntityBlackWidow.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityBlackWidow(World worldIn) {
        super(worldIn);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIBlackWidowAttack(this));
        this.field_70728_aV = NetherConfig.blackWidowEXP;
        if (NetherConfig.blackWidowFireResistant) {
            this.field_70178_ae = true;
        }
    }

    protected float func_70647_i() {
        return super.func_70647_i() - 0.5f * (float)this.getSpiderSize();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)NetherConfig.blackWidowSpeed);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)(NetherConfig.blackWidowDamage + 2.0f));
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)NetherConfig.blackWidowHealth);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(SIZE, (Object)1);
    }

    public boolean func_70652_k(Entity target) {
        if (super.func_70652_k(target)) {
            if (NetherConfig.blackWidowDebuffs && target instanceof EntityLivingBase) {
                EntityLivingBase entityLiving = (EntityLivingBase)target;
                int durAmp = 3;
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                    durAmp = 6;
                } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    durAmp = 12;
                }
                PotionEffect confusion = entityLiving.func_70660_b(MobEffects.field_76431_k);
                int ampAmp = 0;
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                    ampAmp = 1;
                } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    ampAmp = 2;
                }
                if (confusion != null) {
                    int bitCounter = confusion.func_76458_c();
                    if (bitCounter > 2) {
                        entityLiving.func_70690_d(new PotionEffect(MobEffects.field_76438_s, durAmp * (this.getSpiderSize() + 0) * 15, 0));
                    }
                    if (bitCounter > 3) {
                        entityLiving.func_70690_d(new PotionEffect(MobEffects.field_76421_d, durAmp * (this.getSpiderSize() + 0) * 15, bitCounter / 5));
                    }
                    if (bitCounter > 4) {
                        entityLiving.func_70690_d(new PotionEffect(MobEffects.field_76440_q, durAmp * (this.getSpiderSize() + 0) * 15, 0));
                    }
                    if (bitCounter >= 100) {
                        entityLiving.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 30 + confusion.func_76459_b(), 100));
                    } else {
                        entityLiving.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 30 + confusion.func_76459_b(), 1 + confusion.func_76458_c()));
                        entityLiving.func_70690_d(new PotionEffect(MobEffects.field_82731_v, durAmp * (this.getSpiderSize() + 0) * 15, bitCounter / 8));
                    }
                } else {
                    entityLiving.func_70690_d(new PotionEffect(MobEffects.field_76431_k, durAmp * (this.getSpiderSize() + 0) * 15, ampAmp));
                    entityLiving.func_70690_d(new PotionEffect(MobEffects.field_82731_v, durAmp * (this.getSpiderSize() + 0) * 15, 0));
                }
            }
            return true;
        }
        return false;
    }

    protected ResourceLocation func_184647_J() {
        switch (this.getSpiderSize()) {
            case 0: {
                return AdInferosLootTables.ENTITIES_BLACKWIDOW_SMALL;
            }
            case 1: {
                return AdInferosLootTables.ENTITIES_BLACKWIDOW_MEDIUM;
            }
        }
        return AdInferosLootTables.ENTITIES_BLACKWIDOW_LARGE;
    }

    protected void func_184610_a(boolean playerKill, int looting, DamageSource source) {
        if (NetherConfig.blackWidowDrops) {
            super.func_184610_a(playerKill, looting, source);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_82727_n && NetherConfig.blackWidowWitherResistant) {
            return false;
        }
        if (source.func_76346_g() != null && source.func_76346_g().equals((Object)this.func_184187_bx())) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public int getSpiderSize() {
        return (Integer)this.func_184212_Q().func_187225_a(SIZE);
    }

    public void setSpiderSize(int size, boolean fillHealth) {
        this.field_70180_af.func_187227_b(SIZE, (Object)size);
        double f = size * 5 + 15;
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)(NetherConfig.blackWidowDamage + (float)(size * 2)));
        if (fillHealth) {
            this.func_70606_j(this.func_110138_aP());
        }
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("Size", this.getSpiderSize());
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        if (tagCompund.func_150297_b("Size", 99)) {
            this.setSpiderSize(tagCompund.func_74762_e("Size"), false);
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.setSpiderSize(this.field_70146_Z.nextInt(NetherConfig.blackWidowMaxsize + 1), true);
        if (this.getSpiderSize() > 1) {
            int i = this.field_70146_Z.nextInt(2) + 2;
            for (int x = 0; x < i; ++x) {
                EntityBlackWidow spider = new EntityBlackWidow(this.field_70170_p);
                spider.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
                spider.setSpiderSize(0, true);
                this.field_70170_p.func_72838_d((Entity)spider);
            }
        }
        NetherConfig.printDebugInfo(this.func_70005_c_() + " was spawned at " + this.func_180425_c());
        return livingdata;
    }

    public void func_70636_d() {
        super.func_70636_d();
        float f = 0.5f * (float)(this.getSpiderSize() + 1);
        this.func_70105_a(1.4f * f, 0.9f * f);
    }

    protected SoundEvent func_184639_G() {
        return AdInferosSounds.blackwidow_idle.getSound();
    }

    protected SoundEvent func_184601_bQ() {
        return AdInferosSounds.blackwidow_hurt.getSound();
    }

    protected SoundEvent func_184615_bR() {
        return AdInferosSounds.blackwidow_death.getSound();
    }

    public boolean func_70601_bi() {
        if (this.field_70170_p.field_73011_w.getDimension() == -1 && !AdInferosCore.proxy.isDarkNether()) {
            return false;
        }
        return super.func_70601_bi();
    }

    @Override
    public boolean isDarkfireResistant() {
        return NetherConfig.blackWidowDarkfireResistant;
    }

    @Override
    public boolean isCurseResistant() {
        return NetherConfig.blackWidowCurseResistant;
    }

    @Override
    public boolean isWitherResistant() {
        return NetherConfig.blackWidowWitherResistant;
    }

    @Override
    public boolean isAcidResistant() {
        return NetherConfig.blackWidowAcidResistant;
    }

    @Override
    public boolean isSpikeResistant() {
        return false;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.6f;
    }

    static class AIBlackWidowAttack
    extends EntityAIAttackMelee {
        private final EntityBlackWidow blackWidow;

        public AIBlackWidowAttack(EntityBlackWidow blackWidow) {
            super((EntityCreature)blackWidow, 1.0, true);
            this.blackWidow = blackWidow;
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return 2.0f + (float)this.blackWidow.getSpiderSize() * 2.0f + attackTarget.field_70130_N;
        }
    }
}

