/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.adinferos;

import com.google.common.base.Predicate;
import com.superdextor.adinferos.config.NetherConfig;
import com.superdextor.adinferos.init.NetherBlocks;
import com.superdextor.adinferos.world.BiomeGenAbyss;
import com.superdextor.adinferos.world.BiomeGenNether;
import com.superdextor.adinferos.worldgen.WorldGenAcidLakes;
import com.superdextor.adinferos.worldgen.WorldGenAshTree;
import com.superdextor.adinferos.worldgen.WorldGenBigPurpleMushroom;
import com.superdextor.adinferos.worldgen.WorldGenDarkFire;
import com.superdextor.adinferos.worldgen.WorldGenDimstone1;
import com.superdextor.adinferos.worldgen.WorldGenInfernoTree;
import com.superdextor.adinferos.worldgen.WorldGenMagmaTree;
import com.superdextor.adinferos.worldgen.WorldGenNetherDungeon;
import com.superdextor.adinferos.worldgen.WorldGenObsidianBeach;
import com.superdextor.adinferos.worldgen.WorldGenObsidianPyramide;
import com.superdextor.adinferos.worldgen.WorldGenPiggyHouse;
import com.superdextor.adinferos.worldgen.WorldGenPurpleMushrooms;
import com.superdextor.adinferos.worldgen.WorldGenSpikes;
import com.superdextor.thinkbigcore.helpers.ChatHelper;
import com.superdextor.thinkbigcore.worldgen.WorldUtilities;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class NetherGeneration
implements IWorldGenerator {
    public static final BiomeGenBase abyss = new BiomeGenAbyss();
    public static final BiomeGenBase nether = new BiomeGenNether();

    public NetherGeneration() {
        String modId = "adinferos";
        WorldUtilities.register((String)modId, (String)"netherrack_spikes", (WorldGenerator)new WorldGenSpikes());
        WorldUtilities.register((String)modId, (String)"dark_fire", (WorldGenerator)new WorldGenDarkFire());
        WorldUtilities.register((String)modId, (String)"acid_lakes", (WorldGenerator)new WorldGenAcidLakes());
        WorldUtilities.register((String)modId, (String)"large_purple_mushroom", (WorldGenerator)new WorldGenBigPurpleMushroom());
        WorldUtilities.register((String)modId, (String)"dimstone", (WorldGenerator)new WorldGenDimstone1());
        WorldUtilities.register((String)modId, (String)"nether_dungeon", (WorldGenerator)new WorldGenNetherDungeon());
        WorldUtilities.register((String)modId, (String)"inferno_tree", (WorldGenerator)new WorldGenInfernoTree(true));
        WorldUtilities.register((String)modId, (String)"magma_tree", (WorldGenerator)new WorldGenMagmaTree(true, true));
        WorldUtilities.register((String)modId, (String)"ash_tree", (WorldGenerator)new WorldGenAshTree(true));
        WorldUtilities.register((String)modId, (String)"obsidian_beach", (WorldGenerator)new WorldGenObsidianBeach());
        WorldUtilities.register((String)modId, (String)"piggy_house", (WorldGenerator)new WorldGenPiggyHouse());
        WorldUtilities.register((String)modId, (String)"obsidian_pyramide", (WorldGenerator)new WorldGenObsidianPyramide());
        WorldUtilities.register((String)modId, (String)"purple_mushrooms", (WorldGenerator)new WorldGenPurpleMushrooms());
        ChatHelper.printDebugMessage(null, (String)"Ad Inferos successfully loaded it's World Generator");
        NetherConfig.printDebugInfo("Registered World Generator");
    }

    public static void register() {
        BiomeGenBase.func_185354_a((int)NetherConfig.biomeIDNether, (String)"overworld_nether", (BiomeGenBase)nether);
        BiomeGenBase.func_185354_a((int)NetherConfig.biomeIDAbyss, (String)"abyss", (BiomeGenBase)abyss);
        NetherConfig.printDebugInfo("Registered Biomes");
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.getDimension() == -1) {
            NetherConfig.printDebugInfo("Nether Generation: Providing Chuck: " + chunkX + "/" + chunkZ);
            this.generateNether(world, random, new BlockPos(chunkX * 16, 16, chunkZ * 16));
        }
    }

    private void genOre(Block block, World world, Random random, BlockPos pos, int maxVeinSize, int chanceToSpawn, Block generateIn) {
        WorldGenMinable mine = new WorldGenMinable(block.func_176223_P(), maxVeinSize, (Predicate)BlockMatcher.func_177642_a((Block)generateIn));
        for (int i = 0; i < chanceToSpawn; ++i) {
            int x = pos.func_177958_n() + random.nextInt(16);
            int y = random.nextInt(120);
            int z = pos.func_177952_p() + random.nextInt(16);
            mine.func_180709_b(world, random, new BlockPos(x, y, z));
        }
    }

    private void generateNether(World world, Random random, BlockPos pos) {
        int i;
        int k;
        if (NetherConfig.genGoldOreChance > 0.0f) {
            this.genOre(NetherBlocks.gold_ore, world, random, pos, NetherConfig.genGoldOreMinSize + random.nextInt(NetherConfig.genGoldOreMaxSize - NetherConfig.genGoldOreMinSize), (int)(100.0f * NetherConfig.genGoldOreChance), Blocks.field_150424_aL);
        }
        if (NetherConfig.genSoulOreChance > 0.0f) {
            this.genOre(NetherBlocks.soul_ore, world, random, pos, NetherConfig.genSoulOreMinSize + random.nextInt(NetherConfig.genSoulOreMaxSize - NetherConfig.genSoulOreMinSize), (int)(100.0f * NetherConfig.genSoulOreChance), Blocks.field_150425_aM);
        }
        if (NetherConfig.genWitherOreChance > 0.0f) {
            this.genOre(NetherBlocks.wither_ore, world, random, pos, NetherConfig.genWitherOreMinSize + random.nextInt(NetherConfig.genWitherOreMaxSize - NetherConfig.genWitherOreMinSize), (int)(100.0f * NetherConfig.genWitherOreChance), Blocks.field_150424_aL);
        }
        if (NetherConfig.genNetheriteOreChance > 0.0f) {
            this.genOre(NetherBlocks.netherite_ore, world, random, pos, NetherConfig.genNetheriteOreMinSize + random.nextInt(NetherConfig.genNetheriteOreMaxSize - NetherConfig.genNetheriteOreMinSize), (int)(100.0f * NetherConfig.genNetheriteOreChance), Blocks.field_150424_aL);
        }
        if (random.nextFloat() < NetherConfig.genPurpleMushroomChance) {
            new WorldGenPurpleMushrooms().func_180709_b(world, random, pos.func_177982_a(random.nextInt(16), random.nextInt(96), random.nextInt(16)));
        }
        if (NetherConfig.genLargePurpleMushroomChance > 0.0f) {
            k = (int)(10.0f * NetherConfig.genLargePurpleMushroomChance);
            for (i = 0; i < k; ++i) {
                new WorldGenBigPurpleMushroom().func_180709_b(world, random, pos.func_177982_a(random.nextInt(16), random.nextInt(96), random.nextInt(16)));
            }
        }
        if (NetherConfig.genInfernoTreesChance > 0.0f) {
            k = (int)(10.0f * NetherConfig.genInfernoTreesChance);
            for (i = 0; i < k; ++i) {
                new WorldGenInfernoTree(false).func_180709_b(world, random, pos.func_177982_a(random.nextInt(16), random.nextInt(96), random.nextInt(16)));
            }
        }
        if (NetherConfig.genMagmaTreesChance > 0.0f) {
            k = (int)(10.0f * NetherConfig.genMagmaTreesChance);
            for (i = 0; i < k; ++i) {
                new WorldGenMagmaTree(false, false).func_180709_b(world, random, pos.func_177982_a(random.nextInt(16), random.nextInt(96), random.nextInt(16)));
            }
        }
        if (NetherConfig.genDungeonsChance > 0.0f) {
            k = (int)(10.0f * NetherConfig.genDungeonsChance);
            for (i = 0; i < k; ++i) {
                new WorldGenNetherDungeon().func_180709_b(world, random, pos.func_177982_a(random.nextInt(16), random.nextInt(96), random.nextInt(16)));
            }
        }
        if (random.nextFloat() < NetherConfig.genAcidChance) {
            new WorldGenAcidLakes().func_180709_b(world, random, pos.func_177982_a(random.nextInt(16), random.nextInt(96), random.nextInt(16)));
        }
        if (NetherConfig.genPiggyHouseChance > 0.0f) {
            k = (int)(10.0f * NetherConfig.genPiggyHouseChance);
            for (i = 0; i < k; ++i) {
                new WorldGenPiggyHouse().func_180709_b(world, random, pos.func_177982_a(random.nextInt(16), random.nextInt(96), random.nextInt(16)));
            }
        }
        if (NetherConfig.genObsidianPyramideChance > 0.0f) {
            k = (int)(10.0f * NetherConfig.genObsidianPyramideChance);
            for (i = 0; i < k; ++i) {
                new WorldGenObsidianPyramide().func_180709_b(world, random, pos.func_177982_a(random.nextInt(16), random.nextInt(96), random.nextInt(16)));
            }
        }
        if (NetherConfig.genObsidianBeachChance > 0.0f) {
            k = (int)(10.0f * NetherConfig.genObsidianBeachChance);
            for (i = 0; i < k; ++i) {
                new WorldGenObsidianBeach().func_180709_b(world, random, pos.func_177982_a(random.nextInt(16), random.nextInt(96), random.nextInt(16)));
            }
        }
        if (random.nextFloat() < NetherConfig.genSpikesChance) {
            new WorldGenSpikes().func_180709_b(world, random, pos.func_177982_a(random.nextInt(16), random.nextInt(96), random.nextInt(16)));
        }
    }
}

