/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.adinferos;

import com.superdextor.adinferos.AdInferosAchievements;
import com.superdextor.adinferos.AdInferosReference;
import com.superdextor.adinferos.AdInferosSounds;
import com.superdextor.adinferos.NetherEvents;
import com.superdextor.adinferos.NetherGeneration;
import com.superdextor.adinferos.config.NetherConfig;
import com.superdextor.adinferos.enchantments.AdInferosEnchantments;
import com.superdextor.adinferos.entity.NetherEntities;
import com.superdextor.adinferos.init.NetherBlocks;
import com.superdextor.adinferos.init.NetherFluids;
import com.superdextor.adinferos.init.NetherItems;
import com.superdextor.adinferos.inventory.AdInferosGuis;
import com.superdextor.adinferos.inventory.AdInferosLootTables;
import com.superdextor.adinferos.inventory.AdInferosRecipes;
import com.superdextor.adinferos.inventory.AltarRecipes;
import com.superdextor.adinferos.inventory.ExtractorRecipes;
import com.superdextor.adinferos.inventory.NetherFuels;
import com.superdextor.adinferos.inventory.TileEntityAltar;
import com.superdextor.adinferos.inventory.TileEntityExtractor;
import com.superdextor.adinferos.inventory.TileEntityNetherFurnace;
import com.superdextor.adinferos.inventory.TileEntitySpawner;
import com.superdextor.adinferos.network.CMessageUpdateDarkNether;
import com.superdextor.adinferos.network.CMessageUpdateNetherSurvival;
import com.superdextor.adinferos.network.SMessageHellSwordAttack;
import com.superdextor.adinferos.network.SMessageTeleportPlayer;
import com.superdextor.adinferos.proxy.CommonProxy;
import com.superdextor.adinferos.world.ChunkProviderNetherSurvival;
import com.superdextor.adinferos.world.WorldProviderAbyss;
import com.superdextor.adinferos.world.WorldTypeNether;
import com.superdextor.thinkbigcore.ThinkBigConfig;
import com.superdextor.thinkbigcore.network.TBCNetwork;
import java.io.File;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="adinferos", name="Ad Inferos", version="1.2.2", acceptedMinecraftVersions="[1.9]", dependencies="required-after:thinkbigcore@[1.5.5,]", guiFactory="com.superdextor.adinferos.config.GuiFactoryAdInferos")
public class AdInferosCore {
    @Mod.Instance(value="adinferos")
    public static AdInferosCore modInstance;
    @SidedProxy(clientSide="com.superdextor.adinferos.proxy.ClientProxy", serverSide="com.superdextor.adinferos.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static DimensionType abyssDimension;
    public static final WorldType NETHER;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        AdInferosReference.config = new Configuration(new File(ThinkBigConfig.getConfigFilePath((FMLPreInitializationEvent)event), "Ad Inferos.cfg"));
        NetherConfig.initConfig();
        AdInferosSounds.register();
        NetherFluids.registerFluids();
        NetherBlocks.register();
        NetherItems.register();
        AdInferosRecipes.register();
        NetherEntities.register();
        abyssDimension = DimensionType.register((String)"Abyss", (String)"", (int)NetherConfig.dimensionIdAbyss, WorldProviderAbyss.class, (boolean)false);
        NetherGeneration.register();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new NetherGeneration(), (int)1);
        DimensionManager.registerDimension((int)NetherConfig.dimensionIdAbyss, (DimensionType)abyssDimension);
        NetherConfig.printDebugInfo("Registered Abyss Dimension");
        AdInferosAchievements.register();
        AdInferosEnchantments.register();
        TileEntity.func_145826_a(TileEntityAltar.class, (String)"Altar");
        TileEntity.func_145826_a(TileEntityNetherFurnace.class, (String)"NetherrackFurnace");
        TileEntity.func_145826_a(TileEntityExtractor.class, (String)"Extractor");
        TileEntity.func_145826_a(TileEntitySpawner.class, (String)"AFSpawner");
        NetherConfig.printDebugInfo("Registered TileEntities");
        proxy.preInit();
        NetherConfig.printDebugInfo("preInit completed");
    }

    @Mod.EventHandler
    public void Init(FMLInitializationEvent event) {
        AdInferosGuis.register();
        MinecraftForge.EVENT_BUS.register((Object)new NetherEvents());
        if (NetherConfig.allowOverworldNether) {
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(NetherGeneration.nether, NetherConfig.netherBiomeWeight));
            NetherConfig.printDebugInfo("Added Overworld-Nether Biome to BiomeManager");
        }
        if (NetherConfig.allowSmelting) {
            GameRegistry.registerFuelHandler((IFuelHandler)new NetherFuels());
        }
        proxy.init();
        NetherConfig.printDebugInfo("Init completed");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        AltarRecipes.register();
        ExtractorRecipes.register();
        TBCNetwork.registerMessage(SMessageTeleportPlayer.Handler.class, SMessageTeleportPlayer.class, (Side)Side.SERVER, (int)100);
        TBCNetwork.registerMessage(SMessageHellSwordAttack.Handler.class, SMessageHellSwordAttack.class, (Side)Side.SERVER, (int)101);
        TBCNetwork.registerMessage(CMessageUpdateNetherSurvival.Handler.class, CMessageUpdateNetherSurvival.class, (Side)Side.CLIENT, (int)102);
        TBCNetwork.registerMessage(CMessageUpdateDarkNether.Handler.class, CMessageUpdateDarkNether.class, (Side)Side.CLIENT, (int)103);
        NetherConfig.printDebugInfo("Registered Packets");
        AdInferosLootTables.register();
        proxy.postInit();
        NetherConfig.printDebugInfo("postInit completed");
    }

    public static boolean isNetherSurvival(World world) {
        if (!world.field_72995_K && world.func_72863_F() instanceof ChunkProviderServer) {
            ChunkProviderServer providerServer = (ChunkProviderServer)world.func_72863_F();
            if (providerServer.field_186029_c instanceof ChunkProviderNetherSurvival) {
                return true;
            }
        }
        return false;
    }

    static {
        NETHER = new WorldTypeNether();
    }
}

