/*
 * Decompiled with CFR 0.152.
 */
package taintedmagic.common.items.wand;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import taintedmagic.common.TaintedMagic;
import taintedmagic.common.entities.EntityTaintBubble;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.common.config.Config;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.items.wands.WandManager;

public class ItemFocusTaint
extends ItemFocusBasic {
    public static FocusUpgradeType tainturgy = new FocusUpgradeType(55, new ResourceLocation("taintedmagic", "textures/foci/IconTainturgy.png"), "focus.upgrade.tainturgy.name", "focus.upgrade.tainturgy.text", new AspectList().add(Aspect.TAINT, 1).add(Aspect.HEAL, 1));
    public static FocusUpgradeType corrosive = new FocusUpgradeType(56, new ResourceLocation("taintedmagic", "textures/foci/IconCorrosive.png"), "focus.upgrade.corrosive.name", "focus.upgrade.corrosive.text", new AspectList().add(Aspect.TAINT, 1).add(Aspect.POISON, 1));
    IIcon depthIcon = null;
    private static final AspectList costBase = new AspectList().add(Aspect.EARTH, 10).add(Aspect.WATER, 10);
    private static final AspectList costTainturgist = new AspectList().add(Aspect.EARTH, 10).add(Aspect.WATER, 10).add(Aspect.ORDER, 10);

    public ItemFocusTaint() {
        this.func_77637_a(TaintedMagic.tabTaintedMagic);
        this.func_77655_b("ItemFocusTaint");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.icon = ir.func_94245_a("taintedmagic:ItemFocusTaint");
        this.depthIcon = ir.func_94245_a("taintedmagic:ItemFocusTaint_depth");
    }

    public IIcon getFocusDepthLayerIcon(ItemStack s) {
        return this.depthIcon;
    }

    public String getSortingHelper(ItemStack s) {
        return "BM" + super.getSortingHelper(s);
    }

    public int getFocusColor(ItemStack s) {
        return 8073200;
    }

    public AspectList getVisCost(ItemStack s) {
        return this.isUpgradedWith(s, tainturgy) ? costTainturgist : costBase;
    }

    public int getActivationCooldown(ItemStack s) {
        return -1;
    }

    public boolean isVisCostPerTick(ItemStack s) {
        return true;
    }

    public ItemFocusBasic.WandFocusAnimation getAnimation(ItemStack s) {
        return ItemFocusBasic.WandFocusAnimation.WAVE;
    }

    public ItemStack onFocusRightClick(ItemStack s, World w, EntityPlayer p, MovingObjectPosition mop) {
        ItemWandCasting wand = (ItemWandCasting)s.func_77973_b();
        p.func_71008_a(s, Integer.MAX_VALUE);
        WandManager.setCooldown((EntityLivingBase)p, (int)-1);
        return s;
    }

    public void onUsingFocusTick(ItemStack s, EntityPlayer p, int count) {
        ItemWandCasting wand = (ItemWandCasting)s.func_77973_b();
        if (!wand.consumeAllVis(s, p, this.getVisCost(s), false, false)) {
            p.func_71034_by();
            return;
        }
        int range = 8;
        Vec3 vec3d = p.func_70676_i((float)range);
        if (!p.field_70170_p.field_72995_K && p.field_70173_aa % 20 == 0) {
            p.field_70170_p.func_72956_a((Entity)p, "thaumcraft:bubble", 0.33f, 2.0f);
        }
        int potency = wand.getFocusPotency(s);
        if (!p.field_70170_p.field_72995_K && wand.consumeAllVis(s, p, this.getVisCost(s), true, false)) {
            float scatter = this.isUpgradedWith(wand.getFocusItem(s), FocusUpgradeType.enlarge) ? 15.0f : 8.0f;
            for (int a = 0; a < 2 + wand.getFocusPotency(s); ++a) {
                Random rand;
                int randomInt;
                EntityTaintBubble orb = new EntityTaintBubble(p.field_70170_p, (EntityLivingBase)p, scatter, this.isUpgradedWith(wand.getFocusItem(s), corrosive));
                orb.field_70165_t += orb.field_70159_w;
                orb.field_70163_u += orb.field_70181_x;
                orb.field_70161_v += orb.field_70179_y;
                orb.damage = 5.0f + (float)potency;
                p.field_70170_p.func_72838_d((Entity)orb);
                if (this.isUpgradedWith(wand.getFocusItem(s), tainturgy) || (randomInt = (rand = new Random()).nextInt(150)) != 9) continue;
                try {
                    p.func_70690_d(new PotionEffect(Config.potionVisExhaustID, 1000, 2));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public FocusUpgradeType[] getPossibleUpgradesByRank(ItemStack s, int rank) {
        switch (rank) {
            case 1: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency};
            }
            case 2: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency};
            }
            case 3: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency, tainturgy};
            }
            case 4: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency, FocusUpgradeType.enlarge};
            }
            case 5: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency, corrosive};
            }
        }
        return null;
    }
}

