/*
 * Decompiled with CFR 0.152.
 */
package taintedmagic.common.items.wand;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import taintedmagic.common.TaintedMagic;
import taintedmagic.common.entities.EntityEldritchOrbAttack;
import taintedmagic.common.items.wand.ItemFocusTaint;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.items.wands.ItemWandCasting;

public class ItemFocusEldritch
extends ItemFocusBasic {
    public static FocusUpgradeType sanity = new FocusUpgradeType(57, new ResourceLocation("taintedmagic", "textures/foci/IconSanity.png"), "focus.upgrade.sanity.name", "focus.upgrade.sanity.text", new AspectList().add(Aspect.MIND, 1).add(Aspect.HEAL, 1));
    IIcon depthIcon = null;
    private static final AspectList costBase = new AspectList().add(Aspect.ENTROPY, 20).add(Aspect.FIRE, 20);
    private static final AspectList costSane = new AspectList().add(Aspect.ENTROPY, 20).add(Aspect.FIRE, 50).add(Aspect.ORDER, 20);
    private static final AspectList costCorrosive = new AspectList().add(Aspect.ENTROPY, 50).add(Aspect.FIRE, 20).add(Aspect.WATER, 20);
    long soundDelay = 0L;

    public ItemFocusEldritch() {
        this.func_77637_a(TaintedMagic.tabTaintedMagic);
        this.func_77655_b("ItemFocusEldritch");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.icon = ir.func_94245_a("taintedmagic:ItemFocusEldritch");
        this.depthIcon = ir.func_94245_a("taintedmagic:ItemFocusEldritch_depth");
    }

    public IIcon getFocusDepthLayerIcon(ItemStack s) {
        return this.depthIcon;
    }

    public String getSortingHelper(ItemStack s) {
        return "AM" + super.getSortingHelper(s);
    }

    public int getFocusColor(ItemStack s) {
        return 24;
    }

    public AspectList getVisCost(ItemStack s) {
        return this.isUpgradedWith(s, ItemFocusTaint.corrosive) ? costCorrosive : (this.isUpgradedWith(s, sanity) ? costSane : costBase);
    }

    public int getActivationCooldown(ItemStack s) {
        return 600;
    }

    public boolean isVisCostPerTick(ItemStack s) {
        return false;
    }

    public ItemFocusBasic.WandFocusAnimation getAnimation(ItemStack s) {
        return ItemFocusBasic.WandFocusAnimation.WAVE;
    }

    public ItemStack onFocusRightClick(ItemStack s, World w, EntityPlayer p, MovingObjectPosition mop) {
        ItemWandCasting wand = (ItemWandCasting)s.func_77973_b();
        if (!w.field_72995_K) {
            int potency = wand.getFocusPotency(s);
            if (wand.consumeAllVis(s, p, this.getVisCost(s), true, false)) {
                Random rand;
                int randomInt;
                EntityEldritchOrbAttack orb = null;
                orb = new EntityEldritchOrbAttack(w, (EntityLivingBase)p, this.isUpgradedWith(wand.getFocusItem(s), ItemFocusTaint.corrosive));
                orb.dmg = 10.0f + (float)potency;
                w.func_72838_d((Entity)orb);
                if (!this.isUpgradedWith(wand.getFocusItem(s), sanity) && (randomInt = (rand = new Random()).nextInt(10)) == 5) {
                    Thaumcraft.addStickyWarpToPlayer((EntityPlayer)p, (int)1);
                }
            }
            w.func_72956_a((Entity)p, "thaumcraft:egattack", 0.4f, 1.0f + w.field_73012_v.nextFloat() * 0.1f);
        }
        p.func_71038_i();
        return s;
    }

    public FocusUpgradeType[] getPossibleUpgradesByRank(ItemStack s, int rank) {
        switch (rank) {
            case 1: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency};
            }
            case 2: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency};
            }
            case 3: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency, ItemFocusTaint.corrosive};
            }
            case 4: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency};
            }
            case 5: {
                FocusUpgradeType[] focusUpgradeTypeArray = new FocusUpgradeType[3];
                focusUpgradeTypeArray[0] = FocusUpgradeType.frugal;
                focusUpgradeTypeArray[1] = FocusUpgradeType.potency;
                focusUpgradeTypeArray[2] = sanity;
                return focusUpgradeTypeArray;
            }
        }
        return null;
    }
}

