/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.network;

import drzhark.mocreatures.client.MoCClientProxy;
import drzhark.mocreatures.client.gui.helpers.MoCGUIEntityNamer;
import drzhark.mocreatures.entity.IMoCEntity;
import drzhark.mocreatures.entity.IMoCTameable;
import drzhark.mocreatures.entity.monster.MoCEntityGolem;
import drzhark.mocreatures.entity.monster.MoCEntityOgre;
import drzhark.mocreatures.entity.passive.MoCEntityHorse;
import drzhark.mocreatures.network.message.MoCMessageAnimation;
import drzhark.mocreatures.network.message.MoCMessageAppear;
import drzhark.mocreatures.network.message.MoCMessageAttachedEntity;
import drzhark.mocreatures.network.message.MoCMessageEntityDive;
import drzhark.mocreatures.network.message.MoCMessageEntityJump;
import drzhark.mocreatures.network.message.MoCMessageExplode;
import drzhark.mocreatures.network.message.MoCMessageHealth;
import drzhark.mocreatures.network.message.MoCMessageHeart;
import drzhark.mocreatures.network.message.MoCMessageInstaSpawn;
import drzhark.mocreatures.network.message.MoCMessageNameGUI;
import drzhark.mocreatures.network.message.MoCMessageShuffle;
import drzhark.mocreatures.network.message.MoCMessageTwoBytes;
import drzhark.mocreatures.network.message.MoCMessageUpdatePetName;
import drzhark.mocreatures.network.message.MoCMessageVanish;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class MoCMessageHandler {
    public static final SimpleNetworkWrapper INSTANCE = NetworkRegistry.INSTANCE.newSimpleChannel("MoCreatures");

    public static void init() {
        INSTANCE.registerMessage(MoCMessageAnimation.class, MoCMessageAnimation.class, 0, Side.CLIENT);
        INSTANCE.registerMessage(MoCMessageAppear.class, MoCMessageAppear.class, 1, Side.CLIENT);
        INSTANCE.registerMessage(MoCMessageAttachedEntity.class, MoCMessageAttachedEntity.class, 2, Side.CLIENT);
        INSTANCE.registerMessage(MoCMessageEntityDive.class, MoCMessageEntityDive.class, 3, Side.SERVER);
        INSTANCE.registerMessage(MoCMessageEntityJump.class, MoCMessageEntityJump.class, 4, Side.SERVER);
        INSTANCE.registerMessage(MoCMessageExplode.class, MoCMessageExplode.class, 5, Side.CLIENT);
        INSTANCE.registerMessage(MoCMessageHealth.class, MoCMessageHealth.class, 6, Side.CLIENT);
        INSTANCE.registerMessage(MoCMessageHeart.class, MoCMessageHeart.class, 7, Side.CLIENT);
        INSTANCE.registerMessage(MoCMessageInstaSpawn.class, MoCMessageInstaSpawn.class, 8, Side.SERVER);
        INSTANCE.registerMessage(MoCMessageNameGUI.class, MoCMessageNameGUI.class, 9, Side.CLIENT);
        INSTANCE.registerMessage(MoCMessageUpdatePetName.class, MoCMessageUpdatePetName.class, 10, Side.SERVER);
        INSTANCE.registerMessage(MoCMessageShuffle.class, MoCMessageShuffle.class, 11, Side.CLIENT);
        INSTANCE.registerMessage(MoCMessageTwoBytes.class, MoCMessageTwoBytes.class, 12, Side.CLIENT);
        INSTANCE.registerMessage(MoCMessageVanish.class, MoCMessageVanish.class, 13, Side.CLIENT);
    }

    public static void handleMessage(IMessageHandler message, MessageContext ctx) {
        if (ctx.side == Side.CLIENT) {
            FMLCommonHandler.instance().getWorldThread(FMLCommonHandler.instance().getClientToServerNetworkManager().func_150729_e()).func_152344_a((Runnable)new ClientPacketTask(message, ctx));
        }
    }

    public static class ClientPacketTask
    implements Runnable {
        private IMessageHandler message;
        private MessageContext ctx;

        public ClientPacketTask(IMessageHandler message, MessageContext ctx) {
            this.message = message;
            this.ctx = ctx;
        }

        @Override
        public void run() {
            if (this.message instanceof MoCMessageAnimation) {
                MoCMessageAnimation message = (MoCMessageAnimation)this.message;
                List entList = MoCClientProxy.mc.field_71439_g.field_70170_p.field_72996_f;
                for (Entity ent : entList) {
                    if (ent.func_145782_y() != message.entityId || !(ent instanceof IMoCEntity)) continue;
                    ((IMoCEntity)ent).performAnimation(message.animationType);
                    break;
                }
                return;
            }
            if (this.message instanceof MoCMessageAppear) {
                MoCMessageAppear message = (MoCMessageAppear)this.message;
                List entList = MoCClientProxy.mc.field_71439_g.field_70170_p.field_72996_f;
                for (Entity ent : entList) {
                    if (ent.func_145782_y() != message.entityId || !(ent instanceof MoCEntityHorse)) continue;
                    ((MoCEntityHorse)ent).MaterializeFX();
                    break;
                }
                return;
            }
            if (this.message instanceof MoCMessageAttachedEntity) {
                MoCMessageAttachedEntity message = (MoCMessageAttachedEntity)this.message;
                Entity var2 = MoCClientProxy.mc.field_71439_g.field_70170_p.func_73045_a(message.sourceEntityId);
                Entity var3 = MoCClientProxy.mc.field_71439_g.field_70170_p.func_73045_a(message.targetEntityId);
                if (var2 != null) {
                    var2.func_184220_m(var3);
                }
                return;
            }
            if (this.message instanceof MoCMessageExplode) {
                MoCMessageExplode message = (MoCMessageExplode)this.message;
                List entList = MoCClientProxy.mc.field_71439_g.field_70170_p.field_72996_f;
                for (Entity ent : entList) {
                    if (ent.func_145782_y() != message.entityId || !(ent instanceof MoCEntityOgre)) continue;
                    ((MoCEntityOgre)ent).performDestroyBlastAttack();
                    break;
                }
                return;
            }
            if (this.message instanceof MoCMessageHealth) {
                MoCMessageHealth message = (MoCMessageHealth)this.message;
                List entList = MoCClientProxy.mc.field_71439_g.field_70170_p.field_72996_f;
                for (Entity ent : entList) {
                    if (ent.func_145782_y() != message.entityId || !(ent instanceof EntityLiving)) continue;
                    ((EntityLiving)ent).func_70606_j(message.health);
                    break;
                }
                return;
            }
            if (this.message instanceof MoCMessageHeart) {
                MoCMessageHeart message = (MoCMessageHeart)this.message;
                Entity entity = null;
                while (entity == null) {
                    entity = MoCClientProxy.mc.field_71439_g.field_70170_p.func_73045_a(message.entityId);
                    if (entity == null || !(entity instanceof IMoCTameable)) continue;
                    ((IMoCTameable)entity).spawnHeart();
                }
                return;
            }
            if (this.message instanceof MoCMessageShuffle) {
                MoCMessageShuffle message = (MoCMessageShuffle)this.message;
                List entList = MoCClientProxy.mc.field_71439_g.field_70170_p.field_72996_f;
                for (Entity ent : entList) {
                    if (ent.func_145782_y() != message.entityId || !(ent instanceof MoCEntityHorse)) continue;
                    if (message.flag) break;
                    ((MoCEntityHorse)ent).shuffleCounter = 0;
                    break;
                }
                return;
            }
            if (this.message instanceof MoCMessageTwoBytes) {
                MoCMessageTwoBytes message = (MoCMessageTwoBytes)this.message;
                Entity ent = MoCClientProxy.mc.field_71439_g.field_70170_p.func_73045_a(message.entityId);
                if (ent != null && ent instanceof MoCEntityGolem) {
                    ((MoCEntityGolem)ent).saveGolemCube(message.slot, message.value);
                }
                return;
            }
            if (this.message instanceof MoCMessageVanish) {
                MoCMessageVanish message = (MoCMessageVanish)this.message;
                List entList = MoCClientProxy.mc.field_71439_g.field_70170_p.field_72996_f;
                for (Entity ent : entList) {
                    if (ent.func_145782_y() != message.entityId || !(ent instanceof MoCEntityHorse)) continue;
                    ((MoCEntityHorse)ent).setVanishC((byte)1);
                    break;
                }
                return;
            }
            if (this.message instanceof MoCMessageNameGUI) {
                MoCMessageNameGUI message = (MoCMessageNameGUI)this.message;
                Entity entity = MoCClientProxy.mc.field_71439_g.field_70170_p.func_73045_a(message.entityId);
                MoCClientProxy.mc.func_147108_a((GuiScreen)new MoCGUIEntityNamer((IMoCEntity)entity, ((IMoCEntity)entity).getPetName()));
                return;
            }
        }
    }
}

