/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.item;

import drzhark.mocreatures.MoCPetData;
import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityTameableAnimal;
import drzhark.mocreatures.entity.passive.MoCEntityHorse;
import drzhark.mocreatures.entity.passive.MoCEntityWyvern;
import drzhark.mocreatures.item.MoCItem;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAppear;
import drzhark.mocreatures.util.MoCSoundEvents;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MoCItemHorseAmulet
extends MoCItem {
    private int ageCounter;
    private String name;
    private float health;
    private int edad;
    private int creatureType;
    private int spawnClass;
    private boolean rideable;
    private byte armor;
    private boolean adult;
    private UUID ownerUniqueId;
    private String ownerName;
    private int PetId;

    public MoCItemHorseAmulet(String name) {
        super(name);
        this.field_77777_bU = 1;
        this.func_77627_a(true);
        this.ageCounter = 0;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World worldIn, EntityPlayer player, EnumHand hand) {
        if (++this.ageCounter < 2) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (MoCreatures.isServer()) {
            this.initAndReadNBT(stack);
        }
        if (this.spawnClass != 0) {
            double dist = 3.0;
            double newPosY = player.field_70163_u;
            double newPosX = player.field_70165_t - dist * Math.cos(MoCTools.realAngle(player.field_70177_z - 90.0f) / 57.29578f);
            double newPosZ = player.field_70161_v - dist * Math.sin(MoCTools.realAngle(player.field_70177_z - 90.0f) / 57.29578f);
            if (MoCreatures.isServer()) {
                try {
                    MoCEntityTameableAnimal storedCreature = this.spawnClass == 100 ? new MoCEntityWyvern(worldIn) : new MoCEntityHorse(worldIn);
                    storedCreature.func_70107_b(newPosX, newPosY, newPosZ);
                    storedCreature.setType(this.creatureType);
                    storedCreature.setTamed(true);
                    storedCreature.setRideable(this.rideable);
                    storedCreature.setEdad(this.edad);
                    storedCreature.setPetName(this.name);
                    storedCreature.func_70606_j(this.health);
                    storedCreature.setAdult(this.adult);
                    storedCreature.setArmorType(this.armor);
                    storedCreature.setOwnerPetId(this.PetId);
                    storedCreature.setOwnerId(player.func_110124_au());
                    this.ownerName = player.func_70005_c_();
                    if (this.spawnClass == 100) {
                        ((MoCEntityWyvern)storedCreature).setIsGhost(true);
                    }
                    if (!this.ownerUniqueId.equals(player.func_110124_au()) && MoCreatures.instance.mapData != null) {
                        MoCPetData oldOwner = MoCreatures.instance.mapData.getPetData(this.ownerUniqueId);
                        MoCPetData newOwner = MoCreatures.instance.mapData.getPetData(player.func_110124_au());
                        EntityPlayer epOwner = worldIn.func_72924_a(player.func_70005_c_());
                        int maxCount = MoCreatures.proxy.maxTamed;
                        if (MoCTools.isThisPlayerAnOP(epOwner)) {
                            maxCount = MoCreatures.proxy.maxOPTamed;
                        }
                        if (newOwner == null) {
                            if (maxCount > 0 || !MoCreatures.proxy.enableOwnership) {
                                MoCreatures.instance.mapData.updateOwnerPet(storedCreature);
                            }
                        } else if (newOwner.getTamedList().func_74745_c() < maxCount || !MoCreatures.proxy.enableOwnership) {
                            MoCreatures.instance.mapData.updateOwnerPet(storedCreature);
                        }
                        if (oldOwner != null) {
                            for (int j = 0; j < oldOwner.getTamedList().func_74745_c(); ++j) {
                                NBTTagCompound petEntry = oldOwner.getTamedList().func_150305_b(j);
                                if (petEntry.func_74762_e("PetId") != this.PetId) continue;
                                oldOwner.getTamedList().func_74744_a(j);
                            }
                        }
                    }
                    if (player.field_70170_p.func_72838_d((Entity)storedCreature)) {
                        MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAppear(storedCreature.func_145782_y()), new NetworkRegistry.TargetPoint(player.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), player.field_70165_t, player.field_70163_u, player.field_70161_v, 64.0));
                        MoCTools.playCustomSound((Entity)storedCreature, MoCSoundEvents.ENTITY_GENERIC_MAGIC_APPEAR);
                        if (this.spawnClass == 100 || this.creatureType == 21 || this.creatureType == 22) {
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack(MoCreatures.amuletghost, 1, 0));
                        } else if (this.creatureType == 26 || this.creatureType == 27 || this.creatureType == 28) {
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack(MoCreatures.amuletbone, 1, 0));
                        } else if (this.creatureType > 47 && this.creatureType < 60) {
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack(MoCreatures.amuletfairy, 1, 0));
                        } else if (this.creatureType == 39 || this.creatureType == 40) {
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack(MoCreatures.amuletpegasus, 1, 0));
                        }
                        MoCPetData petData = MoCreatures.instance.mapData.getPetData(storedCreature.func_184753_b());
                        if (petData != null) {
                            petData.setInAmulet(storedCreature.getOwnerPetId(), false);
                        }
                    }
                }
                catch (Exception ex) {
                    System.out.println("Error spawning creature from amulet " + ex);
                }
            }
            this.ageCounter = 0;
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.PetId = nbt.func_74762_e("PetId");
        this.creatureType = nbt.func_74762_e("CreatureType");
        this.health = nbt.func_74760_g("Health");
        this.edad = nbt.func_74762_e("Edad");
        this.name = nbt.func_74779_i("Name");
        this.spawnClass = nbt.func_74762_e("SpawnClass");
        this.rideable = nbt.func_74767_n("Rideable");
        this.armor = nbt.func_74771_c("Armor");
        this.adult = nbt.func_74767_n("Adult");
        this.ownerName = nbt.func_74779_i("OwnerName");
        if (nbt.func_186855_b("OwnerUUID")) {
            this.ownerUniqueId = nbt.func_186857_a("OwnerUUID");
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("PetId", this.PetId);
        nbt.func_74768_a("CreatureType", this.creatureType);
        nbt.func_74776_a("Health", this.health);
        nbt.func_74768_a("Edad", this.edad);
        nbt.func_74778_a("Name", this.name);
        nbt.func_74768_a("SpawnClass", this.spawnClass);
        nbt.func_74757_a("Rideable", this.rideable);
        nbt.func_74774_a("Armor", this.armor);
        nbt.func_74757_a("Adult", this.adult);
        nbt.func_74778_a("OwnerName", this.ownerName);
        if (this.ownerUniqueId != null) {
            nbt.func_186854_a("OwnerUUID", this.ownerUniqueId);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List<String> par3List, boolean par4) {
        this.initAndReadNBT(par1ItemStack);
        if (this.spawnClass == 100) {
            par3List.add(TextFormatting.AQUA + "Wyvern");
        } else if (this.spawnClass != 0) {
            par3List.add(TextFormatting.AQUA + "WildHorse");
        }
        if (this.name != "") {
            par3List.add(TextFormatting.BLUE + this.name);
        }
        if (this.ownerName != "") {
            par3List.add(TextFormatting.DARK_BLUE + "Owned by " + this.ownerName);
        }
    }

    private void initAndReadNBT(ItemStack itemstack) {
        if (itemstack.func_77978_p() == null) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbtcompound = itemstack.func_77978_p();
        this.readFromNBT(nbtcompound);
    }
}

