/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.passive;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityTameableAnimal;
import drzhark.mocreatures.entity.ai.EntityAIFleeFromPlayer;
import drzhark.mocreatures.entity.ai.EntityAIFollowOwnerPlayer;
import drzhark.mocreatures.entity.ai.EntityAIHunt;
import drzhark.mocreatures.entity.ai.EntityAIWanderMoC2;
import drzhark.mocreatures.entity.item.MoCEntityEgg;
import drzhark.mocreatures.entity.passive.MoCEntityFox;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAnimation;
import drzhark.mocreatures.util.MoCSoundEvents;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MoCEntityPetScorpion
extends MoCEntityTameableAnimal {
    public static final String[] scorpionNames = new String[]{"Dirt", "Cave", "Nether", "Frost", "Undead"};
    private boolean isPoisoning;
    private int poisontimer;
    public int mouthCounter;
    public int armCounter;
    private int transformCounter;
    private static final DataParameter<Boolean> RIDEABLE = EntityDataManager.func_187226_a(MoCEntityPetScorpion.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> HAS_BABIES = EntityDataManager.func_187226_a(MoCEntityPetScorpion.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_SITTING = EntityDataManager.func_187226_a(MoCEntityPetScorpion.class, (DataSerializer)DataSerializers.field_187198_h);

    public MoCEntityPetScorpion(World world) {
        super(world);
        this.func_70105_a(1.4f, 0.9f);
        this.poisontimer = 0;
        this.setAdult(false);
        this.setEdad(20);
        this.setHasBabies(false);
        this.field_70138_W = 20.0f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWanderMoC2((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFleeFromPlayer((EntityCreature)this, 1.2, 4.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIFollowOwnerPlayer((EntityLiving)this, 1.0, 2.0f, 10.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHunt((EntityCreature)this, (Class<? extends EntityCreature>)EntityAnimal.class, true));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
    }

    @Override
    public void selectType() {
        if (this.getType() == 0) {
            this.setType(1);
        }
    }

    @Override
    public ResourceLocation getTexture() {
        boolean saddle = this.getIsRideable();
        if (this.transformCounter != 0) {
            String newText;
            String string = newText = saddle ? "scorpionundeadsaddle.png" : "scorpionundead.png";
            if (this.transformCounter % 5 == 0) {
                return MoCreatures.proxy.getTexture(newText);
            }
            if (this.transformCounter > 50 && this.transformCounter % 3 == 0) {
                return MoCreatures.proxy.getTexture(newText);
            }
            if (this.transformCounter > 75 && this.transformCounter % 4 == 0) {
                return MoCreatures.proxy.getTexture(newText);
            }
        }
        switch (this.getType()) {
            case 1: {
                if (!saddle) {
                    return MoCreatures.proxy.getTexture("scorpiondirt.png");
                }
                return MoCreatures.proxy.getTexture("scorpiondirtsaddle.png");
            }
            case 2: {
                if (!saddle) {
                    return MoCreatures.proxy.getTexture("scorpioncave.png");
                }
                return MoCreatures.proxy.getTexture("scorpioncavesaddle.png");
            }
            case 3: {
                if (!saddle) {
                    return MoCreatures.proxy.getTexture("scorpionnether.png");
                }
                return MoCreatures.proxy.getTexture("scorpionnethersaddle.png");
            }
            case 4: {
                if (!saddle) {
                    return MoCreatures.proxy.getTexture("scorpionfrost.png");
                }
                return MoCreatures.proxy.getTexture("scorpionfrostsaddle.png");
            }
            case 5: {
                if (!saddle) {
                    return MoCreatures.proxy.getTexture("scorpionundead.png");
                }
                return MoCreatures.proxy.getTexture("scorpionundeadsaddle.png");
            }
        }
        return MoCreatures.proxy.getTexture("scorpiondirt.png");
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HAS_BABIES, (Object)false);
        this.field_70180_af.func_187214_a(IS_SITTING, (Object)false);
        this.field_70180_af.func_187214_a(RIDEABLE, (Object)false);
    }

    @Override
    public void setRideable(boolean flag) {
        this.field_70180_af.func_187227_b(RIDEABLE, (Object)flag);
    }

    @Override
    public boolean getIsRideable() {
        return (Boolean)this.field_70180_af.func_187225_a(RIDEABLE);
    }

    public boolean getHasBabies() {
        return this.getIsAdult() && (Boolean)this.field_70180_af.func_187225_a(HAS_BABIES) != false;
    }

    public boolean getIsPoisoning() {
        return this.isPoisoning;
    }

    @Override
    public boolean getIsSitting() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_SITTING);
    }

    public void setSitting(boolean flag) {
        this.field_70180_af.func_187227_b(IS_SITTING, (Object)flag);
    }

    public void setHasBabies(boolean flag) {
        this.field_70180_af.func_187227_b(HAS_BABIES, (Object)flag);
    }

    public void setPoisoning(boolean flag) {
        if (flag && MoCreatures.isServer()) {
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 0), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
        }
        this.isPoisoning = flag;
    }

    @Override
    public void performAnimation(int animationType) {
        if (animationType == 0) {
            this.setPoisoning(true);
        } else if (animationType == 1) {
            this.armCounter = 1;
        } else if (animationType == 3) {
            this.mouthCounter = 1;
        } else if (animationType == 5) {
            this.transformCounter = 1;
        }
    }

    public boolean func_70617_f_() {
        return this.field_70123_F;
    }

    public boolean climbing() {
        return !this.field_70122_E && this.func_70617_f_();
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70122_E && this.func_184187_bx() != null) {
            this.field_70177_z = this.func_184187_bx().field_70177_z;
        }
        if (this.mouthCounter != 0 && this.mouthCounter++ > 50) {
            this.mouthCounter = 0;
        }
        if (MoCreatures.isServer() && (this.armCounter == 10 || this.armCounter == 40)) {
            MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_SCORPION_CLAW);
        }
        if (this.armCounter != 0 && this.armCounter++ > 24) {
            this.armCounter = 0;
        }
        if (this.getIsPoisoning()) {
            ++this.poisontimer;
            if (this.poisontimer == 1) {
                MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_SCORPION_STING);
            }
            if (this.poisontimer > 50) {
                this.poisontimer = 0;
                this.setPoisoning(false);
            }
        }
        if (this.transformCounter > 0) {
            if (this.transformCounter == 40) {
                MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_GENERIC_TRANSFORM);
            }
            if (++this.transformCounter > 100) {
                this.transformCounter = 0;
                this.setType(5);
                this.selectType();
            }
        }
        super.func_70636_d();
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (super.func_70097_a(damagesource, i)) {
            Entity entity = damagesource.func_76346_g();
            if (!(entity instanceof EntityLivingBase) || entity != null && entity instanceof EntityPlayer && this.getIsTamed()) {
                return false;
            }
            if (entity != null && entity != this && super.shouldAttackPlayers() && this.getIsAdult()) {
                this.func_70624_b((EntityLivingBase)entity);
            }
            return true;
        }
        return false;
    }

    protected void func_174815_a(EntityLivingBase entityLivingBaseIn, Entity entityIn) {
        boolean flag = entityIn instanceof EntityPlayer;
        if (!this.getIsPoisoning() && this.field_70146_Z.nextInt(5) == 0 && entityIn instanceof EntityLivingBase) {
            this.setPoisoning(true);
            if (this.getType() <= 2) {
                if (flag) {
                    MoCreatures.poisonPlayer((EntityPlayer)entityIn);
                }
                ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76436_u, 70, 0));
            } else if (this.getType() == 4) {
                if (flag) {
                    MoCreatures.freezePlayer((EntityPlayer)entityIn);
                }
                ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 70, 0));
            } else if (this.getType() == 3 && flag && MoCreatures.isServer() && !this.field_70170_p.field_73011_w.func_177500_n()) {
                MoCreatures.burnPlayer((EntityPlayer)entityIn);
                ((EntityLivingBase)entityIn).func_70015_d(15);
            }
        } else {
            this.swingArm();
        }
        super.func_174815_a(entityLivingBaseIn, entityIn);
    }

    public void swingArm() {
        if (MoCreatures.isServer()) {
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 1), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
        }
    }

    public boolean swingingTail() {
        return this.getIsPoisoning() && this.poisontimer < 15;
    }

    protected SoundEvent func_184615_bR() {
        return MoCSoundEvents.ENTITY_SCORPION_DEATH;
    }

    protected SoundEvent func_184601_bQ() {
        return MoCSoundEvents.ENTITY_SCORPION_HURT;
    }

    protected SoundEvent func_184639_G() {
        if (MoCreatures.isServer()) {
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 3), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
        }
        return MoCSoundEvents.ENTITY_SCORPION_AMBIENT;
    }

    protected Item func_146068_u() {
        if (!this.getIsAdult()) {
            return Items.field_151007_F;
        }
        boolean flag = this.field_70146_Z.nextInt(100) < MoCreatures.proxy.rareItemDropChance;
        switch (this.getType()) {
            case 1: {
                if (flag) {
                    return MoCreatures.scorpStingDirt;
                }
                return MoCreatures.chitin;
            }
            case 2: {
                if (flag) {
                    return MoCreatures.scorpStingCave;
                }
                return MoCreatures.chitinCave;
            }
            case 3: {
                if (flag) {
                    return MoCreatures.scorpStingNether;
                }
                return MoCreatures.chitinNether;
            }
            case 4: {
                if (flag) {
                    return MoCreatures.scorpStingFrost;
                }
                return MoCreatures.chitinFrost;
            }
            case 5: {
                return Items.field_151078_bh;
            }
        }
        return Items.field_151007_F;
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand, @Nullable ItemStack stack) {
        boolean onMainHand;
        if (super.func_184645_a(player, hand, stack)) {
            return true;
        }
        boolean bl = onMainHand = hand == EnumHand.MAIN_HAND;
        if (stack != null && onMainHand && this.getIsAdult() && !this.getIsRideable() && (stack.func_77973_b() == Items.field_151141_av || stack.func_77973_b() == MoCreatures.horsesaddle)) {
            if (--stack.field_77994_a == 0) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
            }
            this.setRideable(true);
            return true;
        }
        if (stack != null && stack.func_77973_b() == MoCreatures.whip && this.getIsTamed() && !this.func_184207_aI()) {
            this.setSitting(!this.getIsSitting());
            return true;
        }
        if (stack != null && onMainHand && this.getIsTamed() && stack.func_77973_b() == MoCreatures.essenceundead) {
            if (--stack.field_77994_a == 0) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack(Items.field_151069_bo));
            } else {
                player.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo));
            }
            this.transform(5);
            return true;
        }
        if (stack != null && onMainHand && this.getIsTamed() && stack.func_77973_b() == MoCreatures.essencedarkness) {
            if (--stack.field_77994_a == 0) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack(Items.field_151069_bo));
            } else {
                player.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo));
            }
            this.func_70606_j(this.func_110138_aP());
            if (!this.field_70170_p.field_72995_K) {
                int i = this.getType() + 40;
                MoCEntityEgg entityegg = new MoCEntityEgg(this.field_70170_p, i);
                entityegg.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                player.field_70170_p.func_72838_d((Entity)entityegg);
                entityegg.field_70181_x += (double)(this.field_70170_p.field_73012_v.nextFloat() * 0.05f);
                entityegg.field_70159_w += (double)((this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.3f);
                entityegg.field_70179_y += (double)((this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.3f);
            }
            return true;
        }
        if (this.func_184187_bx() == null && this.getEdad() < 60 && !this.getIsAdult()) {
            this.func_184220_m((Entity)player);
            this.field_70177_z = player.field_70177_z;
            if (!this.field_70170_p.field_72995_K && !this.getIsTamed()) {
                MoCTools.tameWithName(player, this);
            }
            return true;
        }
        if (this.func_184187_bx() != null) {
            MoCTools.playCustomSound((Entity)this, SoundEvents.field_187665_Y);
            this.func_184210_p();
            this.field_70159_w = player.field_70159_w * 5.0;
            this.field_70181_x = player.field_70181_x / 2.0 + 0.5;
            this.field_70179_y = player.field_70179_y * 5.0;
            return true;
        }
        if (this.getIsRideable() && this.getIsTamed() && this.getIsAdult() && !this.func_184207_aI()) {
            player.field_70177_z = this.field_70177_z;
            player.field_70125_A = this.field_70125_A;
            if (!this.field_70170_p.field_72995_K) {
                player.func_184220_m((Entity)this);
            }
            return true;
        }
        return false;
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setHasBabies(nbttagcompound.func_74767_n("Babies"));
        this.setRideable(nbttagcompound.func_74767_n("Saddled"));
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74757_a("Babies", this.getHasBabies());
        nbttagcompound.func_74757_a("Saddled", this.getIsRideable());
    }

    @Override
    public int nameYOffset() {
        int n = (int)(1.0 - (double)this.getEdad() * 0.8);
        if (n < -60) {
            n = -60;
        }
        if (this.getIsAdult()) {
            n = -60;
        }
        if (this.getIsSitting()) {
            n = (int)((double)n * 0.8);
        }
        return n;
    }

    @Override
    protected boolean isMyHealFood(ItemStack itemstack) {
        return itemstack.func_77973_b() == MoCreatures.ratRaw || itemstack.func_77973_b() == MoCreatures.ratCooked;
    }

    public int func_70627_aG() {
        return 300;
    }

    public void func_180430_e(float f, float f1) {
    }

    public boolean func_70067_L() {
        return !this.func_184207_aI();
    }

    @Override
    public boolean rideableEntity() {
        return true;
    }

    @Override
    public boolean isMovementCeased() {
        return this.func_184207_aI() || this.getIsSitting();
    }

    @Override
    public void dropMyStuff() {
        MoCTools.dropSaddle(this, this.field_70170_p);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    @Override
    public float getAdjustedYOffset() {
        return 0.2f;
    }

    @Override
    public int getMaxEdad() {
        return 120;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.75 - 0.15;
    }

    public double func_70033_W() {
        if (this.func_184187_bx() instanceof EntityPlayer && this.func_184187_bx() == MoCreatures.proxy.getPlayer() && this.field_70170_p.field_72995_K) {
            return 0.1f;
        }
        if (this.func_184187_bx() instanceof EntityPlayer && this.field_70170_p.field_72995_K) {
            return super.func_70033_W() + (double)0.1f;
        }
        return super.func_70033_W();
    }

    public void func_184232_k(Entity passenger) {
        double dist = 0.2;
        double newPosX = this.field_70165_t + dist * Math.sin(this.field_70761_aq / 57.29578f);
        double newPosZ = this.field_70161_v - dist * Math.cos(this.field_70761_aq / 57.29578f);
        passenger.func_70107_b(newPosX, this.field_70163_u + this.func_70042_X() + passenger.func_70033_W(), newPosZ);
    }

    @Override
    public boolean isNotScared() {
        return this.getIsTamed();
    }

    public void transform(int tType) {
        if (MoCreatures.isServer()) {
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), tType), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
        }
        this.transformCounter = 1;
    }

    @Override
    public boolean isReadyToHunt() {
        return this.getIsAdult() && !this.isMovementCeased();
    }

    @Override
    public boolean canAttackTarget(EntityLivingBase entity) {
        return !(entity instanceof MoCEntityFox) && (double)entity.field_70131_O <= 1.0 && (double)entity.field_70130_N <= 1.0;
    }
}

