/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.passive;

import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.IMoCTameable;
import drzhark.mocreatures.entity.passive.MoCEntityBigCat;
import drzhark.mocreatures.entity.passive.MoCEntityLeopard;
import drzhark.mocreatures.entity.passive.MoCEntityPanther;
import drzhark.mocreatures.entity.passive.MoCEntityTiger;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class MoCEntityLion
extends MoCEntityBigCat {
    public MoCEntityLion(World world) {
        super(world);
    }

    @Override
    public void selectType() {
        if (this.getType() == 0) {
            if (this.field_70146_Z.nextInt(20) == 0) {
                this.setType(this.field_70146_Z.nextInt(2) + 6);
            } else {
                this.setType(this.field_70146_Z.nextInt(2) + 1);
            }
        }
        super.selectType();
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getType()) {
            case 1: {
                return MoCreatures.proxy.getTexture("BCfemaleLion.png");
            }
            case 2: {
                return MoCreatures.proxy.getTexture("BCmaleLion.png");
            }
            case 3: {
                return MoCreatures.proxy.getTexture("BCmaleLion.png");
            }
            case 6: {
                return MoCreatures.proxy.getTexture("BCwhiteLion.png");
            }
            case 7: {
                return MoCreatures.proxy.getTexture("BCwhiteLion.png");
            }
            case 8: {
                return MoCreatures.proxy.getTexture("BCwhiteLion.png");
            }
        }
        return MoCreatures.proxy.getTexture("BCfemaleLion.png");
    }

    @Override
    public boolean hasMane() {
        return this.getIsAdult() && (this.getType() >= 2 && this.getType() < 4 || this.getType() == 7);
    }

    @Override
    public boolean isFlyer() {
        return this.getType() == 3 || this.getType() == 5 || this.getType() == 8;
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand, @Nullable ItemStack stack) {
        boolean onMainHand;
        if (super.func_184645_a(player, hand, stack)) {
            return true;
        }
        boolean bl = onMainHand = hand == EnumHand.MAIN_HAND;
        if (stack != null && onMainHand && this.getIsTamed() && (this.getType() == 2 || this.getType() == 7) && stack.func_77973_b() == MoCreatures.essencelight) {
            if (--stack.field_77994_a == 0) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack(Items.field_151069_bo));
            } else {
                player.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo));
            }
            this.setType(this.getType() + 1);
            return true;
        }
        if (this.getIsRideable() && this.getIsAdult() && !this.func_184207_aI()) {
            player.field_70177_z = this.field_70177_z;
            player.field_70125_A = this.field_70125_A;
            this.setSitting(false);
            if (MoCreatures.isServer()) {
                player.func_184220_m((Entity)this);
            }
            return true;
        }
        return false;
    }

    @Override
    public String getOffspringClazz(IMoCTameable mate) {
        if (mate instanceof MoCEntityTiger && ((MoCEntityTiger)mate).getType() < 3) {
            return "Liger";
        }
        if (this.getType() == 2 && mate instanceof MoCEntityLeopard && ((MoCEntityLeopard)mate).getType() == 1) {
            return "Liard";
        }
        if (this.getType() == 2 && mate instanceof MoCEntityPanther && ((MoCEntityPanther)mate).getType() == 1) {
            return "Lither";
        }
        return "Lion";
    }

    @Override
    public String getClazzString() {
        return "Lion";
    }

    @Override
    public int getOffspringTypeInt(IMoCTameable mate) {
        int x = 0;
        if (mate instanceof MoCEntityTiger && ((MoCEntityTiger)mate).getType() < 3) {
            return 1;
        }
        if (this.getType() == 2 && mate instanceof MoCEntityLeopard && ((MoCEntityLeopard)mate).getType() == 1) {
            return 1;
        }
        if (this.getType() == 2 && mate instanceof MoCEntityPanther && ((MoCEntityPanther)mate).getType() == 1) {
            return 1;
        }
        if (mate instanceof MoCEntityLion) {
            int lionMateType = ((MoCEntityLion)mate).getType();
            if (this.getType() == 1 && lionMateType == 2) {
                x = this.field_70146_Z.nextInt(2) + 1;
            }
            if (this.getType() == 2 && lionMateType == 1) {
                x = this.field_70146_Z.nextInt(2) + 1;
            }
            if (this.getType() == 6 && lionMateType == 7) {
                x = this.field_70146_Z.nextInt(2) + 6;
            }
            if (this.getType() == 7 && lionMateType == 6) {
                x = this.field_70146_Z.nextInt(2) + 6;
            }
            if (this.getType() == 7 && lionMateType == 1) {
                x = this.field_70146_Z.nextInt(2) + 1;
            }
            if (this.getType() == 6 && lionMateType == 2) {
                x = this.field_70146_Z.nextInt(2) + 1;
            }
            if (this.getType() == 1 && lionMateType == 7) {
                x = this.field_70146_Z.nextInt(2) + 1;
            }
            if (this.getType() == 2 && lionMateType == 6) {
                x = this.field_70146_Z.nextInt(2) + 1;
            }
        }
        return x;
    }

    @Override
    public boolean compatibleMate(Entity mate) {
        if (this.getType() == 2 && mate instanceof MoCEntityTiger && ((MoCEntityTiger)mate).getType() < 3) {
            return true;
        }
        if (this.getType() == 2 && mate instanceof MoCEntityLeopard && ((MoCEntityLeopard)mate).getType() == 1) {
            return true;
        }
        if (this.getType() == 2 && mate instanceof MoCEntityPanther && ((MoCEntityPanther)mate).getType() == 1) {
            return true;
        }
        if (mate instanceof MoCEntityLion) {
            return this.getOffspringTypeInt((MoCEntityLion)mate) != 0;
        }
        return false;
    }

    @Override
    public boolean readytoBreed() {
        return (this.getType() < 3 || this.getType() == 6 || this.getType() == 7) && super.readytoBreed();
    }

    @Override
    public float calculateMaxHealth() {
        if (this.getType() == 2 || this.getType() == 7) {
            return 35.0f;
        }
        if (this.getType() == 4) {
            return 40.0f;
        }
        return 30.0f;
    }

    @Override
    public double calculateAttackDmg() {
        return 7.0;
    }

    @Override
    public double getAttackRange() {
        if (this.getType() == 1 || this.getType() == 6) {
            return 12.0;
        }
        return 8.0;
    }

    @Override
    public int getMaxEdad() {
        if (this.getType() == 1 || this.getType() == 6) {
            return 110;
        }
        if (this.getType() == 9) {
            return 100;
        }
        return 120;
    }

    @Override
    public boolean canAttackTarget(EntityLivingBase entity) {
        if (!this.getIsAdult() && (double)this.getEdad() < (double)this.getMaxEdad() * 0.8) {
            return false;
        }
        if (entity instanceof MoCEntityLion) {
            return false;
        }
        return entity.field_70131_O < 2.0f && entity.field_70130_N < 2.0f;
    }
}

