/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.passive;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.IMoCTameable;
import drzhark.mocreatures.entity.passive.MoCEntityBigCat;
import drzhark.mocreatures.entity.passive.MoCEntityLion;
import drzhark.mocreatures.entity.passive.MoCEntityPanther;
import drzhark.mocreatures.entity.passive.MoCEntityTiger;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class MoCEntityLeopard
extends MoCEntityBigCat {
    public MoCEntityLeopard(World world) {
        super(world);
    }

    @Override
    public void selectType() {
        if (this.getType() == 0) {
            this.checkSpawningBiome();
        }
        super.selectType();
    }

    @Override
    public boolean checkSpawningBiome() {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        BlockPos pos = new BlockPos(i, j, k);
        Biome currentbiome = MoCTools.Biomekind(this.field_70170_p, pos);
        try {
            if (BiomeDictionary.isBiomeOfType((Biome)currentbiome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
                this.setType(2);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setType(1);
        return true;
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getType()) {
            case 1: {
                return MoCreatures.proxy.getTexture("BCleopard.png");
            }
            case 2: {
                return MoCreatures.proxy.getTexture("BCsnowLeopard.png");
            }
        }
        return MoCreatures.proxy.getTexture("BCleopard.png");
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand, @Nullable ItemStack stack) {
        if (super.func_184645_a(player, hand, stack)) {
            return true;
        }
        if (this.getIsRideable() && this.getIsAdult() && !this.func_184207_aI()) {
            player.field_70177_z = this.field_70177_z;
            player.field_70125_A = this.field_70125_A;
            this.setSitting(false);
            if (MoCreatures.isServer()) {
                player.func_184220_m((Entity)this);
            }
            return true;
        }
        return false;
    }

    @Override
    public String getOffspringClazz(IMoCTameable mate) {
        if (mate instanceof MoCEntityPanther && ((MoCEntityPanther)mate).getType() == 1) {
            return "Pantard";
        }
        if (mate instanceof MoCEntityTiger && ((MoCEntityTiger)mate).getType() == 1) {
            return "Leoger";
        }
        if (mate instanceof MoCEntityLion && ((MoCEntityLion)mate).getType() == 2) {
            return "Liard";
        }
        return "Leopard";
    }

    @Override
    public int getOffspringTypeInt(IMoCTameable mate) {
        if (mate instanceof MoCEntityPanther && ((MoCEntityPanther)mate).getType() == 1) {
            return 1;
        }
        if (mate instanceof MoCEntityTiger && ((MoCEntityTiger)mate).getType() == 1) {
            return 1;
        }
        if (mate instanceof MoCEntityLion && ((MoCEntityLion)mate).getType() == 2) {
            return 1;
        }
        return this.getType();
    }

    @Override
    public boolean compatibleMate(Entity mate) {
        return mate instanceof MoCEntityLeopard && ((MoCEntityLeopard)mate).getType() == this.getType() || mate instanceof MoCEntityPanther && ((MoCEntityPanther)mate).getType() == 1 || mate instanceof MoCEntityTiger && ((MoCEntityTiger)mate).getType() == 1 || mate instanceof MoCEntityLion && ((MoCEntityLion)mate).getType() == 2;
    }

    @Override
    public float calculateMaxHealth() {
        return 25.0f;
    }

    @Override
    public double calculateAttackDmg() {
        return 5.0;
    }

    @Override
    public double getAttackRange() {
        return 6.0;
    }

    @Override
    public int getMaxEdad() {
        return 95;
    }

    @Override
    public String getClazzString() {
        return "Leopard";
    }

    @Override
    public boolean canAttackTarget(EntityLivingBase entity) {
        if (!this.getIsAdult() && (double)this.getEdad() < (double)this.getMaxEdad() * 0.8) {
            return false;
        }
        if (entity instanceof MoCEntityLeopard) {
            return false;
        }
        return entity.field_70131_O < 1.3f && entity.field_70130_N < 1.3f;
    }

    @Override
    public float getMoveSpeed() {
        return 1.6f;
    }
}

