/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.passive;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityTameableAnimal;
import drzhark.mocreatures.entity.ai.EntityAIFleeFromPlayer;
import drzhark.mocreatures.entity.ai.EntityAIHunt;
import drzhark.mocreatures.entity.ai.EntityAINearestAttackableTargetMoC;
import drzhark.mocreatures.entity.ai.EntityAIWanderMoC2;
import drzhark.mocreatures.util.MoCSoundEvents;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class MoCEntityCrocodile
extends MoCEntityTameableAnimal {
    public float biteProgress;
    public float spin;
    public int spinInt;
    private boolean waterbound;
    private static final DataParameter<Boolean> IS_RESTING = EntityDataManager.func_187226_a(MoCEntityCrocodile.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> EATING_PREY = EntityDataManager.func_187226_a(MoCEntityCrocodile.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_BITING = EntityDataManager.func_187226_a(MoCEntityCrocodile.class, (DataSerializer)DataSerializers.field_187198_h);

    public MoCEntityCrocodile(World world) {
        super(world);
        this.texture = "crocodile.png";
        this.func_70105_a(1.4f, 0.6f);
        this.setEdad(50 + this.field_70146_Z.nextInt(50));
        this.setTamed(false);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFleeFromPlayer((EntityCreature)this, 0.8, 4.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderMoC2((EntityCreature)this, 0.9));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHunt((EntityCreature)this, (Class<? extends EntityCreature>)EntityAnimal.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTargetMoC((EntityCreature)this, EntityPlayer.class, true));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(25.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_RESTING, (Object)false);
        this.field_70180_af.func_187214_a(EATING_PREY, (Object)false);
        this.field_70180_af.func_187214_a(IS_BITING, (Object)false);
    }

    public boolean getIsBiting() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_BITING);
    }

    @Override
    public boolean getIsSitting() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_RESTING);
    }

    public boolean getHasCaughtPrey() {
        return (Boolean)this.field_70180_af.func_187225_a(EATING_PREY);
    }

    public void setBiting(boolean flag) {
        this.field_70180_af.func_187227_b(IS_BITING, (Object)flag);
    }

    public void setIsSitting(boolean flag) {
        this.field_70180_af.func_187227_b(IS_RESTING, (Object)flag);
    }

    public void setHasCaughtPrey(boolean flag) {
        this.field_70180_af.func_187227_b(EATING_PREY, (Object)flag);
    }

    protected void func_70664_aZ() {
        if (this.isSwimming()) {
            if (this.getHasCaughtPrey()) {
                return;
            }
            this.field_70181_x = 0.3;
            this.field_70160_al = true;
        } else if (this.func_70638_az() != null || this.getHasCaughtPrey()) {
            super.func_70664_aZ();
        }
    }

    @Override
    public boolean isMovementCeased() {
        return this.getIsSitting();
    }

    @Override
    public void func_70636_d() {
        if (this.getIsSitting()) {
            this.field_70125_A = -5.0f;
            if (!this.isSwimming() && this.biteProgress < 0.3f && this.field_70146_Z.nextInt(5) == 0) {
                this.biteProgress += 0.005f;
            }
            if (this.func_70638_az() != null) {
                this.setIsSitting(false);
            }
            if (MoCreatures.isServer() && this.func_70638_az() != null || this.isSwimming() || this.getHasCaughtPrey() || this.field_70146_Z.nextInt(500) == 0) {
                this.setIsSitting(false);
                this.biteProgress = 0.0f;
            }
        } else if (MoCreatures.isServer() && this.field_70146_Z.nextInt(500) == 0 && this.func_70638_az() == null && !this.getHasCaughtPrey() && !this.isSwimming()) {
            this.setIsSitting(true);
            this.func_70661_as().func_75499_g();
        }
        if (this.field_70146_Z.nextInt(500) == 0 && !this.getHasCaughtPrey() && !this.getIsSitting()) {
            this.crocBite();
        }
        if (MoCreatures.isServer() && this.field_70146_Z.nextInt(500) == 0 && !this.waterbound && !this.getIsSitting() && !this.isSwimming()) {
            MoCTools.MoveToWater((EntityCreature)this);
        }
        if (this.waterbound) {
            if (!this.func_70055_a(Material.field_151586_h)) {
                MoCTools.MoveToWater((EntityCreature)this);
            } else {
                this.waterbound = false;
            }
        }
        if (this.getHasCaughtPrey()) {
            if (this.func_184207_aI()) {
                this.func_70624_b(null);
                this.biteProgress = 0.4f;
                this.setIsSitting(false);
                if (!this.func_70055_a(Material.field_151586_h)) {
                    this.waterbound = true;
                    if (this.func_184187_bx() instanceof EntityLiving && ((EntityLivingBase)this.func_184187_bx()).func_110143_aJ() > 0.0f) {
                        ((EntityLivingBase)this.func_184187_bx()).field_70725_aQ = 0;
                    }
                    if (MoCreatures.isServer() && this.field_70146_Z.nextInt(50) == 0) {
                        this.func_184187_bx().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 2.0f);
                    }
                }
            } else {
                this.setHasCaughtPrey(false);
                this.biteProgress = 0.0f;
                this.waterbound = false;
            }
            if (this.isSpinning()) {
                this.spinInt += 3;
                if (this.spinInt % 20 == 0) {
                    MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_CROCODILE_ROLL);
                }
                if (this.spinInt > 80) {
                    this.spinInt = 0;
                    this.func_184187_bx().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 4.0f);
                }
                if (this.field_70170_p.field_72995_K || !this.func_184207_aI() || this.func_184187_bx() instanceof EntityPlayer) {
                    // empty if block
                }
            }
        }
        super.func_70636_d();
    }

    @Override
    public boolean isNotScared() {
        return true;
    }

    public void crocBite() {
        if (!this.getIsBiting()) {
            this.setBiting(true);
            this.biteProgress = 0.0f;
        }
    }

    public void func_70071_h_() {
        if (this.getIsBiting() && !this.getHasCaughtPrey()) {
            this.biteProgress += 0.1f;
            if (this.biteProgress == 0.4f) {
                MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_CROCODILE_JAWSNAP);
            }
            if (this.biteProgress > 0.6f) {
                this.setBiting(false);
                this.biteProgress = 0.0f;
            }
        }
        super.func_70071_h_();
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        if (this.getHasCaughtPrey()) {
            return false;
        }
        this.crocBite();
        this.setHasCaughtPrey(false);
        return super.func_70652_k(entityIn);
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float i) {
        Entity entity;
        if (this.func_184207_aI() && (entity = damagesource.func_76346_g()) != null && this.func_184187_bx() == entity) {
            if (this.field_70146_Z.nextInt(2) != 0) {
                return false;
            }
            this.unMount();
        }
        if (super.func_70097_a(damagesource, i)) {
            entity = damagesource.func_76346_g();
            if (this.func_184207_aI() && this.func_184187_bx() == entity && entity != this && entity instanceof EntityLivingBase && super.shouldAttackPlayers()) {
                this.func_70624_b((EntityLivingBase)entity);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canAttackTarget(EntityLivingBase entity) {
        return !(entity instanceof MoCEntityCrocodile);
    }

    public void func_184232_k(Entity passenger) {
        if (!this.func_184207_aI()) {
            return;
        }
        int direction = 1;
        double dist = (double)((float)this.getEdad() * 0.01f + passenger.field_70130_N) - 0.4;
        double newPosX = this.field_70165_t - dist * Math.cos(MoCTools.realAngle(this.field_70177_z - 90.0f) / 57.29578f);
        double newPosZ = this.field_70161_v - dist * Math.sin(MoCTools.realAngle(this.field_70177_z - 90.0f) / 57.29578f);
        passenger.func_70107_b(newPosX, this.field_70163_u + this.func_70042_X() + passenger.func_70033_W(), newPosZ);
        direction = this.spinInt > 40 ? -1 : 1;
        ((EntityLivingBase)passenger).field_70761_aq = this.field_70177_z * (float)direction;
        ((EntityLivingBase)passenger).field_70760_ar = this.field_70177_z * (float)direction;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.35;
    }

    protected SoundEvent func_184615_bR() {
        return MoCSoundEvents.ENTITY_CROCODILE_DEATH;
    }

    protected SoundEvent func_184601_bQ() {
        return MoCSoundEvents.ENTITY_CROCODILE_HURT;
    }

    protected SoundEvent func_184639_G() {
        if (this.getIsSitting()) {
            return MoCSoundEvents.ENTITY_CROCODILE_RESTING;
        }
        return MoCSoundEvents.ENTITY_CROCODILE_AMBIENT;
    }

    protected Item func_146068_u() {
        return MoCreatures.hideCroc;
    }

    public boolean isSpinning() {
        return this.getHasCaughtPrey() && this.func_184207_aI() && this.isSwimming();
    }

    @Override
    public void func_70645_a(DamageSource damagesource) {
        this.unMount();
        MoCTools.checkForTwistedEntities(this.field_70170_p);
        super.func_70645_a(damagesource);
    }

    public void unMount() {
        if (this.func_184207_aI()) {
            if (this.func_184187_bx() instanceof EntityLiving && ((EntityLivingBase)this.func_184187_bx()).func_110143_aJ() > 0.0f) {
                ((EntityLivingBase)this.func_184187_bx()).field_70725_aQ = 0;
            }
            this.func_184210_p();
            this.setHasCaughtPrey(false);
        }
    }

    public int func_70627_aG() {
        return 400;
    }

    @Override
    public boolean isAmphibian() {
        return true;
    }

    @Override
    public boolean isSwimming() {
        return this.func_70090_H();
    }

    @Override
    public boolean isReadyToHunt() {
        return this.isNotScared() && !this.isMovementCeased() && !this.func_184207_aI() && !this.getHasCaughtPrey();
    }

    @Override
    public void func_70612_e(float strafe, float forward) {
        this.moveEntityWithHeadingBypassRider(strafe, forward);
    }
}

