/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.passive;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.IMoCTameable;
import drzhark.mocreatures.entity.passive.MoCEntityBear;
import drzhark.mocreatures.entity.passive.MoCEntityPandaBear;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class MoCEntityBlackBear
extends MoCEntityBear {
    public MoCEntityBlackBear(World world) {
        super(world);
    }

    @Override
    public void selectType() {
        if (this.getType() == 0) {
            this.setType(1);
        }
        super.selectType();
    }

    @Override
    public ResourceLocation getTexture() {
        return MoCreatures.proxy.getTexture("bearblack.png");
    }

    @Override
    public float getBearSize() {
        return 0.9f;
    }

    @Override
    public int getMaxEdad() {
        return 90;
    }

    @Override
    public float calculateMaxHealth() {
        return 30.0f;
    }

    @Override
    public double getAttackRange() {
        int factor = 1;
        if (this.field_70170_p.func_175659_aa().func_151525_a() > 1) {
            factor = 2;
        }
        return 6.0 * (double)factor;
    }

    @Override
    public int getAttackStrength() {
        int factor = this.field_70170_p.func_175659_aa().func_151525_a();
        return 2 * factor;
    }

    @Override
    public boolean shouldAttackPlayers() {
        return false;
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand, @Nullable ItemStack stack) {
        if (super.func_184645_a(player, hand, stack)) {
            return true;
        }
        boolean onMainHand = hand == EnumHand.MAIN_HAND;
        ItemStack itemstack = player.field_71071_by.func_70448_g();
        if (itemstack != null && onMainHand && this.getEdad() < 80 && MoCTools.isItemEdibleforCarnivores(itemstack.func_77973_b())) {
            if (--itemstack.field_77994_a == 0) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
            }
            if (!this.getIsTamed() && MoCreatures.isServer()) {
                MoCTools.tameWithName(player, this);
            }
            this.func_70606_j(this.func_110138_aP());
            this.eatingAnimal();
            if (MoCreatures.isServer() && !this.getIsAdult() && this.getEdad() < 100) {
                this.setEdad(this.getEdad() + 1);
            }
            return true;
        }
        if (itemstack != null && this.getIsTamed() && itemstack.func_77973_b() == MoCreatures.whip) {
            if (this.getBearState() == 0) {
                this.setBearState(2);
            } else {
                this.setBearState(0);
            }
            return true;
        }
        if (this.getIsRideable() && this.getIsAdult() && !this.func_184207_aI()) {
            player.field_70177_z = this.field_70177_z;
            player.field_70125_A = this.field_70125_A;
            this.setBearState(0);
            if (MoCreatures.isServer()) {
                player.func_184220_m((Entity)this);
            }
            return true;
        }
        return false;
    }

    @Override
    public String getOffspringClazz(IMoCTameable mate) {
        return "BlackBear";
    }

    @Override
    public int getOffspringTypeInt(IMoCTameable mate) {
        return 1;
    }

    @Override
    public boolean compatibleMate(Entity mate) {
        return mate instanceof MoCEntityPandaBear;
    }
}

