/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.passive;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityTameableAnimal;
import drzhark.mocreatures.entity.ai.EntityAIFollowAdult;
import drzhark.mocreatures.entity.ai.EntityAIFollowOwnerPlayer;
import drzhark.mocreatures.entity.ai.EntityAIHunt;
import drzhark.mocreatures.entity.ai.EntityAINearestAttackableTargetMoC;
import drzhark.mocreatures.entity.ai.EntityAIPanicMoC;
import drzhark.mocreatures.entity.ai.EntityAIWanderMoC2;
import drzhark.mocreatures.inventory.MoCAnimalChest;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAnimation;
import drzhark.mocreatures.util.MoCSoundEvents;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MoCEntityBear
extends MoCEntityTameableAnimal {
    public int mouthCounter;
    private int attackCounter;
    private int standingCounter;
    private static final DataParameter<Integer> BEAR_STATE = EntityDataManager.func_187226_a(MoCEntityBear.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> RIDEABLE = EntityDataManager.func_187226_a(MoCEntityBear.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> CHESTED = EntityDataManager.func_187226_a(MoCEntityBear.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> GHOST = EntityDataManager.func_187226_a(MoCEntityBear.class, (DataSerializer)DataSerializers.field_187198_h);
    public MoCAnimalChest localchest;
    public MoCAnimalChest emptychest;
    public ItemStack localstack;

    public MoCEntityBear(World world) {
        super(world);
        this.func_70105_a(1.2f, 1.5f);
        this.setEdad(55);
        if (this.field_70146_Z.nextInt(4) == 0) {
            this.setAdult(false);
        } else {
            this.setAdult(true);
        }
        this.field_70138_W = 1.0f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPanicMoC((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFollowOwnerPlayer((EntityLiving)this, 1.0, 2.0f, 10.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowAdult((EntityLiving)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderMoC2((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHunt((EntityCreature)this, (Class<? extends EntityCreature>)EntityAnimal.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTargetMoC((EntityCreature)this, EntityPlayer.class, true));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.calculateMaxHealth());
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)this.getAttackStrength());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BEAR_STATE, (Object)0);
        this.field_70180_af.func_187214_a(RIDEABLE, (Object)false);
        this.field_70180_af.func_187214_a(CHESTED, (Object)false);
        this.field_70180_af.func_187214_a(GHOST, (Object)false);
    }

    public int getBearState() {
        return (Integer)this.field_70180_af.func_187225_a(BEAR_STATE);
    }

    public void setBearState(int i) {
        this.field_70180_af.func_187227_b(BEAR_STATE, (Object)i);
    }

    @Override
    public boolean getIsRideable() {
        return (Boolean)this.field_70180_af.func_187225_a(RIDEABLE);
    }

    public boolean getIsChested() {
        return (Boolean)this.field_70180_af.func_187225_a(CHESTED);
    }

    public boolean getIsGhost() {
        return (Boolean)this.field_70180_af.func_187225_a(GHOST);
    }

    public void setIsChested(boolean flag) {
        this.field_70180_af.func_187227_b(CHESTED, (Object)flag);
    }

    @Override
    public void setRideable(boolean flag) {
        this.field_70180_af.func_187227_b(RIDEABLE, (Object)flag);
    }

    public void setIsGhost(boolean flag) {
        this.field_70180_af.func_187227_b(GHOST, (Object)flag);
    }

    @Override
    public void selectType() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.calculateMaxHealth());
        this.func_70606_j(this.func_110138_aP());
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)this.getAttackStrength());
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(this.getAttackRange());
        if (this.getIsAdult()) {
            this.setEdad(this.getMaxEdad());
        }
    }

    public float getBearSize() {
        return 1.0f;
    }

    public float calculateMaxHealth() {
        return 30.0f;
    }

    public double getAttackRange() {
        return 8.0;
    }

    public int getAttackStrength() {
        return 2;
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        this.startAttack();
        return super.func_70652_k(entityIn);
    }

    @Override
    public boolean isMovementCeased() {
        return this.getBearState() == 2;
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (super.func_70097_a(damagesource, i)) {
            Entity entity = damagesource.func_76346_g();
            if (this.func_184215_y(entity)) {
                return true;
            }
            if (entity != this && entity instanceof EntityLivingBase && super.shouldAttackPlayers()) {
                this.func_70624_b((EntityLivingBase)entity);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isNotScared() {
        return this.getIsAdult();
    }

    @Override
    public void func_70636_d() {
        EntityItem entityitem;
        EntityPlayer entityplayer1;
        super.func_70636_d();
        if (this.mouthCounter > 0 && ++this.mouthCounter > 20) {
            this.mouthCounter = 0;
        }
        if (this.attackCounter > 0 && ++this.attackCounter > 9) {
            this.attackCounter = 0;
        }
        if (MoCreatures.isServer() && !this.getIsAdult() && this.getEdad() < 80 && this.field_70146_Z.nextInt(300) == 0) {
            this.setBearState(2);
        }
        if (MoCreatures.isServer() && this.getBearState() == 2 && !this.getIsTamed() && this.field_70146_Z.nextInt(800) == 0) {
            this.setBearState(0);
        }
        if (MoCreatures.isServer() && this.getBearState() == 2 && !this.getIsTamed() && !this.func_70661_as().func_75500_f()) {
            this.setBearState(0);
        }
        if (MoCreatures.isServer() && this.standingCounter > 0 && ++this.standingCounter > 100) {
            this.standingCounter = 0;
            this.setBearState(0);
        }
        if (MoCreatures.isServer() && !this.getIsTamed() && this.getIsStanding() && this.getBearState() != 2 && this.getIsAdult() && this.field_70146_Z.nextInt(200) == 0 && this.shouldAttackPlayers() && (entityplayer1 = this.field_70170_p.func_72890_a((Entity)this, 4.0)) != null && this.func_70685_l((Entity)entityplayer1) && !entityplayer1.field_71075_bZ.field_75102_a) {
            this.setStand();
            this.setBearState(1);
        }
        if (MoCreatures.isServer() && this.getType() == 3 && this.field_70725_aQ == 0 && this.getBearState() != 2 && (entityitem = this.getClosestItem((Entity)this, 12.0, Items.field_151120_aE, Items.field_151102_aT)) != null) {
            float f = entityitem.func_70032_d((Entity)this);
            if (f > 2.0f) {
                this.getMyOwnPath((Entity)entityitem, f);
            }
            if (f < 2.0f && entityitem != null && this.field_70725_aQ == 0) {
                entityitem.func_70106_y();
                MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_GENERIC_EATING);
                this.func_70606_j(this.func_110138_aP());
            }
        }
    }

    @Override
    public boolean canAttackTarget(EntityLivingBase entity) {
        return !(entity instanceof MoCEntityBear) && (double)entity.field_70131_O <= 1.0 && (double)entity.field_70130_N <= 1.0;
    }

    protected Item func_146068_u() {
        return MoCreatures.animalHide;
    }

    protected SoundEvent func_184615_bR() {
        return MoCSoundEvents.ENTITY_BEAR_DEATH;
    }

    protected SoundEvent func_184601_bQ() {
        this.openMouth();
        return MoCSoundEvents.ENTITY_BEAR_HURT;
    }

    protected SoundEvent func_184639_G() {
        this.openMouth();
        return MoCSoundEvents.ENTITY_BEAR_AMBIENT;
    }

    private void openMouth() {
        this.mouthCounter = 1;
    }

    public float getAttackSwing() {
        if (this.attackCounter == 0) {
            return 0.0f;
        }
        return 1.5f + ((float)this.attackCounter / 10.0f - 10.0f) * 5.0f;
    }

    private void startAttack() {
        if (MoCreatures.isServer() && this.attackCounter == 0 && this.getBearState() == 1) {
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 0), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
            this.attackCounter = 1;
        }
    }

    @Override
    public void performAnimation(int i) {
        this.attackCounter = 1;
    }

    protected void eatingAnimal() {
        this.openMouth();
        MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_GENERIC_EATING);
    }

    @Override
    public double getCustomSpeed() {
        if (this.getBearState() == 2) {
            return 0.0;
        }
        return super.getCustomSpeed();
    }

    @Override
    public boolean isReadyToHunt() {
        return this.getIsAdult() && !this.isMovementCeased();
    }

    public boolean getIsStanding() {
        return this.standingCounter != 0;
    }

    public void setStand() {
        this.standingCounter = 1;
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand, @Nullable ItemStack stack) {
        boolean onMainHand;
        if (super.func_184645_a(player, hand, stack)) {
            return true;
        }
        boolean bl = onMainHand = hand == EnumHand.MAIN_HAND;
        if (stack != null && onMainHand && this.getIsTamed() && !this.getIsRideable() && this.getEdad() > 80 && (stack.func_77973_b() == Items.field_151141_av || stack.func_77973_b() == MoCreatures.horsesaddle)) {
            if (--stack.field_77994_a == 0) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
            }
            this.setRideable(true);
            return true;
        }
        if (stack != null && this.getIsTamed() && onMainHand && MoCTools.isItemEdibleforCarnivores(stack.func_77973_b())) {
            if (--stack.field_77994_a == 0) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
            }
            this.func_70606_j(this.func_110138_aP());
            MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_GENERIC_EATING);
            this.setIsHunting(false);
            this.setHasEaten(true);
            return true;
        }
        if (stack != null && onMainHand && this.getIsTamed() && this.getIsAdult() && !this.getIsChested() && stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150486_ae)) {
            if (--stack.field_77994_a == 0) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
            }
            this.setIsChested(true);
            MoCTools.playCustomSound((Entity)this, SoundEvents.field_187665_Y);
            return true;
        }
        if (this.getIsChested() && player.func_70093_af()) {
            if (this.localchest == null) {
                this.localchest = new MoCAnimalChest("BigBearChest", 18);
            }
            if (this.emptychest == null) {
                this.emptychest = new MoCAnimalChest("BigBearChest", 0);
            }
            if (MoCreatures.isServer()) {
                InventoryLargeChest singleChest = new InventoryLargeChest("BigBearChest", (ILockableContainer)this.localchest, (ILockableContainer)this.emptychest);
                player.func_71007_a((IInventory)singleChest);
            }
            return true;
        }
        return false;
    }

    public double func_70042_X() {
        double Yfactor = (0.086 * (double)this.getEdad() - 2.5) / 10.0;
        return (double)this.field_70131_O * Yfactor;
    }

    @Override
    public int nameYOffset() {
        return (int)((0.445 * (double)this.getEdad() + 15.0) * -1.0);
    }

    @Override
    public boolean rideableEntity() {
        return true;
    }

    @Override
    public float getSizeFactor() {
        return (float)this.getEdad() * 0.01f;
    }

    public void func_184232_k(Entity passenger) {
        double dist = (double)this.getSizeFactor() * 0.1;
        double newPosX = this.field_70165_t + dist * Math.sin(this.field_70761_aq / 57.29578f);
        double newPosZ = this.field_70161_v - dist * Math.cos(this.field_70761_aq / 57.29578f);
        passenger.func_70107_b(newPosX, this.field_70163_u + this.func_70042_X() + passenger.func_70033_W(), newPosZ);
    }

    @Override
    public void dropMyStuff() {
        if (MoCreatures.isServer()) {
            this.dropArmor();
            MoCTools.dropSaddle(this, this.field_70170_p);
            if (this.getIsChested()) {
                MoCTools.dropInventory((Entity)this, this.localchest);
                MoCTools.dropCustomItem((Entity)this, this.field_70170_p, new ItemStack((Block)Blocks.field_150486_ae, 1));
                this.setIsChested(false);
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74757_a("Saddle", this.getIsRideable());
        nbttagcompound.func_74757_a("Chested", this.getIsChested());
        nbttagcompound.func_74757_a("Ghost", this.getIsGhost());
        nbttagcompound.func_74768_a("BearState", this.getBearState());
        if (this.getIsChested() && this.localchest != null) {
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; i < this.localchest.func_70302_i_(); ++i) {
                this.localstack = this.localchest.func_70301_a(i);
                if (this.localstack == null) continue;
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.func_74774_a("Slot", (byte)i);
                this.localstack.func_77955_b(nbttagcompound1);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
            nbttagcompound.func_74782_a("Items", (NBTBase)nbttaglist);
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setRideable(nbttagcompound.func_74767_n("Saddle"));
        this.setIsChested(nbttagcompound.func_74767_n("Chested"));
        this.setIsGhost(nbttagcompound.func_74767_n("Ghost"));
        this.setBearState(nbttagcompound.func_74762_e("BearState"));
        if (this.getIsChested()) {
            NBTTagList nbttaglist = nbttagcompound.func_150295_c("Items", 10);
            this.localchest = new MoCAnimalChest("BigBearChest", 18);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
                int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
                if (j < 0 || j >= this.localchest.func_70302_i_()) continue;
                this.localchest.func_70299_a(j, ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1));
            }
        }
    }
}

