/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.monster;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityMob;
import drzhark.mocreatures.entity.ai.EntityAINearestAttackableTargetMoC;
import drzhark.mocreatures.util.MoCSoundEvents;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class MoCEntityWerewolf
extends MoCEntityMob {
    private boolean transforming;
    private int tcounter;
    private int textCounter;
    private static final DataParameter<Boolean> IS_HUMAN = EntityDataManager.func_187226_a(MoCEntityWerewolf.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_HUNCHED = EntityDataManager.func_187226_a(MoCEntityWerewolf.class, (DataSerializer)DataSerializers.field_187198_h);

    public MoCEntityWerewolf(World world) {
        super(world);
        this.func_70105_a(0.9f, 1.6f);
        this.transforming = false;
        this.tcounter = 0;
        this.setHumanForm(true);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTargetMoC((EntityCreature)this, EntityPlayer.class, true));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_HUMAN, (Object)false);
        this.field_70180_af.func_187214_a(IS_HUNCHED, (Object)false);
    }

    public void func_70606_j(float par1) {
        if (this.getIsHumanForm() && par1 > 15.0f) {
            par1 = 15.0f;
        }
        super.func_70606_j(par1);
    }

    @Override
    public void selectType() {
        if (this.getType() == 0) {
            int k = this.field_70146_Z.nextInt(100);
            if (k <= 28) {
                this.setType(1);
            } else if (k <= 56) {
                this.setType(2);
            } else if (k <= 85) {
                this.setType(3);
            } else {
                this.setType(4);
                this.field_70178_ae = true;
            }
        }
    }

    @Override
    public ResourceLocation getTexture() {
        if (this.getIsHumanForm()) {
            return MoCreatures.proxy.getTexture("wereblank.png");
        }
        switch (this.getType()) {
            case 1: {
                return MoCreatures.proxy.getTexture("wolfblack.png");
            }
            case 2: {
                return MoCreatures.proxy.getTexture("wolfbrown.png");
            }
            case 3: {
                return MoCreatures.proxy.getTexture("wolftimber.png");
            }
            case 4: {
                if (!MoCreatures.proxy.getAnimateTextures()) {
                    return MoCreatures.proxy.getTexture("wolffire1.png");
                }
                ++this.textCounter;
                if (this.textCounter < 10) {
                    this.textCounter = 10;
                }
                if (this.textCounter > 39) {
                    this.textCounter = 10;
                }
                String NTA = "wolffire";
                String NTB = "" + this.textCounter;
                NTB = NTB.substring(0, 1);
                String NTC = ".png";
                return MoCreatures.proxy.getTexture(NTA + NTB + NTC);
            }
        }
        return MoCreatures.proxy.getTexture("wolfbrown.png");
    }

    public boolean getIsHumanForm() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_HUMAN);
    }

    public void setHumanForm(boolean flag) {
        this.field_70180_af.func_187227_b(IS_HUMAN, (Object)flag);
    }

    public boolean getIsHunched() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_HUNCHED);
    }

    public void setHunched(boolean flag) {
        this.field_70180_af.func_187227_b(IS_HUNCHED, (Object)flag);
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        if (this.getIsHumanForm()) {
            this.func_70624_b(null);
            return false;
        }
        if (this.getType() == 4 && entityIn instanceof EntityLivingBase) {
            ((EntityLivingBase)entityIn).func_70015_d(10);
        }
        return super.func_70652_k(entityIn);
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float i) {
        EntityPlayer entityplayer;
        ItemStack itemstack;
        Entity entity = damagesource.func_76346_g();
        if (!this.getIsHumanForm() && entity != null && entity instanceof EntityPlayer && (itemstack = (entityplayer = (EntityPlayer)entity).func_184614_ca()) != null) {
            i = 1.0f;
            if (itemstack.func_77973_b() == MoCreatures.silversword) {
                i = 10.0f;
            }
            if (itemstack.func_77973_b() instanceof ItemSword) {
                String swordMaterial = ((ItemSword)itemstack.func_77973_b()).func_150932_j();
                String swordName = ((ItemSword)itemstack.func_77973_b()).func_77658_a();
                if (swordMaterial.toLowerCase().contains("silver") || swordName.toLowerCase().contains("silver")) {
                    i = ((ItemSword)itemstack.func_77973_b()).func_150931_i() * 3.0f;
                }
            } else if (itemstack.func_77973_b() instanceof ItemTool) {
                String toolMaterial = ((ItemTool)itemstack.func_77973_b()).func_77861_e();
                String toolName = ((ItemTool)itemstack.func_77973_b()).func_77658_a();
                if (toolMaterial.toLowerCase().contains("silver") || toolName.toLowerCase().contains("silver")) {
                    i = ((ItemSword)itemstack.func_77973_b()).func_150931_i() * 2.0f;
                }
            } else if (itemstack.func_77973_b().func_77658_a().toLowerCase().contains("silver")) {
                i = 6.0f;
            }
        }
        return super.func_70097_a(damagesource, i);
    }

    @Override
    public boolean shouldAttackPlayers() {
        return !this.getIsHumanForm() && super.shouldAttackPlayers();
    }

    protected Item func_146068_u() {
        int i = this.field_70146_Z.nextInt(12);
        if (this.getIsHumanForm()) {
            switch (i) {
                case 0: {
                    return Items.field_151038_n;
                }
                case 1: {
                    return Items.field_151053_p;
                }
                case 2: {
                    return Items.field_151041_m;
                }
                case 3: {
                    return Items.field_151017_I;
                }
                case 4: {
                    return Items.field_151039_o;
                }
            }
            return Items.field_151055_y;
        }
        switch (i) {
            case 0: {
                return Items.field_151019_K;
            }
            case 1: {
                return Items.field_151037_a;
            }
            case 2: {
                return Items.field_151036_c;
            }
            case 3: {
                return Items.field_151035_b;
            }
            case 4: {
                return Items.field_151040_l;
            }
            case 5: {
                return Items.field_151018_J;
            }
            case 6: {
                return Items.field_151051_r;
            }
            case 7: {
                return Items.field_151049_t;
            }
            case 8: {
                return Items.field_151050_s;
            }
            case 9: {
                return Items.field_151052_q;
            }
        }
        return Items.field_151153_ao;
    }

    protected SoundEvent func_184615_bR() {
        if (this.getIsHumanForm()) {
            return MoCSoundEvents.ENTITY_WEREWOLF_DEATH_HUMAN;
        }
        return MoCSoundEvents.ENTITY_WEREWOLF_DEATH;
    }

    protected SoundEvent func_184601_bQ() {
        if (this.getIsHumanForm()) {
            if (!this.transforming) {
                return MoCSoundEvents.ENTITY_WEREWOLF_HURT_HUMAN;
            }
            return null;
        }
        return MoCSoundEvents.ENTITY_WEREWOLF_HURT;
    }

    protected SoundEvent func_184639_G() {
        if (this.getIsHumanForm()) {
            return MoCSoundEvents.ENTITY_WEREWOLF_AMBIENT_HUMAN;
        }
        return MoCSoundEvents.ENTITY_WEREWOLF_AMBIENT;
    }

    public boolean IsNight() {
        return !this.field_70170_p.func_72935_r();
    }

    public void func_70645_a(DamageSource damagesource) {
        Entity entity = damagesource.func_76346_g();
        if (this.field_70744_aE > 0 && entity != null) {
            entity.func_70084_c((Entity)this, this.field_70744_aE);
        }
        if (entity != null) {
            entity.func_70074_a((EntityLivingBase)this);
        }
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                Item item = this.func_146068_u();
                if (item == null) continue;
                this.func_145779_a(item, 1);
            }
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if ((this.IsNight() && this.getIsHumanForm() || !this.IsNight() && !this.getIsHumanForm()) && this.field_70146_Z.nextInt(250) == 0) {
                this.transforming = true;
            }
            if (this.getIsHumanForm() && this.func_70638_az() != null) {
                this.func_70624_b(null);
            }
            if (this.func_70638_az() != null && !this.getIsHumanForm()) {
                boolean hunch = this.func_70068_e((Entity)this.func_70638_az()) > 12.0;
                this.setHunched(hunch);
            }
            if (this.transforming && this.field_70146_Z.nextInt(3) == 0) {
                ++this.tcounter;
                if (this.tcounter % 2 == 0) {
                    this.field_70165_t += 0.3;
                    this.field_70163_u += (double)(this.tcounter / 30);
                    this.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 1.0f);
                }
                if (this.tcounter % 2 != 0) {
                    this.field_70165_t -= 0.3;
                }
                if (this.tcounter == 10) {
                    MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_WEREWOLF_TRANSFORM);
                }
                if (this.tcounter > 30) {
                    this.Transform();
                    this.tcounter = 0;
                    this.transforming = false;
                }
            }
            if (this.field_70146_Z.nextInt(300) == 0) {
                this.field_70708_bq -= 100 * this.field_70170_p.func_175659_aa().func_151525_a();
                if (this.field_70708_bq < 0) {
                    this.field_70708_bq = 0;
                }
            }
        }
    }

    private void Transform() {
        if (this.field_70725_aQ > 0) {
            return;
        }
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) + 1;
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        float f = 0.1f;
        for (int l = 0; l < 30; ++l) {
            double d = (float)i + this.field_70170_p.field_73012_v.nextFloat();
            double d1 = (float)j + this.field_70170_p.field_73012_v.nextFloat();
            double d2 = (float)k + this.field_70170_p.field_73012_v.nextFloat();
            double d3 = d - (double)i;
            double d4 = d1 - (double)j;
            double d5 = d2 - (double)k;
            double d6 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
            d3 /= d6;
            d4 /= d6;
            d5 /= d6;
            double d7 = 0.5 / (d6 / (double)f + 0.1);
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, (d + (double)i * 1.0) / 2.0, (d1 + (double)j * 1.0) / 2.0, (d2 + (double)k * 1.0) / 2.0, d3 *= (d7 *= (double)(this.field_70170_p.field_73012_v.nextFloat() * this.field_70170_p.field_73012_v.nextFloat() + 0.3f)), d4 *= d7, d5 *= d7, new int[0]);
        }
        if (this.getIsHumanForm()) {
            this.setHumanForm(false);
            this.func_70606_j(40.0f);
            this.transforming = false;
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        } else {
            this.setHumanForm(true);
            this.func_70606_j(15.0f);
            this.transforming = false;
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setHumanForm(nbttagcompound.func_74767_n("HumanForm"));
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74757_a("HumanForm", this.getIsHumanForm());
    }

    public float func_70689_ay() {
        if (this.getIsHumanForm()) {
            return 0.1f;
        }
        if (this.getIsHunched()) {
            return 0.35f;
        }
        return 0.2f;
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        if (this.getType() == 4) {
            this.field_70178_ae = true;
        }
        return super.func_180482_a(difficulty, livingdata);
    }
}

