/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.monster;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityMob;
import drzhark.mocreatures.entity.ai.EntityAIFleeFromPlayer;
import drzhark.mocreatures.entity.ai.EntityAINearestAttackableTargetMoC;
import drzhark.mocreatures.entity.passive.MoCEntityPetScorpion;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAnimation;
import drzhark.mocreatures.util.MoCSoundEvents;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFleeSun;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAIRestrictSun;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MoCEntityScorpion
extends MoCEntityMob {
    private boolean isPoisoning;
    private int poisontimer;
    public int mouthCounter;
    public int armCounter;
    private static final DataParameter<Boolean> IS_PICKED = EntityDataManager.func_187226_a(MoCEntityScorpion.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> HAS_BABIES = EntityDataManager.func_187226_a(MoCEntityScorpion.class, (DataSerializer)DataSerializers.field_187198_h);

    public MoCEntityScorpion(World world) {
        super(world);
        this.func_70105_a(1.4f, 0.9f);
        this.poisontimer = 0;
        this.setAdult(true);
        this.setEdad(20);
        if (MoCreatures.isServer()) {
            if (this.field_70146_Z.nextInt(4) == 0) {
                this.setHasBabies(true);
            } else {
                this.setHasBabies(false);
            }
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIRestrictSun((EntityCreature)this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIFleeSun((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFleeFromPlayer((EntityCreature)this, 1.2, 4.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTargetMoC((EntityCreature)this, EntityPlayer.class, true));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(18.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
    }

    @Override
    public void selectType() {
        this.checkSpawningBiome();
        if (this.getType() == 0) {
            this.setType(1);
        }
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getType()) {
            case 1: {
                return MoCreatures.proxy.getTexture("scorpiondirt.png");
            }
            case 2: {
                return MoCreatures.proxy.getTexture("scorpioncave.png");
            }
            case 3: {
                return MoCreatures.proxy.getTexture("scorpionnether.png");
            }
            case 4: {
                return MoCreatures.proxy.getTexture("scorpionfrost.png");
            }
        }
        return MoCreatures.proxy.getTexture("scorpiondirt.png");
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_PICKED, (Object)false);
        this.field_70180_af.func_187214_a(HAS_BABIES, (Object)false);
    }

    public boolean getHasBabies() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_BABIES);
    }

    public boolean getIsPicked() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_PICKED);
    }

    public boolean getIsPoisoning() {
        return this.isPoisoning;
    }

    public void setHasBabies(boolean flag) {
        this.field_70180_af.func_187227_b(HAS_BABIES, (Object)flag);
    }

    public void setPicked(boolean flag) {
        this.field_70180_af.func_187227_b(IS_PICKED, (Object)flag);
    }

    public void setPoisoning(boolean flag) {
        if (flag && MoCreatures.isServer()) {
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 0), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
        }
        this.isPoisoning = flag;
    }

    @Override
    public void performAnimation(int animationType) {
        if (animationType == 0) {
            this.setPoisoning(true);
        } else if (animationType == 1) {
            this.armCounter = 1;
        } else if (animationType == 3) {
            this.mouthCounter = 1;
        }
    }

    @Override
    public float getMoveSpeed() {
        return 0.8f;
    }

    @Override
    public boolean func_70617_f_() {
        return this.field_70123_F;
    }

    public boolean climbing() {
        return !this.field_70122_E && this.func_70617_f_();
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70122_E && this.func_184187_bx() != null) {
            this.field_70177_z = this.func_184187_bx().field_70177_z;
        }
        if (this.mouthCounter != 0 && this.mouthCounter++ > 50) {
            this.mouthCounter = 0;
        }
        if (MoCreatures.isServer() && (this.armCounter == 10 || this.armCounter == 40)) {
            MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_SCORPION_CLAW);
        }
        if (this.armCounter != 0 && this.armCounter++ > 24) {
            this.armCounter = 0;
        }
        if (MoCreatures.isServer() && !this.func_184207_aI() && this.getIsAdult() && !this.getHasBabies() && this.field_70146_Z.nextInt(100) == 0) {
            MoCTools.findMobRider((Entity)this);
        }
        if (this.getIsPoisoning()) {
            ++this.poisontimer;
            if (this.poisontimer == 1) {
                MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_SCORPION_STING);
            }
            if (this.poisontimer > 50) {
                this.poisontimer = 0;
                this.setPoisoning(false);
            }
        }
        super.func_70636_d();
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (super.func_70097_a(damagesource, i)) {
            Entity entity = damagesource.func_76346_g();
            if (entity != null && entity != this && entity instanceof EntityLivingBase && this.shouldAttackPlayers() && this.getIsAdult()) {
                this.func_70624_b((EntityLivingBase)entity);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean entitiesToIgnore(Entity entity) {
        return super.entitiesToIgnore(entity) || this.getIsTamed() && entity instanceof MoCEntityScorpion && ((MoCEntityScorpion)entity).getIsTamed();
    }

    protected void func_174815_a(EntityLivingBase entityLivingBaseIn, Entity entityIn) {
        boolean flag = entityIn instanceof EntityPlayer;
        if (!this.getIsPoisoning() && this.field_70146_Z.nextInt(5) == 0 && entityIn instanceof EntityLivingBase) {
            this.setPoisoning(true);
            if (this.getType() <= 2) {
                if (flag) {
                    MoCreatures.poisonPlayer((EntityPlayer)entityIn);
                }
                ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76436_u, 70, 0));
            } else if (this.getType() == 4) {
                if (flag) {
                    MoCreatures.freezePlayer((EntityPlayer)entityIn);
                }
                ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 70, 0));
            } else if (this.getType() == 3 && flag && MoCreatures.isServer() && !this.field_70170_p.field_73011_w.func_177500_n()) {
                MoCreatures.burnPlayer((EntityPlayer)entityIn);
                ((EntityLivingBase)entityIn).func_70015_d(15);
            }
        } else {
            this.swingArm();
        }
        super.func_174815_a(entityLivingBaseIn, entityIn);
    }

    public void swingArm() {
        if (MoCreatures.isServer()) {
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 1), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
    }

    public boolean swingingTail() {
        return this.getIsPoisoning() && this.poisontimer < 15;
    }

    public void func_70645_a(DamageSource damagesource) {
        super.func_70645_a(damagesource);
        if (MoCreatures.isServer() && this.getIsAdult() && this.getHasBabies()) {
            int k = this.field_70146_Z.nextInt(5);
            for (int i = 0; i < k; ++i) {
                MoCEntityPetScorpion entityscorpy = new MoCEntityPetScorpion(this.field_70170_p);
                entityscorpy.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                entityscorpy.setAdult(false);
                entityscorpy.setEdad(20);
                entityscorpy.setType(this.getType());
                this.field_70170_p.func_72838_d((Entity)entityscorpy);
                MoCTools.playCustomSound((Entity)entityscorpy, SoundEvents.field_187665_Y);
            }
        }
    }

    protected SoundEvent func_184615_bR() {
        return MoCSoundEvents.ENTITY_SCORPION_DEATH;
    }

    protected SoundEvent func_184601_bQ() {
        return MoCSoundEvents.ENTITY_SCORPION_HURT;
    }

    protected SoundEvent func_184639_G() {
        if (MoCreatures.isServer()) {
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 3), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
        }
        return MoCSoundEvents.ENTITY_SCORPION_AMBIENT;
    }

    protected Item func_146068_u() {
        if (!this.getIsAdult()) {
            return Items.field_151007_F;
        }
        boolean flag = this.field_70146_Z.nextInt(100) < MoCreatures.proxy.rareItemDropChance;
        switch (this.getType()) {
            case 1: {
                if (flag) {
                    return MoCreatures.scorpStingDirt;
                }
                return MoCreatures.chitin;
            }
            case 2: {
                if (flag) {
                    return MoCreatures.scorpStingCave;
                }
                return MoCreatures.chitinCave;
            }
            case 3: {
                if (flag) {
                    return MoCreatures.scorpStingNether;
                }
                return MoCreatures.chitinNether;
            }
            case 4: {
                if (flag) {
                    return MoCreatures.scorpStingFrost;
                }
                return MoCreatures.chitinFrost;
            }
        }
        return Items.field_151007_F;
    }

    protected void func_70628_a(boolean flag, int x) {
        if (!flag) {
            return;
        }
        Item item = this.func_146068_u();
        if (item != null && this.field_70146_Z.nextInt(3) == 0) {
            this.func_145779_a(item, 1);
        }
    }

    @Override
    public boolean func_70601_bi() {
        return this.func_70814_o() && MoCreatures.entityMap.get(this.getClass()).getFrequency() > 0 && this.getCanSpawnHereLiving() && this.getCanSpawnHereCreature();
    }

    @Override
    public boolean checkSpawningBiome() {
        int k;
        int j;
        if (this.field_70170_p.field_73011_w.func_177500_n()) {
            this.setType(3);
            this.field_70178_ae = true;
            return true;
        }
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        BlockPos pos = new BlockPos(i, j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b), k = MathHelper.func_76128_c((double)this.field_70161_v));
        Biome currentbiome = MoCTools.Biomekind(this.field_70170_p, pos);
        if (BiomeDictionary.isBiomeOfType((Biome)currentbiome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
            this.setType(4);
        } else if (!this.field_70170_p.func_175710_j(pos) && this.field_70163_u < 50.0) {
            this.setType(2);
            return true;
        }
        return true;
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setHasBabies(nbttagcompound.func_74767_n("Babies"));
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74757_a("Babies", this.getHasBabies());
    }

    public int func_70627_aG() {
        return 300;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    @Override
    public float getAdjustedYOffset() {
        return 30.0f;
    }

    @Override
    protected int getMaxEdad() {
        return 120;
    }

    @Override
    public boolean isNotScared() {
        return this.getIsAdult() || this.getEdad() > 70;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.75 - 0.15;
    }

    public void func_184232_k(Entity passenger) {
        double dist = 0.2;
        double newPosX = this.field_70165_t + dist * Math.sin(this.field_70761_aq / 57.29578f);
        double newPosZ = this.field_70161_v - dist * Math.cos(this.field_70761_aq / 57.29578f);
        passenger.func_70107_b(newPosX, this.field_70163_u + this.func_70042_X() + passenger.func_70033_W(), newPosZ);
        passenger.field_70177_z = this.field_70177_z;
    }
}

