/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.monster;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityMob;
import drzhark.mocreatures.entity.ai.EntityAINearestAttackableTargetMoC;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAnimation;
import drzhark.mocreatures.util.MoCSoundEvents;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MoCEntityManticore
extends MoCEntityMob {
    public int mouthCounter;
    public int tailCounter;
    public int wingFlapCounter;
    private boolean isPoisoning;
    private int poisontimer;

    public MoCEntityManticore(World world) {
        super(world);
        this.func_70105_a(1.4f, 1.6f);
        this.field_70178_ae = true;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTargetMoC((EntityCreature)this, EntityPlayer.class, true));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
    }

    @Override
    public void selectType() {
        this.checkSpawningBiome();
        if (this.getType() == 0) {
            this.setType(this.field_70146_Z.nextInt(2) * 2 + 2);
        }
    }

    @Override
    public boolean checkSpawningBiome() {
        int k;
        int j;
        if (this.field_70170_p.field_73011_w.func_177500_n()) {
            this.setType(1);
            this.field_70178_ae = true;
            return true;
        }
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        BlockPos pos = new BlockPos(i, j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b), k = MathHelper.func_76128_c((double)this.field_70161_v));
        Biome currentbiome = MoCTools.Biomekind(this.field_70170_p, pos);
        if (BiomeDictionary.isBiomeOfType((Biome)currentbiome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
            this.setType(3);
        }
        return true;
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getType()) {
            case 1: {
                return MoCreatures.proxy.getTexture("BCmanticore.png");
            }
            case 2: {
                return MoCreatures.proxy.getTexture("BCmanticoreDark.png");
            }
            case 3: {
                return MoCreatures.proxy.getTexture("BCmanticoreBlue.png");
            }
            case 4: {
                return MoCreatures.proxy.getTexture("BCmanticoreGreen.png");
            }
        }
        return MoCreatures.proxy.getTexture("BCmanticoreGreen.png");
    }

    @Override
    public boolean isFlyer() {
        return true;
    }

    @Override
    public float getMoveSpeed() {
        return 0.9f;
    }

    @Override
    public void func_180430_e(float f, float f1) {
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        return super.func_70652_k(entityIn);
    }

    public boolean getIsRideable() {
        return false;
    }

    @Override
    protected boolean isHarmedByDaylight() {
        return true;
    }

    @Override
    public int maxFlyingHeight() {
        return 10;
    }

    @Override
    public int minFlyingHeight() {
        return 1;
    }

    public void func_184232_k(Entity passenger) {
        double dist = -0.1;
        double newPosX = this.field_70165_t + dist * Math.sin(this.field_70761_aq / 57.29578f);
        double newPosZ = this.field_70161_v - dist * Math.cos(this.field_70761_aq / 57.29578f);
        passenger.func_70107_b(newPosX, this.field_70163_u + this.func_70042_X() + passenger.func_70033_W(), newPosZ);
        passenger.field_70177_z = this.field_70177_z;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.75 - 0.1;
    }

    private void openMouth() {
        this.mouthCounter = 1;
    }

    private void moveTail() {
        this.tailCounter = 1;
    }

    public boolean isOnAir() {
        return this.field_70170_p.func_175623_d(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 0.2)), MathHelper.func_76128_c((double)this.field_70161_v)));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.mouthCounter > 0 && ++this.mouthCounter > 30) {
            this.mouthCounter = 0;
        }
        if (this.tailCounter > 0 && ++this.tailCounter > 8) {
            this.tailCounter = 0;
        }
        if (this.wingFlapCounter > 0 && ++this.wingFlapCounter > 20) {
            this.wingFlapCounter = 0;
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.isOnAir() && this.isFlyer() && this.field_70146_Z.nextInt(5) == 0) {
            this.wingFlapCounter = 1;
        }
        if (this.field_70146_Z.nextInt(200) == 0) {
            this.moveTail();
        }
        if (MoCreatures.isServer() && this.isFlyer() && this.isOnAir()) {
            float myFlyingSpeed = MoCTools.getMyMovementSpeed((Entity)this);
            int wingFlapFreq = (int)(25.0f - myFlyingSpeed * 10.0f);
            if (!this.func_184207_aI() || wingFlapFreq < 5) {
                wingFlapFreq = 5;
            }
            if (this.field_70146_Z.nextInt(wingFlapFreq) == 0) {
                this.wingFlap();
            }
        }
        if (this.isFlyer()) {
            if (this.wingFlapCounter > 0 && ++this.wingFlapCounter > 20) {
                this.wingFlapCounter = 0;
            }
            if (this.wingFlapCounter == 5 && MoCreatures.isServer()) {
                MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_GENERIC_WINGFLAP);
            }
        }
        if (this.getIsPoisoning()) {
            ++this.poisontimer;
            if (this.poisontimer == 1) {
                MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_SCORPION_STING);
            }
            if (this.poisontimer > 50) {
                this.poisontimer = 0;
                this.setPoisoning(false);
            }
        }
        if (MoCreatures.isServer()) {
            if (this.isFlyer() && this.field_70146_Z.nextInt(500) == 0) {
                this.wingFlap();
            }
            if (!this.func_184207_aI() && this.field_70146_Z.nextInt(200) == 0) {
                MoCTools.findMobRider((Entity)this);
            }
        }
    }

    @Override
    public void makeEntityJump() {
        this.wingFlap();
        super.makeEntityJump();
    }

    public void wingFlap() {
        if (this.isFlyer() && this.wingFlapCounter == 0) {
            this.wingFlapCounter = 1;
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 3), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
        }
    }

    @Override
    public void performAnimation(int animationType) {
        if (animationType == 0) {
            this.setPoisoning(true);
        } else if (animationType == 3) {
            this.wingFlapCounter = 1;
        }
    }

    public boolean getIsPoisoning() {
        return this.isPoisoning;
    }

    public void setPoisoning(boolean flag) {
        if (flag && MoCreatures.isServer()) {
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 0), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
        }
        this.isPoisoning = flag;
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (super.func_70097_a(damagesource, i)) {
            Entity entity = damagesource.func_76346_g();
            if (entity != null && entity != this && entity instanceof EntityLivingBase && this.shouldAttackPlayers() && this.getIsAdult()) {
                this.func_70624_b((EntityLivingBase)entity);
            }
            return true;
        }
        return false;
    }

    protected void func_174815_a(EntityLivingBase entityLivingBaseIn, Entity entityIn) {
        boolean flag = entityIn instanceof EntityPlayer;
        if (!this.getIsPoisoning() && this.field_70146_Z.nextInt(5) == 0 && entityIn instanceof EntityLivingBase) {
            this.setPoisoning(true);
            if (this.getType() == 4 || this.getType() == 2) {
                if (flag) {
                    MoCreatures.poisonPlayer((EntityPlayer)entityIn);
                }
                ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76436_u, 70, 0));
            } else if (this.getType() == 3) {
                if (flag) {
                    MoCreatures.freezePlayer((EntityPlayer)entityIn);
                }
                ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 70, 0));
            } else if (this.getType() == 1 && flag && MoCreatures.isServer() && !this.field_70170_p.field_73011_w.func_177500_n()) {
                MoCreatures.burnPlayer((EntityPlayer)entityIn);
                ((EntityLivingBase)entityIn).func_70015_d(15);
            }
        } else {
            this.openMouth();
        }
        super.func_174815_a(entityLivingBaseIn, entityIn);
    }

    public boolean swingingTail() {
        return this.getIsPoisoning() && this.poisontimer < 15;
    }

    protected SoundEvent func_184615_bR() {
        this.openMouth();
        return MoCSoundEvents.ENTITY_LION_DEATH;
    }

    protected SoundEvent func_184601_bQ() {
        this.openMouth();
        return MoCSoundEvents.ENTITY_LION_HURT;
    }

    protected SoundEvent func_184639_G() {
        this.openMouth();
        return MoCSoundEvents.ENTITY_LION_AMBIENT;
    }

    @Override
    public float getSizeFactor() {
        return 1.4f;
    }

    protected Item func_146068_u() {
        boolean flag = this.field_70146_Z.nextInt(100) < MoCreatures.proxy.rareItemDropChance;
        switch (this.getType()) {
            case 1: {
                if (flag) {
                    return MoCreatures.scorpStingNether;
                }
                return MoCreatures.chitinNether;
            }
            case 2: {
                if (flag) {
                    return MoCreatures.scorpStingCave;
                }
                return MoCreatures.chitinCave;
            }
            case 3: {
                if (flag) {
                    return MoCreatures.scorpStingFrost;
                }
                return MoCreatures.chitinFrost;
            }
            case 4: {
                if (flag) {
                    return MoCreatures.scorpStingDirt;
                }
                return MoCreatures.chitin;
            }
        }
        return MoCreatures.chitin;
    }

    protected void func_70628_a(boolean flag, int x) {
        BlockPos pos = new BlockPos((double)MathHelper.func_76128_c((double)this.field_70165_t), (double)MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b), this.field_70161_v);
        int chance = MoCreatures.proxy.rareItemDropChance;
        if (this.field_70146_Z.nextInt(100) < chance) {
            this.func_70099_a(new ItemStack(MoCreatures.mocegg, 1, this.getType() + 61), 0.0f);
        } else {
            super.func_70628_a(flag, x);
        }
    }
}

