/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.monster;

import com.mojang.authlib.GameProfile;
import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityMob;
import drzhark.mocreatures.entity.ai.EntityAINearestAttackableTargetMoC;
import drzhark.mocreatures.entity.item.MoCEntityThrowableRock;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAnimation;
import drzhark.mocreatures.network.message.MoCMessageTwoBytes;
import drzhark.mocreatures.util.MoCSoundEvents;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class MoCEntityGolem
extends MoCEntityMob
implements IEntityAdditionalSpawnData {
    public int tcounter;
    public MoCEntityThrowableRock tempRock;
    private byte[] golemCubes;
    private int dCounter = 0;
    private int sCounter;
    private static final DataParameter<Integer> GOLEM_STATE = EntityDataManager.func_187226_a(MoCEntityGolem.class, (DataSerializer)DataSerializers.field_187192_b);

    public MoCEntityGolem(World world) {
        super(world);
        this.texture = "golemt.png";
        this.func_70105_a(1.5f, 4.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTargetMoC((EntityCreature)this, EntityPlayer.class, true));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
    }

    public void writeSpawnData(ByteBuf data) {
        for (int i = 0; i < 23; ++i) {
            data.writeByte((int)this.golemCubes[i]);
        }
    }

    public void readSpawnData(ByteBuf data) {
        for (int i = 0; i < 23; ++i) {
            this.golemCubes[i] = data.readByte();
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.initGolemCubes();
        this.field_70180_af.func_187214_a(GOLEM_STATE, (Object)0);
    }

    public int getGolemState() {
        return (Integer)this.field_70180_af.func_187225_a(GOLEM_STATE);
    }

    public void setGolemState(int i) {
        this.field_70180_af.func_187227_b(GOLEM_STATE, (Object)i);
    }

    @Override
    public void func_70636_d() {
        float distanceToTarget;
        super.func_70636_d();
        if (MoCreatures.isServer()) {
            EntityPlayer entityplayer1;
            if (this.getGolemState() == 0 && (entityplayer1 = this.field_70170_p.func_72890_a((Entity)this, 8.0)) != null) {
                this.setGolemState(1);
            }
            if (this.getGolemState() == 1 && !this.isMissingCubes()) {
                this.setGolemState(2);
            }
            if (this.getGolemState() > 2 && this.getGolemState() != 4 && this.func_70638_az() == null) {
                this.setGolemState(1);
            }
            if (this.getGolemState() > 1 && this.func_70638_az() != null && this.field_70146_Z.nextInt(20) == 0) {
                if (this.func_110143_aJ() >= 30.0f) {
                    this.setGolemState(2);
                }
                if (this.func_110143_aJ() < 30.0f && this.func_110143_aJ() >= 10.0f) {
                    this.setGolemState(3);
                }
                if (this.func_110143_aJ() < 10.0f) {
                    this.setGolemState(4);
                }
            }
            if (this.getGolemState() != 0 && this.getGolemState() != 4 && this.isMissingCubes()) {
                int freq = 21 - this.getGolemState() * this.field_70170_p.func_175659_aa().func_151525_a();
                if (this.getGolemState() == 1) {
                    freq = 10;
                }
                if (this.field_70146_Z.nextInt(freq) == 0) {
                    this.acquireRock(2);
                }
            }
            if (this.getGolemState() == 4) {
                this.func_70661_as().func_75499_g();
                ++this.dCounter;
                if (this.dCounter < 80 && this.field_70146_Z.nextInt(3) == 0) {
                    this.acquireRock(4);
                }
                if (this.dCounter == 120) {
                    MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_GOLEM_DYING, 3.0f);
                    MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 1), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
                }
                if (this.dCounter > 140) {
                    MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_GOLEM_EXPLODE, 3.0f);
                    this.destroyGolem();
                }
            }
        }
        if (this.tcounter == 0 && this.func_70638_az() != null && this.canShoot() && (distanceToTarget = this.func_70032_d((Entity)this.func_70638_az())) > 6.0f) {
            this.tcounter = 1;
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 0), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
        }
        if (this.tcounter != 0) {
            if (this.tcounter++ == 70 && this.func_70638_az() != null && this.canShoot() && !this.func_70638_az().field_70128_L && this.func_70685_l((Entity)this.func_70638_az())) {
                this.shootBlock((Entity)this.func_70638_az());
            } else if (this.tcounter > 90) {
                this.tcounter = 0;
            }
        }
        if (MoCreatures.proxy.getParticleFX() > 0 && this.getGolemState() == 4 && this.sCounter > 0) {
            for (int i = 0; i < 10; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70146_Z.nextGaussian(), this.field_70146_Z.nextGaussian(), this.field_70146_Z.nextGaussian(), new int[0]);
            }
        }
    }

    private void destroyGolem() {
        List<Integer> usedBlocks = this.usedCubes();
        if (!usedBlocks.isEmpty() && MoCTools.mobGriefing(this.field_70170_p) && MoCreatures.proxy.golemDestroyBlocks) {
            for (int i = 0; i < usedBlocks.size(); ++i) {
                Block block = Block.func_149729_e((int)this.generateBlock(this.golemCubes[usedBlocks.get(i)]));
                EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(block, 1, 0));
                entityitem.func_174867_a(10);
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
        }
        this.func_70106_y();
    }

    @Override
    public boolean isMovementCeased() {
        return this.getGolemState() == 4;
    }

    protected void acquireRock(int type) {
        BlockPos myTRockPos = MoCTools.getRandomBlockPos((Entity)this, 24.0);
        if (myTRockPos == null) {
            return;
        }
        boolean canDestroyBlocks = MoCTools.mobGriefing(this.field_70170_p) && MoCreatures.proxy.golemDestroyBlocks;
        IBlockState blockstate = this.field_70170_p.func_180495_p(myTRockPos);
        if (Block.func_149682_b((Block)blockstate.func_177230_c()) == 0) {
            return;
        }
        BlockEvent.BreakEvent event = null;
        if (!this.field_70170_p.field_72995_K) {
            event = new BlockEvent.BreakEvent(this.field_70170_p, myTRockPos, blockstate, (EntityPlayer)FakePlayerFactory.get((WorldServer)((WorldServer)this.field_70170_p), (GameProfile)MoCreatures.MOCFAKEPLAYER));
        }
        if (canDestroyBlocks && event != null && !event.isCanceled()) {
            this.field_70170_p.func_175698_g(myTRockPos);
        } else {
            canDestroyBlocks = false;
        }
        if (!canDestroyBlocks) {
            blockstate = Block.func_176220_d((int)this.returnRandomCheapBlock());
        }
        MoCEntityThrowableRock trock = new MoCEntityThrowableRock(this.field_70170_p, (Entity)this, myTRockPos.func_177958_n(), myTRockPos.func_177956_o() + 1, myTRockPos.func_177952_p());
        trock.setState(blockstate);
        trock.setBehavior(type);
        this.field_70170_p.func_72838_d((Entity)trock);
    }

    private int returnRandomCheapBlock() {
        int i = this.field_70146_Z.nextInt(4);
        switch (i) {
            case 0: {
                return 3;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 79;
            }
        }
        return 3;
    }

    public void receiveRock(IBlockState state) {
        if (MoCreatures.isServer()) {
            byte myBlock = this.translateOre(Block.func_149682_b((Block)state.func_177230_c()));
            byte slot = (byte)this.getRandomCubeAdj();
            if (slot != -1 && slot < 23 && myBlock != -1 && this.getGolemState() != 4) {
                MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_GOLEM_ATTACH, 3.0f);
                int h = this.field_70170_p.func_175659_aa().func_151525_a();
                this.func_70606_j(this.func_110143_aJ() + (float)h);
                if (this.func_110143_aJ() > this.func_110138_aP()) {
                    this.func_70606_j(this.func_110138_aP());
                }
                this.saveGolemCube(slot, myBlock);
            } else {
                MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_TURTLE_HURT, 2.0f);
                if (MoCTools.mobGriefing(this.field_70170_p) && MoCreatures.proxy.golemDestroyBlocks) {
                    EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state)));
                    entityitem.func_174867_a(10);
                    entityitem.func_70288_d();
                }
            }
        }
    }

    @Override
    public void performAnimation(int animationType) {
        if (animationType == 0) {
            this.tcounter = 1;
        }
        if (animationType == 1) {
            this.sCounter = 1;
        }
    }

    private void shootBlock(Entity entity) {
        int i;
        if (entity == null) {
            return;
        }
        ArrayList<Integer> armBlocks = new ArrayList<Integer>();
        for (int i2 = 9; i2 < 15; ++i2) {
            if (this.golemCubes[i2] == 30) continue;
            armBlocks.add(i2);
        }
        if (armBlocks.isEmpty()) {
            return;
        }
        int j = this.field_70146_Z.nextInt(armBlocks.size());
        int x = i = ((Integer)armBlocks.get(j)).intValue();
        if (i == 9 || i == 12) {
            if (this.golemCubes[i + 2] != 30) {
                x = i + 2;
            } else if (this.golemCubes[i + 1] != 30) {
                x = i + 1;
            }
        }
        if ((i == 10 || i == 13) && this.golemCubes[i + 1] != 30) {
            x = i + 1;
        }
        MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_GOLEM_SHOOT, 3.0f);
        MoCTools.ThrowStone((Entity)this, entity, Block.func_176220_d((int)this.generateBlock(this.golemCubes[x])), 10.0, 0.4);
        this.saveGolemCube((byte)x, (byte)30);
        this.tcounter = 0;
    }

    private boolean canShoot() {
        int x = 0;
        for (int i = 9; i < 15; i = (int)((byte)(i + 1))) {
            if (this.golemCubes[i] == 30) continue;
            ++x;
        }
        return x != 0 && this.getGolemState() != 4 && this.getGolemState() != 1;
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float i) {
        boolean uncoveredChest;
        if (this.getGolemState() == 4) {
            return false;
        }
        List<Integer> missingChestBlocks = this.missingChestCubes();
        boolean bl = uncoveredChest = missingChestBlocks.size() == 4;
        if (!this.openChest() && !uncoveredChest && this.getGolemState() != 1) {
            int j = this.field_70170_p.func_175659_aa().func_151525_a();
            if (MoCreatures.isServer() && this.field_70146_Z.nextInt(j) == 0) {
                this.destroyRandomGolemCube();
            } else {
                MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_TURTLE_HURT, 2.0f);
            }
            Entity entity = damagesource.func_76346_g();
            if (entity != this && this.field_70170_p.func_175659_aa().func_151525_a() > 0 && entity instanceof EntityLivingBase) {
                this.func_70624_b((EntityLivingBase)entity);
                return true;
            }
            return false;
        }
        if (i > 5.0f) {
            i = 5.0f;
        }
        if (this.getGolemState() != 1 && super.func_70097_a(damagesource, i)) {
            Entity entity = damagesource.func_76346_g();
            if (entity != this && this.field_70170_p.func_175659_aa().func_151525_a() > 0 && entity instanceof EntityLivingBase) {
                this.func_70624_b((EntityLivingBase)entity);
                return true;
            }
            return false;
        }
        if (this.getGolemState() == 1) {
            Entity entity = damagesource.func_76346_g();
            if (entity != this && this.field_70170_p.func_175659_aa().func_151525_a() > 0 && entity instanceof EntityLivingBase) {
                this.func_70624_b((EntityLivingBase)entity);
                return true;
            }
            return false;
        }
        return false;
    }

    private void destroyRandomGolemCube() {
        int i = this.getRandomUsedCube();
        if (i == 4) {
            return;
        }
        int x = i;
        if ((i == 10 || i == 13 || i == 16 || i == 19) && this.golemCubes[i + 1] != 30) {
            x = i + 1;
        }
        if (i == 9 || i == 12 || i == 15 || i == 18) {
            if (this.golemCubes[i + 2] != 30) {
                x = i + 2;
            } else if (this.golemCubes[i + 1] != 30) {
                x = i + 1;
            }
        }
        if (x != -1 && this.golemCubes[x] != 30) {
            Block block = Block.func_149729_e((int)this.generateBlock(this.golemCubes[x]));
            this.saveGolemCube((byte)x, (byte)30);
            MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_GOLEM_HURT, 3.0f);
            if (MoCTools.mobGriefing(this.field_70170_p) && MoCreatures.proxy.golemDestroyBlocks) {
                EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(block, 1, 0));
                entityitem.func_174867_a(10);
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
        }
    }

    @Override
    public float getAdjustedYOffset() {
        if (this.golemCubes[17] != 30 || this.golemCubes[20] != 30) {
            return 0.0f;
        }
        if (this.golemCubes[16] != 30 || this.golemCubes[19] != 30) {
            return 0.4f;
        }
        if (this.golemCubes[15] != 30 || this.golemCubes[18] != 30) {
            return 0.7f;
        }
        if (this.golemCubes[1] != 30 || this.golemCubes[3] != 30) {
            return 0.8f;
        }
        return 1.45f;
    }

    @Override
    public float getSizeFactor() {
        return 1.8f;
    }

    public byte getBlockText(int i) {
        return this.golemCubes[i];
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74768_a("golemState", this.getGolemState());
        NBTTagList cubeLists = new NBTTagList();
        for (int i = 0; i < 23; ++i) {
            NBTTagCompound nbttag = new NBTTagCompound();
            nbttag.func_74774_a("Slot", this.golemCubes[i]);
            cubeLists.func_74742_a((NBTBase)nbttag);
        }
        nbttagcompound.func_74782_a("GolemBlocks", (NBTBase)cubeLists);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setGolemState(nbttagcompound.func_74762_e("golemState"));
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("GolemBlocks", 10);
        for (int i = 0; i < 23; ++i) {
            NBTTagCompound var4 = nbttaglist.func_150305_b(i);
            this.golemCubes[i] = var4.func_74771_c("Slot");
        }
    }

    private void initGolemCubes() {
        this.golemCubes = new byte[23];
        for (int i = 0; i < 23; ++i) {
            this.golemCubes[i] = 30;
        }
        int j = this.field_70146_Z.nextInt(4);
        switch (j) {
            case 0: {
                j = 7;
                break;
            }
            case 1: {
                j = 11;
                break;
            }
            case 2: {
                j = 15;
                break;
            }
            case 3: {
                j = 21;
            }
        }
        this.saveGolemCube((byte)4, (byte)j);
    }

    public void saveGolemCube(byte slot, byte value) {
        this.golemCubes[slot] = value;
        if (MoCreatures.isServer() && MoCreatures.proxy.worldInitDone) {
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageTwoBytes(this.func_145782_y(), slot, value), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
        }
    }

    private List<Integer> missingCubes() {
        ArrayList<Integer> emptyBlocks = new ArrayList<Integer>();
        for (int i = 0; i < 23; ++i) {
            if (this.golemCubes[i] != 30) continue;
            emptyBlocks.add(i);
        }
        return emptyBlocks;
    }

    public boolean isMissingCubes() {
        for (int i = 0; i < 23; ++i) {
            if (this.golemCubes[i] != 30) continue;
            return true;
        }
        return false;
    }

    private List<Integer> missingChestCubes() {
        ArrayList<Integer> emptyChestBlocks = new ArrayList<Integer>();
        for (int i = 0; i < 4; ++i) {
            if (this.golemCubes[i] != 30) continue;
            emptyChestBlocks.add(i);
        }
        return emptyChestBlocks;
    }

    private List<Integer> usedCubes() {
        ArrayList<Integer> usedBlocks = new ArrayList<Integer>();
        for (int i = 0; i < 23; ++i) {
            if (this.golemCubes[i] == 30) continue;
            usedBlocks.add(i);
        }
        return usedBlocks;
    }

    private int getRandomUsedCube() {
        List<Integer> usedBlocks = this.usedCubes();
        if (usedBlocks.isEmpty()) {
            return -1;
        }
        int randomEmptyBlock = this.field_70146_Z.nextInt(usedBlocks.size());
        return usedBlocks.get(randomEmptyBlock);
    }

    private int getRandomMissingCube() {
        List<Integer> emptyChestBlocks = this.missingChestCubes();
        if (!emptyChestBlocks.isEmpty()) {
            int randomEmptyBlock = this.field_70146_Z.nextInt(emptyChestBlocks.size());
            return emptyChestBlocks.get(randomEmptyBlock);
        }
        List<Integer> emptyBlocks = this.missingCubes();
        if (emptyBlocks.isEmpty()) {
            return -1;
        }
        int randomEmptyBlock = this.field_70146_Z.nextInt(emptyBlocks.size());
        return emptyBlocks.get(randomEmptyBlock);
    }

    private int getRandomCubeAdj() {
        int i = this.getRandomMissingCube();
        if (i == 10 || i == 13 || i == 16 || i == 19) {
            if (this.golemCubes[i - 1] == 30) {
                return i - 1;
            }
            this.saveGolemCube((byte)i, this.golemCubes[i - 1]);
            return i - 1;
        }
        if (i == 11 || i == 14 || i == 17 || i == 20) {
            if (this.golemCubes[i - 2] == 30 && this.golemCubes[i - 1] == 30) {
                return i - 2;
            }
            if (this.golemCubes[i - 1] == 30) {
                this.saveGolemCube((byte)(i - 1), this.golemCubes[i - 2]);
                return i - 2;
            }
            this.saveGolemCube((byte)i, this.golemCubes[i - 1]);
            this.saveGolemCube((byte)(i - 1), this.golemCubes[i - 2]);
            return i - 2;
        }
        return i;
    }

    @Override
    public float rollRotationOffset() {
        int leftLeg = 0;
        int rightLeg = 0;
        if (this.golemCubes[15] != 30) {
            ++leftLeg;
        }
        if (this.golemCubes[16] != 30) {
            ++leftLeg;
        }
        if (this.golemCubes[17] != 30) {
            ++leftLeg;
        }
        if (this.golemCubes[18] != 30) {
            ++rightLeg;
        }
        if (this.golemCubes[19] != 30) {
            ++rightLeg;
        }
        if (this.golemCubes[20] != 30) {
            ++rightLeg;
        }
        return (float)(leftLeg - rightLeg) * 10.0f;
    }

    public boolean openChest() {
        if (this.isMissingCubes()) {
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(2.0, 2.0, 2.0));
            for (int i = 0; i < list.size(); ++i) {
                Entity entity1 = (Entity)list.get(i);
                if (!(entity1 instanceof MoCEntityThrowableRock)) continue;
                if (MoCreatures.proxy.getParticleFX() > 0) {
                    MoCreatures.proxy.VacuumFX(this);
                }
                return true;
            }
        }
        return false;
    }

    private byte translateOre(int blockType) {
        switch (blockType) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 18: {
                return 10;
            }
            case 2: 
            case 3: {
                return 1;
            }
            case 4: 
            case 48: {
                return 2;
            }
            case 5: {
                return 3;
            }
            case 12: {
                return 4;
            }
            case 13: {
                return 5;
            }
            case 16: 
            case 21: 
            case 56: 
            case 73: 
            case 74: {
                return 24;
            }
            case 14: 
            case 41: {
                return 7;
            }
            case 15: 
            case 42: {
                return 11;
            }
            case 57: {
                return 15;
            }
            case 17: {
                return 6;
            }
            case 20: {
                return 8;
            }
            case 22: 
            case 35: {
                return 9;
            }
            case 45: {
                return 12;
            }
            case 49: {
                return 14;
            }
            case 58: {
                return 16;
            }
            case 61: 
            case 62: {
                return 17;
            }
            case 78: 
            case 79: {
                return 18;
            }
            case 81: {
                return 19;
            }
            case 82: {
                return 20;
            }
            case 86: 
            case 91: 
            case 103: {
                return 22;
            }
            case 87: {
                return 23;
            }
            case 89: {
                return 25;
            }
            case 98: {
                return 26;
            }
            case 112: {
                return 27;
            }
            case 129: 
            case 133: {
                return 21;
            }
        }
        return -1;
    }

    private int generateBlock(int golemBlock) {
        switch (golemBlock) {
            case 0: {
                return 1;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 5;
            }
            case 4: {
                return 12;
            }
            case 5: {
                return 13;
            }
            case 6: {
                return 17;
            }
            case 7: {
                return 41;
            }
            case 8: {
                return 20;
            }
            case 9: {
                return 35;
            }
            case 10: {
                return 18;
            }
            case 11: {
                return 42;
            }
            case 12: {
                return 45;
            }
            case 13: {
                return 2;
            }
            case 14: {
                return 49;
            }
            case 15: {
                return 57;
            }
            case 16: {
                return 58;
            }
            case 17: {
                return 51;
            }
            case 18: {
                return 79;
            }
            case 19: {
                return 81;
            }
            case 20: {
                return 82;
            }
            case 21: {
                return 133;
            }
            case 22: {
                return 86;
            }
            case 23: {
                return 87;
            }
            case 24: {
                return 56;
            }
            case 25: {
                return 89;
            }
            case 26: {
                return 98;
            }
            case 27: {
                return 112;
            }
        }
        return 2;
    }

    private int countLegBlocks() {
        int x = 0;
        for (int i = 15; i < 21; i = (int)((byte)(i + 1))) {
            if (this.golemCubes[i] == 30) continue;
            ++x;
        }
        return x;
    }

    public float func_70689_ay() {
        return 0.15f * ((float)this.countLegBlocks() / 6.0f);
    }

    public ResourceLocation getEffectTexture() {
        switch (this.getGolemState()) {
            case 1: {
                return MoCreatures.proxy.getTexture("golemeffect1.png");
            }
            case 2: {
                return MoCreatures.proxy.getTexture("golemeffect2.png");
            }
            case 3: {
                return MoCreatures.proxy.getTexture("golemeffect3.png");
            }
            case 4: {
                return MoCreatures.proxy.getTexture("golemeffect4.png");
            }
        }
        return null;
    }

    public float colorFX(int i) {
        switch (this.getGolemState()) {
            case 1: {
                if (i == 1) {
                    return 0.25490198f;
                }
                if (i == 2) {
                    return 0.6156863f;
                }
                if (i == 3) {
                    return 0.99607843f;
                }
            }
            case 2: {
                if (i == 1) {
                    return 0.95686275f;
                }
                if (i == 2) {
                    return 0.972549f;
                }
                if (i == 3) {
                    return 0.14117648f;
                }
            }
            case 3: {
                if (i == 1) {
                    return 1.0f;
                }
                if (i == 2) {
                    return 0.6039216f;
                }
                if (i == 3) {
                    return 0.08235294f;
                }
            }
            case 4: {
                if (i == 1) {
                    return 0.972549f;
                }
                if (i == 2) {
                    return 0.039215688f;
                }
                if (i != 3) break;
                return 0.039215688f;
            }
        }
        return 0.0f;
    }

    protected void func_180429_a(BlockPos p_180429_1_, Block p_180429_2_) {
        this.func_184185_a(MoCSoundEvents.ENTITY_GOLEM_WALK, 1.0f, 1.0f);
    }

    protected SoundEvent func_184601_bQ() {
        return MoCSoundEvents.ENTITY_GOLEM_AMBIENT;
    }

    @Override
    public boolean func_70601_bi() {
        return super.func_70601_bi() && this.field_70170_p.func_175710_j(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v))) && this.field_70163_u > 50.0;
    }
}

