/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.ai;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import drzhark.mocreatures.entity.IMoCEntity;
import drzhark.mocreatures.entity.ai.EntitiAITargetMoC;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EntitySelectors;

public class EntityAINearestAttackableTargetMoC
extends EntitiAITargetMoC {
    protected final Class<? extends EntityLivingBase> targetClass;
    private final int targetChance;
    protected final Sorter theNearestAttackableTargetSorter;
    protected Predicate<EntityLivingBase> targetEntitySelector;
    protected EntityLivingBase targetEntity;
    private IMoCEntity theAttacker;

    public EntityAINearestAttackableTargetMoC(EntityCreature creature, Class<? extends EntityLivingBase> classTarget, boolean checkSight) {
        this(creature, classTarget, checkSight, false);
    }

    public EntityAINearestAttackableTargetMoC(EntityCreature creature, Class<? extends EntityLivingBase> classTarget, boolean checkSight, boolean onlyNearby) {
        this(creature, classTarget, 10, checkSight, onlyNearby, null);
    }

    public EntityAINearestAttackableTargetMoC(EntityCreature creature, Class<? extends EntityLivingBase> classTarget, int chance, boolean checkSight, boolean onlyNearby, final Predicate<EntityLivingBase> targetSelector) {
        super(creature, checkSight, onlyNearby);
        if (creature instanceof IMoCEntity) {
            this.theAttacker = (IMoCEntity)creature;
        }
        this.targetClass = classTarget;
        this.targetChance = chance;
        this.theNearestAttackableTargetSorter = new Sorter((Entity)creature);
        this.func_75248_a(1);
        this.targetEntitySelector = new Predicate<EntityLivingBase>(){

            public boolean apply(EntityLivingBase entitylivingbaseIn) {
                if (targetSelector != null && !targetSelector.apply((Object)entitylivingbaseIn)) {
                    return false;
                }
                if (entitylivingbaseIn instanceof EntityPlayer) {
                    double d0 = EntityAINearestAttackableTargetMoC.this.getTargetDistance();
                    if (entitylivingbaseIn.func_70093_af()) {
                        d0 *= (double)0.8f;
                    }
                    if (entitylivingbaseIn.func_82150_aj()) {
                        float f = ((EntityPlayer)entitylivingbaseIn).func_82243_bO();
                        if (f < 0.1f) {
                            f = 0.1f;
                        }
                        d0 *= (double)(0.7f * f);
                    }
                    if ((double)entitylivingbaseIn.func_70032_d((Entity)EntityAINearestAttackableTargetMoC.this.taskOwner) > d0) {
                        return false;
                    }
                }
                return EntityAINearestAttackableTargetMoC.this.isSuitableTarget(entitylivingbaseIn, false);
            }
        };
    }

    public boolean func_75250_a() {
        if (this.theAttacker != null && (this.theAttacker.isMovementCeased() || !this.theAttacker.isNotScared())) {
            return false;
        }
        if (this.targetChance > 0 && this.taskOwner.func_70681_au().nextInt(this.targetChance) != 0) {
            return false;
        }
        double d0 = this.getTargetDistance();
        List list = this.taskOwner.field_70170_p.func_175647_a(this.targetClass, this.taskOwner.func_174813_aQ().func_72314_b(d0, 4.0, d0), Predicates.and(this.targetEntitySelector, (Predicate)EntitySelectors.field_180132_d));
        Collections.sort(list, this.theNearestAttackableTargetSorter);
        if (list.isEmpty()) {
            return false;
        }
        this.targetEntity = (EntityLivingBase)list.get(0);
        return !(this.targetEntity instanceof EntityPlayer) || this.theAttacker.shouldAttackPlayers();
    }

    @Override
    public void func_75249_e() {
        this.taskOwner.func_70624_b(this.targetEntity);
        super.func_75249_e();
    }

    public static class Sorter
    implements Comparator<Entity> {
        private final Entity theEntity;

        public Sorter(Entity theEntityIn) {
            this.theEntity = theEntityIn;
        }

        @Override
        public int compare(Entity p_compare_1_, Entity p_compare_2_) {
            double d1;
            double d0 = this.theEntity.func_70068_e(p_compare_1_);
            return d0 < (d1 = this.theEntity.func_70068_e(p_compare_2_)) ? -1 : (d0 > d1 ? 1 : 0);
        }
    }
}

