/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.ai;

import drzhark.mocreatures.entity.MoCEntityAnimal;
import drzhark.mocreatures.entity.monster.MoCEntityOgre;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public abstract class EntitiAITargetMoC
extends EntityAIBase {
    protected final EntityCreature taskOwner;
    protected boolean shouldCheckSight;
    private boolean nearbyOnly;
    private int targetSearchStatus;
    private int targetSearchDelay;
    private int targetUnseenTicks;

    public EntitiAITargetMoC(EntityCreature creature, boolean checkSight, boolean onlyNearby) {
        this.taskOwner = creature;
        this.shouldCheckSight = checkSight;
        this.nearbyOnly = onlyNearby;
    }

    public EntitiAITargetMoC(EntityCreature creature, boolean checkSight) {
        this(creature, checkSight, false);
    }

    public static boolean isSuitableTarget(EntityLiving attacker, EntityLivingBase target, boolean includeInvincibles, boolean checkSight) {
        if (target == null) {
            return false;
        }
        if (target == attacker) {
            return false;
        }
        if (!target.func_70089_S()) {
            return false;
        }
        if (!attacker.func_70686_a(target.getClass())) {
            return false;
        }
        if (attacker instanceof MoCEntityAnimal && !(target instanceof EntityPlayer)) {
            MoCEntityAnimal mocattacker = (MoCEntityAnimal)attacker;
            if (!mocattacker.canAttackTarget(target)) {
                return false;
            }
            if (mocattacker.getIsTamed() && target instanceof MoCEntityAnimal && ((MoCEntityAnimal)target).getIsTamed()) {
                return false;
            }
        }
        Team team = attacker.func_96124_cp();
        Team team1 = target.func_96124_cp();
        if (team != null && team1 == team) {
            return false;
        }
        if (attacker instanceof IEntityOwnable && ((IEntityOwnable)attacker).func_184753_b() != null) {
            if (target instanceof IEntityOwnable && ((IEntityOwnable)attacker).func_184753_b().equals(((IEntityOwnable)target).func_184753_b())) {
                return false;
            }
            if (target == ((IEntityOwnable)attacker).func_70902_q()) {
                return false;
            }
        } else if (target instanceof EntityPlayer && includeInvincibles && ((EntityPlayer)target).field_71075_bZ.field_75102_a) {
            return false;
        }
        return !checkSight || attacker.func_70635_at().func_75522_a((Entity)target);
    }

    public boolean func_75253_b() {
        EntityLivingBase entitylivingbase = this.taskOwner.func_70638_az();
        if (entitylivingbase == null) {
            return false;
        }
        if (!entitylivingbase.func_70089_S()) {
            return false;
        }
        Team team = this.taskOwner.func_96124_cp();
        Team team1 = entitylivingbase.func_96124_cp();
        if (team != null && team1 == team) {
            return false;
        }
        double d0 = this.getTargetDistance();
        if (this.taskOwner.func_70068_e((Entity)entitylivingbase) > d0 * d0) {
            return false;
        }
        if (this.shouldCheckSight) {
            if (this.taskOwner.func_70635_at().func_75522_a((Entity)entitylivingbase)) {
                this.targetUnseenTicks = 0;
            } else if (++this.targetUnseenTicks > 60) {
                return false;
            }
        }
        return !(entitylivingbase instanceof EntityPlayer) || !((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a;
    }

    protected double getTargetDistance() {
        if (this.taskOwner instanceof MoCEntityOgre) {
            return ((MoCEntityOgre)this.taskOwner).getAttackRange();
        }
        IAttributeInstance iattributeinstance = this.taskOwner.func_110148_a(SharedMonsterAttributes.field_111265_b);
        return iattributeinstance == null ? 16.0 : iattributeinstance.func_111126_e();
    }

    public void func_75249_e() {
        this.targetSearchStatus = 0;
        this.targetSearchDelay = 0;
        this.targetUnseenTicks = 0;
    }

    public void func_75251_c() {
        this.taskOwner.func_70624_b((EntityLivingBase)null);
    }

    protected boolean isSuitableTarget(EntityLivingBase target, boolean includeInvincibles) {
        if (!EntitiAITargetMoC.isSuitableTarget((EntityLiving)this.taskOwner, target, includeInvincibles, this.shouldCheckSight)) {
            return false;
        }
        if (!this.taskOwner.func_180485_d(new BlockPos((Entity)target))) {
            return false;
        }
        if (this.nearbyOnly) {
            if (--this.targetSearchDelay <= 0) {
                this.targetSearchStatus = 0;
            }
            if (this.targetSearchStatus == 0) {
                int n = this.targetSearchStatus = this.canEasilyReach(target) ? 1 : 2;
            }
            if (this.targetSearchStatus == 2) {
                return false;
            }
        }
        return true;
    }

    private boolean canEasilyReach(EntityLivingBase p_75295_1_) {
        int j;
        this.targetSearchDelay = 10 + this.taskOwner.func_70681_au().nextInt(5);
        Path path = this.taskOwner.func_70661_as().func_75494_a((Entity)p_75295_1_);
        if (path == null) {
            return false;
        }
        PathPoint pathpoint = path.func_75870_c();
        if (pathpoint == null) {
            return false;
        }
        int i = pathpoint.field_75839_a - MathHelper.func_76128_c((double)p_75295_1_.field_70165_t);
        return (double)(i * i + (j = pathpoint.field_75838_c - MathHelper.func_76128_c((double)p_75295_1_.field_70161_v)) * j) <= 2.25;
    }
}

