/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.IMoCEntity;
import drzhark.mocreatures.entity.IMoCTameable;
import drzhark.mocreatures.entity.ai.EntityAIMoverHelperMoC;
import drzhark.mocreatures.entity.ai.PathNavigateFlyer;
import drzhark.mocreatures.entity.item.MoCEntityEgg;
import drzhark.mocreatures.entity.item.MoCEntityKittyBed;
import drzhark.mocreatures.entity.item.MoCEntityLitterBox;
import drzhark.mocreatures.entity.passive.MoCEntityHorse;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class MoCEntityAnimal
extends EntityAnimal
implements IMoCEntity {
    protected boolean divePending;
    protected boolean jumpPending;
    protected int temper;
    protected boolean isEntityJumping;
    protected boolean riderIsDisconnecting = false;
    public float moveSpeed;
    protected String texture = "blank.jpg";
    private int huntingCounter;
    protected boolean isTameable = false;
    protected PathNavigate navigatorWater;
    protected PathNavigate navigatorFlyer;
    private double divingDepth;
    private boolean randomAttributesUpdated;
    protected static final DataParameter<Boolean> ADULT = EntityDataManager.func_187226_a(MoCEntityAnimal.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(MoCEntityAnimal.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> AGE = EntityDataManager.func_187226_a(MoCEntityAnimal.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<String> NAME_STR = EntityDataManager.func_187226_a(MoCEntityAnimal.class, (DataSerializer)DataSerializers.field_187194_d);

    public MoCEntityAnimal(World world) {
        super(world);
        this.navigatorWater = new PathNavigateSwimmer((EntityLiving)this, world);
        this.field_70765_h = new EntityAIMoverHelperMoC((EntityLiving)this);
        this.navigatorFlyer = new PathNavigateFlyer((EntityLiving)this, world);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
    }

    @Override
    public ResourceLocation getTexture() {
        return MoCreatures.proxy.getTexture(this.texture);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData par1EntityLivingData) {
        this.selectType();
        return super.func_180482_a(difficulty, par1EntityLivingData);
    }

    @Override
    public void selectType() {
        this.setType(1);
    }

    public EntityAgeable func_90011_a(EntityAgeable var1) {
        return null;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ADULT, (Object)false);
        this.field_70180_af.func_187214_a(TYPE, (Object)0);
        this.field_70180_af.func_187214_a(AGE, (Object)45);
        this.field_70180_af.func_187214_a(NAME_STR, (Object)"");
    }

    @Override
    public void setType(int i) {
        this.field_70180_af.func_187227_b(TYPE, (Object)i);
    }

    @Override
    public int getType() {
        return (Integer)this.field_70180_af.func_187225_a(TYPE);
    }

    public void setDisplayName(boolean flag) {
    }

    @Override
    public boolean renderName() {
        return MoCreatures.proxy.getDisplayPetName() && this.getPetName() != null && !this.getPetName().equals("") && !this.func_184207_aI() && this.func_184187_bx() == null;
    }

    @Override
    public boolean getIsAdult() {
        return (Boolean)this.field_70180_af.func_187225_a(ADULT);
    }

    @Override
    public void setAdult(boolean flag) {
        this.field_70180_af.func_187227_b(ADULT, (Object)flag);
    }

    @Override
    public String getPetName() {
        return (String)this.field_70180_af.func_187225_a(NAME_STR);
    }

    @Override
    public void setPetName(String name) {
        this.field_70180_af.func_187227_b(NAME_STR, (Object)name);
    }

    @Override
    public int getEdad() {
        return (Integer)this.field_70180_af.func_187225_a(AGE);
    }

    @Override
    public void setEdad(int i) {
        this.field_70180_af.func_187227_b(AGE, (Object)i);
    }

    @Override
    public boolean getIsTamed() {
        return false;
    }

    @Override
    public int getOwnerPetId() {
        return 0;
    }

    @Override
    public void setOwnerPetId(int petId) {
    }

    @Override
    public UUID getOwnerId() {
        return null;
    }

    public boolean getIsJumping() {
        return this.isEntityJumping;
    }

    public void setIsJumping(boolean flag) {
        this.isEntityJumping = flag;
    }

    protected boolean func_70692_ba() {
        if (MoCreatures.proxy.forceDespawns) {
            return !this.getIsTamed();
        }
        return false;
    }

    @Override
    public boolean checkSpawningBiome() {
        return true;
    }

    protected EntityLivingBase getClosestEntityLiving(Entity entity, double d) {
        double d1 = -1.0;
        EntityLivingBase entityliving = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(d, d, d));
        for (int i = 0; i < list.size(); ++i) {
            Entity entity1 = (Entity)list.get(i);
            if (this.entitiesToIgnore(entity1)) continue;
            double d2 = entity1.func_70092_e(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            if (!(d < 0.0) && !(d2 < d * d) || d1 != -1.0 && !(d2 < d1) || !((EntityLivingBase)entity1).func_70685_l(entity)) continue;
            d1 = d2;
            entityliving = (EntityLivingBase)entity1;
        }
        return entityliving;
    }

    public EntityLivingBase getClosestTarget(Entity entity, double d) {
        double d1 = -1.0;
        EntityLivingBase entityliving = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(d, d, d));
        for (int i = 0; i < list.size(); ++i) {
            Entity entity1 = (Entity)list.get(i);
            if (!(entity1 instanceof EntityLivingBase) || entity1 == entity || entity1 == entity.func_184187_bx() || entity1 == entity.func_184187_bx() || entity1 instanceof EntityPlayer || entity1 instanceof EntityMob || this.field_70131_O <= entity1.field_70131_O || this.field_70130_N <= entity1.field_70130_N) continue;
            double d2 = entity1.func_70092_e(entity.field_70163_u, entity.field_70161_v, entity.field_70159_w);
            if (!(d < 0.0) && !(d2 < d * d) || d1 != -1.0 && !(d2 < d1) || !((EntityLivingBase)entity1).func_70685_l(entity)) continue;
            d1 = d2;
            entityliving = (EntityLivingBase)entity1;
        }
        return entityliving;
    }

    protected EntityLivingBase getClosestSpecificEntity(Entity entity, Class<? extends EntityLiving> myClass, double d) {
        double d1 = -1.0;
        EntityLivingBase entityliving = null;
        List list = this.field_70170_p.func_72839_b(entity, entity.func_174813_aQ().func_72314_b(d, d, d));
        for (int i = 0; i < list.size(); ++i) {
            Entity entity1 = (Entity)list.get(i);
            if (!myClass.isAssignableFrom(entity1.getClass())) continue;
            double d2 = entity1.func_70092_e(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            if (!(d < 0.0) && !(d2 < d * d) || d1 != -1.0 && !(d2 < d1)) continue;
            d1 = d2;
            entityliving = (EntityLivingBase)entity1;
        }
        return entityliving;
    }

    public boolean entitiesToIgnore(Entity entity) {
        return !(entity instanceof EntityLiving) || entity instanceof EntityMob || entity instanceof EntityPlayer || entity instanceof MoCEntityKittyBed || entity instanceof MoCEntityLitterBox || this.getIsTamed() && entity instanceof IMoCEntity && ((IMoCEntity)entity).getIsTamed() || entity instanceof EntityWolf && !MoCreatures.proxy.attackWolves || entity instanceof MoCEntityHorse && !MoCreatures.proxy.attackHorses || entity.field_70130_N >= this.field_70130_N || entity.field_70131_O >= this.field_70131_O || entity instanceof MoCEntityEgg || entity instanceof IMoCEntity && !MoCreatures.proxy.enableHunters;
    }

    protected EntityLivingBase getBoogey(double d) {
        EntityLivingBase entityliving = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(d, 4.0, d));
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (!this.entitiesToInclude(entity)) continue;
            entityliving = (EntityLivingBase)entity;
        }
        return entityliving;
    }

    public boolean entitiesToInclude(Entity entity) {
        return entity.getClass() != this.getClass() && entity instanceof EntityLivingBase && ((double)entity.field_70130_N >= 0.5 || (double)entity.field_70131_O >= 0.5);
    }

    public void func_70636_d() {
        if (MoCreatures.isServer()) {
            if (this.rideableEntity() && this.func_184207_aI()) {
                this.Riding();
            }
            if (this.isMovementCeased()) {
                this.func_70661_as().func_75499_g();
            }
            if (this.getEdad() == 0) {
                this.setEdad(this.getMaxEdad() - 10);
            }
            if (!this.getIsAdult() && this.field_70146_Z.nextInt(300) == 0 && this.getEdad() < this.getMaxEdad()) {
                this.setEdad(this.getEdad() + 1);
                if (this.getEdad() >= this.getMaxEdad()) {
                    this.setAdult(true);
                }
            }
            if (MoCreatures.proxy.enableHunters && this.isReadyToHunt() && !this.getIsHunting() && this.field_70146_Z.nextInt(500) == 0) {
                this.setIsHunting(true);
            }
            if (this.getIsHunting() && ++this.huntingCounter > 50) {
                this.setIsHunting(false);
            }
            this.func_70661_as().func_75501_e();
        }
        if (this.func_70090_H() && this.isAmphibian() && (this.field_70146_Z.nextInt(500) == 0 || !this.randomAttributesUpdated)) {
            this.setNewDivingDepth();
            this.randomAttributesUpdated = true;
        }
        if (this.canRidePlayer() && this.func_184218_aH()) {
            MoCTools.dismountSneakingPlayer((EntityLiving)this);
        }
        this.func_70875_t();
        super.func_70636_d();
    }

    public int getMaxEdad() {
        return 100;
    }

    @Override
    public boolean isNotScared() {
        return false;
    }

    public boolean swimmerEntity() {
        return false;
    }

    public boolean isSwimming() {
        return this.func_70055_a(Material.field_151586_h);
    }

    public boolean isMyAphrodisiac(Item item1) {
        return false;
    }

    public void dropMyStuff() {
    }

    protected boolean isMyHealFood(ItemStack itemstack) {
        return false;
    }

    public boolean func_70090_H() {
        if (this.isAmphibian()) {
            return this.field_70170_p.func_72918_a(this.func_174813_aQ().func_72314_b(0.0, -0.2, 0.0), Material.field_151586_h, (Entity)this);
        }
        return super.func_70090_H();
    }

    public boolean func_70648_aU() {
        return this.isAmphibian();
    }

    public EntityItem getClosestItem(Entity entity, double d, Item item, Item item1) {
        double d1 = -1.0;
        EntityItem entityitem = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(d, d, d));
        for (int k = 0; k < list.size(); ++k) {
            EntityItem entityitem1;
            Entity entity1 = (Entity)list.get(k);
            if (!(entity1 instanceof EntityItem) || (entityitem1 = (EntityItem)entity1).func_92059_d().func_77973_b() != item && entityitem1.func_92059_d().func_77973_b() != item1) continue;
            double d2 = entityitem1.func_70092_e(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            if (!(d < 0.0) && !(d2 < d * d) || d1 != -1.0 && !(d2 < d1)) continue;
            d1 = d2;
            entityitem = entityitem1;
        }
        return entityitem;
    }

    public EntityItem getClosestEntityItem(Entity entity, double d) {
        double d1 = -1.0;
        EntityItem entityitem = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(d, d, d));
        for (int k = 0; k < list.size(); ++k) {
            Entity entity1 = (Entity)list.get(k);
            if (!(entity1 instanceof EntityItem)) continue;
            EntityItem entityitem1 = (EntityItem)entity1;
            double d2 = entityitem1.func_70092_e(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            if (!(d < 0.0) && !(d2 < d * d) || d1 != -1.0 && !(d2 < d1)) continue;
            d1 = d2;
            entityitem = entityitem1;
        }
        return entityitem;
    }

    public EntityItem getClosestFood(Entity entity, double d) {
        double d1 = -1.0;
        EntityItem entityitem = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(d, d, d));
        for (int k = 0; k < list.size(); ++k) {
            EntityItem entityitem1;
            Entity entity1 = (Entity)list.get(k);
            if (!(entity1 instanceof EntityItem) || !MoCTools.isItemEdible((entityitem1 = (EntityItem)entity1).func_92059_d().func_77973_b())) continue;
            double d2 = entityitem1.func_70092_e(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            if (!(d < 0.0) && !(d2 < d * d) || d1 != -1.0 && !(d2 < d1)) continue;
            d1 = d2;
            entityitem = entityitem1;
        }
        return entityitem;
    }

    public void faceLocation(int i, int j, int k, float f) {
        double var4 = (double)i + 0.5 - this.field_70165_t;
        double var8 = (double)k + 0.5 - this.field_70161_v;
        double var6 = (double)j + 0.5 - this.field_70163_u;
        double var14 = MathHelper.func_76133_a((double)(var4 * var4 + var8 * var8));
        float var12 = (float)(Math.atan2(var8, var4) * 180.0 / Math.PI) - 90.0f;
        float var13 = (float)(-(Math.atan2(var6, var14) * 180.0 / Math.PI));
        this.field_70125_A = -this.updateRotation2(this.field_70125_A, var13, f);
        this.field_70177_z = this.updateRotation2(this.field_70177_z, var12, f);
    }

    private float updateRotation2(float par1, float par2, float par3) {
        float var4;
        for (var4 = par2 - par1; var4 < -180.0f; var4 += 360.0f) {
        }
        while (var4 >= 180.0f) {
            var4 -= 360.0f;
        }
        if (var4 > par3) {
            var4 = par3;
        }
        if (var4 < -par3) {
            var4 = -par3;
        }
        return par1 + var4;
    }

    public void getMyOwnPath(Entity entity, float f) {
        Path pathentity = this.func_70661_as().func_75494_a(entity);
        if (pathentity != null) {
            this.func_70661_as().func_75484_a(pathentity, 1.0);
        }
    }

    public void Riding() {
        if (this.func_184207_aI() && this.func_184187_bx() instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)this.func_184187_bx();
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(1.0, 0.0, 1.0));
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    float f;
                    Entity entity = (Entity)list.get(i);
                    if (entity.field_70128_L) continue;
                    entity.func_70100_b_(entityplayer);
                    if (!(entity instanceof EntityMob) || !((f = this.func_70032_d(entity)) < 2.0f) || !(entity instanceof EntityMob) || this.field_70146_Z.nextInt(10) != 0) continue;
                    this.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)((EntityLivingBase)entity)), (float)((EntityMob)entity).func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
                }
            }
            if (entityplayer.func_70093_af()) {
                this.makeEntityDive();
            }
        }
    }

    protected void getPathOrWalkableBlock(Entity entity, float f) {
        Path pathentity = this.field_70699_by.func_179680_a(entity.func_180425_c());
        if (pathentity == null && f > 8.0f) {
            int i = MathHelper.func_76128_c((double)entity.field_70165_t) - 2;
            int j = MathHelper.func_76128_c((double)entity.field_70161_v) - 2;
            int k = MathHelper.func_76128_c((double)entity.func_174813_aQ().field_72338_b);
            for (int l = 0; l <= 4; ++l) {
                for (int i1 = 0; i1 <= 4; ++i1) {
                    BlockPos pos = new BlockPos(i, k, j);
                    if (l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || !this.field_70170_p.func_180495_p(pos.func_177982_a(l, -1, i1)).func_185915_l() || this.field_70170_p.func_180495_p(pos.func_177982_a(l, 0, i1)).func_185915_l() || this.field_70170_p.func_180495_p(pos.func_177982_a(l, 1, i1)).func_185915_l()) continue;
                    this.func_70012_b((float)(i + l) + 0.5f, k, (float)(j + i1) + 0.5f, this.field_70177_z, this.field_70125_A);
                    return;
                }
            }
        } else {
            this.field_70699_by.func_75484_a(pathentity, 16.0);
        }
    }

    public MoCEntityAnimal spawnBabyAnimal(EntityAgeable par1EntityAgeable) {
        return null;
    }

    public boolean getCanSpawnHereCreature() {
        BlockPos pos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b), MathHelper.func_76128_c((double)this.field_70161_v));
        return this.func_180484_a(pos) >= 0.0f;
    }

    public boolean getCanSpawnHereLiving() {
        return this.field_70170_p.func_72855_b(this.func_174813_aQ()) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ());
    }

    public boolean func_70601_bi() {
        if (MoCreatures.entityMap.get(this.getClass()).getFrequency() <= 0) {
            return false;
        }
        if (this.field_70170_p.field_73011_w.func_186058_p().func_186068_a() != 0) {
            return this.getCanSpawnHereCreature() && this.getCanSpawnHereLiving();
        }
        BlockPos pos = new BlockPos((double)MathHelper.func_76128_c((double)this.field_70165_t), (double)MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b), this.field_70161_v);
        String s = MoCTools.biomeName(this.field_70170_p, pos);
        if (s.toLowerCase().contains("jungle")) {
            return this.getCanSpawnHereJungle();
        }
        if (s.equals("WyvernBiome")) {
            return this.getCanSpawnHereMoCBiome();
        }
        return super.func_70601_bi();
    }

    private boolean getCanSpawnHereMoCBiome() {
        if (this.field_70170_p.func_72855_b(this.func_174813_aQ()) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ())) {
            BlockPos pos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b), MathHelper.func_76128_c((double)this.field_70161_v));
            if (pos.func_177956_o() < 50) {
                return false;
            }
            IBlockState blockstate = this.field_70170_p.func_180495_p(pos.func_177977_b());
            Block block = blockstate.func_177230_c();
            if (block == MoCreatures.mocDirt || block == MoCreatures.mocGrass || block != null && block.isLeaves(blockstate, (IBlockAccess)this.field_70170_p, pos.func_177977_b())) {
                return true;
            }
        }
        return false;
    }

    public boolean getCanSpawnHereJungle() {
        return this.field_70170_p.func_72855_b(this.func_174813_aQ()) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty();
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74757_a("Adult", this.getIsAdult());
        nbttagcompound.func_74768_a("Edad", this.getEdad());
        nbttagcompound.func_74778_a("Name", this.getPetName());
        nbttagcompound.func_74768_a("TypeInt", this.getType());
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setAdult(nbttagcompound.func_74767_n("Adult"));
        this.setEdad(nbttagcompound.func_74762_e("Edad"));
        this.setPetName(nbttagcompound.func_74779_i("Name"));
        this.setType(nbttagcompound.func_74762_e("TypeInt"));
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.func_184207_aI()) {
            EntityLivingBase passenger = (EntityLivingBase)this.func_184179_bs();
            if (passenger != null) {
                this.moveEntityWithRider(strafe, forward, passenger);
            }
            return;
        }
        if (this.isAmphibian() && this.func_70090_H() || this.isFlyer() && this.getIsFlying()) {
            this.func_70060_a(strafe, forward, 0.1f);
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.9f;
            this.field_70181_x *= (double)0.9f;
            this.field_70179_y *= (double)0.9f;
            if (this.func_70638_az() == null) {
                this.field_70181_x -= 0.005;
            }
        } else {
            super.func_70612_e(strafe, forward);
        }
    }

    public void moveEntityWithHeadingBypassRider(float strafe, float forward) {
        super.func_70612_e(strafe, forward);
    }

    public void moveEntityWithRider(float strafe, float forward, EntityLivingBase passenger) {
        if (passenger == null) {
            return;
        }
        if (this.func_184207_aI() && !this.getIsTamed()) {
            this.moveEntityWithRiderUntamed(strafe, forward, passenger);
            return;
        }
        boolean flySelfPropelled = this.selfPropelledFlyer() && this.isOnAir();
        boolean flyingMount = this.isFlyer() && this.func_184207_aI() && this.getIsTamed() && !this.field_70122_E && this.isOnAir();
        this.field_70126_B = this.field_70177_z = passenger.field_70177_z;
        this.field_70125_A = passenger.field_70125_A * 0.5f;
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        this.field_70759_as = this.field_70761_aq = this.field_70177_z;
        if (!this.selfPropelledFlyer() || this.selfPropelledFlyer() && !this.isOnAir()) {
            strafe = (float)((double)(passenger.field_70702_br * 0.5f) * this.getCustomSpeed());
            forward = (float)((double)passenger.field_70701_bs * this.getCustomSpeed());
        }
        if (this.jumpPending && this.isFlyer()) {
            this.field_70181_x += this.flyerThrust();
            this.jumpPending = false;
            if (flySelfPropelled) {
                float velX = MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f));
                float velZ = MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f));
                this.field_70159_w += (double)(-0.5f * velX);
                this.field_70179_y += (double)(0.5f * velZ);
            }
        } else if (this.jumpPending && !this.getIsJumping()) {
            this.field_70181_x = this.getCustomJump() * 2.0;
            this.setIsJumping(true);
            this.jumpPending = false;
        }
        if (this.divePending) {
            this.divePending = false;
            this.field_70181_x -= 0.3;
        }
        if (flyingMount) {
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.func_70060_a(strafe, forward, this.flyerFriction() / 10.0f);
            this.field_70181_x *= this.myFallSpeed();
            this.field_70181_x -= 0.055;
            this.field_70179_y *= (double)this.flyerFriction();
            this.field_70159_w *= (double)this.flyerFriction();
        } else {
            this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
            super.func_70612_e(strafe, forward);
        }
        if (this.field_70122_E) {
            this.setIsJumping(false);
            this.divePending = false;
            this.jumpPending = false;
        }
    }

    public void moveEntityWithRiderUntamed(float strafe, float forward, EntityLivingBase passenger) {
        if (this.func_184207_aI() && !this.getIsTamed()) {
            if (this.field_70146_Z.nextInt(5) == 0 && !this.getIsJumping() && this.jumpPending) {
                this.field_70181_x += this.getCustomJump();
                this.setIsJumping(true);
                this.jumpPending = false;
            }
            if (this.field_70146_Z.nextInt(10) == 0) {
                this.field_70159_w += this.field_70146_Z.nextDouble() / 30.0;
                this.field_70179_y += this.field_70146_Z.nextDouble() / 10.0;
            }
            if (MoCreatures.isServer()) {
                this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
            if (MoCreatures.isServer() && this.field_70146_Z.nextInt(50) == 0) {
                passenger.field_70181_x += 0.9;
                passenger.field_70179_y -= 0.3;
                passenger.func_184210_p();
            }
            if (this.field_70122_E) {
                this.setIsJumping(false);
            }
            if (MoCreatures.isServer() && this instanceof IMoCTameable && passenger instanceof EntityPlayer) {
                int chance = this.getMaxTemper() - this.getTemper();
                if (chance <= 0) {
                    chance = 1;
                }
                if (this.field_70146_Z.nextInt(chance * 8) == 0) {
                    MoCTools.tameWithName((EntityPlayer)passenger, (IMoCTameable)((Object)this));
                }
            }
        }
    }

    @Override
    public int maxFlyingHeight() {
        return 5;
    }

    protected double myFallSpeed() {
        return 0.6;
    }

    protected double flyerThrust() {
        return 0.3;
    }

    protected float flyerFriction() {
        return 0.91f;
    }

    protected boolean selfPropelledFlyer() {
        return false;
    }

    @Override
    public void makeEntityJump() {
        this.jumpPending = true;
    }

    @Override
    public boolean isFlyer() {
        return false;
    }

    public int getTemper() {
        return this.temper;
    }

    public void setTemper(int i) {
        this.temper = i;
    }

    public int getMaxTemper() {
        return 100;
    }

    public double getCustomSpeed() {
        return 0.6;
    }

    public double getCustomJump() {
        return 0.4;
    }

    protected SoundEvent getAngrySound() {
        return null;
    }

    public boolean rideableEntity() {
        return false;
    }

    @Override
    public int nameYOffset() {
        return -80;
    }

    protected Entity findPlayerToAttack() {
        return null;
    }

    public void repelMobs(Entity entity1, Double dist, World worldObj) {
        List list = worldObj.func_72839_b(entity1, entity1.func_174813_aQ().func_72314_b(dist.doubleValue(), 4.0, dist.doubleValue()));
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (!(entity instanceof EntityMob)) continue;
            EntityMob entitymob = (EntityMob)entity;
            entitymob.func_70624_b(null);
            entitymob.func_70661_as().func_75499_g();
        }
    }

    public void faceItem(int i, int j, int k, float f) {
        double d = (double)i - this.field_70165_t;
        double d1 = (double)k - this.field_70161_v;
        double d2 = (double)j - this.field_70163_u;
        double d3 = MathHelper.func_76133_a((double)(d * d + d1 * d1));
        float f1 = (float)(Math.atan2(d1, d) * 180.0 / 3.141592741012573) - 90.0f;
        float f2 = (float)(Math.atan2(d2, d3) * 180.0 / 3.141592741012573);
        this.field_70125_A = -this.adjustRotation(this.field_70125_A, f2, f);
        this.field_70177_z = this.adjustRotation(this.field_70177_z, f1, f);
    }

    public float adjustRotation(float f, float f1, float f2) {
        float f3 = f1;
        for (f3 = f1 - f; f3 < -180.0f; f3 += 360.0f) {
        }
        while (f3 >= 180.0f) {
            f3 -= 360.0f;
        }
        if (f3 > f2) {
            f3 = f2;
        }
        if (f3 < -f2) {
            f3 = -f2;
        }
        return f + f3;
    }

    public boolean isFlyingAlone() {
        return false;
    }

    @Override
    public void performAnimation(int attackType) {
    }

    public boolean isMyFavoriteFood(ItemStack par1ItemStack) {
        return false;
    }

    private void followPlayer() {
        EntityPlayer entityplayer1 = this.field_70170_p.func_72890_a((Entity)this, 24.0);
        if (entityplayer1 == null) {
            return;
        }
        ItemStack itemstack1 = entityplayer1.field_71071_by.func_70448_g();
        if (itemstack1 != null && this.isMyFavoriteFood(itemstack1)) {
            this.func_70661_as().func_75497_a((Entity)entityplayer1, 1.0);
        }
    }

    @Override
    public void makeEntityDive() {
        this.divePending = true;
    }

    public boolean isOnAir() {
        return this.field_70170_p.func_175623_d(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 0.2)), MathHelper.func_76128_c((double)this.field_70161_v))) && this.field_70170_p.func_175623_d(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 1.2)), MathHelper.func_76128_c((double)this.field_70161_v)));
    }

    @Override
    public float getSizeFactor() {
        return 1.0f;
    }

    @Override
    public float getAdjustedYOffset() {
        return 0.0f;
    }

    public void func_70645_a(DamageSource damagesource) {
        if (MoCreatures.isServer()) {
            this.dropMyStuff();
        }
        super.func_70645_a(damagesource);
    }

    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (this.isNotScared()) {
            EntityLivingBase tempEntity = this.func_70638_az();
            boolean flag = super.func_70097_a(damagesource, i);
            this.func_70624_b(tempEntity);
            return flag;
        }
        return super.func_70097_a(damagesource, i);
    }

    public boolean getIsRideable() {
        return false;
    }

    public void setRideable(boolean b) {
    }

    @Override
    public void setArmorType(int i) {
    }

    public int getArmorType() {
        return 0;
    }

    public void dropArmor() {
    }

    @Override
    public float pitchRotationOffset() {
        return 0.0f;
    }

    @Override
    public float rollRotationOffset() {
        return 0.0f;
    }

    @Override
    public float yawRotationOffset() {
        return 0.0f;
    }

    @Override
    public float getAdjustedZOffset() {
        return 0.0f;
    }

    @Override
    public float getAdjustedXOffset() {
        return 0.0f;
    }

    protected boolean canBeTrappedInNet() {
        return this instanceof IMoCTameable && this.getIsTamed();
    }

    @Override
    public boolean canAttackTarget(EntityLivingBase entity) {
        return this.field_70131_O >= entity.field_70131_O && this.field_70130_N >= entity.field_70130_N;
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    public boolean isReadyToHunt() {
        return false;
    }

    public boolean func_184652_a(EntityPlayer player) {
        return false;
    }

    @Override
    public boolean getIsSitting() {
        return false;
    }

    @Override
    public boolean isMovementCeased() {
        return this.getIsSitting() || this.func_184207_aI();
    }

    public boolean getIsHunting() {
        return this.huntingCounter != 0;
    }

    public void setIsHunting(boolean flag) {
        this.huntingCounter = flag ? this.field_70146_Z.nextInt(30) + 1 : 0;
    }

    @Override
    public boolean shouldAttackPlayers() {
        return !this.getIsTamed() && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    public void func_70074_a(EntityLivingBase entityLivingIn) {
        if (!(entityLivingIn instanceof EntityPlayer)) {
            MoCTools.destroyDrops((Entity)this, 3.0);
        }
    }

    public PathNavigate func_70661_as() {
        if (this.func_70090_H() && this.isAmphibian()) {
            return this.navigatorWater;
        }
        if (this.isFlyer() && this.getIsFlying()) {
            return this.navigatorFlyer;
        }
        return this.field_70699_by;
    }

    public boolean isAmphibian() {
        return false;
    }

    @Override
    public boolean isDiving() {
        return false;
    }

    @Override
    public double getDivingDepth() {
        return (float)this.divingDepth;
    }

    protected void setNewDivingDepth(double setDepth) {
        if (setDepth != 0.0) {
            if (setDepth > this.maxDivingDepth()) {
                setDepth = this.maxDivingDepth();
            }
            if (setDepth < this.minDivingDepth()) {
                setDepth = this.minDivingDepth();
            }
            this.divingDepth = setDepth;
        } else {
            this.divingDepth = (float)(this.field_70146_Z.nextDouble() * (this.maxDivingDepth() - this.minDivingDepth()) + this.minDivingDepth());
        }
    }

    protected void setNewDivingDepth() {
        this.setNewDivingDepth(0.0);
    }

    protected double minDivingDepth() {
        return 0.2;
    }

    protected double maxDivingDepth() {
        return 1.0;
    }

    @Override
    public void forceEntityJump() {
        this.func_70664_aZ();
    }

    @Override
    public int minFlyingHeight() {
        return 1;
    }

    @Override
    public boolean getIsFlying() {
        return false;
    }

    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        return type == EnumCreatureType.CREATURE;
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean canRidePlayer() {
        return false;
    }
}

