/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.IMoCEntity;
import drzhark.mocreatures.entity.IMoCTameable;
import drzhark.mocreatures.entity.MoCEntityAnimal;
import drzhark.mocreatures.entity.ai.PathNavigateFlyer;
import drzhark.mocreatures.entity.item.MoCEntityEgg;
import drzhark.mocreatures.entity.item.MoCEntityKittyBed;
import drzhark.mocreatures.entity.item.MoCEntityLitterBox;
import drzhark.mocreatures.entity.passive.MoCEntityHorse;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class MoCEntityAmbient
extends EntityAnimal
implements IMoCEntity {
    protected static final DataParameter<Boolean> ADULT = EntityDataManager.func_187226_a(MoCEntityAmbient.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(MoCEntityAmbient.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> AGE = EntityDataManager.func_187226_a(MoCEntityAmbient.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<String> NAME_STR = EntityDataManager.func_187226_a(MoCEntityAmbient.class, (DataSerializer)DataSerializers.field_187194_d);
    protected String texture;
    protected boolean riderIsDisconnecting;
    protected PathNavigate navigatorFlyer;

    public MoCEntityAmbient(World world) {
        super(world);
        this.navigatorFlyer = new PathNavigateFlyer((EntityLiving)this, world);
    }

    @Override
    public ResourceLocation getTexture() {
        return MoCreatures.proxy.getTexture(this.texture);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData par1EntityLivingData) {
        this.selectType();
        return super.func_180482_a(difficulty, par1EntityLivingData);
    }

    @Override
    public void selectType() {
        this.setType(1);
    }

    public EntityAgeable func_90011_a(EntityAgeable var1) {
        return null;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ADULT, (Object)false);
        this.field_70180_af.func_187214_a(TYPE, (Object)0);
        this.field_70180_af.func_187214_a(AGE, (Object)45);
        this.field_70180_af.func_187214_a(NAME_STR, (Object)"");
    }

    @Override
    public void setType(int i) {
        this.field_70180_af.func_187227_b(TYPE, (Object)i);
    }

    @Override
    public int getType() {
        return (Integer)this.field_70180_af.func_187225_a(TYPE);
    }

    public void setDisplayName(boolean flag) {
    }

    @Override
    public boolean renderName() {
        return MoCreatures.proxy.getDisplayPetName() && this.getPetName() != null && !this.getPetName().equals("") && !this.func_184207_aI() && this.func_184187_bx() == null;
    }

    @Override
    public boolean getIsAdult() {
        return (Boolean)this.field_70180_af.func_187225_a(ADULT);
    }

    @Override
    public void setAdult(boolean flag) {
        this.field_70180_af.func_187227_b(ADULT, (Object)flag);
    }

    @Override
    public String getPetName() {
        return (String)this.field_70180_af.func_187225_a(NAME_STR);
    }

    @Override
    public void setPetName(String name) {
        this.field_70180_af.func_187227_b(NAME_STR, (Object)name);
    }

    @Override
    public int getEdad() {
        return (Integer)this.field_70180_af.func_187225_a(AGE);
    }

    @Override
    public void setEdad(int i) {
        this.field_70180_af.func_187227_b(AGE, (Object)i);
    }

    @Override
    public boolean getIsTamed() {
        return false;
    }

    @Override
    public int getOwnerPetId() {
        return 0;
    }

    @Override
    public void setOwnerPetId(int petId) {
    }

    @Override
    public UUID getOwnerId() {
        return null;
    }

    protected boolean func_70692_ba() {
        if (MoCreatures.proxy.forceDespawns) {
            return !this.getIsTamed();
        }
        return false;
    }

    @Override
    public boolean checkSpawningBiome() {
        return true;
    }

    protected EntityLivingBase getClosestEntityLiving(Entity entity, double d) {
        double d1 = -1.0;
        EntityLivingBase entityliving = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(d, d, d));
        for (int i = 0; i < list.size(); ++i) {
            Entity entity1 = (Entity)list.get(i);
            if (this.entitiesToIgnore(entity1)) continue;
            double d2 = entity1.func_70092_e(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            if (!(d < 0.0) && !(d2 < d * d) || d1 != -1.0 && !(d2 < d1) || !((EntityLivingBase)entity1).func_70685_l(entity)) continue;
            d1 = d2;
            entityliving = (EntityLivingBase)entity1;
        }
        return entityliving;
    }

    public void func_70636_d() {
        if (MoCreatures.isServer()) {
            if (this.isMovementCeased()) {
                this.func_70661_as().func_75499_g();
            }
            this.func_70661_as().func_75501_e();
        }
        super.func_70636_d();
    }

    public boolean swimmerEntity() {
        return false;
    }

    public boolean isSwimming() {
        return this.func_70055_a(Material.field_151586_h);
    }

    public boolean isMyAphrodisiac(Item item1) {
        return false;
    }

    public void dropMyStuff() {
    }

    protected boolean isMyHealFood(ItemStack itemstack) {
        return false;
    }

    public boolean func_70090_H() {
        if (this.swimmerEntity()) {
            return false;
        }
        return super.func_70090_H();
    }

    public boolean func_70648_aU() {
        return this.swimmerEntity();
    }

    public EntityItem getClosestItem(Entity entity, double d, ItemStack item, ItemStack item1) {
        double d1 = -1.0;
        EntityItem entityitem = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(d, d, d));
        for (int k = 0; k < list.size(); ++k) {
            EntityItem entityitem1;
            Entity entity1 = (Entity)list.get(k);
            if (!(entity1 instanceof EntityItem) || (entityitem1 = (EntityItem)entity1).func_92059_d() != item && entityitem1.func_92059_d() != item1) continue;
            double d2 = entityitem1.func_70092_e(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            if (!(d < 0.0) && !(d2 < d * d) || d1 != -1.0 && !(d2 < d1)) continue;
            d1 = d2;
            entityitem = entityitem1;
        }
        return entityitem;
    }

    public EntityItem getClosestEntityItem(Entity entity, double d) {
        double d1 = -1.0;
        EntityItem entityitem = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(d, d, d));
        for (int k = 0; k < list.size(); ++k) {
            Entity entity1 = (Entity)list.get(k);
            if (!(entity1 instanceof EntityItem)) continue;
            EntityItem entityitem1 = (EntityItem)entity1;
            double d2 = entityitem1.func_70092_e(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            if (!(d < 0.0) && !(d2 < d * d) || d1 != -1.0 && !(d2 < d1)) continue;
            d1 = d2;
            entityitem = entityitem1;
        }
        return entityitem;
    }

    public void faceLocation(int i, int j, int k, float f) {
        double var4 = (double)i + 0.5 - this.field_70165_t;
        double var8 = (double)k + 0.5 - this.field_70161_v;
        double var6 = (double)j + 0.5 - this.field_70163_u;
        double var14 = MathHelper.func_76133_a((double)(var4 * var4 + var8 * var8));
        float var12 = (float)(Math.atan2(var8, var4) * 180.0 / Math.PI) - 90.0f;
        float var13 = (float)(-(Math.atan2(var6, var14) * 180.0 / Math.PI));
        this.field_70125_A = -this.updateRotation(this.field_70125_A, var13, f);
        this.field_70177_z = this.updateRotation(this.field_70177_z, var12, f);
    }

    private float updateRotation(float par1, float par2, float par3) {
        float var4;
        for (var4 = par2 - par1; var4 < -180.0f; var4 += 360.0f) {
        }
        while (var4 >= 180.0f) {
            var4 -= 360.0f;
        }
        if (var4 > par3) {
            var4 = par3;
        }
        if (var4 < -par3) {
            var4 = -par3;
        }
        return par1 + var4;
    }

    public void getMyOwnPath(Entity entity, float f) {
        Path pathentity = this.func_70661_as().func_75494_a(entity);
        if (pathentity != null) {
            this.func_70661_as().func_75484_a(pathentity, 1.0);
        }
    }

    public void Riding() {
        if (this.func_184207_aI() && this.func_184187_bx() instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)this.func_184187_bx();
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(1.0, 0.0, 1.0));
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    float f;
                    Entity entity = (Entity)list.get(i);
                    if (entity.field_70128_L) continue;
                    entity.func_70100_b_(entityplayer);
                    if (entity instanceof EntityMob && (f = this.func_70032_d(entity)) < 2.0f && this.field_70146_Z.nextInt(10) != 0) continue;
                }
            }
            if (entityplayer.func_70093_af() && !this.field_70170_p.field_72995_K) {
                entityplayer.func_184210_p();
            }
        }
    }

    protected void getPathOrWalkableBlock(Entity entity, float f) {
        Path pathentity = this.field_70699_by.func_179680_a(entity.func_180425_c());
        if (pathentity == null && f > 8.0f) {
            int i = MathHelper.func_76128_c((double)entity.field_70165_t) - 2;
            int j = MathHelper.func_76128_c((double)entity.field_70161_v) - 2;
            int k = MathHelper.func_76128_c((double)entity.func_174813_aQ().field_72338_b);
            for (int l = 0; l <= 4; ++l) {
                for (int i1 = 0; i1 <= 4; ++i1) {
                    BlockPos pos = new BlockPos(i, j, k);
                    if (l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || !this.field_70170_p.func_180495_p(pos.func_177982_a(l, -1, i1)).func_185915_l() || this.field_70170_p.func_180495_p(pos.func_177982_a(l, 0, i1)).func_185915_l() || this.field_70170_p.func_180495_p(pos.func_177982_a(l, 1, i1)).func_185915_l()) continue;
                    this.func_70012_b((float)(i + l) + 0.5f, k, (float)(j + i1) + 0.5f, this.field_70177_z, this.field_70125_A);
                    return;
                }
            }
        } else {
            this.field_70699_by.func_75484_a(pathentity, 16.0);
        }
    }

    public boolean getCanSpawnHereAnimal() {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        BlockPos pos = new BlockPos(i, j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b), k = MathHelper.func_76128_c((double)this.field_70161_v));
        return this.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150349_c && this.field_70170_p.func_175699_k(pos) > 8;
    }

    public boolean getCanSpawnHereCreature() {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        return this.func_180484_a(new BlockPos(i, j, k)) >= 0.0f;
    }

    public boolean getCanSpawnHereLiving() {
        return this.field_70170_p.func_72855_b(this.func_174813_aQ()) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).size() == 0 && !this.field_70170_p.func_72953_d(this.func_174813_aQ());
    }

    public boolean getCanSpawnHereAquatic() {
        return this.field_70170_p.func_72855_b(this.func_174813_aQ());
    }

    public boolean func_70601_bi() {
        if (MoCreatures.entityMap.get(this.getClass()).getFrequency() <= 0) {
            return false;
        }
        BlockPos pos = new BlockPos((double)MathHelper.func_76128_c((double)this.field_70165_t), (double)MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b), this.field_70161_v);
        String s = MoCTools.biomeName(this.field_70170_p, pos);
        if (s.equals("Jungle") || s.equals("JungleHills")) {
            return this.getCanSpawnHereJungle();
        }
        return super.func_70601_bi();
    }

    public boolean getCanSpawnHereJungle() {
        if (this.field_70170_p.func_72855_b(this.func_174813_aQ()) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ())) {
            int var1 = MathHelper.func_76128_c((double)this.field_70165_t);
            int var2 = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
            int var3 = MathHelper.func_76128_c((double)this.field_70161_v);
            if (var2 < 63) {
                return false;
            }
            BlockPos pos = new BlockPos(var1, var2, var3);
            IBlockState blockstate = this.field_70170_p.func_180495_p(pos.func_177977_b());
            Block block = blockstate.func_177230_c();
            if (block == Blocks.field_150349_c || block == Blocks.field_150362_t || block.isLeaves(blockstate, (IBlockAccess)this.field_70170_p, pos.func_177977_b())) {
                return true;
            }
        }
        return false;
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound = MoCTools.getEntityData((Entity)this);
        nbttagcompound.func_74757_a("Adult", this.getIsAdult());
        nbttagcompound.func_74768_a("Edad", this.getEdad());
        nbttagcompound.func_74778_a("Name", this.getPetName());
        nbttagcompound.func_74768_a("TypeInt", this.getType());
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        nbttagcompound = MoCTools.getEntityData((Entity)this);
        this.setAdult(nbttagcompound.func_74767_n("Adult"));
        this.setEdad(nbttagcompound.func_74762_e("Edad"));
        this.setPetName(nbttagcompound.func_74779_i("Name"));
        this.setType(nbttagcompound.func_74762_e("TypeInt"));
    }

    public void moveEntityWithHeadingOld(float f, float f1) {
        if (!(this.isFlyer() || this.rideableEntity() && this.func_184207_aI())) {
            super.func_70612_e(f, f1);
            return;
        }
        if (this.func_70072_I()) {
            if (this.func_184207_aI()) {
                this.field_70159_w += this.func_184187_bx().field_70159_w * (this.getCustomSpeed() / 2.0);
                this.field_70179_y += this.func_184187_bx().field_70179_y * (this.getCustomSpeed() / 2.0);
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                }
                this.field_70125_A = this.func_184187_bx().field_70125_A * 0.5f;
                if (this.field_70146_Z.nextInt(20) == 0) {
                    this.field_70177_z = this.func_184187_bx().field_70177_z;
                }
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                if (MoCreatures.isServer() && !this.getIsTamed()) {
                    MoCTools.playCustomSound((Entity)this, this.getAngrySound());
                    this.func_184187_bx().field_70181_x += 0.3;
                    this.func_184187_bx().field_70179_y -= 0.3;
                    this.func_184187_bx().func_184210_p();
                }
            }
            double d = this.field_70163_u;
            if (!this.field_70170_p.field_72995_K) {
                this.func_70060_a(f, f1, 0.02f);
                this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
            this.field_70159_w *= (double)0.8f;
            this.field_70181_x *= (double)0.8f;
            this.field_70179_y *= (double)0.8f;
            this.field_70181_x -= 0.02;
            if (this.field_70123_F && this.func_70038_c(this.field_70159_w, this.field_70181_x + (double)0.6f - this.field_70163_u + d, this.field_70179_y)) {
                this.field_70181_x = 0.300000011920929;
            }
        } else if (this.func_70058_J()) {
            if (this.func_184207_aI()) {
                this.field_70159_w += this.func_184187_bx().field_70159_w * (this.getCustomSpeed() / 2.0);
                this.field_70179_y += this.func_184187_bx().field_70179_y * (this.getCustomSpeed() / 2.0);
                this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70125_A = this.func_184187_bx().field_70125_A * 0.5f;
                if (this.field_70146_Z.nextInt(20) == 0) {
                    this.field_70177_z = this.func_184187_bx().field_70177_z;
                }
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                if (MoCreatures.isServer() && !this.getIsTamed()) {
                    MoCTools.playCustomSound((Entity)this, this.getAngrySound());
                    this.func_184187_bx().field_70181_x += 0.3;
                    this.func_184187_bx().field_70179_y -= 0.3;
                    this.func_184187_bx().func_184210_p();
                }
            }
            double d1 = this.field_70163_u;
            this.func_70060_a(f, f1, 0.02f);
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.5;
            this.field_70181_x *= 0.5;
            this.field_70179_y *= 0.5;
            this.field_70181_x -= 0.02;
            if (this.field_70123_F && this.func_70038_c(this.field_70159_w, this.field_70181_x + (double)0.6f - this.field_70163_u + d1, this.field_70179_y)) {
                this.field_70181_x = 0.300000011920929;
            }
        } else {
            float f2 = 0.91f;
            if (this.field_70122_E) {
                f2 = 0.5460001f;
                Block block = this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c();
                if (block != Blocks.field_150350_a) {
                    f2 = block.field_149765_K * 0.91f;
                }
            }
            float f3 = 0.162771f / (f2 * f2 * f2);
            this.func_70060_a(f, f1, this.field_70122_E ? 0.1f * f3 : 0.02f);
            if (this.func_70617_f_()) {
                this.field_70143_R = 0.0f;
                if (this.field_70181_x < -0.15) {
                    this.field_70181_x = -0.15;
                }
            }
            if (this.func_184207_aI() && !this.getIsTamed()) {
                if (this.field_70146_Z.nextInt(10) == 0) {
                    this.field_70159_w += this.field_70146_Z.nextDouble() / 30.0;
                    this.field_70179_y += this.field_70146_Z.nextDouble() / 10.0;
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                }
                if (MoCreatures.isServer() && this.field_70146_Z.nextInt(50) == 0) {
                    MoCTools.playCustomSound((Entity)this, this.getAngrySound());
                    this.func_184187_bx().field_70181_x += 0.9;
                    this.func_184187_bx().field_70179_y -= 0.3;
                    this.func_184187_bx().func_184210_p();
                }
            }
            if (this.func_184207_aI() && this.getIsTamed()) {
                if (!this.selfPropelledFlyer() || this.selfPropelledFlyer() && !this.isOnAir()) {
                    this.field_70159_w += this.func_184187_bx().field_70159_w * this.getCustomSpeed();
                    this.field_70179_y += this.func_184187_bx().field_70179_y * this.getCustomSpeed();
                }
                if (MoCreatures.isServer()) {
                    this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                }
                this.field_70126_B = this.field_70177_z = this.func_184187_bx().field_70177_z;
                this.field_70125_A = this.func_184187_bx().field_70125_A * 0.5f;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
            if (this.isFlyingAlone()) {
                int distY = MoCTools.distanceToFloor((Entity)this);
                if (distY <= this.maxFlyingHeight()) {
                    this.field_70181_x *= (double)f2;
                }
                if (distY <= this.maxFlyingHeight() && (this.field_70123_F || this.field_70146_Z.nextInt(100) == 0)) {
                    this.field_70181_x += 0.1;
                }
                if (distY > this.maxFlyingHeight() || this.field_70146_Z.nextInt(150) == 0) {
                    this.field_70181_x -= 0.1;
                }
                if (this.isOnAir()) {
                    double velX = (double)0.05f * Math.cos(MoCTools.realAngle(this.field_70177_z - 90.0f) / 57.29578f);
                    double velZ = (double)0.05f * Math.sin(MoCTools.realAngle(this.field_70177_z - 90.0f) / 57.29578f);
                    this.field_70159_w -= velX;
                    this.field_70179_y -= velZ;
                }
            }
            if (this.isFlyer() && !this.func_184207_aI() && this.func_70638_az() != null && this.func_70638_az().field_70163_u < this.field_70163_u && this.field_70146_Z.nextInt(30) == 0) {
                this.field_70181_x = -0.25;
            }
            if (this.isFlyer() && this.func_184207_aI() && this.getIsTamed()) {
                this.field_70181_x -= 0.08;
                this.field_70181_x *= this.myFallSpeed();
            } else if (!this.isFlyingAlone()) {
                this.field_70181_x -= 0.08;
                this.field_70181_x *= (double)0.98f;
            }
            if (this.func_184207_aI() && this.isOnAir()) {
                f2 = this.flyerFriction();
            }
            this.field_70159_w *= (double)f2;
            this.field_70179_y *= (double)f2;
        }
        this.field_184618_aE = this.field_70721_aZ;
        double d2 = this.field_70165_t - this.field_70169_q;
        double d3 = this.field_70161_v - this.field_70166_s;
        float f4 = MathHelper.func_76133_a((double)(d2 * d2 + d3 * d3)) * 4.0f;
        if (f4 > 1.0f) {
            f4 = 1.0f;
        }
        this.field_70721_aZ += (f4 - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    protected double myFallSpeed() {
        return 0.6;
    }

    protected double flyerThrust() {
        return 0.3;
    }

    protected float flyerFriction() {
        return 0.91f;
    }

    protected boolean selfPropelledFlyer() {
        return false;
    }

    @Override
    public void makeEntityJump() {
    }

    @Override
    public boolean isFlyer() {
        return false;
    }

    public int getMaxTemper() {
        return 100;
    }

    public double getCustomSpeed() {
        return 0.8;
    }

    public double getCustomJump() {
        return 0.4;
    }

    protected SoundEvent getAngrySound() {
        return null;
    }

    @Override
    public void makeEntityDive() {
    }

    public boolean rideableEntity() {
        return false;
    }

    @Override
    public int nameYOffset() {
        return -80;
    }

    protected Entity findPlayerToAttack() {
        return null;
    }

    public void repelMobs(Entity entity1, Double dist, World worldObj) {
        List list = worldObj.func_72839_b(entity1, entity1.func_174813_aQ().func_72314_b(dist.doubleValue(), 4.0, dist.doubleValue()));
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (!(entity instanceof EntityMob)) continue;
            EntityMob entitymob = (EntityMob)entity;
            entitymob.func_70624_b(null);
            entitymob.func_70661_as().func_75499_g();
        }
    }

    public void faceItem(int i, int j, int k, float f) {
        double d = (double)i - this.field_70165_t;
        double d1 = (double)k - this.field_70161_v;
        double d2 = (double)j - this.field_70163_u;
        double d3 = MathHelper.func_76133_a((double)(d * d + d1 * d1));
        float f1 = (float)(Math.atan2(d1, d) * 180.0 / 3.141592741012573) - 90.0f;
        float f2 = (float)(Math.atan2(d2, d3) * 180.0 / 3.141592741012573);
        this.field_70125_A = -this.adjustRotation(this.field_70125_A, f2, f);
        this.field_70177_z = this.adjustRotation(this.field_70177_z, f1, f);
    }

    public float adjustRotation(float f, float f1, float f2) {
        float f3 = f1;
        for (f3 = f1 - f; f3 < -180.0f; f3 += 360.0f) {
        }
        while (f3 >= 180.0f) {
            f3 -= 360.0f;
        }
        if (f3 > f2) {
            f3 = f2;
        }
        if (f3 < -f2) {
            f3 = -f2;
        }
        return f + f3;
    }

    public boolean isFlyingAlone() {
        return false;
    }

    public float getMoveSpeed() {
        return 0.7f;
    }

    @Override
    public void performAnimation(int attackType) {
    }

    public boolean isMyFavoriteFood(ItemStack par1ItemStack) {
        return false;
    }

    private void followPlayer() {
        EntityPlayer entityplayer1 = this.field_70170_p.func_72890_a((Entity)this, 24.0);
        if (entityplayer1 == null) {
            return;
        }
        ItemStack itemstack1 = entityplayer1.field_71071_by.func_70448_g();
        if (itemstack1 != null && this.isMyFavoriteFood(itemstack1)) {
            this.func_70661_as().func_75497_a((Entity)entityplayer1, 1.0);
        }
    }

    public boolean isOnAir() {
        return this.field_70170_p.func_175623_d(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 0.2)), MathHelper.func_76128_c((double)this.field_70161_v))) && this.field_70170_p.func_175623_d(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 1.2)), MathHelper.func_76128_c((double)this.field_70161_v)));
    }

    @Override
    public float getSizeFactor() {
        return 1.0f;
    }

    @Override
    public float getAdjustedYOffset() {
        return 0.0f;
    }

    public boolean getIsRideable() {
        return false;
    }

    public void setRideable(boolean b) {
    }

    public boolean entitiesToIgnore(Entity entity) {
        return !(entity instanceof EntityLiving) || entity instanceof EntityMob || entity instanceof EntityPlayer && this.getIsTamed() || entity instanceof MoCEntityKittyBed || entity instanceof MoCEntityLitterBox || this.getIsTamed() && entity instanceof MoCEntityAnimal && ((MoCEntityAnimal)entity).getIsTamed() || entity instanceof EntityWolf && !MoCreatures.proxy.attackWolves || entity instanceof MoCEntityHorse && !MoCreatures.proxy.attackHorses || entity.field_70130_N > this.field_70130_N && entity.field_70131_O > this.field_70131_O || entity instanceof MoCEntityEgg;
    }

    @Override
    public void setArmorType(int i) {
    }

    protected EntityLivingBase getBoogey(double d) {
        EntityLivingBase entityliving = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(d, 4.0, d));
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (!this.entitiesToInclude(entity)) continue;
            entityliving = (EntityLivingBase)entity;
        }
        return entityliving;
    }

    public boolean entitiesToInclude(Entity entity) {
        return entity instanceof EntityLivingBase && ((double)entity.field_70130_N >= 0.5 || (double)entity.field_70131_O >= 0.5);
    }

    @Override
    public float pitchRotationOffset() {
        return 0.0f;
    }

    @Override
    public float rollRotationOffset() {
        return 0.0f;
    }

    @Override
    public float yawRotationOffset() {
        return 0.0f;
    }

    @Override
    public float getAdjustedZOffset() {
        return 0.0f;
    }

    @Override
    public float getAdjustedXOffset() {
        return 0.0f;
    }

    protected boolean canBeTrappedInNet() {
        return this instanceof IMoCTameable && this.getIsTamed();
    }

    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        return type == EnumCreatureType.AMBIENT;
    }

    @Override
    public boolean canAttackTarget(EntityLivingBase entity) {
        return false;
    }

    public boolean func_184652_a(EntityPlayer player) {
        return false;
    }

    @Override
    public boolean getIsSitting() {
        return false;
    }

    @Override
    public boolean isNotScared() {
        return false;
    }

    @Override
    public boolean isMovementCeased() {
        return this.getIsSitting();
    }

    @Override
    public boolean shouldAttackPlayers() {
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    @Override
    public double getDivingDepth() {
        return 0.5;
    }

    @Override
    public boolean isDiving() {
        return false;
    }

    @Override
    public void forceEntityJump() {
        this.func_70664_aZ();
    }

    public void func_180430_e(float f, float f1) {
    }

    @Override
    public int minFlyingHeight() {
        return 2;
    }

    @Override
    public int maxFlyingHeight() {
        return 4;
    }

    public void func_70612_e(float strafe, float forward) {
        if (!this.getIsFlying()) {
            super.func_70612_e(strafe, forward);
            return;
        }
        this.moveEntityWithHeadingFlying(strafe, forward);
    }

    public void moveEntityWithHeadingFlying(float strafe, float forward) {
        if (this.func_70613_aW()) {
            this.func_70060_a(strafe, forward, 0.1f);
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.9f;
            this.field_70181_x *= (double)0.9f;
            this.field_70179_y *= (double)0.9f;
        } else {
            super.func_70612_e(strafe, forward);
        }
    }

    @Override
    public boolean getIsFlying() {
        return false;
    }
}

