/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.command;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.entity.MoCEntityTameableAnimal;
import drzhark.mocreatures.entity.passive.MoCEntityHorse;
import drzhark.mocreatures.entity.passive.MoCEntityWyvern;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAppear;
import drzhark.mocreatures.util.MoCSoundEvents;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CommandMoCSpawn
extends CommandBase {
    private static List<String> commands = new ArrayList<String>();
    private static List<String> aliases = new ArrayList<String>();

    public String func_71517_b() {
        return "mocspawn";
    }

    public List<String> func_71514_a() {
        return aliases;
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender par1ICommandSender) {
        return "commands.mocspawn.usage";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        if (args.length == 2) {
            String entityType = args[0];
            int type = 0;
            try {
                type = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.RED + "ERROR:" + TextFormatting.WHITE + "The spawn type " + type + " for " + entityType + " is not a valid type.", new Object[0]));
                return;
            }
            String playername = sender.func_70005_c_();
            EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(playername);
            MoCEntityTameableAnimal specialEntity = null;
            if (entityType.equalsIgnoreCase("horse")) {
                specialEntity = new MoCEntityHorse(player.field_70170_p);
                specialEntity.setAdult(true);
            } else if (entityType.equalsIgnoreCase("wyvern")) {
                specialEntity = new MoCEntityWyvern(player.field_70170_p);
                specialEntity.setAdult(false);
            } else if (entityType.equalsIgnoreCase("wyvernghost")) {
                specialEntity = new MoCEntityWyvern(player.field_70170_p);
                specialEntity.setAdult(false);
                ((MoCEntityWyvern)specialEntity).setIsGhost(true);
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.RED + "ERROR:" + TextFormatting.WHITE + "The entity spawn type " + entityType + " is not a valid type.", new Object[0]));
                return;
            }
            double dist = 3.0;
            double newPosY = player.field_70163_u;
            double newPosX = player.field_70165_t - dist * Math.cos(MoCTools.realAngle(player.field_70177_z - 90.0f) / 57.29578f);
            double newPosZ = player.field_70161_v - dist * Math.sin(MoCTools.realAngle(player.field_70177_z - 90.0f) / 57.29578f);
            specialEntity.func_70107_b(newPosX, newPosY, newPosZ);
            specialEntity.setTamed(true);
            specialEntity.setOwnerId(null);
            specialEntity.setPetName("Rename_Me");
            specialEntity.setType(type);
            if (entityType.equalsIgnoreCase("horse") && (type < 1 || type > 67) || entityType.equalsIgnoreCase("wyvern") && (type < 1 || type > 12)) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.RED + "ERROR:" + TextFormatting.WHITE + "The spawn type " + type + " is not a valid type.", new Object[0]));
                return;
            }
            player.field_70170_p.func_72838_d((Entity)specialEntity);
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAppear(specialEntity.func_145782_y()), new NetworkRegistry.TargetPoint(player.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), player.field_70165_t, player.field_70163_u, player.field_70161_v, 64.0));
            MoCTools.playCustomSound((Entity)specialEntity, MoCSoundEvents.ENTITY_GENERIC_MAGIC_APPEAR);
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.RED + "ERROR:" + TextFormatting.WHITE + "Invalid spawn parameters entered.", new Object[0]));
        }
    }

    protected List<String> getSortedPossibleCommands(ICommandSender par1ICommandSender) {
        Collections.sort(commands);
        return commands;
    }

    public void sendCommandHelp(ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("\u00a72Listing MoCreatures commands", new Object[0]));
        for (int i = 0; i < commands.size(); ++i) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation(commands.get(i), new Object[0]));
        }
    }

    static {
        commands.add("/mocspawn <horse|wyvern> <int>");
        aliases.add("mocspawn");
    }
}

