/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures;

import com.mojang.authlib.GameProfile;
import drzhark.mocreatures.MoCEntityData;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.IMoCEntity;
import drzhark.mocreatures.entity.IMoCTameable;
import drzhark.mocreatures.entity.MoCEntityAnimal;
import drzhark.mocreatures.entity.MoCEntityTameableAnimal;
import drzhark.mocreatures.entity.ambient.MoCEntityMaggot;
import drzhark.mocreatures.entity.item.MoCEntityThrowableRock;
import drzhark.mocreatures.entity.monster.MoCEntityOgre;
import drzhark.mocreatures.entity.monster.MoCEntitySilverSkeleton;
import drzhark.mocreatures.entity.passive.MoCEntityHorse;
import drzhark.mocreatures.entity.passive.MoCEntityLeoger;
import drzhark.mocreatures.entity.passive.MoCEntityLiard;
import drzhark.mocreatures.entity.passive.MoCEntityLiger;
import drzhark.mocreatures.entity.passive.MoCEntityLither;
import drzhark.mocreatures.entity.passive.MoCEntityManticorePet;
import drzhark.mocreatures.entity.passive.MoCEntityPanthard;
import drzhark.mocreatures.entity.passive.MoCEntityPanthger;
import drzhark.mocreatures.entity.passive.MoCEntityPetScorpion;
import drzhark.mocreatures.inventory.MoCAnimalChest;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageNameGUI;
import drzhark.mocreatures.util.MoCLog;
import drzhark.mocreatures.util.MoCSoundEvents;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockJukebox;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.Path;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

public class MoCTools {
    public static void spawnSlimes(World worldObj, Entity entity) {
        if (MoCreatures.isServer()) {
            int var2 = 1 + worldObj.field_73012_v.nextInt(1);
            for (int i = 0; i < var2; ++i) {
                float var4 = ((float)(i % 2) - 0.5f) * 1.0f / 4.0f;
                float var5 = ((float)(i / 2) - 0.5f) * 1.0f / 4.0f;
                EntitySlime var6 = new EntitySlime(worldObj);
                var6.func_70012_b(entity.field_70165_t + (double)var4, entity.field_70163_u + 0.5, entity.field_70161_v + (double)var5, worldObj.field_73012_v.nextFloat() * 360.0f, 0.0f);
                worldObj.func_72838_d((Entity)var6);
            }
        }
    }

    public static void dropSaddle(MoCEntityAnimal entity, World worldObj) {
        if (!entity.getIsRideable() || !MoCreatures.isServer()) {
            return;
        }
        MoCTools.dropCustomItem((Entity)entity, worldObj, new ItemStack(MoCreatures.horsesaddle, 1));
        entity.setRideable(false);
    }

    public static void dropBags(MoCEntityAnimal entity, World worldObj) {
        if (!MoCreatures.isServer()) {
            return;
        }
        MoCTools.dropCustomItem((Entity)entity, worldObj, new ItemStack((Block)Blocks.field_150486_ae, 1));
    }

    public static void dropCustomItem(Entity entity, World worldObj, ItemStack itemstack) {
        if (!MoCreatures.isServer()) {
            return;
        }
        EntityItem entityitem = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, itemstack);
        float f3 = 0.05f;
        entityitem.field_70159_w = (float)worldObj.field_73012_v.nextGaussian() * f3;
        entityitem.field_70181_x = (float)worldObj.field_73012_v.nextGaussian() * f3 + 0.2f;
        entityitem.field_70179_y = (float)worldObj.field_73012_v.nextGaussian() * f3;
        worldObj.func_72838_d((Entity)entityitem);
    }

    public static void bigsmack(Entity entity, Entity entity1, float force) {
        double d = entity.field_70165_t - entity1.field_70165_t;
        double d1 = entity.field_70161_v - entity1.field_70161_v;
        d1 = entity.field_70161_v - entity1.field_70161_v;
        while (d * d + d1 * d1 < 1.0E-4) {
            d = (Math.random() - Math.random()) * 0.01;
            d1 = (Math.random() - Math.random()) * 0.01;
        }
        float f = MathHelper.func_76133_a((double)(d * d + d1 * d1));
        entity1.field_70159_w /= 2.0;
        entity1.field_70181_x /= 2.0;
        entity1.field_70179_y /= 2.0;
        entity1.field_70159_w -= d / (double)f * (double)force;
        entity1.field_70181_x += (double)force;
        entity1.field_70179_y -= d1 / (double)f * (double)force;
        if (entity1.field_70181_x > (double)force) {
            entity1.field_70181_x = force;
        }
    }

    public static void buckleMobs(EntityLiving entityattacker, Double dist, World worldObj) {
        List list = worldObj.func_72839_b((Entity)entityattacker, entityattacker.func_174813_aQ().func_72314_b(dist.doubleValue(), 2.0, dist.doubleValue()));
        for (int i = 0; i < list.size(); ++i) {
            Entity entitytarget = (Entity)list.get(i);
            if (!(entitytarget instanceof EntityLiving) || entityattacker.func_184207_aI() && entitytarget == entityattacker.func_184187_bx()) continue;
            entitytarget.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)entityattacker), 2.0f);
            MoCTools.bigsmack((Entity)entityattacker, entitytarget, 0.6f);
            MoCTools.playCustomSound((Entity)entityattacker, MoCSoundEvents.ENTITY_GENERIC_TUD);
        }
    }

    public static void buckleMobsNotPlayers(EntityLiving entityattacker, Double dist, World worldObj) {
        List list = worldObj.func_72839_b((Entity)entityattacker, entityattacker.func_174813_aQ().func_72314_b(dist.doubleValue(), 2.0, dist.doubleValue()));
        for (int i = 0; i < list.size(); ++i) {
            Entity entitytarget = (Entity)list.get(i);
            if (!(entitytarget instanceof EntityLiving) || entitytarget instanceof EntityPlayer || entityattacker.func_184207_aI() && entitytarget == entityattacker.func_184187_bx()) continue;
            entitytarget.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)entityattacker), 2.0f);
            MoCTools.bigsmack((Entity)entityattacker, entitytarget, 0.6f);
            MoCTools.playCustomSound((Entity)entityattacker, MoCSoundEvents.ENTITY_GENERIC_TUD);
        }
    }

    public static void spawnNearPlayer(EntityPlayer player, int entityId, int numberToSpawn) {
        WorldServer worldObj = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(player.field_70170_p.field_73011_w.func_186058_p().func_186068_a());
        for (int i = 0; i < numberToSpawn; ++i) {
            EntityLiving entityliving = null;
            try {
                Class<? extends EntityLiving> entityClass = MoCreatures.instaSpawnerMap.get(entityId);
                entityliving = entityClass.getConstructor(World.class).newInstance(worldObj);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (entityliving == null) continue;
            entityliving.func_70012_b(player.field_70165_t - 1.0, player.field_70163_u, player.field_70161_v - 1.0, player.field_70177_z, player.field_70125_A);
            worldObj.func_72838_d((Entity)entityliving);
        }
    }

    public static void spawnNearPlayerbyName(EntityPlayer player, String eName, int numberToSpawn) {
        WorldServer worldObj = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(player.field_70170_p.field_73011_w.func_186058_p().func_186068_a());
        for (int i = 0; i < numberToSpawn; ++i) {
            EntityLiving entityToSpawn = null;
            try {
                MoCEntityData entityData = MoCreatures.mocEntityMap.get(eName);
                Class<? extends EntityLiving> myClass = entityData.getEntityClass();
                entityToSpawn = myClass.getConstructor(World.class).newInstance(worldObj);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (entityToSpawn == null) continue;
            IEntityLivingData entitylivingdata = null;
            entityToSpawn.func_180482_a(player.field_70170_p.func_175649_E(new BlockPos(entityToSpawn)), entitylivingdata);
            entityToSpawn.func_70012_b(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
            worldObj.func_72838_d((Entity)entityToSpawn);
        }
    }

    public static void playCustomSound(Entity entity, SoundEvent customSound) {
        MoCTools.playCustomSound(entity, customSound, 1.0f);
    }

    public static void playCustomSound(Entity entity, SoundEvent customSound, float volume) {
        entity.func_184185_a(customSound, volume, 1.0f + (entity.field_70170_p.field_73012_v.nextFloat() - entity.field_70170_p.field_73012_v.nextFloat()) * 0.2f);
    }

    public static EntityLiving spawnListByNameClass(String eName, World worldObj) {
        EntityLiving entityToSpawn;
        block2: {
            entityToSpawn = null;
            try {
                MoCEntityData entityData = MoCreatures.mocEntityMap.get(eName);
                Class myClass = null;
                myClass = entityData == null && eName.contains("PetScorpion") ? MoCEntityPetScorpion.class : (entityData == null && eName.contains("ManticorePet") ? MoCEntityManticorePet.class : (entityData == null && eName.contains("Liger") ? MoCEntityLiger.class : (entityData == null && eName.contains("Leoger") ? MoCEntityLeoger.class : (entityData == null && eName.contains("Liard") ? MoCEntityLiard.class : (entityData == null && eName.contains("Lither") ? MoCEntityLither.class : (entityData == null && eName.contains("Panthard") ? MoCEntityPanthard.class : (entityData == null && eName.contains("Panthger") ? MoCEntityPanthger.class : entityData.getEntityClass())))))));
                entityToSpawn = (EntityLiving)myClass.getConstructor(World.class).newInstance(worldObj);
            }
            catch (Exception e) {
                if (!MoCreatures.proxy.debug) break block2;
                MoCLog.logger.warn("Unable to find class for entity " + eName + ", " + e);
            }
        }
        return entityToSpawn;
    }

    public static boolean NearMaterialWithDistance(Entity entity, Double double1, Material mat) {
        AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_72314_b(double1.doubleValue(), double1.doubleValue(), double1.doubleValue());
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76128_c((double)(axisalignedbb.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76128_c((double)(axisalignedbb.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)(axisalignedbb.field_72334_f + 1.0));
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    IBlockState blockstate = entity.field_70170_p.func_180495_p(new BlockPos(k1, l1, i2));
                    if (blockstate.func_177230_c() == Blocks.field_150350_a || blockstate.func_185904_a() != mat) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isNearBlockName(Entity entity, Double dist, String blockName) {
        AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_72314_b(dist.doubleValue(), dist / 2.0, dist.doubleValue());
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76128_c((double)(axisalignedbb.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76128_c((double)(axisalignedbb.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)(axisalignedbb.field_72334_f + 1.0));
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    IBlockState blockstate = entity.field_70170_p.func_180495_p(new BlockPos(k1, l1, i2));
                    if (blockstate.func_177230_c() == Blocks.field_150350_a) continue;
                    String nameToCheck = "";
                    nameToCheck = blockstate.func_177230_c().func_149739_a();
                    if (nameToCheck == null || nameToCheck == "" || !nameToCheck.equals(blockName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static BlockJukebox.TileEntityJukebox nearJukeBoxRecord(Entity entity, Double dist) {
        AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_72314_b(dist.doubleValue(), dist / 2.0, dist.doubleValue());
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76128_c((double)(axisalignedbb.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76128_c((double)(axisalignedbb.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)(axisalignedbb.field_72334_f + 1.0));
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    BlockPos pos = new BlockPos(k1, l1, i2);
                    IBlockState blockstate = entity.field_70170_p.func_180495_p(pos);
                    if (entity.field_70170_p.func_175623_d(pos) || !(blockstate.func_177230_c() instanceof BlockJukebox)) continue;
                    BlockJukebox.TileEntityJukebox juky = (BlockJukebox.TileEntityJukebox)entity.field_70170_p.func_175625_s(pos);
                    return juky;
                }
            }
        }
        return null;
    }

    public static void checkForTwistedEntities(World world) {
        for (int l = 0; l < world.field_72996_f.size(); ++l) {
            Entity entity = (Entity)world.field_72996_f.get(l);
            if (!(entity instanceof EntityLivingBase)) continue;
            EntityLivingBase twisted = (EntityLivingBase)entity;
            if (twisted.field_70725_aQ <= 0 || twisted.func_184187_bx() != null || !(twisted.func_110143_aJ() > 0.0f)) continue;
            twisted.field_70725_aQ = 0;
        }
    }

    public static double getSqDistanceTo(Entity entity, double i, double j, double k) {
        double l = entity.field_70165_t - i;
        double i1 = entity.field_70163_u - j;
        double j1 = entity.field_70161_v - k;
        return Math.sqrt(l * l + i1 * i1 + j1 * j1);
    }

    public static int[] ReturnNearestMaterialCoord(Entity entity, Material material, Double double1, Double yOff) {
        double shortestDistance = -1.0;
        double distance = 0.0;
        int x = -9999;
        int y = -1;
        int z = -1;
        AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_72314_b(double1.doubleValue(), yOff.doubleValue(), double1.doubleValue());
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76128_c((double)(axisalignedbb.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76128_c((double)(axisalignedbb.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)(axisalignedbb.field_72334_f + 1.0));
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    BlockPos pos = new BlockPos(k1, l1, i2);
                    IBlockState blockstate = entity.field_70170_p.func_180495_p(pos);
                    if (blockstate.func_177230_c() == Blocks.field_150350_a || blockstate.func_185904_a() != material) continue;
                    distance = MoCTools.getSqDistanceTo(entity, k1, l1, i2);
                    if (shortestDistance == -1.0) {
                        x = k1;
                        y = l1;
                        z = i2;
                        shortestDistance = distance;
                    }
                    if (!(distance < shortestDistance)) continue;
                    x = k1;
                    y = l1;
                    z = i2;
                    shortestDistance = distance;
                }
            }
        }
        x = entity.field_70165_t > (double)x ? (x -= 2) : (x += 2);
        z = entity.field_70161_v > (double)z ? (z -= 2) : (z += 2);
        return new int[]{x, y, z};
    }

    public static int[] ReturnNearestBlockCoord(Entity entity, Block block1, Double dist) {
        double shortestDistance = -1.0;
        double distance = 0.0;
        int x = -9999;
        int y = -1;
        int z = -1;
        AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_72314_b(dist.doubleValue(), dist.doubleValue(), dist.doubleValue());
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76128_c((double)(axisalignedbb.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76128_c((double)(axisalignedbb.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)(axisalignedbb.field_72334_f + 1.0));
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    BlockPos pos = new BlockPos(k1, l1, i2);
                    IBlockState blockstate = entity.field_70170_p.func_180495_p(pos);
                    if (blockstate.func_177230_c() == Blocks.field_150350_a || blockstate.func_177230_c() != block1) continue;
                    distance = MoCTools.getSqDistanceTo(entity, k1, l1, i2);
                    if (shortestDistance == -1.0) {
                        x = k1;
                        y = l1;
                        z = i2;
                        shortestDistance = distance;
                    }
                    if (!(distance < shortestDistance)) continue;
                    x = k1;
                    y = l1;
                    z = i2;
                    shortestDistance = distance;
                }
            }
        }
        x = entity.field_70165_t > (double)x ? (x -= 2) : (x += 2);
        z = entity.field_70161_v > (double)z ? (z -= 2) : (z += 2);
        return new int[]{x, y, z};
    }

    public static void MoveCreatureToXYZ(EntityCreature movingEntity, int x, int y, int z, float f) {
        Path pathentity = movingEntity.func_70661_as().func_75488_a((double)x, (double)y, (double)z);
        if (pathentity != null) {
            movingEntity.func_70661_as().func_75484_a(pathentity, (double)f);
        }
    }

    public static void MoveToWater(EntityCreature entity) {
        int[] ai = MoCTools.ReturnNearestMaterialCoord((Entity)entity, Material.field_151586_h, 20.0, 2.0);
        if (ai[0] > -1000) {
            MoCTools.MoveCreatureToXYZ(entity, ai[0], ai[1], ai[2], 24.0f);
        }
    }

    public static float realAngle(float origAngle) {
        return origAngle % 360.0f;
    }

    public static void SlideEntityToXYZ(Entity entity, int x, int y, int z) {
        if (entity != null) {
            if (entity.field_70163_u < (double)y) {
                entity.field_70181_x += 0.15;
            }
            if (entity.field_70165_t < (double)x) {
                double d = (double)x - entity.field_70165_t;
                if (d > 0.5) {
                    entity.field_70159_w += 0.05;
                }
            } else {
                double d1 = entity.field_70165_t - (double)x;
                if (d1 > 0.5) {
                    entity.field_70159_w -= 0.05;
                }
            }
            if (entity.field_70161_v < (double)z) {
                double d2 = (double)z - entity.field_70161_v;
                if (d2 > 0.5) {
                    entity.field_70179_y += 0.05;
                }
            } else {
                double d3 = entity.field_70161_v - (double)z;
                if (d3 > 0.5) {
                    entity.field_70179_y -= 0.05;
                }
            }
        }
    }

    public static float distanceToSurface(Entity entity) {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)entity.field_70165_t);
        IBlockState blockstate = entity.field_70170_p.func_180495_p(new BlockPos(i, j = MathHelper.func_76128_c((double)entity.field_70163_u), k = MathHelper.func_76128_c((double)entity.field_70161_v)));
        if (blockstate.func_177230_c() != Blocks.field_150350_a && blockstate.func_185904_a() == Material.field_151586_h) {
            for (int x = 1; x < 64; ++x) {
                blockstate = entity.field_70170_p.func_180495_p(new BlockPos(i, j + x, k));
                if (blockstate.func_177230_c() != Blocks.field_150350_a && blockstate.func_185904_a() == Material.field_151586_h) continue;
                return x;
            }
        }
        return 0.0f;
    }

    public static double waterSurfaceAtGivenPosition(double posX, double posY, double posZ, World worldIn) {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)posX);
        IBlockState blockstate = worldIn.func_180495_p(new BlockPos(i, j = MathHelper.func_76128_c((double)posY), k = MathHelper.func_76128_c((double)posZ)));
        if (blockstate.func_177230_c() != Blocks.field_150350_a && blockstate.func_185904_a() == Material.field_151586_h) {
            for (int x = 1; x < 64; ++x) {
                blockstate = worldIn.func_180495_p(new BlockPos(i, j + x, k));
                if (blockstate.func_177230_c() != Blocks.field_150350_a && blockstate.func_185904_a() == Material.field_151586_h) continue;
                return j + x;
            }
        }
        return 0.0;
    }

    public static double waterSurfaceAtGivenEntity(Entity entity) {
        return MoCTools.waterSurfaceAtGivenPosition(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70170_p);
    }

    public static float distanceToSurface(double posX, double posY, double posZ, World worldIn) {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)posX);
        IBlockState blockstate = worldIn.func_180495_p(new BlockPos(i, j = MathHelper.func_76128_c((double)posY), k = MathHelper.func_76128_c((double)posZ)));
        if (blockstate.func_177230_c() != Blocks.field_150350_a && blockstate.func_185904_a() == Material.field_151586_h) {
            for (int x = 1; x < 64; ++x) {
                blockstate = worldIn.func_180495_p(new BlockPos(i, j + x, k));
                if (blockstate.func_177230_c() != Blocks.field_150350_a && blockstate.func_185904_a() == Material.field_151586_h) continue;
                return x;
            }
        }
        return 0.0f;
    }

    public static int distanceToFloor(Entity entity) {
        int i = MathHelper.func_76128_c((double)entity.field_70165_t);
        int j = MathHelper.func_76128_c((double)entity.field_70163_u);
        int k = MathHelper.func_76128_c((double)entity.field_70161_v);
        for (int x = 0; x < 64; ++x) {
            Block block = entity.field_70170_p.func_180495_p(new BlockPos(i, j - x, k)).func_177230_c();
            if (block == Blocks.field_150350_a) continue;
            return x;
        }
        return 0;
    }

    public boolean isInsideOfMaterial(Material material, Entity entity) {
        int k;
        int j;
        double d = entity.field_70163_u + (double)entity.func_70047_e();
        int i = MathHelper.func_76128_c((double)entity.field_70165_t);
        BlockPos pos = new BlockPos(i, j = MathHelper.func_76141_d((float)MathHelper.func_76128_c((double)d)), k = MathHelper.func_76128_c((double)entity.field_70161_v));
        IBlockState blockstate = entity.field_70170_p.func_180495_p(pos);
        if (blockstate.func_177230_c() != Blocks.field_150350_a && blockstate.func_185904_a() == material) {
            float f = BlockLiquid.func_149801_b((int)blockstate.func_177230_c().func_176201_c(blockstate)) - 0.1111111f;
            float f1 = (float)(j + 1) - f;
            return d < (double)f1;
        }
        return false;
    }

    public static void disorientEntity(Entity entity) {
        double rotD = 0.0;
        double motD = 0.0;
        double d = entity.field_70170_p.field_73012_v.nextGaussian();
        double d1 = 0.1 * d;
        motD = 0.2 * d1 + 0.8 * motD;
        entity.field_70159_w += motD;
        entity.field_70179_y += motD;
        double d2 = 0.78 * d;
        rotD = 0.125 * d2 + 0.875 * rotD;
        entity.field_70177_z = (float)((double)entity.field_70177_z + rotD);
        entity.field_70125_A = (float)((double)entity.field_70125_A + rotD);
    }

    public static void slowEntity(Entity entity) {
        entity.field_70159_w *= 0.8;
        entity.field_70179_y *= 0.8;
    }

    public static int colorize(int i) {
        return ~i & 0xF;
    }

    public int countEntities(Class<? extends EntityLiving> class1, World worldObj) {
        int i = 0;
        for (int j = 0; j < worldObj.field_72996_f.size(); ++j) {
            Entity entity = (Entity)worldObj.field_72996_f.get(j);
            if (!class1.isAssignableFrom(entity.getClass())) continue;
            ++i;
        }
        return i;
    }

    public static float distToPlayer(Entity entity) {
        return 0.0f;
    }

    public static String biomeName(World world, BlockPos pos) {
        BiomeProvider biomeProvider = world.func_72959_q();
        if (biomeProvider == null) {
            return null;
        }
        Biome Biome2 = biomeProvider.func_180631_a(pos);
        if (Biome2 == null) {
            return null;
        }
        return Biome2.func_185359_l();
    }

    public static Biome Biomekind(World world, BlockPos pos) {
        BiomeProvider biomeProvider = world.func_72959_q();
        if (biomeProvider == null) {
            return null;
        }
        Biome Biome2 = biomeProvider.func_180631_a(pos);
        if (Biome2 == null) {
            return null;
        }
        return Biome2;
    }

    public static void destroyDrops(Entity entity, double d) {
        if (!MoCreatures.proxy.destroyDrops) {
            return;
        }
        List list = entity.field_70170_p.func_72839_b(entity, entity.func_174813_aQ().func_72314_b(d, d, d));
        for (int i = 0; i < list.size(); ++i) {
            EntityItem entityitem;
            Entity entity1 = (Entity)list.get(i);
            if (!(entity1 instanceof EntityItem) || (entityitem = (EntityItem)entity1) == null || entityitem.func_174872_o() >= 50) continue;
            entityitem.func_70106_y();
        }
    }

    public static void repelMobs(Entity entity1, Double dist, World worldObj) {
        List list = worldObj.func_72839_b(entity1, entity1.func_174813_aQ().func_72314_b(dist.doubleValue(), 4.0, dist.doubleValue()));
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (!(entity instanceof EntityMob)) continue;
            EntityMob entitymob = (EntityMob)entity;
            entitymob.func_70624_b(null);
            entitymob.func_70661_as().func_75499_g();
        }
    }

    public static void dropGoodies(World worldObj, Entity entity) {
        if (!MoCreatures.isServer()) {
            return;
        }
        EntityItem entityitem = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack(Blocks.field_150364_r, 16));
        entityitem.func_174867_a(10);
        worldObj.func_72838_d((Entity)entityitem);
        EntityItem entityitem2 = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack(Items.field_151045_i, 64));
        entityitem2.func_174867_a(10);
        worldObj.func_72838_d((Entity)entityitem2);
        EntityItem entityitem3 = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack(Blocks.field_150423_aK, 6));
        entityitem3.func_174867_a(10);
        worldObj.func_72838_d((Entity)entityitem3);
        EntityItem entityitem4 = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack(Blocks.field_150347_e, 64));
        entityitem4.func_174867_a(10);
        worldObj.func_72838_d((Entity)entityitem4);
        EntityItem entityitem5 = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack(Items.field_151034_e, 24));
        entityitem5.func_174867_a(10);
        worldObj.func_72838_d((Entity)entityitem5);
        EntityItem entityitem6 = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack(Items.field_151116_aA, 64));
        entityitem6.func_174867_a(10);
        worldObj.func_72838_d((Entity)entityitem6);
        EntityItem entityitem7 = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack(MoCreatures.recordshuffle, 6));
        entityitem7.func_174867_a(10);
        worldObj.func_72838_d((Entity)entityitem7);
        EntityItem entityitem8 = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack(Items.field_151042_j, 64));
        entityitem8.func_174867_a(10);
        worldObj.func_72838_d((Entity)entityitem8);
        EntityItem entityitem9 = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack(Items.field_151043_k, 12));
        entityitem9.func_174867_a(10);
        worldObj.func_72838_d((Entity)entityitem9);
        EntityItem entityitem10 = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack(Items.field_151007_F, 32));
        entityitem10.func_174867_a(10);
        worldObj.func_72838_d((Entity)entityitem10);
        EntityItem entityitem12 = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack((Block)Blocks.field_150328_O, 6));
        entityitem12.func_174867_a(10);
        worldObj.func_72838_d((Entity)entityitem12);
        EntityItem entityitem13 = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack(Items.field_151072_bj, 12));
        entityitem13.func_174867_a(10);
        worldObj.func_72838_d((Entity)entityitem13);
        EntityItem entityitem14 = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack(Items.field_151079_bi, 12));
        entityitem14.func_174867_a(10);
        worldObj.func_72838_d((Entity)entityitem14);
        EntityItem entityitem15 = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack(Items.field_151073_bk, 12));
        entityitem15.func_174867_a(10);
        worldObj.func_72838_d((Entity)entityitem15);
        EntityItem entityitem16 = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack(Blocks.field_150368_y, 2));
        entityitem16.func_174867_a(10);
        worldObj.func_72838_d((Entity)entityitem16);
        EntityItem entityitem17 = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack(Items.field_151103_aS, 12));
        entityitem17.func_174867_a(10);
        worldObj.func_72838_d((Entity)entityitem17);
        EntityItem entityitem18 = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack(MoCreatures.unicornhorn, 16));
        entityitem18.func_174867_a(10);
        worldObj.func_72838_d((Entity)entityitem18);
        EntityItem entityitem19 = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack((Block)Blocks.field_150480_ab, 32));
        entityitem19.func_174867_a(10);
        worldObj.func_72838_d((Entity)entityitem19);
        EntityItem entityitem20 = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack(MoCreatures.essencedarkness, 6));
        entityitem20.func_174867_a(10);
        worldObj.func_72838_d((Entity)entityitem20);
        EntityItem entityitem21 = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack(MoCreatures.essenceundead, 6));
        entityitem21.func_174867_a(10);
        worldObj.func_72838_d((Entity)entityitem21);
        EntityItem entityitem22 = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack(MoCreatures.essencefire, 6));
        entityitem22.func_174867_a(10);
        worldObj.func_72838_d((Entity)entityitem22);
        EntityItem entityitem23 = new EntityItem(worldObj, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack(Item.func_150898_a((Block)Blocks.field_150325_L), 6, 15));
        entityitem23.func_174867_a(10);
        worldObj.func_72838_d((Entity)entityitem23);
    }

    public static boolean mobGriefing(World world) {
        return world.func_82736_K().func_82766_b("mobGriefing");
    }

    public static void DestroyBlast(Entity entity, double d, double d1, double d2, float f, boolean flag) {
        EntityPlayer player = entity instanceof EntityPlayer ? (EntityPlayer)entity : null;
        entity.field_70170_p.func_184148_a(player, d, d1, d2, MoCSoundEvents.ENTITY_GENERIC_DESTROY, SoundCategory.HOSTILE, 4.0f, (1.0f + (entity.field_70170_p.field_73012_v.nextFloat() - entity.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        boolean mobGriefing = MoCTools.mobGriefing(entity.field_70170_p);
        HashSet<BlockPos> hashset = new HashSet<BlockPos>();
        float f1 = f;
        int i = 16;
        for (int j = 0; j < i; ++j) {
            for (int l = 0; l < i; ++l) {
                for (int j1 = 0; j1 < i; ++j1) {
                    if (j != 0 && j != i - 1 && l != 0 && l != i - 1 && j1 != 0 && j1 != i - 1) continue;
                    double d3 = (float)j / ((float)i - 1.0f) * 2.0f - 1.0f;
                    double d4 = (float)l / ((float)i - 1.0f) * 2.0f - 1.0f;
                    double d5 = (float)j1 / ((float)i - 1.0f) * 2.0f - 1.0f;
                    double d6 = Math.sqrt(d3 * d3 + d4 * d4 + d5 * d5);
                    d3 /= d6;
                    d4 /= d6;
                    d5 /= d6;
                    double d8 = d;
                    double d10 = d1;
                    double d12 = d2;
                    float f3 = 0.3f;
                    float f4 = 5.0f;
                    for (float f2 = f * (0.7f + entity.field_70170_p.field_73012_v.nextFloat() * 0.6f); !(f2 <= 0.0f); f2 -= f3 * 0.75f) {
                        int i6;
                        int l5;
                        int k5 = MathHelper.func_76128_c((double)d8);
                        BlockPos pos = new BlockPos(k5, l5 = MathHelper.func_76128_c((double)d10), i6 = MathHelper.func_76128_c((double)d12));
                        IBlockState blockstate = entity.field_70170_p.func_180495_p(pos);
                        if (blockstate.func_177230_c() != Blocks.field_150350_a) {
                            f4 = blockstate.func_185887_b(entity.field_70170_p, pos);
                            f2 -= (blockstate.func_177230_c().func_149638_a(entity) + 0.3f) * (f3 / 10.0f);
                        }
                        if (f2 > 0.0f && d10 > entity.field_70163_u && f4 < 3.0f) {
                            hashset.add(pos);
                        }
                        d8 += d3 * (double)f3;
                        d10 += d4 * (double)f3;
                        d12 += d5 * (double)f3;
                    }
                }
            }
        }
        f *= 2.0f;
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            int k = MathHelper.func_76128_c((double)(d - (double)f - 1.0));
            int i1 = MathHelper.func_76128_c((double)(d + (double)f + 1.0));
            int k1 = MathHelper.func_76128_c((double)(d1 - (double)f - 1.0));
            int l1 = MathHelper.func_76128_c((double)(d1 + (double)f + 1.0));
            int i2 = MathHelper.func_76128_c((double)(d2 - (double)f - 1.0));
            int j2 = MathHelper.func_76128_c((double)(d2 + (double)f + 1.0));
            List list = entity.field_70170_p.func_72839_b(entity, new AxisAlignedBB((double)k, (double)k1, (double)i2, (double)i1, (double)l1, (double)j2));
            Vec3d vec3d = new Vec3d(d, d1, d2);
            for (int k2 = 0; k2 < list.size(); ++k2) {
                Entity entity1 = (Entity)list.get(k2);
                double d7 = entity1.func_70011_f(d, d1, d2) / (double)f;
                if (d7 > 1.0) continue;
                double d9 = entity1.field_70165_t - d;
                double d11 = entity1.field_70163_u - d1;
                double d13 = entity1.field_70161_v - d2;
                double d15 = MathHelper.func_76133_a((double)(d9 * d9 + d11 * d11 + d13 * d13));
                d9 /= d15;
                d11 /= d15;
                d13 /= d15;
                double d17 = entity.field_70170_p.func_72842_a(vec3d, entity1.func_174813_aQ());
                double d19 = (1.0 - d7) * d17;
                if (entity1 instanceof MoCEntityOgre) continue;
                entity1.func_70097_a(DamageSource.field_76377_j, (float)((int)((d19 * d19 + d19) / 2.0 * 3.0 * (double)f + 1.0)));
                double d21 = d19;
                entity1.field_70159_w += d9 * d21;
                entity1.field_70181_x += d11 * d21;
                entity1.field_70179_y += d13 * d21;
            }
        }
        f = f1;
        ArrayList<BlockPos> arraylist = new ArrayList<BlockPos>();
        arraylist.addAll(hashset);
        for (int l2 = arraylist.size() - 1; l2 >= 0; --l2) {
            BlockPos chunkposition = (BlockPos)arraylist.get(l2);
            IBlockState blockstate = entity.field_70170_p.func_180495_p(chunkposition);
            for (int j5 = 0; j5 < 5; ++j5) {
                double d14 = (float)chunkposition.func_177958_n() + entity.field_70170_p.field_73012_v.nextFloat();
                double d16 = (float)chunkposition.func_177956_o() + entity.field_70170_p.field_73012_v.nextFloat();
                double d18 = (float)chunkposition.func_177952_p() + entity.field_70170_p.field_73012_v.nextFloat();
                double d20 = d14 - d;
                double d22 = d16 - d1;
                double d23 = d18 - d2;
                double d24 = MathHelper.func_76133_a((double)(d20 * d20 + d22 * d22 + d23 * d23));
                d20 /= d24;
                d22 /= d24;
                d23 /= d24;
                double d25 = 0.5 / (d24 / (double)f + 0.1);
                d25 *= (double)(entity.field_70170_p.field_73012_v.nextFloat() * entity.field_70170_p.field_73012_v.nextFloat() + 0.3f);
                d20 *= (d25 -= 1.0);
                d22 *= d25 - 1.0;
                d23 *= d25;
                if (FMLCommonHandler.instance().getEffectiveSide() != Side.CLIENT) continue;
                entity.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, (d14 + d * 1.0) / 2.0, (d16 + d1 * 1.0) / 2.0, (d18 + d2 * 1.0) / 2.0, d20, d22, d23, new int[0]);
                entity.field_70159_w -= 0.001000000047497451;
                entity.field_70181_x -= 0.001000000047497451;
            }
            if (!mobGriefing || FMLCommonHandler.instance().getEffectiveSide() != Side.SERVER || blockstate.func_177230_c() == Blocks.field_150350_a) continue;
            BlockEvent.BreakEvent event = null;
            if (!entity.field_70170_p.field_72995_K) {
                try {
                    event = new BlockEvent.BreakEvent(entity.field_70170_p, chunkposition, blockstate, (EntityPlayer)FakePlayerFactory.get((WorldServer)DimensionManager.getWorld((int)entity.field_70170_p.field_73011_w.func_186058_p().func_186068_a()), (GameProfile)MoCreatures.MOCFAKEPLAYER));
                }
                catch (Throwable d14) {
                    // empty catch block
                }
            }
            if (event == null || event.isCanceled()) continue;
            blockstate.func_177230_c().func_180653_a(entity.field_70170_p, chunkposition, blockstate, 0.3f, 1);
            entity.field_70170_p.func_175698_g(chunkposition);
            Explosion explosion = new Explosion(entity.field_70170_p, null, (double)chunkposition.func_177958_n(), (double)chunkposition.func_177956_o(), (double)chunkposition.func_177952_p(), 3.0f, false, false);
            blockstate.func_177230_c().func_180652_a(entity.field_70170_p, chunkposition, explosion);
        }
        if (mobGriefing && FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && flag) {
            for (int i3 = arraylist.size() - 1; i3 >= 0; --i3) {
                BlockPos chunkposition1 = (BlockPos)arraylist.get(i3);
                IBlockState blockstate = entity.field_70170_p.func_180495_p(chunkposition1);
                if (blockstate.func_177230_c() != Blocks.field_150350_a || entity.field_70170_p.field_73012_v.nextInt(8) != 0) continue;
                BlockEvent.BreakEvent event = null;
                if (!entity.field_70170_p.field_72995_K) {
                    event = new BlockEvent.BreakEvent(entity.field_70170_p, chunkposition1, blockstate, (EntityPlayer)FakePlayerFactory.get((WorldServer)((WorldServer)entity.field_70170_p), (GameProfile)MoCreatures.MOCFAKEPLAYER));
                }
                if (event == null || event.isCanceled()) continue;
                entity.field_70170_p.func_180501_a(chunkposition1, Blocks.field_150480_ab.func_176223_P(), 3);
            }
        }
    }

    public static int despawnVanillaAnimals(World worldObj) {
        return MoCTools.despawnVanillaAnimals(worldObj, null);
    }

    public static int despawnVanillaAnimals(World worldObj, List[] classList) {
        int count = 0;
        for (int j = 0; j < worldObj.field_72996_f.size(); ++j) {
            Entity entity = (Entity)worldObj.field_72996_f.get(j);
            if (!(entity instanceof EntityLiving) || !(entity instanceof EntityCow) && !(entity instanceof EntitySheep) && !(entity instanceof EntityPig) && !(entity instanceof EntityChicken) && !(entity instanceof EntitySquid) && !(entity instanceof EntityWolf)) continue;
            count += MoCTools.entityDespawnCheck(worldObj, (EntityLiving)entity);
        }
        return count;
    }

    protected static int entityDespawnCheck(World worldObj, EntityLiving entityliving) {
        int count = 0;
        EntityPlayer entityplayer = worldObj.func_72890_a((Entity)entityliving, -1.0);
        if (entityplayer != null) {
            double d = entityplayer.field_70165_t - entityliving.field_70165_t;
            double d1 = entityplayer.field_70163_u - entityliving.field_70163_u;
            double d2 = entityplayer.field_70161_v - entityliving.field_70161_v;
            double d3 = d * d + d1 * d1 + d2 * d2;
            if (d3 > 16384.0) {
                entityliving.func_70106_y();
                ++count;
            }
            if (entityliving.func_70654_ax() > 600 && worldObj.field_73012_v.nextInt(800) == 0) {
                if (d3 < 1024.0) {
                    entityliving.func_70097_a(DamageSource.func_76358_a(null), 0.0f);
                } else {
                    entityliving.func_70106_y();
                    ++count;
                }
            }
        }
        return count;
    }

    public static void updatePlayerArmorEffects(EntityPlayer player) {
        ItemStack[] mystack = new ItemStack[]{player.field_71071_by.field_70460_b[0], player.field_71071_by.field_70460_b[1], player.field_71071_by.field_70460_b[2], player.field_71071_by.field_70460_b[3]};
        if (mystack[0] != null && mystack[0].func_77973_b() == MoCreatures.scorpBootsCave && mystack[1] != null && mystack[1].func_77973_b() == MoCreatures.scorpLegsCave && mystack[2] != null && mystack[2].func_77973_b() == MoCreatures.scorpPlateCave && mystack[3] != null && mystack[3].func_77973_b() == MoCreatures.scorpHelmetCave) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 300, 0));
            return;
        }
        if (mystack[0] != null && mystack[0].func_77973_b() == MoCreatures.scorpBootsNether && mystack[1] != null && mystack[1].func_77973_b() == MoCreatures.scorpLegsNether && mystack[2] != null && mystack[2].func_77973_b() == MoCreatures.scorpPlateNether && mystack[3] != null && mystack[3].func_77973_b() == MoCreatures.scorpHelmetNether) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 300, 0));
            return;
        }
        if (mystack[0] != null && mystack[0].func_77973_b() == MoCreatures.scorpBootsFrost && mystack[1] != null && mystack[1].func_77973_b() == MoCreatures.scorpLegsFrost && mystack[2] != null && mystack[2].func_77973_b() == MoCreatures.scorpPlateFrost && mystack[3] != null && mystack[3].func_77973_b() == MoCreatures.scorpHelmetFrost) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76427_o, 300, 0));
            return;
        }
        if (mystack[0] != null && mystack[0].func_77973_b() == MoCreatures.scorpBootsDirt && mystack[1] != null && mystack[1].func_77973_b() == MoCreatures.scorpLegsDirt && mystack[2] != null && mystack[2].func_77973_b() == MoCreatures.scorpPlateDirt && mystack[3] != null && mystack[3].func_77973_b() == MoCreatures.scorpHelmetDirt) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 70, 0));
            return;
        }
    }

    public static int destroyRandomBlock(Entity entity, double distance) {
        int l = (int)(distance * distance * distance);
        for (int i = 0; i < l; ++i) {
            int x = (int)(entity.field_70165_t + (double)entity.field_70170_p.field_73012_v.nextInt((int)distance) - (double)((int)(distance / 2.0)));
            int y = (int)(entity.field_70163_u + (double)entity.field_70170_p.field_73012_v.nextInt((int)distance) - (double)((int)(distance / 4.0)));
            int z = (int)(entity.field_70161_v + (double)entity.field_70170_p.field_73012_v.nextInt((int)distance) - (double)((int)(distance / 2.0)));
            BlockPos pos = new BlockPos(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z));
            IBlockState blockstate = entity.field_70170_p.func_180495_p(pos.func_177984_a());
            IBlockState blockstate1 = entity.field_70170_p.func_180495_p(pos);
            if (blockstate.func_177230_c() == Blocks.field_150350_a || blockstate1.func_177230_c() != Blocks.field_150350_a) continue;
            if (MoCTools.mobGriefing(entity.field_70170_p)) {
                blockstate1 = entity.field_70170_p.func_180495_p(pos);
                BlockEvent.BreakEvent event = null;
                if (!entity.field_70170_p.field_72995_K) {
                    event = new BlockEvent.BreakEvent(entity.field_70170_p, pos.func_177984_a(), blockstate, (EntityPlayer)FakePlayerFactory.get((WorldServer)((WorldServer)entity.field_70170_p), (GameProfile)MoCreatures.MOCFAKEPLAYER));
                }
                if (event != null && !event.isCanceled()) {
                    entity.field_70170_p.func_175698_g(pos);
                }
            }
            return Block.func_149682_b((Block)blockstate.func_177230_c());
        }
        return 0;
    }

    public static IBlockState destroyRandomBlockWithIBlockState(Entity entity, double distance) {
        int l = (int)(distance * distance * distance);
        for (int i = 0; i < l; ++i) {
            int x = (int)(entity.field_70165_t + (double)entity.field_70170_p.field_73012_v.nextInt((int)distance) - (double)((int)(distance / 2.0)));
            int y = (int)(entity.field_70163_u + (double)entity.field_70170_p.field_73012_v.nextInt((int)distance) - (double)((int)(distance / 2.0)));
            int z = (int)(entity.field_70161_v + (double)entity.field_70170_p.field_73012_v.nextInt((int)distance) - (double)((int)(distance / 2.0)));
            BlockPos pos = new BlockPos(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z));
            IBlockState stateAbove = entity.field_70170_p.func_180495_p(pos.func_177984_a());
            IBlockState stateTarget = entity.field_70170_p.func_180495_p(pos);
            if ((double)pos.func_177956_o() == (double)((int)entity.field_70163_u) - 1.0 && pos.func_177958_n() == (int)Math.floor(entity.field_70165_t) && pos.func_177952_p() == (int)Math.floor(entity.field_70161_v) || stateTarget.func_177230_c() == Blocks.field_150350_a || stateTarget.func_177230_c() == Blocks.field_150355_j || stateTarget.func_177230_c() == Blocks.field_150357_h || stateAbove.func_177230_c() != Blocks.field_150350_a) continue;
            if (MoCTools.mobGriefing(entity.field_70170_p)) {
                BlockEvent.BreakEvent event = null;
                if (!entity.field_70170_p.field_72995_K) {
                    event = new BlockEvent.BreakEvent(entity.field_70170_p, pos, stateTarget, (EntityPlayer)FakePlayerFactory.get((WorldServer)((WorldServer)entity.field_70170_p), (GameProfile)MoCreatures.MOCFAKEPLAYER));
                }
                if (event != null && !event.isCanceled()) {
                    entity.field_70170_p.func_175698_g(pos);
                } else {
                    stateTarget = null;
                }
            }
            if (stateTarget == null) continue;
            return stateTarget;
        }
        return null;
    }

    public static int[] getRandomBlockCoords(Entity entity, double distance) {
        int tempX = -9999;
        int tempY = -1;
        int tempZ = -1;
        int ii = (int)(distance * distance * (distance / 2.0));
        for (int i = 0; i < ii; ++i) {
            int x = (int)(entity.field_70165_t + (double)entity.field_70170_p.field_73012_v.nextInt((int)distance) - (double)((int)(distance / 2.0)));
            int y = (int)(entity.field_70163_u + (double)entity.field_70170_p.field_73012_v.nextInt((int)(distance / 2.0)) - (double)((int)(distance / 4.0)));
            int z = (int)(entity.field_70161_v + (double)entity.field_70170_p.field_73012_v.nextInt((int)distance) - (double)((int)(distance / 2.0)));
            BlockPos pos = new BlockPos(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z));
            IBlockState blockstate1 = entity.field_70170_p.func_180495_p(pos.func_177984_a());
            IBlockState blockstate2 = entity.field_70170_p.func_180495_p(pos);
            IBlockState blockstate3 = entity.field_70170_p.func_180495_p(pos.func_177974_f());
            IBlockState blockstate4 = entity.field_70170_p.func_180495_p(pos.func_177976_e());
            IBlockState blockstate5 = entity.field_70170_p.func_180495_p(pos.func_177977_b());
            IBlockState blockstate6 = entity.field_70170_p.func_180495_p(pos.func_177968_d());
            IBlockState blockstate7 = entity.field_70170_p.func_180495_p(pos.func_177978_c());
            float tX = (float)x - (float)entity.field_70165_t;
            float tY = (float)y - (float)entity.field_70163_u;
            float tZ = (float)z - (float)entity.field_70161_v;
            float spawnDist = tX * tX + tY * tY + tZ * tZ;
            if (!MoCTools.allowedBlock(Block.func_149682_b((Block)blockstate1.func_177230_c())) || !((blockstate2.func_177230_c() == Blocks.field_150350_a || blockstate3.func_177230_c() == Blocks.field_150350_a || blockstate4.func_177230_c() == Blocks.field_150350_a || blockstate5.func_177230_c() == Blocks.field_150350_a || blockstate6.func_177230_c() == Blocks.field_150350_a || blockstate7.func_177230_c() == Blocks.field_150350_a) & spawnDist > 100.0f)) continue;
            tempX = x;
            tempY = y;
            tempZ = z;
            break;
        }
        return new int[]{tempX, tempY, tempZ};
    }

    public static BlockPos getRandomBlockPos(Entity entity, double distance) {
        int tempX = -9999;
        int tempY = -1;
        int tempZ = -1;
        int ii = (int)(distance * distance * (distance / 2.0));
        for (int i = 0; i < ii; ++i) {
            int x = (int)(entity.field_70165_t + (double)entity.field_70170_p.field_73012_v.nextInt((int)distance) - (double)((int)(distance / 2.0)));
            int y = (int)(entity.field_70163_u + (double)entity.field_70170_p.field_73012_v.nextInt((int)(distance / 2.0)) - (double)((int)(distance / 4.0)));
            int z = (int)(entity.field_70161_v + (double)entity.field_70170_p.field_73012_v.nextInt((int)distance) - (double)((int)(distance / 2.0)));
            BlockPos pos = new BlockPos(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z));
            IBlockState blockstate1 = entity.field_70170_p.func_180495_p(pos.func_177984_a());
            IBlockState blockstate2 = entity.field_70170_p.func_180495_p(pos);
            IBlockState blockstate3 = entity.field_70170_p.func_180495_p(pos.func_177974_f());
            IBlockState blockstate4 = entity.field_70170_p.func_180495_p(pos.func_177976_e());
            IBlockState blockstate5 = entity.field_70170_p.func_180495_p(pos.func_177977_b());
            IBlockState blockstate6 = entity.field_70170_p.func_180495_p(pos.func_177968_d());
            IBlockState blockstate7 = entity.field_70170_p.func_180495_p(pos.func_177978_c());
            float tX = (float)x - (float)entity.field_70165_t;
            float tY = (float)y - (float)entity.field_70163_u;
            float tZ = (float)z - (float)entity.field_70161_v;
            float spawnDist = tX * tX + tY * tY + tZ * tZ;
            if (!MoCTools.allowedBlock(Block.func_149682_b((Block)blockstate1.func_177230_c())) || !((blockstate2.func_177230_c() == Blocks.field_150350_a || blockstate3.func_177230_c() == Blocks.field_150350_a || blockstate4.func_177230_c() == Blocks.field_150350_a || blockstate5.func_177230_c() == Blocks.field_150350_a || blockstate6.func_177230_c() == Blocks.field_150350_a || blockstate7.func_177230_c() == Blocks.field_150350_a) & spawnDist > 100.0f)) continue;
            tempX = x;
            tempY = y;
            tempZ = z;
            break;
        }
        return new BlockPos(MathHelper.func_76128_c((double)tempX), MathHelper.func_76128_c((double)tempY), MathHelper.func_76128_c((double)tempZ));
    }

    public static boolean allowedBlock(int ID) {
        return ID != 0 && ID != 7 && ID != 8 && ID != 9 && ID != 10 && ID != 11 && ID != 23 && ID != 37 && ID != 38 && ID != 50 && ID != 51 && ID != 54 && (ID < 63 || ID > 77) && ID != 95 && ID != 90 && ID != 93 && ID != 94 && ID < 134;
    }

    public static boolean tameWithName(EntityPlayer ep, IMoCTameable storedCreature) {
        if (ep == null) {
            return false;
        }
        if (MoCreatures.proxy.enableOwnership) {
            if (storedCreature == null) {
                ep.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.RED + "ERROR:" + TextFormatting.WHITE + "The stored creature is NULL and could not be created. Report to admin.", new Object[0]));
                return false;
            }
            int max = 0;
            max = MoCreatures.proxy.maxTamed;
            if (!MoCreatures.instance.mapData.isExistingPet(ep.func_110124_au(), storedCreature)) {
                int count = MoCTools.numberTamedByPlayer(ep);
                if (MoCTools.isThisPlayerAnOP(ep)) {
                    max = MoCreatures.proxy.maxOPTamed;
                }
                if (count >= max) {
                    String message = "\u00a74" + ep.func_70005_c_() + " can not tame more creatures, limit of " + max + " reached";
                    ep.func_145747_a((ITextComponent)new TextComponentTranslation(message, new Object[0]));
                    return false;
                }
            }
        }
        storedCreature.setOwnerId(ep.func_110124_au());
        MoCMessageHandler.INSTANCE.sendTo((IMessage)new MoCMessageNameGUI(((Entity)storedCreature).func_145782_y()), (EntityPlayerMP)ep);
        storedCreature.setTamed(true);
        if (MoCreatures.instance.mapData != null && storedCreature.getOwnerPetId() == -1) {
            MoCreatures.instance.mapData.updateOwnerPet(storedCreature);
        }
        return true;
    }

    public static int numberTamedByPlayer(EntityPlayer ep) {
        if (MoCreatures.instance.mapData != null && MoCreatures.instance.mapData.getPetData(ep.func_110124_au()) != null) {
            return MoCreatures.instance.mapData.getPetData(ep.func_110124_au()).getTamedList().func_74745_c();
        }
        return 0;
    }

    public static int destroyBlocksInFront(Entity entity, double distance, int strength, int height) {
        if (strength == 0) {
            return 0;
        }
        int count = 0;
        float strengthF = strength;
        double newPosX = entity.field_70165_t - distance * Math.cos(MoCTools.realAngle(entity.field_70177_z - 90.0f) / 57.29578f);
        double newPosZ = entity.field_70161_v - distance * Math.sin(MoCTools.realAngle(entity.field_70177_z - 90.0f) / 57.29578f);
        double newPosY = entity.field_70163_u;
        int x = MathHelper.func_76128_c((double)newPosX);
        int y = MathHelper.func_76128_c((double)newPosY);
        int z = MathHelper.func_76128_c((double)newPosZ);
        for (int i = 0; i < height; ++i) {
            BlockPos pos = new BlockPos(x, y + i, z);
            IBlockState blockstate = entity.field_70170_p.func_180495_p(pos);
            if (blockstate.func_177230_c() == Blocks.field_150350_a || !(blockstate.func_185887_b(entity.field_70170_p, pos) <= strengthF)) continue;
            BlockEvent.BreakEvent event = null;
            if (!entity.field_70170_p.field_72995_K) {
                event = new BlockEvent.BreakEvent(entity.field_70170_p, pos, blockstate, (EntityPlayer)FakePlayerFactory.get((WorldServer)((WorldServer)entity.field_70170_p), (GameProfile)MoCreatures.MOCFAKEPLAYER));
            }
            if (event == null || event.isCanceled()) continue;
            blockstate.func_177230_c().func_180653_a(entity.field_70170_p, pos, blockstate, 0.2f * strengthF, 1);
            entity.field_70170_p.func_175698_g(pos);
            if (entity.field_70170_p.field_73012_v.nextInt(3) != 0) continue;
            MoCTools.playCustomSound(entity, MoCSoundEvents.ENTITY_GOLEM_WALK);
            ++count;
        }
        return count;
    }

    public static void dropInventory(Entity entity, MoCAnimalChest animalchest) {
        if (animalchest == null || !MoCreatures.isServer()) {
            return;
        }
        int i = MathHelper.func_76128_c((double)entity.field_70165_t);
        int j = MathHelper.func_76128_c((double)entity.func_174813_aQ().field_72338_b);
        int k = MathHelper.func_76128_c((double)entity.field_70161_v);
        for (int l = 0; l < animalchest.func_70302_i_(); ++l) {
            ItemStack itemstack = animalchest.func_70301_a(l);
            if (itemstack == null) continue;
            float f = entity.field_70170_p.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float f1 = entity.field_70170_p.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float f2 = entity.field_70170_p.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float f3 = 0.05f;
            EntityItem entityitem = new EntityItem(entity.field_70170_p, (double)((float)i + f), (double)((float)j + f1), (double)((float)k + f2), itemstack);
            entityitem.field_70159_w = (float)entity.field_70170_p.field_73012_v.nextGaussian() * f3;
            entityitem.field_70181_x = (float)entity.field_70170_p.field_73012_v.nextGaussian() * f3 + 0.2f;
            entityitem.field_70179_y = (float)entity.field_70170_p.field_73012_v.nextGaussian() * f3;
            entity.field_70170_p.func_72838_d((Entity)entityitem);
            animalchest.func_70299_a(l, null);
        }
    }

    public static void dropHorseAmulet(MoCEntityTameableAnimal entity) {
        if (MoCreatures.isServer()) {
            ItemStack stack = MoCTools.getProperAmulet(entity);
            if (stack == null) {
                return;
            }
            if (stack.func_77978_p() == null) {
                stack.func_77982_d(new NBTTagCompound());
            }
            NBTTagCompound nbtt = stack.func_77978_p();
            EntityPlayer epOwner = entity.field_70170_p.func_152378_a(entity.func_184753_b());
            try {
                nbtt.func_74768_a("SpawnClass", 21);
                nbtt.func_74776_a("Health", entity.func_110143_aJ());
                nbtt.func_74768_a("Edad", entity.getEdad());
                nbtt.func_74778_a("Name", entity.getPetName());
                nbtt.func_74757_a("Rideable", entity.getIsRideable());
                nbtt.func_74768_a("Armor", entity.getArmorType());
                nbtt.func_74768_a("CreatureType", entity.getType());
                nbtt.func_74757_a("Adult", entity.getIsAdult());
                nbtt.func_74778_a("OwnerName", epOwner != null ? epOwner.func_70005_c_() : "");
                nbtt.func_186854_a("OwnerUUID", entity.func_184753_b());
                nbtt.func_74768_a("PetId", entity.getOwnerPetId());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (epOwner != null && epOwner.field_71071_by.func_70447_i() != -1) {
                epOwner.field_71071_by.func_70441_a(stack);
            } else {
                EntityItem entityitem = new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, stack);
                entityitem.func_174867_a(20);
                entity.field_70170_p.func_72838_d((Entity)entityitem);
            }
        }
    }

    public static void dropAmulet(IMoCEntity entity, int amuletType, EntityPlayer player) {
        if (!((Entity)entity).field_70170_p.field_72995_K) {
            ItemStack stack = new ItemStack(MoCreatures.fishnetfull, 1, 0);
            if (amuletType == 2) {
                stack = new ItemStack(MoCreatures.petamuletfull, 1, 0);
            }
            if (amuletType == 3) {
                stack = new ItemStack(MoCreatures.amuletghostfull, 1, 0);
            }
            if (stack.func_77978_p() == null) {
                stack.func_77982_d(new NBTTagCompound());
            }
            NBTTagCompound nbtt = stack.func_77978_p();
            try {
                String petClass = entity.getClass().getSimpleName().replace("MoCEntity", "");
                if (petClass.equalsIgnoreCase("Horse")) {
                    petClass = "WildHorse";
                } else if (petClass.equalsIgnoreCase("Komodo")) {
                    petClass = "KomodoDragon";
                }
                if (amuletType == 3) {
                    nbtt.func_74768_a("SpawnClass", 100);
                } else {
                    nbtt.func_74778_a("SpawnClass", petClass);
                }
                nbtt.func_186854_a("OwnerUUID", player.func_110124_au());
                nbtt.func_74776_a("Health", ((EntityLiving)entity).func_110143_aJ());
                nbtt.func_74768_a("Edad", entity.getEdad());
                nbtt.func_74778_a("Name", entity.getPetName());
                nbtt.func_74768_a("CreatureType", entity.getType());
                nbtt.func_74757_a("Adult", entity.getIsAdult());
                nbtt.func_74768_a("PetId", entity.getOwnerPetId());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!player.field_71071_by.func_70441_a(stack)) {
                EntityItem entityitem = new EntityItem(((EntityLivingBase)entity).field_70170_p, ((EntityLivingBase)entity).field_70165_t, ((EntityLivingBase)entity).field_70163_u, ((EntityLivingBase)entity).field_70161_v, stack);
                entityitem.func_174867_a(20);
                ((EntityLivingBase)entity).field_70170_p.func_72838_d((Entity)entityitem);
            }
        }
    }

    public static ItemStack getProperAmulet(MoCEntityAnimal entity) {
        if (entity instanceof MoCEntityHorse) {
            if (entity.getType() == 26 || entity.getType() == 27 || entity.getType() == 28) {
                return new ItemStack(MoCreatures.amuletbonefull, 1, 0);
            }
            if (entity.getType() > 47 && entity.getType() < 60) {
                return new ItemStack(MoCreatures.amuletfairyfull, 1, 0);
            }
            if (entity.getType() == 39 || entity.getType() == 40) {
                return new ItemStack(MoCreatures.amuletpegasusfull, 1, 0);
            }
            if (entity.getType() == 21 || entity.getType() == 22) {
                return new ItemStack(MoCreatures.amuletghostfull, 1, 0);
            }
        }
        return null;
    }

    public static ItemStack getProperEmptyAmulet(MoCEntityAnimal entity) {
        if (entity instanceof MoCEntityHorse) {
            if (entity.getType() == 26 || entity.getType() == 27 || entity.getType() == 28) {
                return new ItemStack(MoCreatures.amuletbone, 1, 0);
            }
            if (entity.getType() > 49 && entity.getType() < 60) {
                return new ItemStack(MoCreatures.amuletfairy, 1, 0);
            }
            if (entity.getType() == 39 || entity.getType() == 40) {
                return new ItemStack(MoCreatures.amuletpegasus, 1, 0);
            }
            if (entity.getType() == 21 || entity.getType() == 22) {
                return new ItemStack(MoCreatures.amuletghost, 1, 0);
            }
        }
        return null;
    }

    public static int countPlayersInDimension(WorldServer worldObj, int dimension) {
        int playersInDimension = 0;
        for (int j = 0; j < worldObj.field_73010_i.size(); ++j) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)worldObj.field_73010_i.get(j);
            if (entityplayermp.field_71093_bK != dimension) continue;
            ++playersInDimension;
        }
        return playersInDimension;
    }

    public static boolean isThisPlayerAnOP(EntityPlayer player) {
        if (!MoCreatures.isServer()) {
            return false;
        }
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152596_g(player.func_146103_bH());
    }

    public static void spawnMaggots(World worldObj, Entity entity) {
        if (MoCreatures.isServer()) {
            int var2 = 1 + worldObj.field_73012_v.nextInt(4);
            for (int i = 0; i < var2; ++i) {
                float var4 = ((float)(i % 2) - 0.5f) * 1.0f / 4.0f;
                float var5 = ((float)(i / 2) - 0.5f) * 1.0f / 4.0f;
                MoCEntityMaggot maggot = new MoCEntityMaggot(worldObj);
                maggot.func_70012_b(entity.field_70165_t + (double)var4, entity.field_70163_u + 0.5, entity.field_70161_v + (double)var5, worldObj.field_73012_v.nextFloat() * 360.0f, 0.0f);
                worldObj.func_72838_d((Entity)maggot);
            }
        }
    }

    public static void getPathToEntity(EntityLiving creatureToMove, Entity entityTarget, float f) {
        Path pathentity = creatureToMove.func_70661_as().func_75494_a(entityTarget);
        if (pathentity != null && f < 12.0f) {
            creatureToMove.func_70661_as().func_75484_a(pathentity, 1.0);
        }
    }

    public static void runLikeHell(EntityLiving runningEntity, Entity boogey) {
        double d = runningEntity.field_70165_t - boogey.field_70165_t;
        double d1 = runningEntity.field_70161_v - boogey.field_70161_v;
        double d2 = Math.atan2(d, d1);
        double d3 = runningEntity.field_70165_t + Math.sin(d2 += (double)(runningEntity.field_70170_p.field_73012_v.nextFloat() - runningEntity.field_70170_p.field_73012_v.nextFloat()) * 0.75) * 8.0;
        double d4 = runningEntity.field_70161_v + Math.cos(d2) * 8.0;
        int i = MathHelper.func_76128_c((double)d3);
        int j = MathHelper.func_76128_c((double)runningEntity.func_174813_aQ().field_72338_b);
        int k = MathHelper.func_76128_c((double)d4);
        for (int l = 0; l < 16; ++l) {
            int i1 = i + runningEntity.field_70170_p.field_73012_v.nextInt(4) - runningEntity.field_70170_p.field_73012_v.nextInt(4);
            int j1 = j + runningEntity.field_70170_p.field_73012_v.nextInt(3) - runningEntity.field_70170_p.field_73012_v.nextInt(3);
            int k1 = k + runningEntity.field_70170_p.field_73012_v.nextInt(4) - runningEntity.field_70170_p.field_73012_v.nextInt(4);
            BlockPos pos = new BlockPos(i1, j1, k1);
            if (j1 <= 4 || runningEntity.field_70170_p.func_180495_p(pos).func_177230_c() != Blocks.field_150350_a && runningEntity.field_70170_p.func_180495_p(pos).func_177230_c() != Blocks.field_150433_aE || runningEntity.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150350_a) continue;
            runningEntity.func_70661_as().func_75492_a((double)i1, (double)j1, (double)k1, 1.0);
            break;
        }
    }

    public static boolean findNearPlayerAndPoison(Entity poisoner, boolean needsToBeInWater) {
        EntityPlayer entityplayertarget = poisoner.field_70170_p.func_72890_a(poisoner, 2.0);
        if (entityplayertarget != null && (needsToBeInWater && entityplayertarget.func_70090_H() || !needsToBeInWater) && poisoner.func_70032_d((Entity)entityplayertarget) < 2.0f && !entityplayertarget.field_71075_bZ.field_75102_a && (entityplayertarget.func_184187_bx() == null || !(entityplayertarget.func_184187_bx() instanceof EntityBoat))) {
            MoCreatures.poisonPlayer(entityplayertarget);
            entityplayertarget.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 120, 0));
            return true;
        }
        return false;
    }

    public static boolean isTamed(Entity entity) {
        if (entity instanceof EntityTameable && ((EntityTameable)entity).func_70909_n()) {
            return true;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        entity.func_189511_e(nbt);
        if (nbt != null) {
            if (nbt.func_74764_b("Owner") && !nbt.func_74779_i("Owner").equals("")) {
                return true;
            }
            if (nbt.func_74764_b("Tamed") && nbt.func_74767_n("Tamed")) {
                return true;
            }
        }
        return false;
    }

    public static void ThrowStone(Entity throwerEntity, Entity targetEntity, IBlockState state, double speedMod, double height) {
        MoCTools.ThrowStone(throwerEntity, (int)targetEntity.field_70165_t, (int)targetEntity.field_70163_u, (int)targetEntity.field_70161_v, state, speedMod, height);
    }

    public static void ThrowStone(Entity throwerEntity, int X, int Y, int Z, IBlockState state) {
        MoCTools.ThrowStone(throwerEntity, X, Y, Z, state, 10.0, 0.25);
    }

    public static void ThrowStone(Entity throwerEntity, int X, int Y, int Z, IBlockState state, double speedMod, double height) {
        MoCEntityThrowableRock etrock = new MoCEntityThrowableRock(throwerEntity.field_70170_p, throwerEntity, throwerEntity.field_70165_t, throwerEntity.field_70163_u + 0.5, throwerEntity.field_70161_v);
        throwerEntity.field_70170_p.func_72838_d((Entity)etrock);
        etrock.setState(state);
        etrock.setBehavior(0);
        etrock.field_70159_w = ((double)X - throwerEntity.field_70165_t) / speedMod;
        etrock.field_70181_x = ((double)Y - throwerEntity.field_70163_u) / speedMod + height;
        etrock.field_70179_y = ((double)Z - throwerEntity.field_70161_v) / speedMod;
    }

    public static float getMyMovementSpeed(Entity entity) {
        return MathHelper.func_76133_a((double)(entity.field_70159_w * entity.field_70159_w + entity.field_70179_y * entity.field_70179_y));
    }

    public static EntityItem getClosestFood(Entity entity, double d) {
        double d1 = -1.0;
        EntityItem entityitem = null;
        List list = entity.field_70170_p.func_72839_b(entity, entity.func_174813_aQ().func_72314_b(d, d, d));
        for (int k = 0; k < list.size(); ++k) {
            EntityItem entityitem1;
            Entity entity1 = (Entity)list.get(k);
            if (!(entity1 instanceof EntityItem) || !MoCTools.isItemEdible((entityitem1 = (EntityItem)entity1).func_92059_d().func_77973_b())) continue;
            double d2 = entityitem1.func_70092_e(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            if (!(d < 0.0) && !(d2 < d * d) || d1 != -1.0 && !(d2 < d1)) continue;
            d1 = d2;
            entityitem = entityitem1;
        }
        return entityitem;
    }

    public static boolean isItemEdible(Item item1) {
        return item1 instanceof ItemFood || item1 instanceof ItemSeeds || item1 == Items.field_151015_O || item1 == Items.field_151102_aT || item1 == Items.field_151105_aU || item1 == Items.field_151110_aK;
    }

    public static boolean isItemEdibleforCarnivores(Item item1) {
        return item1 == Items.field_151082_bd || item1 == Items.field_151076_bf || item1 == Items.field_151083_be || item1 == Items.field_151077_bg || item1 == Items.field_179566_aV || item1 == Items.field_179558_bo || item1 == Items.field_179557_bn || item1 == Items.field_151157_am || item1 == Items.field_179561_bm || item1 == Items.field_179559_bp || item1 == Items.field_151115_aP || item1 == Items.field_151147_al;
    }

    public static NBTTagCompound getEntityData(Entity entity) {
        if (!entity.getEntityData().func_74764_b("mocreatures")) {
            entity.getEntityData().func_74782_a("mocreatures", (NBTBase)new NBTTagCompound());
        }
        return entity.getEntityData().func_74775_l("mocreatures");
    }

    public static void findMobRider(Entity mountEntity) {
        List list = mountEntity.field_70170_p.func_72839_b(mountEntity, mountEntity.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0));
        for (int i = 0; i < list.size(); ++i) {
            EntityMob entitymob;
            Entity entity = (Entity)list.get(i);
            if (!(entity instanceof EntityMob) || (entitymob = (EntityMob)entity).func_184187_bx() != null || !(entitymob instanceof EntitySkeleton) && !(entitymob instanceof EntityZombie) && !(entitymob instanceof MoCEntitySilverSkeleton)) continue;
            entitymob.func_184220_m(mountEntity);
            break;
        }
    }

    public static void copyDataFromOld(Entity source, Entity target) {
        NBTTagCompound nbttagcompound = target.func_189511_e(new NBTTagCompound());
        nbttagcompound.func_82580_o("Dimension");
        source.func_70020_e(nbttagcompound);
    }

    public static boolean dismountSneakingPlayer(EntityLiving entity) {
        if (!entity.func_184218_aH()) {
            return false;
        }
        Entity entityRidden = entity.func_184187_bx();
        if (entityRidden instanceof EntityLivingBase && ((EntityLivingBase)entityRidden).func_70093_af()) {
            entity.func_184210_p();
            double dist = -1.5;
            double newPosX = entityRidden.field_70165_t + dist * Math.sin(((EntityLivingBase)entityRidden).field_70761_aq / 57.29578f);
            double newPosZ = entityRidden.field_70161_v - dist * Math.cos(((EntityLivingBase)entityRidden).field_70761_aq / 57.29578f);
            entity.func_70107_b(newPosX, entityRidden.field_70163_u + 2.0, newPosZ);
            MoCTools.playCustomSound((Entity)entity, SoundEvents.field_187665_Y);
            return true;
        }
        return false;
    }
}

