/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures;

import com.google.common.collect.Maps;
import drzhark.mocreatures.MoCPetData;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.IMoCTameable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraftforge.common.DimensionManager;

public class MoCPetMapData
extends WorldSavedData {
    private Map<UUID, MoCPetData> petMap = Maps.newHashMap();

    public MoCPetMapData(String par1Str) {
        super(par1Str);
        this.func_76185_a();
    }

    public MoCPetData getPetData(UUID ownerUniqueId) {
        return this.petMap.get(ownerUniqueId);
    }

    public Map<UUID, MoCPetData> getPetMap() {
        return this.petMap;
    }

    public boolean removeOwnerPet(IMoCTameable pet, int petId) {
        if (this.petMap.get(pet.getOwnerId()) != null && this.petMap.get(pet.getOwnerId()).removePet(petId)) {
            this.func_76185_a();
            pet.setOwnerPetId(-1);
            return true;
        }
        return false;
    }

    public void updateOwnerPet(IMoCTameable pet) {
        this.func_76185_a();
        if (pet.getOwnerPetId() == -1 || this.petMap.get(pet.getOwnerId()) == null) {
            UUID owner = MoCreatures.isServer() ? pet.getOwnerId() : Minecraft.func_71410_x().field_71439_g.func_110124_au();
            MoCPetData petData = null;
            int id = -1;
            if (this.petMap.containsKey(owner)) {
                petData = this.petMap.get(owner);
                id = petData.addPet(pet);
            } else {
                petData = new MoCPetData(pet);
                id = petData.addPet(pet);
                this.petMap.put(owner, petData);
            }
            pet.setOwnerPetId(id);
        } else {
            UUID owner = pet.getOwnerId();
            MoCPetData petData = this.getPetData(owner);
            NBTTagCompound rootNBT = petData.getOwnerRootNBT();
            NBTTagList tag = rootNBT.func_150295_c("TamedList", 10);
            int id = -1;
            id = pet.getOwnerPetId();
            for (int i = 0; i < tag.func_74745_c(); ++i) {
                NBTTagCompound nbt = tag.func_150305_b(i);
                if (nbt.func_74762_e("PetId") != id) continue;
                nbt.func_74782_a("Pos", (NBTBase)this.newDoubleNBTList(((Entity)pet).field_70165_t, ((Entity)pet).field_70163_u, ((Entity)pet).field_70161_v));
                nbt.func_74768_a("ChunkX", ((Entity)pet).field_70176_ah);
                nbt.func_74768_a("ChunkY", ((Entity)pet).field_70162_ai);
                nbt.func_74768_a("ChunkZ", ((Entity)pet).field_70164_aj);
                nbt.func_74768_a("Dimension", ((Entity)pet).field_70170_p.field_73011_w.func_186058_p().func_186068_a());
                nbt.func_74768_a("PetId", pet.getOwnerPetId());
            }
        }
    }

    protected NBTTagList newDoubleNBTList(double ... par1ArrayOfDouble) {
        NBTTagList nbttaglist = new NBTTagList();
        double[] adouble = par1ArrayOfDouble;
        int i = par1ArrayOfDouble.length;
        for (int j = 0; j < i; ++j) {
            double d1 = adouble[j];
            nbttaglist.func_74742_a((NBTBase)new NBTTagDouble(d1));
        }
        return nbttaglist;
    }

    public boolean isExistingPet(UUID owner, IMoCTameable pet) {
        MoCPetData petData = MoCreatures.instance.mapData.getPetData(owner);
        if (petData != null) {
            NBTTagList tag = petData.getTamedList();
            for (int i = 0; i < tag.func_74745_c(); ++i) {
                NBTTagCompound nbt = tag.func_150305_b(i);
                if (nbt.func_74762_e("PetId") != pet.getOwnerPetId()) continue;
                return true;
            }
        }
        return false;
    }

    public void forceSave() {
        ISaveHandler saveHandler;
        if (DimensionManager.getWorld((int)0) != null && (saveHandler = DimensionManager.getWorld((int)0).func_72860_G()) != null) {
            try {
                File file1 = saveHandler.func_75758_b("mocreatures");
                if (file1 != null) {
                    NBTTagCompound nbttagcompound = new NBTTagCompound();
                    this.func_189551_b(nbttagcompound);
                    NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                    nbttagcompound1.func_74782_a("data", (NBTBase)nbttagcompound);
                    FileOutputStream fileoutputstream = new FileOutputStream(file1);
                    CompressedStreamTools.func_74799_a((NBTTagCompound)nbttagcompound1, (OutputStream)fileoutputstream);
                    fileoutputstream.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void func_76184_a(NBTTagCompound par1NBTTagCompound) {
        for (String s : par1NBTTagCompound.func_150296_c()) {
            NBTTagCompound nbt = (NBTTagCompound)par1NBTTagCompound.func_74781_a(s);
            UUID ownerUniqueId = UUID.fromString(s);
            if (this.petMap.containsKey(ownerUniqueId)) continue;
            this.petMap.put(ownerUniqueId, new MoCPetData(nbt, ownerUniqueId));
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound par1NBTTagCompound) {
        for (Map.Entry<UUID, MoCPetData> ownerEntry : this.petMap.entrySet()) {
            try {
                if (this.petMap.entrySet() == null || ownerEntry.getKey() == null) continue;
                par1NBTTagCompound.func_74782_a(ownerEntry.getKey().toString(), (NBTBase)ownerEntry.getValue().getOwnerRootNBT());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return par1NBTTagCompound;
    }
}

