/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.renderer;

import de.matthiasmann.twl.Color;
import java.util.HashMap;

public final class FontParameter {
    static final HashMap<String, Parameter<?>> parameterMap = new HashMap();
    public static final Parameter<Color> COLOR = FontParameter.newParameter("color", Color.WHITE);
    public static final Parameter<Boolean> UNDERLINE = FontParameter.newParameter("underline", false);
    public static final Parameter<Boolean> LINETHROUGH = FontParameter.newParameter("linethrough", false);
    private Object[] values;

    public FontParameter() {
        this.values = new Object[8];
    }

    public FontParameter(FontParameter base) {
        this.values = (Object[])base.values.clone();
    }

    public <T> void put(Parameter<T> param, T value) {
        if (param == null) {
            throw new NullPointerException("type");
        }
        if (value != null && !param.dataClass.isInstance(value)) {
            throw new ClassCastException("value");
        }
        int ordinal = param.ordinal;
        int curLength = this.values.length;
        if (ordinal >= curLength) {
            Object[] tmp = new Object[Math.max(ordinal + 1, curLength * 2)];
            System.arraycopy(this.values, 0, tmp, 0, curLength);
            this.values = tmp;
        }
        this.values[ordinal] = value;
    }

    public <T> T get(Parameter<T> param) {
        Object raw;
        if (param.ordinal < this.values.length && (raw = this.values[param.ordinal]) != null) {
            return param.dataClass.cast(raw);
        }
        return param.defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Parameter[] getRegisteredParameter() {
        HashMap<String, Parameter<?>> hashMap = parameterMap;
        synchronized (hashMap) {
            return parameterMap.values().toArray(new Parameter[parameterMap.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Parameter<?> getParameter(String name) {
        HashMap<String, Parameter<?>> hashMap = parameterMap;
        synchronized (hashMap) {
            return parameterMap.get(name);
        }
    }

    public static <T> Parameter<T> newParameter(String name, T defaultValue) {
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue");
        }
        Class<?> dataClass = defaultValue.getClass();
        return FontParameter.newParameter(name, dataClass, defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Parameter<T> newParameter(String name, Class<T> dataClass, T defaultValue) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (dataClass == null) {
            throw new NullPointerException("dataClass");
        }
        HashMap<String, Parameter<?>> hashMap = parameterMap;
        synchronized (hashMap) {
            Parameter<?> existing = parameterMap.get(name);
            if (existing != null) {
                if (existing.dataClass != dataClass || !FontParameter.equals(existing.defaultValue, defaultValue)) {
                    throw new IllegalStateException("type '" + name + "' already registered but different");
                }
                Parameter<?> type = existing;
                return type;
            }
            Parameter<T> type = new Parameter<T>(name, dataClass, defaultValue, parameterMap.size());
            parameterMap.put(name, type);
            return type;
        }
    }

    private static boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static final class Parameter<T> {
        final String name;
        final Class<T> dataClass;
        final T defaultValue;
        final int ordinal;

        Parameter(String name, Class<T> dataClass, T defaultValue, int ordinal) {
            this.name = name;
            this.dataClass = dataClass;
            this.defaultValue = defaultValue;
            this.ordinal = ordinal;
        }

        public final String getName() {
            return this.name;
        }

        public final Class<T> getDataClass() {
            return this.dataClass;
        }

        public final T getDefaultValue() {
            return this.defaultValue;
        }

        public String toString() {
            return this.ordinal + ":" + this.name + ":" + this.dataClass.getSimpleName();
        }
    }
}

