/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.load.java;

import me.modmuss50.fr.repack.kotlin.Pair;
import me.modmuss50.fr.repack.kotlin._Assertions;
import me.modmuss50.fr.repack.kotlin.collections.CollectionsKt;
import me.modmuss50.fr.repack.kotlin.jvm.internal.DefaultConstructorMarker;
import me.modmuss50.fr.repack.kotlin.jvm.internal.Intrinsics;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.load.java.BuiltinMethodsWithDifferentJvmName;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.load.java.BuiltinMethodsWithSpecialGenericSignature;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.load.java.SpecialBuiltinMembers;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.load.java.descriptors.JavaClassDescriptor;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.load.java.descriptors.JavaMethodDescriptor;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.load.kotlin.JvmType;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.load.kotlin.MethodSignatureMappingKt;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.resolve.ExternalOverridabilityCondition;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import me.modmuss50.fr.repack.org.jetbrains.annotations.NotNull;
import me.modmuss50.fr.repack.org.jetbrains.annotations.Nullable;

public final class JavaIncompatibilityRulesOverridabilityCondition
implements ExternalOverridabilityCondition {
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public ExternalOverridabilityCondition.Result isOverridable(@NotNull CallableDescriptor superDescriptor, @NotNull CallableDescriptor subDescriptor, @Nullable ClassDescriptor subClassDescriptor) {
        Intrinsics.checkParameterIsNotNull(superDescriptor, "superDescriptor");
        Intrinsics.checkParameterIsNotNull(subDescriptor, "subDescriptor");
        if (this.isIncompatibleInAccordanceWithBuiltInOverridabilityRules(superDescriptor, subDescriptor, subClassDescriptor)) {
            return ExternalOverridabilityCondition.Result.INCOMPATIBLE;
        }
        if (Companion.doesJavaOverrideHaveIncompatibleValueParameterKinds(superDescriptor, subDescriptor)) {
            return ExternalOverridabilityCondition.Result.INCOMPATIBLE;
        }
        return ExternalOverridabilityCondition.Result.UNKNOWN;
    }

    private final boolean isIncompatibleInAccordanceWithBuiltInOverridabilityRules(CallableDescriptor superDescriptor, CallableDescriptor subDescriptor, ClassDescriptor subClassDescriptor) {
        if (!(superDescriptor instanceof CallableMemberDescriptor) || !(subDescriptor instanceof FunctionDescriptor) || SpecialBuiltinMembers.isFromBuiltins((CallableMemberDescriptor)subDescriptor)) {
            return false;
        }
        if (!BuiltinMethodsWithSpecialGenericSignature.INSTANCE.getSameAsBuiltinMethodWithErasedValueParameters(((FunctionDescriptor)subDescriptor).getName()) && !BuiltinMethodsWithDifferentJvmName.INSTANCE.getSameAsRenamedInJvmBuiltin(((FunctionDescriptor)subDescriptor).getName())) {
            return false;
        }
        CallableMemberDescriptor overriddenBuiltin = SpecialBuiltinMembers.getOverriddenSpecialBuiltin((CallableMemberDescriptor)superDescriptor);
        Boolean bl = ((FunctionDescriptor)subDescriptor).isHiddenToOvercomeSignatureClash();
        CallableDescriptor callableDescriptor = superDescriptor;
        if (!(callableDescriptor instanceof FunctionDescriptor)) {
            callableDescriptor = null;
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)callableDescriptor;
        boolean isOneOfDescriptorsHidden = Intrinsics.areEqual(bl, functionDescriptor != null ? Boolean.valueOf(functionDescriptor.isHiddenToOvercomeSignatureClash()) : null) ^ true;
        if (isOneOfDescriptorsHidden && (overriddenBuiltin == null || !((FunctionDescriptor)subDescriptor).isHiddenToOvercomeSignatureClash())) {
            return true;
        }
        if (!(subClassDescriptor instanceof JavaClassDescriptor) || ((FunctionDescriptor)subDescriptor).getInitialSignatureDescriptor() != null) {
            return false;
        }
        return overriddenBuiltin != null && !SpecialBuiltinMembers.hasRealKotlinSuperClassWithOverrideOf(subClassDescriptor, overriddenBuiltin);
    }

    @Override
    @NotNull
    public ExternalOverridabilityCondition.Contract getContract() {
        return ExternalOverridabilityCondition.Contract.CONFLICTS_ONLY;
    }

    public static final class Companion {
        public final boolean doesJavaOverrideHaveIncompatibleValueParameterKinds(@NotNull CallableDescriptor superDescriptor, @NotNull CallableDescriptor subDescriptor) {
            Intrinsics.checkParameterIsNotNull(superDescriptor, "superDescriptor");
            Intrinsics.checkParameterIsNotNull(subDescriptor, "subDescriptor");
            if (!(subDescriptor instanceof JavaMethodDescriptor) || !(superDescriptor instanceof FunctionDescriptor)) {
                return false;
            }
            boolean bl = ((JavaMethodDescriptor)subDescriptor).getValueParameters().size() == ((FunctionDescriptor)superDescriptor).getValueParameters().size();
            if (_Assertions.ENABLED && !bl) {
                String string = "External overridability condition with CONFLICTS_ONLY should not be run with different value parameters size";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            Iterable iterable = ((JavaMethodDescriptor)subDescriptor).getOriginal().getValueParameters();
            Iterable iterable2 = ((FunctionDescriptor)superDescriptor).getOriginal().getValueParameters();
            Intrinsics.checkExpressionValueIsNotNull(iterable2, "superDescriptor.original.valueParameters");
            for (Pair pair : CollectionsKt.zip(iterable, iterable2)) {
                ValueParameterDescriptor subParameter = (ValueParameterDescriptor)pair.component1();
                ValueParameterDescriptor superParameter = (ValueParameterDescriptor)pair.component2();
                FunctionDescriptor functionDescriptor = (FunctionDescriptor)subDescriptor;
                ValueParameterDescriptor valueParameterDescriptor = subParameter;
                Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor, "subParameter");
                boolean isSubPrimitive = this.mapValueParameterType(functionDescriptor, valueParameterDescriptor) instanceof JvmType.Primitive;
                FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)superDescriptor;
                ValueParameterDescriptor valueParameterDescriptor2 = superParameter;
                Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor2, "superParameter");
                boolean isSuperPrimitive = this.mapValueParameterType(functionDescriptor2, valueParameterDescriptor2) instanceof JvmType.Primitive;
                if (isSubPrimitive == isSuperPrimitive) continue;
                return true;
            }
            return false;
        }

        private final JvmType mapValueParameterType(FunctionDescriptor f, ValueParameterDescriptor valueParameterDescriptor) {
            return MethodSignatureMappingKt.forceSingleValueParameterBoxing(f) || this.isPrimitiveCompareTo(f) ? MethodSignatureMappingKt.mapToJvmType(TypeUtilsKt.makeNullable(valueParameterDescriptor.getType())) : MethodSignatureMappingKt.mapToJvmType(valueParameterDescriptor.getType());
        }

        private final boolean isPrimitiveCompareTo(FunctionDescriptor f) {
            if (f.getValueParameters().size() != 1) {
                return false;
            }
            DeclarationDescriptor declarationDescriptor = f.getContainingDeclaration();
            if (!(declarationDescriptor instanceof ClassDescriptor)) {
                declarationDescriptor = null;
            }
            ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
            if (classDescriptor == null) {
                return false;
            }
            ClassDescriptor classDescriptor2 = classDescriptor;
            ClassifierDescriptor classifierDescriptor = CollectionsKt.single(f.getValueParameters()).getType().getConstructor().getDeclarationDescriptor();
            if (!(classifierDescriptor instanceof ClassDescriptor)) {
                classifierDescriptor = null;
            }
            ClassDescriptor classDescriptor3 = (ClassDescriptor)classifierDescriptor;
            if (classDescriptor3 == null) {
                return false;
            }
            ClassDescriptor parameterClass = classDescriptor3;
            return KotlinBuiltIns.isPrimitiveClass(classDescriptor2) && Intrinsics.areEqual(DescriptorUtilsKt.getFqNameSafe(classDescriptor2), DescriptorUtilsKt.getFqNameSafe(parameterClass));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

