/*
 * Decompiled with CFR 0.152.
 */
package mca.util;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S2APacketParticles;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class Utilities {
    private Utilities() {
    }

    public static boolean isPointClear(World world, int posX, int posY, int posZ) {
        Block block = world.func_147439_a(posX, posY, posZ);
        return !block.func_149688_o().func_76230_c();
    }

    public static double getNumberInRange(Random rand, float standardDeviation, float mean) {
        return rand.nextGaussian() * (double)standardDeviation + (double)mean;
    }

    public static void spawnParticlesAroundPointS(String name, World world, double posX, double posY, double posZ, int rate) {
        Random rand = world.field_73012_v;
        for (int i = 0; i < rate; ++i) {
            float parX = (float)(posX + (double)(rand.nextFloat() * 1.0f * 2.0f) - 1.0);
            float parY = (float)(posY + 0.5 + (double)(rand.nextFloat() * 1.0f));
            float parZ = (float)(posZ + (double)(rand.nextFloat() * 1.0f * 2.0f) - 1.0);
            float velX = (float)(rand.nextGaussian() * 0.02);
            float velY = (float)(rand.nextGaussian() * 0.02);
            float velZ = (float)(rand.nextGaussian() * 0.02);
            S2APacketParticles packet = new S2APacketParticles(name, parX, parY, parZ, velX, velY, velZ, 0.0f, 0);
            for (int j = 0; j < world.field_73010_i.size(); ++j) {
                EntityPlayerMP entityPlayerMP = (EntityPlayerMP)world.field_73010_i.get(j);
                ChunkCoordinates chunkCoordinates = entityPlayerMP.func_82114_b();
                double deltaX = posX - (double)chunkCoordinates.field_71574_a;
                double deltaY = posY - (double)chunkCoordinates.field_71572_b;
                double deltaZ = posZ - (double)chunkCoordinates.field_71573_c;
                double distanceSq = deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
                if (!(distanceSq <= 256.0)) continue;
                entityPlayerMP.field_71135_a.func_147359_a((Packet)packet);
            }
        }
    }

    public static void spawnParticlesAroundEntityS(String name, Entity entityOrigin, int rate) {
        Random rand = entityOrigin.field_70170_p.field_73012_v;
        for (int i = 0; i < rate; ++i) {
            float parX = (float)(entityOrigin.field_70165_t + (double)(rand.nextFloat() * entityOrigin.field_70130_N * 2.0f) - (double)entityOrigin.field_70130_N);
            float parY = (float)(entityOrigin.field_70163_u + 0.5 + (double)(rand.nextFloat() * entityOrigin.field_70131_O));
            float parZ = (float)(entityOrigin.field_70161_v + (double)(rand.nextFloat() * entityOrigin.field_70130_N * 2.0f) - (double)entityOrigin.field_70130_N);
            float velX = (float)(rand.nextGaussian() * 0.02);
            float velY = (float)(rand.nextGaussian() * 0.02);
            float velZ = (float)(rand.nextGaussian() * 0.02);
            S2APacketParticles packet = new S2APacketParticles(name, parX, parY, parZ, velX, velY, velZ, 0.0f, 0);
            for (int j = 0; j < entityOrigin.field_70170_p.field_73010_i.size(); ++j) {
                EntityPlayerMP entityPlayerMP = (EntityPlayerMP)entityOrigin.field_70170_p.field_73010_i.get(j);
                ChunkCoordinates chunkCoordinates = entityPlayerMP.func_82114_b();
                double deltaX = entityOrigin.field_70165_t - (double)chunkCoordinates.field_71574_a;
                double deltaY = entityOrigin.field_70163_u - (double)chunkCoordinates.field_71572_b;
                double deltaZ = entityOrigin.field_70161_v - (double)chunkCoordinates.field_71573_c;
                double distanceSq = deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
                if (!(distanceSq <= 256.0)) continue;
                entityPlayerMP.field_71135_a.func_147359_a((Packet)packet);
            }
        }
    }

    public static void spawnParticlesAroundEntityC(String name, Entity entityOrigin, int rate) {
        Random rand = entityOrigin.field_70170_p.field_73012_v;
        for (int i = 0; i < rate; ++i) {
            float parX = (float)(entityOrigin.field_70165_t + (double)(rand.nextFloat() * entityOrigin.field_70130_N * 2.0f) - (double)entityOrigin.field_70130_N);
            float parY = (float)(entityOrigin.field_70163_u + 0.5 + (double)(rand.nextFloat() * entityOrigin.field_70131_O));
            float parZ = (float)(entityOrigin.field_70161_v + (double)(rand.nextFloat() * entityOrigin.field_70130_N * 2.0f) - (double)entityOrigin.field_70130_N);
            float velX = (float)(rand.nextGaussian() * 0.02);
            float velY = (float)(rand.nextGaussian() * 0.02);
            float velZ = (float)(rand.nextGaussian() * 0.02);
            entityOrigin.field_70170_p.func_72869_a(name, (double)parX, (double)parY, (double)parZ, (double)velX, (double)velY, (double)velZ);
        }
    }

    public static void setDoorIsOpenAt(World world, int doorX, int doorY, int doorZ, boolean isOpen) {
    }

    public static boolean getDoorIsOpenAt(World world, int doorX, int doorY, int doorZ) {
        try {
            BlockDoor door = (BlockDoor)world.func_147439_a(doorX, doorY, doorZ);
            return !door.func_150015_f((IBlockAccess)world, doorX, doorY, doorZ);
        }
        catch (Exception e) {
            return false;
        }
    }
}

