/*
 * Decompiled with CFR 0.152.
 */
package mca.packets;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import mca.core.MCA;
import mca.tile.TileTombstone;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import radixcore.network.ByteBufIO;
import radixcore.packets.AbstractPacket;
import radixcore.util.BlockHelper;

public class PacketTombstoneUpdateSet
extends AbstractPacket
implements IMessage,
IMessageHandler<PacketTombstoneUpdateSet, IMessage> {
    private int x;
    private int y;
    private int z;
    private String[] text;

    public PacketTombstoneUpdateSet() {
    }

    public PacketTombstoneUpdateSet(TileTombstone tombstone) {
        this.x = tombstone.field_145851_c;
        this.y = tombstone.field_145848_d;
        this.z = tombstone.field_145849_e;
        this.text = tombstone.signText;
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.text = new String[4];
        this.x = byteBuf.readInt();
        this.y = byteBuf.readInt();
        this.z = byteBuf.readInt();
        for (int i = 0; i < 4; ++i) {
            String readText = (String)ByteBufIO.readObject((ByteBuf)byteBuf);
            this.text[i] = readText = readText.equals("@n/a@") ? "" : readText;
        }
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeInt(this.x);
        byteBuf.writeInt(this.y);
        byteBuf.writeInt(this.z);
        for (String s : this.text) {
            if (s == null || s.isEmpty()) {
                s = "@n/a@";
            }
            ByteBufIO.writeObject((ByteBuf)byteBuf, (Object)s);
        }
    }

    public IMessage onMessage(PacketTombstoneUpdateSet packet, MessageContext context) {
        EntityPlayer player = this.getPlayer(context);
        World world = player.field_70170_p;
        try {
            TileTombstone tombstone = (TileTombstone)BlockHelper.getTileEntity((World)world, (int)packet.x, (int)packet.y, (int)packet.z);
            if (tombstone != null) {
                tombstone.signText = packet.text;
            }
            if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
                MCA.getPacketHandler().sendPacketToAllPlayers(packet);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }
}

