/*
 * Decompiled with CFR 0.152.
 */
package mca.ai;

import java.util.List;
import mca.ai.AbstractToggleAI;
import mca.api.FishingEntry;
import mca.api.RegistryMCA;
import mca.core.MCA;
import mca.entity.EntityChoreFishHook;
import mca.entity.EntityHuman;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import radixcore.data.WatchedBoolean;
import radixcore.math.Point3D;
import radixcore.util.RadixLogic;
import radixcore.util.RadixMath;

public class AIFishing
extends AbstractToggleAI {
    private WatchedBoolean isAIActive;
    private EntityChoreFishHook hook;
    private boolean hasWaterPoint;
    private boolean hasFishingTarget;
    private boolean isFishing;
    private int waterCoordinatesX;
    private int waterCoordinatesY;
    private int waterCoordinatesZ;
    private int fishingTicks;
    private int fishCatchCheck;
    private int idleFishingTime;

    public AIFishing(EntityHuman owner) {
        super(owner);
        this.isAIActive = new WatchedBoolean(false, 43, owner.getDataWatcherEx());
    }

    public void startFishing(EntityPlayer player) {
        this.assigningPlayer = player != null ? player.func_110124_au().toString() : "none";
        this.setIsActive(true);
    }

    @Override
    public void setIsActive(boolean value) {
        this.isAIActive.setValue((Object)value);
    }

    @Override
    public boolean getIsActive() {
        return this.isAIActive.getBoolean();
    }

    @Override
    public void onUpdateCommon() {
    }

    @Override
    public void onUpdateClient() {
    }

    @Override
    public void onUpdateServer() {
        if (!MCA.getConfig().allowFishingChore) {
            this.notifyAssigningPlayer("\u00a7CThis chore is disabled.");
            this.reset();
            return;
        }
        try {
            this.doItemVerification();
            if (!this.hasWaterPoint) {
                this.trySetWaterCoordinates();
                return;
            }
            if (!this.canFishingBegin()) {
                this.owner.func_70661_as().func_75484_a(this.owner.func_70661_as().func_75488_a((double)this.waterCoordinatesX, (double)this.waterCoordinatesY, (double)this.waterCoordinatesZ), (double)0.6f);
                return;
            }
            this.owner.func_70661_as().func_75499_g();
            if (this.hasFishingTarget) {
                if (this.idleFishingTime < 20) {
                    this.doFishingIdleUpdate();
                } else {
                    if (this.hook == null || this.hook.field_70128_L) {
                        this.hook = new EntityChoreFishHook(this.owner.field_70170_p, this.owner);
                        this.owner.field_70170_p.func_72838_d((Entity)this.hook);
                        this.owner.func_71038_i();
                    }
                    this.doFaceFishEntity();
                    this.doFishingActiveUpdate();
                }
            } else {
                this.doSetFishingTarget();
            }
        }
        catch (Exception e) {
            this.reset();
        }
    }

    @Override
    public void reset() {
        this.isAIActive.setValue((Object)false);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("isFishingActive", this.isAIActive.getBoolean().booleanValue());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.isAIActive.setValue((Object)nbt.func_74767_n("isFishingActive"));
    }

    @Override
    protected String getName() {
        return "Fishing";
    }

    private boolean trySetWaterCoordinates() {
        Point3D waterCoordinates = RadixLogic.getFirstNearestBlock((Entity)this.owner, (Block)Blocks.field_150355_j, (int)10);
        if (waterCoordinates == null) {
            this.owner.say(MCA.getLanguageManager().getString("fishing.nowater"), this.getAssigningPlayer());
            this.reset();
            return false;
        }
        this.waterCoordinatesX = waterCoordinates.iPosX;
        this.waterCoordinatesY = waterCoordinates.iPosY;
        this.waterCoordinatesZ = waterCoordinates.iPosZ;
        this.hasWaterPoint = true;
        return true;
    }

    private boolean canFishingBegin() {
        return RadixLogic.getFirstNearestBlock((Entity)this.owner, (Block)Blocks.field_150355_j, (int)1) != null;
    }

    private void doSetFishingTarget() {
        List nearbyWater = RadixLogic.getNearbyBlocks((Entity)this.owner, (Block)Blocks.field_150355_j, (int)10);
        Point3D randomNearbyWater = (Point3D)nearbyWater.get(RadixMath.getNumberInRange((int)0, (int)(nearbyWater.size() - 1)));
        this.waterCoordinatesX = randomNearbyWater.iPosX;
        this.waterCoordinatesY = randomNearbyWater.iPosY;
        this.waterCoordinatesZ = randomNearbyWater.iPosZ;
        this.hasFishingTarget = true;
    }

    private void doFishingIdleUpdate() {
        if (this.hook != null) {
            this.hook.func_70106_y();
        }
        this.owner.facePosition(new Point3D(this.waterCoordinatesX, this.waterCoordinatesY, this.waterCoordinatesZ));
        ++this.idleFishingTime;
    }

    private void doGenerateNextCatchCheck() {
        this.fishCatchCheck = this.owner.field_70170_p.field_73012_v.nextInt(200) + 100;
        this.hook = new EntityChoreFishHook(this.owner.field_70170_p, this.owner);
        this.owner.field_70170_p.func_72838_d((Entity)this.hook);
        this.owner.damageHeldItem(1);
        this.owner.func_71038_i();
    }

    public void doFishCatchAttempt() {
        int catchChance = 100;
        if (RadixLogic.getBooleanWithProbability((int)100)) {
            try {
                FishingEntry entry = RegistryMCA.getRandomFishingEntry();
                int amountToAdd = this.getFishAmountToAdd();
                Item fishItem = entry.getFishItem();
                this.owner.getInventory().addItemStackToInventory(new ItemStack(fishItem, amountToAdd, entry.getItemDamage()));
                this.fishCatchCheck = 0;
                this.fishingTicks = 0;
                this.owner.damageHeldItem(1);
                if (this.owner.getInventory().containsCountOf(Items.field_151115_aP, 64)) {
                    this.owner.say(MCA.getLanguageManager().getString("notify.child.chore.finished.fishing"), this.getAssigningPlayer());
                    this.reset();
                    return;
                }
                this.idleFishingTime = 0;
                this.hasFishingTarget = false;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else {
            this.hook = null;
            this.fishCatchCheck = 0;
            this.fishingTicks = 0;
            this.idleFishingTime = 0;
            this.hasFishingTarget = false;
        }
    }

    private void doFishingActiveUpdate() {
        if (this.hook == null || this.hook.field_70128_L) {
            this.fishCatchCheck = 0;
            this.fishingTicks = 0;
            this.idleFishingTime = 0;
            this.trySetWaterCoordinates();
        } else {
            ++this.fishingTicks;
        }
    }

    private void doFaceFishEntity() {
        if (this.hook != null) {
            this.owner.func_70671_ap().func_75651_a((Entity)this.hook, 16.0f, 2.0f);
        }
    }

    private void doItemVerification() {
        if (this.owner instanceof EntityHuman && !this.owner.getInventory().contains((Item)Items.field_151112_aM)) {
            this.owner.say("fishing.norod", this.getAssigningPlayer());
            this.reset();
            return;
        }
        this.owner.setHeldItem(this.owner.getInventory().func_70301_a(this.owner.getInventory().getFirstSlotContainingItem((Item)Items.field_151112_aM)).func_77973_b());
    }

    private int getFishCatchChance() {
        return 30;
    }

    private int getFishAmountToAdd() {
        return 1;
    }

    public void setHookEntity(EntityChoreFishHook hook) {
        this.hook = hook;
    }

    public void resetFishTargetPosition() {
        this.hasFishingTarget = false;
        this.idleFishingTime = 0;
    }
}

