/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen.schematic;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicBlocks;
import tragicneko.tragicmc.util.ChestHooks;
import tragicneko.tragicmc.util.WorldHelper;
import tragicneko.tragicmc.worldgen.schematic.Schematic;
import tragicneko.tragicmc.worldgen.structure.Structure;

public class SchematicTimeAltar
extends Schematic {
    private static Block quartz = Blocks.field_150371_ca;
    private static Block crystal = TragicBlocks.StarCrystal;
    private static Block summon = TragicBlocks.SummonBlock;
    private static Block chest = Blocks.field_150486_ae;
    private int variant = 0;

    public SchematicTimeAltar(BlockPos pos, Structure str, World world) {
        super(pos, str, world, 5, 10, 10);
        this.variant = world.field_73012_v.nextInt(16);
    }

    @Override
    public Schematic generateStructure(World world, Random rand, int x, int y, int z) {
        int i;
        for (int y1 = 0; y1 < 6; ++y1) {
            for (int x1 = -7; x1 < 8; ++x1) {
                for (int z1 = -7; z1 < 8; ++z1) {
                    this.setBlockToAir(world, x + x1, y + y1, z + z1);
                }
            }
        }
        ArrayList<BlockPos> list = WorldHelper.getBlocksInCircularRange(world, 8.0, x, y, z);
        for (i = 0; i < list.size(); ++i) {
            BlockPos coords = list.get(i);
            this.setBlock(world, coords.func_177958_n(), coords.func_177956_o(), coords.func_177952_p(), quartz, 0, 2);
        }
        list = WorldHelper.getBlocksInCircularRange(world, 4.446, x, y, z);
        for (i = 0; i < list.size(); ++i) {
            BlockPos coords = list.get(i);
            this.setBlock(world, coords.func_177958_n(), coords.func_177956_o(), coords.func_177952_p(), crystal, this.variant, 2);
        }
        this.setBlock(world, x, y + 1, z, quartz);
        this.setBlock(world, x, y + 2, z, quartz);
        this.setBlock(world, x, y + 2, z + 1, quartz);
        this.setBlock(world, x, y + 2, z - 1, quartz);
        this.setBlock(world, x + 1, y + 2, z, quartz);
        this.setBlock(world, x - 1, y + 2, z, quartz);
        this.setBlock(world, x, y + 3, z, summon, 7, 2);
        this.setBlock(world, x, y, z, chest, 0, 2, ChestHooks.epicHook);
        this.setBlock(world, x + 1, y, z, quartz);
        this.setBlock(world, x - 1, y, z, quartz);
        this.setBlock(world, x, y, z + 1, quartz);
        this.setBlock(world, x, y, z - 1, quartz);
        return this;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("variant", this.variant);
        return tag;
    }

    @Override
    public Schematic readFromNBT(NBTTagCompound tag) {
        this.variant = tag.func_74762_e("variant");
        return this;
    }
}

