/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen.schematic;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicBlocks;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.util.ChestHooks;
import tragicneko.tragicmc.worldgen.schematic.Schematic;
import tragicneko.tragicmc.worldgen.structure.Structure;

public class SchematicSpiderNest
extends Schematic {
    private int radius = 0;
    private int top = 5;
    private int bottom = -3;
    private final double fulcrum = 0.25466875;

    public SchematicSpiderNest(BlockPos pos, Structure str, World world) {
        super(pos, str, world, 8, 16, 16);
        this.radius = world.field_73012_v.nextInt(20) + 14;
        this.top = world.field_73012_v.nextInt(3) + 5;
        this.bottom = world.field_73012_v.nextInt(3) - 3;
    }

    @Override
    public Schematic generateStructure(World world, Random rand, int x, int y, int z) {
        for (int x1 = -this.radius; x1 < this.radius; ++x1) {
            double raw = Math.cos(0.25466875 * (double)x1 * 0.63) * 7.853338896115051 + (double)(this.radius * 3 / 4);
            int width = MathHelper.func_76125_a((int)MathHelper.func_76128_c((double)raw), (int)(this.radius / 3), (int)this.radius);
            for (int z1 = -width; z1 < width; ++z1) {
                int range = 4 + rand.nextInt(this.top * 5 / 8);
                int botR = this.bottom + rand.nextInt(3);
                for (int y1 = this.bottom; y1 < this.top; ++y1) {
                    if (y1 <= botR || y1 >= range) {
                        if ((y1 == botR || y1 == range) && rand.nextInt(20) == 0) {
                            if (rand.nextInt(6) == 0) {
                                this.setBlock(world, x + x1, y + y1, z + z1, Blocks.field_150474_ac, 0, 2, TragicConfig.getBoolean("allowStin") ? "TragicMC.Stin" : "Spider");
                                continue;
                            }
                            if (rand.nextInt(16) == 0) {
                                this.setBlock(world, x + x1, y + y1, z + z1, (Block)Blocks.field_150486_ae, 0, 2, ChestHooks.uncommonHook);
                                continue;
                            }
                            this.setBlock(world, x + x1, y + y1, z + z1, TragicBlocks.Corsin, 8, 2);
                            continue;
                        }
                        this.setBlock(world, x + x1, y + y1, z + z1, TragicBlocks.Corsin, rand.nextInt(4) == 0 ? (rand.nextInt(10) == 0 ? 4 : 1) : 0, 2);
                        continue;
                    }
                    if (rand.nextInt(12) == 0) {
                        this.setBlock(world, x + x1, y + y1, z + z1, Blocks.field_150321_G, 0, 2);
                        continue;
                    }
                    this.setBlockToAir(world, x + x1, y + y1, z + z1);
                }
            }
        }
        this.setBlockToAir(world, x, y, z);
        return this;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("radius", this.radius);
        tag.func_74768_a("top", this.top);
        tag.func_74768_a("bottom", this.bottom);
        return tag;
    }

    @Override
    public Schematic readFromNBT(NBTTagCompound tag) {
        this.radius = tag.func_74762_e("radius");
        this.top = tag.func_74762_e("top");
        this.bottom = tag.func_74762_e("bottom");
        return this;
    }
}

