/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen.schematic;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;
import tragicneko.tragicmc.TragicBlocks;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.util.ChestHooks;
import tragicneko.tragicmc.util.WorldHelper;
import tragicneko.tragicmc.worldgen.schematic.Schematic;
import tragicneko.tragicmc.worldgen.schematic.SchematicDesertTower;
import tragicneko.tragicmc.worldgen.structure.Structure;

public class SchematicObsidianCavern
extends Schematic {
    private static Block obs = Blocks.field_150343_Z;
    private static Block bedrock = Blocks.field_150357_h;
    private static Block ladder = Blocks.field_150468_ap;
    private static Block summon = TragicBlocks.SummonBlock;
    private static Block chest = Blocks.field_150486_ae;
    private static Block glowstone = Blocks.field_150426_aN;
    private static Block spawner = Blocks.field_150474_ac;
    private int variant = 0;
    private int variant2 = 0;

    public SchematicObsidianCavern(BlockPos pos, Structure str, World world) {
        super(pos, str, world, 8, 12, 12);
        this.variant = world.field_73012_v.nextInt(7);
        this.variant2 = world.field_73012_v.nextInt(10);
    }

    @Override
    public Schematic generateStructure(World world, Random rand, int x, int y, int z) {
        this.generateTube(world, rand, x, y, z);
        this.generateCavernOfferings(world, rand, x, y, z);
        this.generateCaveOpening(world, rand, x, y, z);
        return this;
    }

    public void generateTube(World world, Random rand, int x, int y, int z) {
        int x1;
        int wuh;
        int wah;
        int who;
        int wuh2;
        int wah2;
        int starty = y;
        y = 0;
        for (wah2 = 0; wah2 < 19; ++wah2) {
            for (wuh2 = 0; wuh2 < 19; ++wuh2) {
                this.setBlock(world, x + wah2 - 9, y, z + wuh2 - 9, bedrock);
            }
        }
        y = 1;
        for (who = 0; who < 7; ++who) {
            for (wah = 0; wah < 19; ++wah) {
                for (wuh = 0; wuh < 19; ++wuh) {
                    this.setBlockToAir(world, x + wah - 9, y + who, z + wuh - 9);
                }
            }
            for (x1 = 0; x1 < 19; ++x1) {
                this.setBlock(world, x + x1 - 9, y + who, z - 9, bedrock);
                this.setBlock(world, x - 9, y + who, z + x1 - 9, bedrock);
                this.setBlock(world, x + 18 - 9, y + who, z + x1 - 9, bedrock);
                this.setBlock(world, x + x1 - 9, y + who, z + 18 - 9, bedrock);
            }
        }
        y = 7;
        for (who = 0; who < 5; ++who) {
            for (wah = 0; wah < 11; ++wah) {
                for (wuh = 0; wuh < 11; ++wuh) {
                    this.setBlockToAir(world, x + wah - 5, y + who, z + wuh - 5);
                }
            }
            for (x1 = 0; x1 < 13; ++x1) {
                this.setBlock(world, x + x1 - 6, y + who, z - 6, bedrock);
                this.setBlock(world, x - 6, y + who, z + x1 - 6, bedrock);
                this.setBlock(world, x + 12 - 6, y + who, z + x1 - 6, bedrock);
                this.setBlock(world, x + x1 - 6, y + who, z + 12 - 6, bedrock);
            }
            for (x1 = 0; x1 < 15; ++x1) {
                this.setBlock(world, x + x1 - 7, y + who, z - 7, bedrock);
                this.setBlock(world, x - 7, y + who, z + x1 - 7, bedrock);
                this.setBlock(world, x + 14 - 7, y + who, z + x1 - 7, bedrock);
                this.setBlock(world, x + x1 - 7, y + who, z + 14 - 7, bedrock);
            }
            for (x1 = 0; x1 < 17; ++x1) {
                this.setBlock(world, x + x1 - 8, y + who, z - 8, bedrock);
                this.setBlock(world, x - 8, y + who, z + x1 - 8, bedrock);
                this.setBlock(world, x + 16 - 8, y + who, z + x1 - 8, bedrock);
                this.setBlock(world, x + x1 - 8, y + who, z + 16 - 8, bedrock);
            }
        }
        y = 12;
        for (who = 0; who < 2; ++who) {
            for (wah = 0; wah < 7; ++wah) {
                for (wuh = 0; wuh < 7; ++wuh) {
                    this.setBlockToAir(world, x + wah - 3, y + who, z + wuh - 3);
                }
            }
            for (x1 = 0; x1 < 9; ++x1) {
                this.setBlock(world, x + x1 - 4, y + who, z - 4, bedrock);
                this.setBlock(world, x - 4, y + who, z + x1 - 4, bedrock);
                this.setBlock(world, x + 8 - 4, y + who, z + x1 - 4, bedrock);
                this.setBlock(world, x + x1 - 4, y + who, z + 8 - 4, bedrock);
            }
            for (x1 = 0; x1 < 11; ++x1) {
                this.setBlock(world, x + x1 - 5, y + who, z - 5, bedrock);
                this.setBlock(world, x - 5, y + who, z + x1 - 5, bedrock);
                this.setBlock(world, x + 10 - 5, y + who, z + x1 - 5, bedrock);
                this.setBlock(world, x + x1 - 5, y + who, z + 10 - 5, bedrock);
            }
        }
        y = 13;
        for (wah2 = 0; wah2 < 5; ++wah2) {
            for (wuh2 = 0; wuh2 < 5; ++wuh2) {
                this.setBlockToAir(world, x + wah2 - 2, y, z + wuh2 - 2);
            }
        }
        for (int x12 = 0; x12 < 7; ++x12) {
            this.setBlock(world, x + x12 - 3, y, z - 3, bedrock);
            this.setBlock(world, x - 3, y, z + x12 - 3, bedrock);
            this.setBlock(world, x + 6 - 3, y, z + x12 - 3, bedrock);
            this.setBlock(world, x + x12 - 3, y, z + 6 - 3, bedrock);
        }
        y = 14;
        for (who = 0; who < 2; ++who) {
            for (wah = 0; wah < 3; ++wah) {
                for (wuh = 0; wuh < 3; ++wuh) {
                    this.setBlockToAir(world, x + wah - 1, y + who, z + wuh - 1);
                }
            }
            for (x1 = 0; x1 < 5; ++x1) {
                this.setBlock(world, x + x1 - 2, y + who, z - 2, bedrock);
                this.setBlock(world, x - 2, y + who, z + x1 - 2, bedrock);
                this.setBlock(world, x + 4 - 2, y + who, z + x1 - 2, bedrock);
                this.setBlock(world, x + x1 - 2, y + who, z + 4 - 2, bedrock);
            }
        }
        y = 16;
        who = 0;
        while (y + who <= starty) {
            for (wah = 0; wah < 3; ++wah) {
                for (wuh = 0; wuh < 3; ++wuh) {
                    this.setBlockToAir(world, x + wah - 1, y + who, z + wuh - 1);
                }
            }
            for (x1 = 0; x1 < 3; ++x1) {
                this.setBlock(world, x + x1 - 1, y + who, z - 1, obs);
                this.setBlock(world, x - 1, y + who, z + x1 - 1, obs);
                this.setBlock(world, x + 2 - 1, y + who, z + x1 - 1, obs);
                this.setBlock(world, x + x1 - 1, y + who, z + 2 - 1, obs);
                if ((y + who) % 12 != 0 || y + who == starty) continue;
                int i = rand.nextInt(3);
                this.setBlock(world, x, y + who, z - 1, TragicBlocks.ObsidianVariant, i, 3);
                this.setBlock(world, x - 1, y + who, z, TragicBlocks.ObsidianVariant, i, 3);
                this.setBlock(world, x + 1, y + who, z, TragicBlocks.ObsidianVariant, i, 3);
                this.setBlock(world, x, y + who, z + 1, TragicBlocks.ObsidianVariant, i, 3);
            }
            ++who;
        }
        int i = 0;
        while (y + i <= starty) {
            this.setBlock(world, x, y + i, z, ladder, 3, 2);
            ++i;
        }
        this.setBlock(world, x + 8, 6, z + 8, glowstone);
        this.setBlock(world, x + 8, 6, z - 8, glowstone);
        this.setBlock(world, x - 8, 6, z + 8, glowstone);
        this.setBlock(world, x - 8, 6, z - 8, glowstone);
        this.setBlock(world, x + 5, 11, z + 5, glowstone);
        this.setBlock(world, x + 5, 11, z - 5, glowstone);
        this.setBlock(world, x - 5, 11, z + 5, glowstone);
        this.setBlock(world, x - 5, 11, z - 5, glowstone);
    }

    public void generateCaveOpening(World world, Random rand, int x, int y, int z) {
        Block luxury = SchematicDesertTower.luxuryBlocks[rand.nextInt(SchematicDesertTower.luxuryBlocks.length)];
        int meta = 0;
        if (luxury == TragicBlocks.CompactOre) {
            meta = rand.nextInt(5);
        }
        switch (this.variant) {
            case 0: {
                int y1;
                for (y1 = 0; y1 < 4; ++y1) {
                    for (int x1 = -1; x1 < 2; ++x1) {
                        for (int z1 = -1; z1 < 2; ++z1) {
                            this.setBlock(world, x + x1, y + y1, z + z1, obs);
                        }
                    }
                }
                for (y1 = 1; y1 < 3; ++y1) {
                    this.setBlockToAir(world, x + 1, y + y1, z);
                    this.setBlockToAir(world, x - 1, y + y1, z);
                    this.setBlockToAir(world, x, y + y1, z + 1);
                    this.setBlockToAir(world, x, y + y1, z - 1);
                    this.setBlockToAir(world, x, y + y1, z);
                }
                for (int x1 = -1; x1 < 2; ++x1) {
                    this.setBlock(world, x + x1, y + 4, z, obs);
                    this.setBlock(world, x, y + 4, z + x1, obs);
                    this.setBlock(world, x + 2, y, z + x1, obs);
                    this.setBlock(world, x - 2, y, z + x1, obs);
                    this.setBlock(world, x + x1, y, z - 2, obs);
                    this.setBlock(world, x + x1, y, z + 2, obs);
                }
                this.setBlock(world, x, y + 4, z, luxury, meta, 2);
                this.setBlock(world, x, y + 5, z, obs);
                this.setBlock(world, x, y + 6, z, obs);
                break;
            }
            case 1: {
                int x1;
                int y1;
                for (y1 = 0; y1 < 8; ++y1) {
                    for (x1 = -1; x1 < 1; ++x1) {
                        for (int z1 = -1; z1 < 2; ++z1) {
                            this.setBlock(world, x + x1, y + y1, z + z1, obs);
                        }
                    }
                }
                this.setBlockToAir(world, x, y + 4, z);
                this.setBlockToAir(world, x, y + 5, z + 1);
                this.setBlockToAir(world, x, y + 5, z - 1);
                this.setBlock(world, x - 1, y + 5, z + 1, luxury, meta, 2);
                this.setBlock(world, x - 1, y + 5, z - 1, luxury, meta, 2);
                for (int x12 = -1; x12 < 2; ++x12) {
                    this.setBlock(world, x + x12, y, z - 2, obs);
                    this.setBlock(world, x + x12, y, z + 2, obs);
                    if (x12 == 0) {
                        this.setBlock(world, x + x12, y + 1, z - 2, obs);
                        this.setBlock(world, x + x12, y + 1, z + 2, obs);
                    }
                    if (x12 != -1) continue;
                    this.setBlock(world, x + x12, y + 2, z - 2, obs);
                    this.setBlock(world, x + x12, y + 2, z + 2, obs);
                    this.setBlock(world, x + x12, y + 1, z - 2, obs);
                    this.setBlock(world, x + x12, y + 1, z + 2, obs);
                }
                for (y1 = 3; y1 < 7; ++y1) {
                    for (x1 = -1; x1 < 1; ++x1) {
                        this.setBlock(world, x + x1, y + y1, z - 2, obs);
                        this.setBlock(world, x + x1, y + y1, z + 2, obs);
                    }
                }
                for (y1 = 0; y1 < 8; ++y1) {
                    this.setBlock(world, x - 2, y + y1, z + 1, obs);
                    this.setBlock(world, x - 2, y + y1, z, obs);
                    this.setBlock(world, x - 2, y + y1, z - 1, obs);
                }
                this.setBlock(world, x - 2, y + 5, z - 2, obs);
                this.setBlock(world, x - 2, y + 5, z + 2, obs);
                this.setBlockToAir(world, x - 2, y + 7, z - 1);
                this.setBlockToAir(world, x - 2, y + 7, z + 1);
                this.setBlock(world, x - 2, y + 7, z, obs);
                this.setBlockToAir(world, x, y + 1, z);
                this.setBlockToAir(world, x, y + 1, z - 1);
                this.setBlockToAir(world, x, y + 1, z + 1);
                this.setBlockToAir(world, x, y + 2, z);
                this.setBlockToAir(world, x, y + 2, z - 1);
                this.setBlockToAir(world, x, y + 2, z + 1);
                this.setBlockToAir(world, x, y + 3, z + 2);
                this.setBlockToAir(world, x, y + 3, z - 2);
                for (y1 = 0; y1 < 3; ++y1) {
                    for (int z1 = -2; z1 < 3; ++z1) {
                        if (y1 != 0) {
                            if (z1 == 0) continue;
                            this.setBlock(world, x + 2, y + y1, z + z1, obs);
                            continue;
                        }
                        this.setBlock(world, x + 2, y + y1, z + z1, obs);
                    }
                }
                break;
            }
            case 2: {
                int y1;
                for (y1 = 0; y1 < 6; ++y1) {
                    for (int x1 = -1; x1 < 1; ++x1) {
                        for (int z1 = -1; z1 < 2; ++z1) {
                            this.setBlock(world, x + x1, y + y1, z + z1, obs);
                        }
                    }
                }
                this.setBlockToAir(world, x, y + 1, z);
                this.setBlockToAir(world, x, y + 2, z);
                this.setBlock(world, x, y + 4, z, luxury, meta, 2);
                this.setBlock(world, x + 1, y + 3, z, obs);
                this.setBlock(world, x + 1, y + 4, z - 1, obs);
                this.setBlock(world, x + 1, y + 4, z + 1, obs);
                this.setBlock(world, x + 1, y + 5, z, obs);
                this.setBlock(world, x, y + 4, z - 2, obs);
                this.setBlock(world, x, y + 4, z + 2, obs);
                this.setBlock(world, x - 1, y + 4, z - 2, obs);
                this.setBlock(world, x - 1, y + 4, z + 2, obs);
                this.setBlock(world, x, y + 6, z, obs);
                this.setBlock(world, x - 1, y + 6, z, obs);
                for (y1 = 2; y1 < 6; ++y1) {
                    this.setBlock(world, x - 2, y + y1, z, obs);
                }
                this.setBlock(world, x - 2, y + 4, z - 1, obs);
                this.setBlock(world, x - 2, y + 4, z + 1, obs);
                this.setBlock(world, x + 1, y + 1, z - 1, obs);
                this.setBlock(world, x + 1, y + 1, z + 1, obs);
                break;
            }
            case 3: {
                int x1;
                for (int z1 = -1; z1 < 2; ++z1) {
                    this.setBlock(world, x - 1, y, z + z1, obs);
                    this.setBlock(world, x + 1, y, z + z1, obs);
                    this.setBlock(world, x + 2, y, z + z1, obs);
                    for (int x13 = -2; x13 < 5; ++x13) {
                        this.setBlock(world, x + x13, y + 3, z + z1, obs);
                    }
                }
                for (int y1 = 0; y1 < 5; ++y1) {
                    for (int z1 = -1; z1 < 2; ++z1) {
                        if (y1 > 0 && z1 != 0) {
                            this.setBlock(world, x, y + y1, z + z1, obs);
                        }
                        this.setBlock(world, x - 1, y + y1, z + z1, obs);
                    }
                }
                this.setBlock(world, x + 2, y + 1, z + 1, obs);
                this.setBlock(world, x + 2, y + 1, z - 1, obs);
                this.setBlock(world, x + 4, y + 2, z + 1, obs);
                this.setBlock(world, x + 4, y + 2, z - 1, obs);
                for (x1 = -3; x1 < 5; ++x1) {
                    this.setBlock(world, x + x1, y + 4, z, obs);
                }
                this.setBlock(world, x - 3, y + 5, z, obs);
                this.setBlock(world, x, y + 6, z, obs);
                this.setBlock(world, x + 4, y + 4, z + 1, obs);
                this.setBlock(world, x + 4, y + 4, z - 1, obs);
                this.setBlock(world, x + 1, y + 4, z + 1, luxury, meta, 2);
                this.setBlock(world, x + 1, y + 4, z - 1, luxury, meta, 2);
                this.setBlock(world, x + 1, y + 4, z - 2, obs);
                this.setBlock(world, x + 1, y + 4, z + 2, obs);
                this.setBlock(world, x + 1, y + 5, z + 1, obs);
                this.setBlock(world, x + 1, y + 5, z - 1, obs);
                for (x1 = -1; x1 < 1; ++x1) {
                    this.setBlock(world, x + x1, y + 4, z + 1, obs);
                    this.setBlock(world, x + x1, y + 4, z - 1, obs);
                }
                for (x1 = -1; x1 < 3; ++x1) {
                    this.setBlock(world, x + x1, y + 5, z, obs);
                    if (x1 >= 2) continue;
                    this.setBlock(world, x + x1, y + 3, z - 2, obs);
                    this.setBlock(world, x + x1, y + 3, z + 2, obs);
                }
                for (x1 = -4; x1 < -1; ++x1) {
                    this.setBlock(world, x + x1, y + 1, z, obs);
                    if (x1 <= -4) continue;
                    this.setBlock(world, x + x1, y + 2, z, obs);
                    this.setBlock(world, x + x1, y, z, obs);
                }
                break;
            }
            case 4: {
                int y1;
                for (y1 = 1; y1 < 6; ++y1) {
                    for (int z1 = -1; z1 < 2; ++z1) {
                        int x1;
                        this.setBlock(world, x - 1, y + y1, z + z1, obs);
                        if (z1 != 0) {
                            if (y1 == 1 || y1 == 2) {
                                this.setBlock(world, x + 1, y + y1, z + z1, obs);
                            }
                            if (y1 == 1) {
                                this.setBlock(world, x + 2, y + y1, z + z1, obs);
                            }
                        }
                        if (y1 > 3) {
                            this.setBlock(world, x, y + y1, z + z1, obs);
                        } else if (z1 != 0) {
                            this.setBlock(world, x, y + y1, z + z1, obs);
                        }
                        if (y1 == 3) {
                            for (x1 = 0; x1 < 4; ++x1) {
                                this.setBlock(world, x + x1, y + y1, z + z1, obs);
                            }
                        }
                        if (y1 != 4 || z1 != 0) continue;
                        for (x1 = 0; x1 < 3; ++x1) {
                            this.setBlock(world, x + x1, y + y1, z, obs);
                        }
                    }
                }
                this.setBlock(world, x, y + 4, z - 1, luxury, meta, 2);
                this.setBlock(world, x, y + 4, z + 1, luxury, meta, 2);
                this.setBlock(world, x, y + 4, z - 2, obs);
                this.setBlock(world, x, y + 4, z + 2, obs);
                this.setBlock(world, x - 1, y + 4, z - 2, obs);
                this.setBlock(world, x + 1, y + 4, z - 2, obs);
                this.setBlock(world, x - 1, y + 4, z + 2, obs);
                this.setBlock(world, x + 1, y + 4, z + 2, obs);
                this.setBlock(world, x, y + 5, z - 2, obs);
                this.setBlock(world, x, y + 5, z + 2, obs);
                this.setBlock(world, x, y + 3, z - 2, obs);
                this.setBlock(world, x, y + 3, z + 2, obs);
                for (int z1 = -1; z1 < 2; ++z1) {
                    this.setBlock(world, x + 1, y + 5, z + z1, obs);
                    this.setBlock(world, x + 2, y, z + z1, obs);
                }
                this.setBlockToAir(world, x - 1, y + 5, z);
                this.setBlock(world, x - 1, y + 5, z - 2, obs);
                this.setBlock(world, x - 1, y + 5, z + 2, obs);
                this.setBlock(world, x - 1, y + 6, z - 2, obs);
                this.setBlock(world, x - 1, y + 6, z + 2, obs);
                for (y1 = 5; y1 < 8; ++y1) {
                    this.setBlock(world, x - 1, y + y1, z - 3, obs);
                    this.setBlock(world, x - 1, y + y1, z + 3, obs);
                }
                this.setBlock(world, x - 2, y + 6, z - 3, obs);
                this.setBlock(world, x - 2, y + 6, z + 3, obs);
                this.setBlock(world, x - 2, y + 7, z - 3, obs);
                this.setBlock(world, x - 2, y + 7, z + 3, obs);
                this.setBlock(world, x - 2, y + 7, z - 4, obs);
                this.setBlock(world, x - 2, y + 7, z + 4, obs);
                this.setBlock(world, x - 2, y + 8, z + 4, obs);
                this.setBlock(world, x - 2, y + 8, z - 4, obs);
                this.setBlock(world, x - 3, y + 8, z + 4, obs);
                this.setBlock(world, x - 3, y + 8, z - 4, obs);
                break;
            }
            default: {
                int y1;
                block44: for (y1 = 0; y1 < 3; ++y1) {
                    switch (y1) {
                        case 0: {
                            int z1;
                            int x1;
                            for (x1 = -3; x1 < 4; ++x1) {
                                for (z1 = -3; z1 < 4; ++z1) {
                                    this.setBlock(world, x + x1, y + y1, z + z1, obs);
                                }
                            }
                            continue block44;
                        }
                        case 1: {
                            int z1;
                            int x1;
                            for (x1 = -2; x1 < 3; ++x1) {
                                for (z1 = -2; z1 < 3; ++z1) {
                                    this.setBlock(world, x + x1, y + y1, z + z1, obs);
                                }
                            }
                            continue block44;
                        }
                        case 2: {
                            int z1;
                            int x1;
                            for (x1 = -1; x1 < 2; ++x1) {
                                for (z1 = -1; z1 < 2; ++z1) {
                                    if (x1 == 0 || z1 == 0) continue;
                                    this.setBlock(world, x + x1, y + y1, z + z1, obs);
                                }
                            }
                            continue block44;
                        }
                    }
                }
                for (y1 = 0; y1 < 3; ++y1) {
                    this.setBlock(world, x + 1, y + y1, z, obs);
                    this.setBlock(world, x - 1, y + y1, z, obs);
                    this.setBlock(world, x, y + y1, z + 1, obs);
                    this.setBlock(world, x, y + y1, z - 1, obs);
                    this.setBlock(world, x, y + y1, z, ladder, 3, 2);
                }
            }
        }
        this.setBlockToAir(world, x, y, z);
    }

    public void generateCavernOfferings(World world, Random rand, int x, int y, int z) {
        switch (this.variant2) {
            case 0: {
                ArrayList<BlockPos> list = WorldHelper.getBlocksInCircularRange(world, 3.0, x, 0.0, z);
                for (int i = 0; i < list.size(); ++i) {
                    BlockPos coords = list.get(i);
                    this.setBlockToAir(world, coords.func_177958_n(), coords.func_177956_o(), coords.func_177952_p());
                }
                this.setBlock(world, x, 0, z, bedrock);
                this.setBlock(world, x, 1, z, chest, 0, 2, this.getChestHooks(1));
                break;
            }
            case 1: {
                this.setBlock(world, x, 1, z, bedrock);
                this.setBlock(world, x + 1, 1, z, chest, 0, 2, this.getChestHooks(0));
                this.setBlock(world, x - 1, 1, z, chest, 0, 2, this.getChestHooks(0));
                this.setBlock(world, x, 1, z + 1, chest, 0, 2, this.getChestHooks(0));
                this.setBlock(world, x, 1, z - 1, chest, 0, 2, this.getChestHooks(0));
                break;
            }
            case 2: {
                this.setBlock(world, x, 1, z, bedrock);
                int wubwub = rand.nextInt(4) + 1;
                int xerces = rand.nextInt(10);
                if (xerces == 1) {
                    xerces = 0;
                }
                if (xerces >= 7) {
                    xerces = 6;
                }
                this.setBlock(world, x + 5, 1, z + 5, summon, xerces, 2);
                this.setBlock(world, x + 1, 1, z, chest, 0, 2, this.getChestHooks(2));
                if (wubwub <= 1) break;
                xerces = rand.nextInt(10);
                if (xerces == 1) {
                    xerces = 0;
                }
                if (xerces >= 7) {
                    xerces = 6;
                }
                this.setBlock(world, x - 5, 1, z + 5, summon, xerces, 2);
                this.setBlock(world, x - 1, 1, z, chest, 0, 2, this.getChestHooks(2));
                if (wubwub <= 2) break;
                xerces = rand.nextInt(10);
                if (xerces == 1) {
                    xerces = 0;
                }
                if (xerces >= 7) {
                    xerces = 6;
                }
                this.setBlock(world, x - 5, 1, z - 5, summon, xerces, 2);
                this.setBlock(world, x, 1, z + 1, chest, 0, 2, this.getChestHooks(2));
                if (wubwub <= 3) break;
                xerces = rand.nextInt(10);
                if (xerces == 1) {
                    xerces = 0;
                }
                if (xerces >= 7) {
                    xerces = 6;
                }
                this.setBlock(world, x + 5, 1, z - 5, summon, xerces, 2);
                this.setBlock(world, x, 1, z - 1, chest, 0, 2, this.getChestHooks(2));
                break;
            }
            case 3: {
                int mow = rand.nextInt(10);
                if (mow == 1) {
                    mow = 0;
                }
                if (mow >= 7) {
                    mow = 6;
                }
                this.setBlock(world, x, 1, z, summon, mow, 2);
                break;
            }
            case 4: {
                this.setBlock(world, x, 1, z, spawner, 0, 2, this.getRandomEntityNameForSpawner(rand.nextInt(10)));
                break;
            }
            case 5: {
                this.setBlock(world, x, 1, z, bedrock);
                int zera = rand.nextInt(4) + 1;
                int oppa = rand.nextInt(10);
                this.setBlock(world, x + 5, 1, z + 5, spawner, 0, 2, this.getRandomEntityNameForSpawner(oppa));
                this.setBlock(world, x + 1, 1, z, chest, 0, 2, this.getChestHooks(0));
                oppa = rand.nextInt(10);
                if (zera <= 1) break;
                this.setBlock(world, x - 5, 1, z + 5, spawner, 0, 2, this.getRandomEntityNameForSpawner(oppa));
                this.setBlock(world, x - 1, 1, z, chest, 0, 2, this.getChestHooks(0));
                oppa = rand.nextInt(10);
                if (zera <= 2) break;
                this.setBlock(world, x - 5, 1, z - 5, spawner, 0, 2, this.getRandomEntityNameForSpawner(oppa));
                this.setBlock(world, x, 1, z + 1, chest, 0, 2, this.getChestHooks(0));
                oppa = rand.nextInt(10);
                if (zera <= 3) break;
                this.setBlock(world, x + 5, 1, z - 5, spawner, 0, 2, this.getRandomEntityNameForSpawner(oppa));
                this.setBlock(world, x, 1, z - 1, chest, 0, 2, this.getChestHooks(0));
                break;
            }
            case 6: {
                this.setBlock(world, x, 1, z, chest, 0, 2, this.getChestHooks(1));
                this.setBlock(world, x, 2, z, spawner, 0, 2, this.getRandomEntityNameForSpawner(rand.nextInt(10)));
                break;
            }
            case 7: {
                int mrow = rand.nextInt(10);
                if (mrow == 1) {
                    mrow = 0;
                }
                if (mrow >= 7) {
                    mrow = 6;
                }
                this.setBlock(world, x, 1, z, chest, 0, 2, this.getChestHooks(0));
                this.setBlock(world, x, 2, z, summon, mrow, 2);
                int zera = rand.nextInt(4) + 1;
                int oppa = rand.nextInt(10);
                this.setBlock(world, x + 5, 1, z + 5, spawner, 0, 2, this.getRandomEntityNameForSpawner(oppa));
                oppa = rand.nextInt(10);
                if (zera <= 1) break;
                this.setBlock(world, x - 5, 1, z + 5, spawner, 0, 2, this.getRandomEntityNameForSpawner(oppa));
                oppa = rand.nextInt(10);
                if (zera <= 2) break;
                this.setBlock(world, x - 5, 1, z - 5, spawner, 0, 2, this.getRandomEntityNameForSpawner(oppa));
                oppa = rand.nextInt(10);
                if (zera <= 3) break;
                this.setBlock(world, x + 5, 1, z - 5, spawner, 0, 2, this.getRandomEntityNameForSpawner(oppa));
                break;
            }
            case 8: {
                int mrow = rand.nextInt(10);
                if (mrow == 1) {
                    mrow = 0;
                }
                if (mrow >= 7) {
                    mrow = 6;
                }
                this.setBlock(world, x, 1, z, chest, 0, 2, this.getChestHooks(2));
                Block luxury = SchematicDesertTower.luxuryBlocks[rand.nextInt(SchematicDesertTower.luxuryBlocks.length)];
                int meta = 0;
                if (luxury == TragicBlocks.CompactOre) {
                    meta = rand.nextInt(5);
                }
                this.setBlock(world, x, 2, z, luxury, meta, 2);
                this.setBlock(world, x, 3, z, summon, mrow, 2);
                int zera = rand.nextInt(4) + 1;
                int oppa = rand.nextInt(10);
                this.setBlock(world, x + 5, 1, z + 5, spawner, 0, 2, this.getRandomEntityNameForSpawner(oppa));
                oppa = rand.nextInt(10);
                if (zera <= 1) break;
                this.setBlock(world, x - 5, 1, z + 5, spawner, 0, 2, this.getRandomEntityNameForSpawner(oppa));
                oppa = rand.nextInt(10);
                if (zera <= 2) break;
                this.setBlock(world, x - 5, 1, z - 5, spawner, 0, 2, this.getRandomEntityNameForSpawner(oppa));
                oppa = rand.nextInt(10);
                if (zera <= 3) break;
                this.setBlock(world, x + 5, 1, z - 5, spawner, 0, 2, this.getRandomEntityNameForSpawner(oppa));
                break;
            }
            default: {
                this.setBlock(world, x, 1, z, chest, 0, 2, this.getChestHooks(1));
            }
        }
    }

    public ChestGenHooks getChestHooks(int flag) {
        ChestGenHooks hook = ChestHooks.commonHook;
        if (flag == 0) {
            hook = ChestHooks.rareHook;
        } else if (flag == 1) {
            hook = ChestGenHooks.getInfo((String)"mineshaftCorridor");
        } else if (flag == 2) {
            hook = ChestHooks.epicHook;
        }
        return hook;
    }

    public String getRandomEntityNameForSpawner(int i) {
        String s = TragicConfig.getBoolean("allowPlague") ? "TragicMC.Plague" : "Blaze";
        switch (i) {
            case 0: {
                s = TragicConfig.getBoolean("allowMinotaur") ? "TragicMC.Minotaur" : this.getRandomVanillaEntityNameForSpawner(i);
                break;
            }
            case 1: {
                s = TragicConfig.getBoolean("allowInkling") ? "TragicMC.Inkling" : this.getRandomVanillaEntityNameForSpawner(i);
                break;
            }
            case 2: {
                s = TragicConfig.getBoolean("allowJabba") ? "TragicMC.Jabba" : this.getRandomVanillaEntityNameForSpawner(i);
                break;
            }
            case 3: {
                s = TragicConfig.getBoolean("allowNorVox") ? "TragicMC.NorVox" : this.getRandomVanillaEntityNameForSpawner(i);
                break;
            }
            case 4: {
                s = TragicConfig.getBoolean("allowRagr") ? "TragicMC.Ragr" : this.getRandomVanillaEntityNameForSpawner(i);
                break;
            }
            case 5: {
                s = TragicConfig.getBoolean("allowTox") ? "TragicMC.Tox" : this.getRandomVanillaEntityNameForSpawner(i);
                break;
            }
            case 6: {
                s = TragicConfig.getBoolean("allowGragul") ? "TragicMC.Gragul" : this.getRandomVanillaEntityNameForSpawner(i);
                break;
            }
            case 7: {
                s = TragicConfig.getBoolean("allowJarra") ? "TragicMC.Jarra" : this.getRandomVanillaEntityNameForSpawner(i);
                break;
            }
            case 8: {
                s = TragicConfig.getBoolean("allowKragul") ? "TragicMC.Kragul" : this.getRandomVanillaEntityNameForSpawner(i);
                break;
            }
        }
        return s;
    }

    public String getRandomVanillaEntityNameForSpawner(int i) {
        String s = "Skeleton";
        switch (i) {
            case 0: {
                s = "Zombie";
                break;
            }
            case 1: {
                s = "Enderman";
                break;
            }
            case 2: {
                s = "Slime";
                break;
            }
            case 3: {
                s = "Blaze";
                break;
            }
            case 4: {
                s = "Spider";
                break;
            }
            case 5: {
                s = "Witch";
                break;
            }
        }
        return s;
    }

    public String getRandomBossNameForSpawner(int i) {
        String s = TragicConfig.getBoolean("allowApis") ? "TragicMC.Apis" : "Enderman";
        switch (i) {
            case 0: {
                s = TragicConfig.getBoolean("allowEmpariah") ? "TragicMC.Yeti" : "Enderman";
                break;
            }
            case 1: {
                s = TragicConfig.getBoolean("allowKitsunakuma") ? "TragicMC.Kitsune" : "Enderman";
                break;
            }
            case 2: {
                s = TragicConfig.getBoolean("allowPolaris") ? "TragicMC.Polaris" : "Enderman";
                break;
            }
        }
        return s;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("variant", this.variant);
        tag.func_74768_a("variant2", this.variant2);
        return tag;
    }

    @Override
    public Schematic readFromNBT(NBTTagCompound tag) {
        this.variant = tag.func_74762_e("variant");
        this.variant2 = tag.func_74762_e("variant2");
        return this;
    }
}

