/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen.schematic;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;
import tragicneko.tragicmc.TragicBlocks;
import tragicneko.tragicmc.entity.mob.EntityCommonNeko;
import tragicneko.tragicmc.entity.mob.EntityMechaNeko;
import tragicneko.tragicmc.entity.mob.EntityTraderNeko;
import tragicneko.tragicmc.util.ChestHooks;
import tragicneko.tragicmc.util.WorldHelper;
import tragicneko.tragicmc.worldgen.schematic.Schematic;
import tragicneko.tragicmc.worldgen.schematic.SchematicNekoHouse;
import tragicneko.tragicmc.worldgen.structure.Structure;

public class SchematicNekoVillage
extends Schematic {
    private static final byte[] BLOCK_OFFSETS = new byte[]{-17, 0, 17};
    private static final byte[][] SMALL_BUILDING_OFFSETS = new byte[][]{{-3, -3}, {3, -3}, {-3, 3}, {3, 3}};
    private static final byte[][] INTERNAL_ROTATION_OFFSETS = new byte[][]{{-2, 0}, {2, 0}, {0, -2}, {0, 2}};
    private byte[][] byteMap = new byte[3][3];
    private byte[][] buildingMap = new byte[9][4];

    public SchematicNekoVillage(BlockPos origin, Structure structure, World world) {
        super(origin, structure, world, 15, 70, 70);
        this.byteMap = this.generateBlockComposition(world.field_73012_v);
        this.buildingMap = this.generateBuildingMap(world.field_73012_v);
    }

    @Override
    public Schematic generateStructure(World world, Random rand, int x, int y, int z) {
        for (int y1 = -1; y1 < 12; y1 = (int)((byte)(y1 + 1))) {
            for (int x1 = -27; x1 < 28; x1 = (int)((byte)(x1 + 1))) {
                for (int z1 = -27; z1 < 28; z1 = (int)((byte)(z1 + 1))) {
                    this.setBlockToAir(world, x + x1, y + y1, z + z1);
                }
            }
        }
        this.generateRoads(world, rand, x, y, z);
        for (int b = 0; b < this.byteMap.length; b = (int)((byte)(b + 1))) {
            for (int b2 = 0; b2 < this.byteMap[b].length; b2 = (int)((byte)(b2 + 1))) {
                byte bit = this.byteMap[b][b2];
                byte xOffset = BLOCK_OFFSETS[b2];
                byte zOffset = BLOCK_OFFSETS[b];
                byte block = (byte)(b * 3 + b2);
                if (bit == 0) {
                    this.placeSmallBuildings(world, rand, x + xOffset, y, z + zOffset, block);
                    continue;
                }
                if (bit != 1) continue;
                this.placeLargeBuilding(world, rand, x + xOffset, y, z + zOffset, block);
            }
        }
        return this;
    }

    public void generateRoads(World world, Random rand, int x, int y, int z) {
        int y1;
        int i;
        int z1;
        int x1;
        for (x1 = -27; x1 < 28; x1 = (int)((byte)(x1 + 1))) {
            for (z1 = -27; z1 < 28; z1 = (int)((byte)(z1 + 1))) {
                int state = z1 > -27 && z1 < 27 ? (x1 >= -9 && x1 < -7 || x1 > 7 && x1 <= 9 ? 2 : (x1 == -10 || x1 == -7 || x1 == 7 || x1 == 10 ? 1 : 5)) : 5;
                this.setBlock(world, new BlockPos(x + x1, y - 1, z + z1), TragicBlocks.NekitePlate.func_176203_a(state));
                if (x1 <= -27 || x1 >= 27 || (z1 < -10 || z1 >= -6) && (z1 <= 6 || z1 > 10)) continue;
                i = (z1 == -10 || z1 == -7 || z1 == 7 || z1 == 10) && (x1 < -10 || x1 > -7 && x1 < 7 || x1 > 10) ? 1 : 2;
                this.setBlock(world, new BlockPos(x + x1, y - 1, z + z1), TragicBlocks.NekitePlate.func_176203_a(i));
            }
        }
        for (x1 = -27; x1 < -24; x1 = (int)((byte)(x1 + 1))) {
            for (z1 = -27; z1 < 28; z1 = (int)((byte)(z1 + 1))) {
                for (y1 = 0; y1 < 8; y1 = (int)((byte)(y1 + 1))) {
                    if (y1 >= 7 && x1 == -26 || y1 >= 7 && (z1 == -26 || z1 == 26) && x1 == -25) continue;
                    i = y1 >= 6 ? 1 : 2;
                    this.setBlock(world, new BlockPos(x + x1, y + y1, z + z1), TragicBlocks.NekitePlate.func_176203_a(i));
                    this.setBlock(world, new BlockPos(x + Math.abs(x1), y + y1, z + z1), TragicBlocks.NekitePlate.func_176203_a(i));
                    this.setBlock(world, new BlockPos(x + z1, y + y1, z + x1), TragicBlocks.NekitePlate.func_176203_a(i));
                    this.setBlock(world, new BlockPos(x + z1, y + y1, z + Math.abs(x1)), TragicBlocks.NekitePlate.func_176203_a(i));
                }
            }
        }
        for (x1 = -27; x1 < -24; x1 = (int)((byte)(x1 + 1))) {
            for (z1 = -27; z1 < -24; z1 = (int)((byte)(z1 + 1))) {
                for (y1 = 8; y1 < 12; y1 = (int)((byte)(y1 + 1))) {
                    if (y1 != 10 && (x1 == -26 || z1 == -26)) continue;
                    i = y1 == 10 && x1 == z1 && x1 == -26 ? 0 : 1;
                    this.setBlock(world, new BlockPos(x + x1, y + y1, z + z1), TragicBlocks.NekitePlate.func_176203_a(i));
                    this.setBlock(world, new BlockPos(x + Math.abs(x1), y + y1, z + z1), TragicBlocks.NekitePlate.func_176203_a(i));
                    this.setBlock(world, new BlockPos(x + z1, y + y1, z + x1), TragicBlocks.NekitePlate.func_176203_a(i));
                    this.setBlock(world, new BlockPos(x + z1, y + y1, z + Math.abs(x1)), TragicBlocks.NekitePlate.func_176203_a(i));
                    this.setBlock(world, new BlockPos(x + x1, y + y1, z + Math.abs(z1)), TragicBlocks.NekitePlate.func_176203_a(i));
                    this.setBlock(world, new BlockPos(x + Math.abs(x1), y + y1, z + Math.abs(z1)), TragicBlocks.NekitePlate.func_176203_a(i));
                    this.setBlock(world, new BlockPos(x + Math.abs(z1), y + y1, z + x1), TragicBlocks.NekitePlate.func_176203_a(i));
                    this.setBlock(world, new BlockPos(x + Math.abs(z1), y + y1, z + Math.abs(x1)), TragicBlocks.NekitePlate.func_176203_a(i));
                }
            }
        }
        for (x1 = -11; x1 < -5; x1 = (int)((byte)(x1 + 1))) {
            for (z1 = -27; z1 < -24; z1 = (int)((byte)(z1 + 1))) {
                for (y1 = 0; y1 < 4; y1 = (int)((byte)(y1 + 1))) {
                    this.setBlockToAir(world, x + x1, y + y1, z + z1);
                    this.setBlockToAir(world, x + Math.abs(x1), y + y1, z + z1);
                    this.setBlockToAir(world, x + z1, y + y1, z + x1);
                    this.setBlockToAir(world, x + z1, y + y1, z + Math.abs(x1));
                    this.setBlockToAir(world, x + x1, y + y1, z + Math.abs(z1));
                    this.setBlockToAir(world, x + Math.abs(x1), y + y1, z + Math.abs(z1));
                    this.setBlockToAir(world, x + Math.abs(z1), y + y1, z + x1);
                    this.setBlockToAir(world, x + Math.abs(z1), y + y1, z + Math.abs(x1));
                    if (x1 != -11 && x1 != -6 && y1 != 3) continue;
                    i = z1 == -26 ? (y1 == 3 && (x1 == -8 || x1 == -9) ? 0 : 2) : 1;
                    this.setBlock(world, new BlockPos(x + x1, y + y1, z + z1), TragicBlocks.NekitePlate.func_176203_a(i));
                    this.setBlock(world, new BlockPos(x + Math.abs(x1), y + y1, z + z1), TragicBlocks.NekitePlate.func_176203_a(i));
                    this.setBlock(world, new BlockPos(x + z1, y + y1, z + x1), TragicBlocks.NekitePlate.func_176203_a(i));
                    this.setBlock(world, new BlockPos(x + z1, y + y1, z + Math.abs(x1)), TragicBlocks.NekitePlate.func_176203_a(i));
                    this.setBlock(world, new BlockPos(x + x1, y + y1, z + Math.abs(z1)), TragicBlocks.NekitePlate.func_176203_a(i));
                    this.setBlock(world, new BlockPos(x + Math.abs(x1), y + y1, z + Math.abs(z1)), TragicBlocks.NekitePlate.func_176203_a(i));
                    this.setBlock(world, new BlockPos(x + Math.abs(z1), y + y1, z + x1), TragicBlocks.NekitePlate.func_176203_a(i));
                    this.setBlock(world, new BlockPos(x + Math.abs(z1), y + y1, z + Math.abs(x1)), TragicBlocks.NekitePlate.func_176203_a(i));
                }
            }
        }
    }

    public void placeSmallBuildings(World world, Random rand, int x, int y, int z, byte block) {
        for (byte b = 0; b < SMALL_BUILDING_OFFSETS.length; b = (byte)(b + 1)) {
            this.generateFiveByFive(world, rand, x + SMALL_BUILDING_OFFSETS[b][0], y, z + SMALL_BUILDING_OFFSETS[b][1], b, block);
        }
        for (int y1 = 0; y1 < 4; y1 = (int)((byte)(y1 + 1))) {
            int state = y1 == 3 ? 0 : 1;
            this.setBlock(world, new BlockPos(x + 6, y + y1, z + 6), TragicBlocks.NekitePlate.func_176203_a(state));
            this.setBlock(world, new BlockPos(x - 6, y + y1, z + 6), TragicBlocks.NekitePlate.func_176203_a(state));
            this.setBlock(world, new BlockPos(x + 6, y + y1, z - 6), TragicBlocks.NekitePlate.func_176203_a(state));
            this.setBlock(world, new BlockPos(x - 6, y + y1, z - 6), TragicBlocks.NekitePlate.func_176203_a(state));
        }
    }

    public void generateFiveByFive(World world, Random rand, int x, int y, int z, byte spot, byte block) {
        byte rotation = this.getRotationFromBlockPosition(rand, spot, block);
        byte meow = this.buildingMap[block][spot];
        if (meow <= 10) {
            this.generateSmallNekoFlat(world, rand, x, y, z, rotation);
        } else if (meow <= 12) {
            this.generatePowerCell(world, rand, x, y, z);
        } else if (meow <= 13) {
            this.generateAntenna(world, rand, x, y, z);
        } else {
            this.generateVacantLot(world, rand, x, y, z, rotation);
        }
    }

    public byte getRotationFromBlockPosition(Random rand, byte spot, byte block) {
        byte rotation = 0;
        if (spot == 0) {
            rotation = rand.nextBoolean() ? (byte)0 : 2;
        } else if (spot == 1) {
            rotation = rand.nextBoolean() ? (byte)1 : 2;
        } else if (spot == 2) {
            rotation = rand.nextBoolean() ? (byte)0 : 3;
        } else if (spot == 3) {
            byte by = rotation = rand.nextBoolean() ? (byte)1 : 3;
        }
        if (spot == 0 && block == 0) {
            rotation = 1;
        }
        if (spot == 1 && block == 0) {
            rotation = 1;
        }
        if (spot == 2 && block == 0) {
            rotation = 3;
        }
        if (spot == 0 && block == 1) {
            rotation = 0;
        }
        if (spot == 1 && block == 1) {
            rotation = 1;
        }
        if (spot == 0 && block == 2) {
            rotation = 0;
        }
        if (spot == 1 && block == 2) {
            rotation = 0;
        }
        if (spot == 3 && block == 2) {
            rotation = 3;
        }
        if (spot == 0 && block == 3) {
            rotation = 2;
        }
        if (spot == 2 && block == 3) {
            rotation = 3;
        }
        if (spot == 1 && block == 5) {
            rotation = 2;
        }
        if (spot == 3 && block == 5) {
            rotation = 3;
        }
        if (spot == 0 && block == 6) {
            rotation = 2;
        }
        if (spot == 2 && block == 6) {
            rotation = 1;
        }
        if (spot == 3 && block == 6) {
            rotation = 1;
        }
        if (spot == 2 && block == 7) {
            rotation = 0;
        }
        if (spot == 3 && block == 7) {
            rotation = 1;
        }
        if (spot == 1 && block == 8) {
            rotation = 2;
        }
        if (spot == 2 && block == 8) {
            rotation = 0;
        }
        if (spot == 3 && block == 8) {
            rotation = 0;
        }
        return rotation;
    }

    public void generateAntenna(World world, Random rand, int x, int y, int z) {
        int z1;
        int x1;
        int y1;
        for (y1 = 0; y1 < 5; y1 = (int)((byte)(y1 + 1))) {
            for (x1 = -2; x1 < 3; x1 = (int)((byte)(x1 + 1))) {
                for (z1 = -2; z1 < 3; z1 = (int)((byte)(z1 + 1))) {
                    if (Math.abs(x1) != Math.abs(z1)) continue;
                    this.setBlock(world, new BlockPos(x + x1, y + y1, z + z1), Blocks.field_150411_aY.func_176203_a(0));
                }
            }
        }
        for (y1 = 5; y1 < 10; y1 = (int)((byte)(y1 + 1))) {
            for (x1 = -1; x1 < 2; x1 = (int)((byte)(x1 + 1))) {
                for (z1 = -1; z1 < 2; z1 = (int)((byte)(z1 + 1))) {
                    if (Math.abs(x1) != Math.abs(z1) && y1 % 2 != 0) continue;
                    this.setBlock(world, new BlockPos(x + x1, y + y1, z + z1), Blocks.field_150411_aY.func_176203_a(0));
                }
            }
        }
        for (y1 = 0; y1 < 18; y1 = (int)((byte)(y1 + 1))) {
            this.setBlock(world, new BlockPos(x, y + y1, z), y1 > 10 ? Blocks.field_150411_aY.func_176203_a(0) : Blocks.field_150339_S.func_176203_a(0));
        }
        this.setBlock(world, new BlockPos(x, y + 18, z), Blocks.field_150461_bJ.func_176203_a(0));
    }

    public void generateSmallNekoFlat(World world, Random rand, int x, int y, int z, byte rotation) {
        int y1;
        for (y1 = 0; y1 < 9; y1 = (int)((byte)(y1 + 1))) {
            for (int x1 = -2; x1 < 3; x1 = (int)((byte)(x1 + 1))) {
                int i = y1 == 0 || y1 == 4 || y1 == 8 || Math.abs(x1) == 2 ? 1 : 2;
                this.setBlock(world, new BlockPos(x + x1, y + y1, z + 2), TragicBlocks.NekitePlate.func_176203_a(i));
                this.setBlock(world, new BlockPos(x + 2, y + y1, z + x1), TragicBlocks.NekitePlate.func_176203_a(i));
                this.setBlock(world, new BlockPos(x + x1, y + y1, z - 2), TragicBlocks.NekitePlate.func_176203_a(i));
                this.setBlock(world, new BlockPos(x - 2, y + y1, z + x1), TragicBlocks.NekitePlate.func_176203_a(i));
            }
        }
        for (int x1 = -1; x1 < 2; x1 = (int)((byte)(x1 + 1))) {
            for (int z1 = -1; z1 < 2; z1 = (int)((byte)(z1 + 1))) {
                this.setBlock(world, new BlockPos(x + x1, y + 3, z + z1), TragicBlocks.NekitePlate.func_176203_a(2));
                this.setBlock(world, new BlockPos(x + x1, y + 7, z + z1), TragicBlocks.NekitePlate.func_176203_a(2));
            }
        }
        this.setBlockToAir(world, x + INTERNAL_ROTATION_OFFSETS[rotation][0], y, z + INTERNAL_ROTATION_OFFSETS[rotation][1]);
        this.setBlockToAir(world, x + INTERNAL_ROTATION_OFFSETS[rotation][0], y + 1, z + INTERNAL_ROTATION_OFFSETS[rotation][1]);
        this.setBlock(world, new BlockPos(x + 1, y, z + 1), Blocks.field_150462_ai.func_176203_a(0));
        this.setBlock(world, new BlockPos(x - 1, y, z - 1), Blocks.field_150460_al.func_176203_a(0), SchematicNekoHouse.getFurnaceStacks(0, rand), SchematicNekoHouse.getFurnaceStacks(1, rand), SchematicNekoHouse.getFurnaceStacks(2, rand));
        for (y1 = 0; y1 < 4; y1 = (int)((byte)(y1 + 1))) {
            this.setBlock(world, new BlockPos(x - 1, y + y1, z + 1), Blocks.field_150468_ap.func_176203_a(0));
        }
        this.setBlock(world, new BlockPos(x, y + 3, z), TragicBlocks.NekitePlate.func_176203_a(0));
        this.setBlock(world, new BlockPos(x - 1, y + 4, z - 1), Blocks.field_150486_ae.func_176203_a(3), ChestHooks.foodHook);
        this.setBlock(world, new BlockPos(x + 1, y + 4, z), Blocks.field_150324_C.func_176203_a(2));
        this.setBlock(world, new BlockPos(x + 1, y + 4, z - 1), Blocks.field_150324_C.func_176203_a(10));
        for (int b = 0; b < INTERNAL_ROTATION_OFFSETS.length; b = (int)((byte)(b + 1))) {
            this.setBlockToAir(world, x + INTERNAL_ROTATION_OFFSETS[b][0], y + 5, z + INTERNAL_ROTATION_OFFSETS[b][1]);
            this.setBlockToAir(world, x + INTERNAL_ROTATION_OFFSETS[b][0], y + 6, z + INTERNAL_ROTATION_OFFSETS[b][1]);
        }
        this.spawnEntity(world, new BlockPos(x, y, z), (Entity)(rand.nextBoolean() ? new EntityCommonNeko(world) : new EntityTraderNeko(world)));
    }

    public void generateVacantLot(World world, Random rand, int x, int y, int z, byte rotation) {
        for (int y1 = 0; y1 < 8; y1 = (int)((byte)(y1 + 1))) {
            for (int x1 = -2; x1 < 3; x1 = (int)((byte)(x1 + 1))) {
                for (int z1 = -2; z1 < 3; z1 = (int)((byte)(z1 + 1))) {
                    this.setBlockToAir(world, x + x1, y + y1, z + z1);
                }
            }
        }
        byte[] metaLookup = new byte[]{4, 12, 8, 0};
        byte meta = metaLookup[rotation];
        this.setBlock(world, new BlockPos(x + INTERNAL_ROTATION_OFFSETS[rotation][0], y, z + INTERNAL_ROTATION_OFFSETS[rotation][1]), Blocks.field_150472_an.func_176203_a((int)meta), new Object[]{new String[]{"", "For sale!", "Contact Chuck!"}});
    }

    public void generatePowerCell(World world, Random rand, int x, int y, int z) {
        for (int y1 = 0; y1 < 5; y1 = (int)((byte)(y1 + 1))) {
            for (int x1 = -1; x1 < 2; x1 = (int)((byte)(x1 + 1))) {
                for (int z1 = -1; z1 < 2; z1 = (int)((byte)(z1 + 1))) {
                    IBlockState state = Math.abs(z1) != Math.abs(x1) && y1 < 4 ? Blocks.field_150451_bX.func_176203_a(0) : Blocks.field_150339_S.func_176203_a(0);
                    this.setBlock(world, new BlockPos(x + x1, y + y1, z + z1), state);
                }
            }
        }
        for (int b = 0; b < INTERNAL_ROTATION_OFFSETS.length; b = (int)((byte)(b + 1))) {
            for (int y1 = 0; y1 < 4; y1 = (int)((byte)(y1 + 1))) {
                this.setBlock(world, new BlockPos(x + INTERNAL_ROTATION_OFFSETS[b][0], y + y1, z + INTERNAL_ROTATION_OFFSETS[b][1]), Blocks.field_150379_bu.func_176203_a(0));
            }
        }
        this.setBlock(world, new BlockPos(x, y + 3, z), Blocks.field_150451_bX.func_176203_a(0));
        this.setBlock(world, new BlockPos(x, y + 4, z), Blocks.field_150451_bX.func_176203_a(0));
        this.setBlock(world, new BlockPos(x, y + 5, z), Blocks.field_150379_bu.func_176203_a(0));
        this.setBlock(world, new BlockPos(x, y + 1, z), Blocks.field_150486_ae.func_176203_a(0), ChestHooks.rareHook);
    }

    public void placeLargeBuilding(World world, Random rand, int x, int y, int z, byte block) {
        byte meow = this.buildingMap[block][0];
        if (meow <= 6) {
            this.generateHousingComplex(world, rand, x, y, z, block);
        } else if (meow <= 9) {
            this.generateArmsDepot(world, rand, x, y, z, block);
        } else if (meow <= 10) {
            this.generateStorageBuilding(world, rand, x, y, z, block);
        } else if (meow <= 13) {
            this.generatePark(world, rand, x, y, z);
        } else {
            this.generatePlaza(world, rand, x, y, z);
        }
        for (int y1 = 0; y1 < 4; y1 = (int)((byte)(y1 + 1))) {
            int state = y1 == 3 ? 0 : 1;
            this.setBlock(world, new BlockPos(x + 6, y + y1, z + 6), TragicBlocks.NekitePlate.func_176203_a(state));
            this.setBlock(world, new BlockPos(x - 6, y + y1, z + 6), TragicBlocks.NekitePlate.func_176203_a(state));
            this.setBlock(world, new BlockPos(x + 6, y + y1, z - 6), TragicBlocks.NekitePlate.func_176203_a(state));
            this.setBlock(world, new BlockPos(x - 6, y + y1, z - 6), TragicBlocks.NekitePlate.func_176203_a(state));
        }
    }

    public void generateHousingComplex(World world, Random rand, int x, int y, int z, byte block) {
        for (byte b = 0; b < SMALL_BUILDING_OFFSETS.length; b = (byte)(b + 1)) {
            this.generateSmallNekoFlat(world, rand, x + SMALL_BUILDING_OFFSETS[b][0], y, z + SMALL_BUILDING_OFFSETS[b][1], this.getRotationFromBlockPosition(rand, b, block));
        }
    }

    public void generateStorageBuilding(World world, Random rand, int x, int y, int z, byte block) {
        int z1;
        int x1;
        int x12;
        for (int y1 = 0; y1 < 9; y1 = (int)((byte)(y1 + 1))) {
            for (x12 = -5; x12 < 6; x12 = (int)((byte)(x12 + 1))) {
                int i = y1 == 0 || y1 == 4 || y1 == 8 || Math.abs(x12) == 5 ? 1 : 2;
                this.setBlock(world, new BlockPos(x + x12, y + y1, z + 5), TragicBlocks.NekitePlate.func_176203_a(i));
                this.setBlock(world, new BlockPos(x + 5, y + y1, z + x12), TragicBlocks.NekitePlate.func_176203_a(i));
                this.setBlock(world, new BlockPos(x + x12, y + y1, z - 5), TragicBlocks.NekitePlate.func_176203_a(i));
                this.setBlock(world, new BlockPos(x - 5, y + y1, z + x12), TragicBlocks.NekitePlate.func_176203_a(i));
            }
        }
        for (x1 = -4; x1 < 5; x1 = (int)((byte)(x1 + 1))) {
            for (z1 = -4; z1 < 5; z1 = (int)((byte)(z1 + 1))) {
                this.setBlock(world, new BlockPos(x + x1, y + 3, z + z1), TragicBlocks.NekitePlate.func_176203_a(2));
                this.setBlock(world, new BlockPos(x + x1, y + 7, z + z1), TragicBlocks.NekitePlate.func_176203_a(2));
            }
        }
        for (x1 = -1; x1 < 2; x1 = (int)((byte)(x1 + 1))) {
            for (z1 = -1; z1 < 2; z1 = (int)((byte)(z1 + 1))) {
                this.setBlock(world, new BlockPos(x + x1, y + 3, z + z1), TragicBlocks.NekitePlate.func_176203_a(0));
            }
        }
        byte b = this.getRotationFromBlockPosition(rand, (byte)(block % 4), block);
        for (x12 = -1; x12 < 2; x12 = (int)((byte)(x12 + 1))) {
            for (int z12 = -1; z12 < 2; z12 = (int)((byte)(z12 + 1))) {
                this.setBlockToAir(world, x + INTERNAL_ROTATION_OFFSETS[b][0] * 3 + x12, y, z + INTERNAL_ROTATION_OFFSETS[b][1] * 3 + z12);
                this.setBlockToAir(world, x + INTERNAL_ROTATION_OFFSETS[b][0] * 3 + x12, y + 1, z + INTERNAL_ROTATION_OFFSETS[b][1] * 3 + z12);
            }
        }
        for (int y1 = 0; y1 < 4; y1 = (int)((byte)(y1 + 1))) {
            this.setBlock(world, new BlockPos(x - 4, y + y1, z + 4), Blocks.field_150468_ap.func_176203_a(0));
            if (y1 == 0) {
                this.setBlock(world, new BlockPos(x - 2, y + y1, z + 4), Blocks.field_150462_ai.func_176203_a(0));
                this.setBlock(world, new BlockPos(x - 3, y + y1, z + 4), Blocks.field_150467_bQ.func_176203_a(0));
            }
            if (y1 >= 3) continue;
            ChestGenHooks hook = rand.nextBoolean() ? ChestHooks.commonHook : ChestHooks.foodHook;
            this.setBlock(world, new BlockPos(x - 4, y + y1, z - 3), Blocks.field_150486_ae.func_176203_a(5), hook);
            this.setBlock(world, new BlockPos(x - 4, y + y1, z - 2), Blocks.field_150486_ae.func_176203_a(5), hook);
            hook = rand.nextBoolean() ? ChestHooks.commonHook : ChestHooks.foodHook;
            this.setBlock(world, new BlockPos(x + 4, y + y1, z - 3), Blocks.field_150486_ae.func_176203_a(4), hook);
            this.setBlock(world, new BlockPos(x + 4, y + y1, z - 2), Blocks.field_150486_ae.func_176203_a(4), hook);
            hook = rand.nextBoolean() ? ChestHooks.commonHook : ChestHooks.foodHook;
            this.setBlock(world, new BlockPos(x + 4, y + y1, z + 3), Blocks.field_150486_ae.func_176203_a(4), hook);
            this.setBlock(world, new BlockPos(x + 4, y + y1, z + 2), Blocks.field_150486_ae.func_176203_a(4), hook);
            hook = rand.nextBoolean() ? ChestHooks.commonHook : ChestHooks.foodHook;
            this.setBlock(world, new BlockPos(x - 3, y + y1, z - 4), Blocks.field_150486_ae.func_176203_a(3), hook);
            this.setBlock(world, new BlockPos(x - 2, y + y1, z - 4), Blocks.field_150486_ae.func_176203_a(3), hook);
            hook = rand.nextBoolean() ? ChestHooks.commonHook : ChestHooks.foodHook;
            this.setBlock(world, new BlockPos(x + 3, y + y1, z - 4), Blocks.field_150486_ae.func_176203_a(3), hook);
            this.setBlock(world, new BlockPos(x + 2, y + y1, z - 4), Blocks.field_150486_ae.func_176203_a(3), hook);
            hook = rand.nextBoolean() ? ChestHooks.commonHook : ChestHooks.foodHook;
            this.setBlock(world, new BlockPos(x + 3, y + y1, z + 4), Blocks.field_150486_ae.func_176203_a(0), hook);
            this.setBlock(world, new BlockPos(x + 2, y + y1, z + 4), Blocks.field_150486_ae.func_176203_a(0), hook);
            this.setBlock(world, new BlockPos(x - 4, y + y1 + 4, z - 3), Blocks.field_150486_ae.func_176203_a(5), ChestHooks.uncommonHook);
            this.setBlock(world, new BlockPos(x - 4, y + y1 + 4, z - 2), Blocks.field_150486_ae.func_176203_a(5), ChestHooks.uncommonHook);
            this.setBlock(world, new BlockPos(x + 4, y + y1 + 4, z - 3), Blocks.field_150486_ae.func_176203_a(4), ChestHooks.uncommonHook);
            this.setBlock(world, new BlockPos(x + 4, y + y1 + 4, z - 2), Blocks.field_150486_ae.func_176203_a(4), ChestHooks.uncommonHook);
            this.setBlock(world, new BlockPos(x + 4, y + y1 + 4, z + 3), Blocks.field_150486_ae.func_176203_a(4), ChestHooks.uncommonHook);
            this.setBlock(world, new BlockPos(x + 4, y + y1 + 4, z + 2), Blocks.field_150486_ae.func_176203_a(4), ChestHooks.uncommonHook);
            this.setBlock(world, new BlockPos(x - 3, y + y1 + 4, z - 4), Blocks.field_150486_ae.func_176203_a(3), ChestHooks.uncommonHook);
            this.setBlock(world, new BlockPos(x - 2, y + y1 + 4, z - 4), Blocks.field_150486_ae.func_176203_a(3), ChestHooks.uncommonHook);
            this.setBlock(world, new BlockPos(x + 3, y + y1 + 4, z - 4), Blocks.field_150486_ae.func_176203_a(3), ChestHooks.uncommonHook);
            this.setBlock(world, new BlockPos(x + 2, y + y1 + 4, z - 4), Blocks.field_150486_ae.func_176203_a(3), ChestHooks.uncommonHook);
            this.setBlock(world, new BlockPos(x + 3, y + y1 + 4, z + 4), Blocks.field_150486_ae.func_176203_a(0), ChestHooks.uncommonHook);
            this.setBlock(world, new BlockPos(x + 2, y + y1 + 4, z + 4), Blocks.field_150486_ae.func_176203_a(0), ChestHooks.uncommonHook);
        }
        this.spawnEntity(world, new BlockPos(x + 1, y, z), (Entity)new EntityCommonNeko(world));
        this.spawnEntity(world, new BlockPos(x - 1, y, z), (Entity)new EntityCommonNeko(world));
        this.spawnEntity(world, new BlockPos(x, y, z + 1), (Entity)new EntityCommonNeko(world));
        this.spawnEntity(world, new BlockPos(x, y, z - 1), (Entity)new EntityCommonNeko(world));
    }

    public void generateArmsDepot(World world, Random rand, int x, int y, int z, byte block) {
        int z1;
        int x1;
        int x12;
        for (int y1 = 0; y1 < 9; y1 = (int)((byte)(y1 + 1))) {
            for (x12 = -5; x12 < 6; x12 = (int)((byte)(x12 + 1))) {
                int i = y1 == 0 || y1 == 4 || y1 == 8 || Math.abs(x12) == 5 || Math.abs(x12) == 2 ? 3 : 2;
                this.setBlock(world, new BlockPos(x + x12, y + y1, z + 5), TragicBlocks.NekitePlate.func_176203_a(i));
                this.setBlock(world, new BlockPos(x + 5, y + y1, z + x12), TragicBlocks.NekitePlate.func_176203_a(i));
                this.setBlock(world, new BlockPos(x + x12, y + y1, z - 5), TragicBlocks.NekitePlate.func_176203_a(i));
                this.setBlock(world, new BlockPos(x - 5, y + y1, z + x12), TragicBlocks.NekitePlate.func_176203_a(i));
            }
        }
        for (x1 = -4; x1 < 5; x1 = (int)((byte)(x1 + 1))) {
            for (z1 = -4; z1 < 5; z1 = (int)((byte)(z1 + 1))) {
                this.setBlock(world, new BlockPos(x + x1, y + 7, z + z1), TragicBlocks.NekitePlate.func_176203_a(2));
            }
        }
        for (x1 = -2; x1 < 3; x1 = (int)((byte)(x1 + 1))) {
            for (z1 = -2; z1 < 3; z1 = (int)((byte)(z1 + 1))) {
                this.setBlock(world, new BlockPos(x + x1, y, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            }
        }
        for (x1 = -1; x1 < 2; x1 = (int)((byte)(x1 + 1))) {
            for (z1 = -1; z1 < 2; z1 = (int)((byte)(z1 + 1))) {
                this.setBlock(world, new BlockPos(x + x1, y, z + z1), TragicBlocks.NekitePlate.func_176203_a(0));
            }
        }
        byte b = this.getRotationFromBlockPosition(rand, (byte)(block % 4), block);
        for (x12 = -1; x12 < 2; x12 = (int)((byte)(x12 + 1))) {
            for (int z12 = -1; z12 < 2; z12 = (int)((byte)(z12 + 1))) {
                this.setBlockToAir(world, x + INTERNAL_ROTATION_OFFSETS[b][0] * 3 + x12, y, z + INTERNAL_ROTATION_OFFSETS[b][1] * 3 + z12);
                this.setBlockToAir(world, x + INTERNAL_ROTATION_OFFSETS[b][0] * 3 + x12, y + 1, z + INTERNAL_ROTATION_OFFSETS[b][1] * 3 + z12);
            }
        }
        for (int y1 = 0; y1 < 3; y1 = (int)((byte)(y1 + 1))) {
            if (y1 == 0) {
                this.setBlock(world, new BlockPos(x - 2, y + y1, z + 4), Blocks.field_150462_ai.func_176203_a(0));
                this.setBlock(world, new BlockPos(x - 3, y + y1, z + 4), Blocks.field_150467_bQ.func_176203_a(0));
            }
            this.setBlock(world, new BlockPos(x - 4, y + y1, z - 3), Blocks.field_150486_ae.func_176203_a(5), ChestHooks.uncommonHook);
            this.setBlock(world, new BlockPos(x - 4, y + y1, z - 2), Blocks.field_150486_ae.func_176203_a(5), ChestHooks.uncommonHook);
            this.setBlock(world, new BlockPos(x + 4, y + y1, z - 3), Blocks.field_150486_ae.func_176203_a(4), ChestHooks.uncommonHook);
            this.setBlock(world, new BlockPos(x + 4, y + y1, z - 2), Blocks.field_150486_ae.func_176203_a(4), ChestHooks.uncommonHook);
            this.setBlock(world, new BlockPos(x - 4, y + y1, z + 3), Blocks.field_150486_ae.func_176203_a(5), ChestHooks.uncommonHook);
            this.setBlock(world, new BlockPos(x - 4, y + y1, z + 2), Blocks.field_150486_ae.func_176203_a(5), ChestHooks.uncommonHook);
            this.setBlock(world, new BlockPos(x + 4, y + y1, z + 3), Blocks.field_150486_ae.func_176203_a(4), ChestHooks.uncommonHook);
            this.setBlock(world, new BlockPos(x + 4, y + y1, z + 2), Blocks.field_150486_ae.func_176203_a(4), ChestHooks.uncommonHook);
            this.setBlock(world, new BlockPos(x - 3, y + y1, z - 4), Blocks.field_150486_ae.func_176203_a(3), ChestHooks.uncommonHook);
            this.setBlock(world, new BlockPos(x - 2, y + y1, z - 4), Blocks.field_150486_ae.func_176203_a(3), ChestHooks.uncommonHook);
            this.setBlock(world, new BlockPos(x + 3, y + y1, z - 4), Blocks.field_150486_ae.func_176203_a(3), ChestHooks.uncommonHook);
            this.setBlock(world, new BlockPos(x + 2, y + y1, z - 4), Blocks.field_150486_ae.func_176203_a(3), ChestHooks.uncommonHook);
            this.setBlock(world, new BlockPos(x - 3, y + y1, z + 4), Blocks.field_150486_ae.func_176203_a(0), ChestHooks.uncommonHook);
            this.setBlock(world, new BlockPos(x - 2, y + y1, z + 4), Blocks.field_150486_ae.func_176203_a(0), ChestHooks.uncommonHook);
            this.setBlock(world, new BlockPos(x + 3, y + y1, z + 4), Blocks.field_150486_ae.func_176203_a(0), ChestHooks.uncommonHook);
            this.setBlock(world, new BlockPos(x + 2, y + y1, z + 4), Blocks.field_150486_ae.func_176203_a(0), ChestHooks.uncommonHook);
        }
        EntityMechaNeko neko = new EntityMechaNeko(world);
        neko.func_70107_b((double)x - 1.5, y, (double)z - 1.5);
        neko.func_180482_a(world.func_175649_E(new BlockPos(x - 2, y, z - 2)), null);
        this.spawnEntity(world, new BlockPos(x - 2, y, z - 2), (Entity)neko);
        neko = new EntityMechaNeko(world);
        neko.func_70107_b((double)x + 2.5, y, (double)z + 2.5);
        neko.func_180482_a(world.func_175649_E(new BlockPos(x + 2, y, z + 2)), null);
        this.spawnEntity(world, new BlockPos(x + 2, y, z + 2), (Entity)neko);
    }

    public void generatePark(World world, Random rand, int x, int y, int z) {
        ArrayList<BlockPos> list;
        int b;
        for (int x1 = -6; x1 < 7; x1 = (int)((byte)(x1 + 1))) {
            for (int z1 = -6; z1 < 7; z1 = (int)((byte)(z1 + 1))) {
                this.setBlock(world, new BlockPos(x + x1, y - 1, z + z1), TragicBlocks.NekoGrass.func_176203_a(0));
            }
        }
        for (b = 0; b < 16; b = (int)((byte)(b + 1))) {
            if (rand.nextInt(4) != 0) continue;
            this.setBlock(world, new BlockPos(x + rand.nextInt(7) - rand.nextInt(7), y, z + rand.nextInt(7) - rand.nextInt(7)), TragicBlocks.NekoBush.func_176203_a(0));
        }
        for (b = 0; b < 32; b = (int)((byte)(b + 1))) {
            if (rand.nextInt(4) != 0) continue;
            this.setBlock(world, new BlockPos(x + rand.nextInt(7) - rand.nextInt(7), y, z + rand.nextInt(7) - rand.nextInt(7)), TragicBlocks.TragicFlower2.func_176203_a(11));
        }
        for (b = 0; b < 3; b = (int)((byte)(b + 1))) {
            if (!rand.nextBoolean()) continue;
            BlockPos pos = new BlockPos(x + rand.nextInt(5) - rand.nextInt(5), y - 1, z + rand.nextInt(5) - rand.nextInt(5));
            int width = rand.nextInt(2) + 2;
            list = WorldHelper.getBlocksInCircularRange(world, (double)width / 2.0, pos);
            for (BlockPos coord : list) {
                this.setBlock(world, coord, Blocks.field_150358_i.func_176203_a(0));
            }
            list = WorldHelper.getBlocksInCircularRange(world, width, pos);
            for (BlockPos coord : list) {
                if (rand.nextInt(4) == 0) continue;
                this.setBlock(world, coord, Blocks.field_150358_i.func_176203_a(0));
            }
            break;
        }
        for (b = 0; b < 3; b = (int)((byte)(b + 1))) {
            if (!rand.nextBoolean()) continue;
            BlockPos pos = new BlockPos(x + rand.nextInt(6) - rand.nextInt(6), y, z + rand.nextInt(6) - rand.nextInt(6));
            int height = rand.nextInt(3) + 4;
            list = WorldHelper.getBlocksInSphericalRange(world, (double)height / 2.0, pos.func_177981_b(height - 1));
            for (BlockPos coord : list) {
                this.setBlock(world, coord, TragicBlocks.NekowoodLeaves.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(true)));
            }
            for (int y1 = -1; y1 < height; y1 = (int)((byte)(y1 + 1))) {
                this.setBlock(world, pos.func_177981_b(y1), TragicBlocks.Nekowood.func_176203_a(0));
            }
        }
    }

    public void generatePlaza(World world, Random rand, int x, int y, int z) {
        int z1;
        int x1;
        boolean flag = rand.nextBoolean();
        for (x1 = -6; x1 < 7; x1 = (int)((byte)(x1 + 1))) {
            for (z1 = -6; z1 < 7; z1 = (int)((byte)(z1 + 1))) {
                int i = Math.abs(z1) == Math.abs(x1) || x1 % 2 == 0 && flag || !flag && z1 % 2 == 0 ? 1 : 2;
                this.setBlock(world, new BlockPos(x + x1, y - 1, z + z1), TragicBlocks.NekitePlate.func_176203_a(i));
            }
        }
        for (x1 = -1; x1 < 2; x1 = (int)((byte)(x1 + 1))) {
            for (z1 = -1; z1 < 2; z1 = (int)((byte)(z1 + 1))) {
                this.setBlock(world, new BlockPos(x + x1, y, z + z1), Blocks.field_150358_i.func_176203_a(0));
            }
        }
        this.setBlock(world, new BlockPos(x - 1, y, z + 2), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 1, y, z + 2), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 1, y, z - 2), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 1, y, z - 2), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 2, y, z + 1), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 2, y, z - 1), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 2, y, z + 1), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 2, y, z - 1), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 2, y, z), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 2, y, z), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x, y, z + 2), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x, y, z - 2), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x, y, z), TragicBlocks.NekitePlate.func_176203_a(0));
        this.setBlock(world, new BlockPos(x, y + 1, z), TragicBlocks.NekitePlate.func_176203_a(0));
        this.setBlock(world, new BlockPos(x, y + 2, z), TragicBlocks.NekitePlate.func_176203_a(0));
        this.setBlock(world, new BlockPos(x, y + 3, z), Blocks.field_150358_i.func_176203_a(0));
        this.spawnEntity(world, new BlockPos(x + 3, y, z + 3), (Entity)new EntityCommonNeko(world));
        this.spawnEntity(world, new BlockPos(x - 3, y, z + 3), (Entity)new EntityCommonNeko(world));
        this.spawnEntity(world, new BlockPos(x + 3, y, z - 3), (Entity)new EntityCommonNeko(world));
        this.spawnEntity(world, new BlockPos(x - 3, y, z - 3), (Entity)new EntityCommonNeko(world));
    }

    public byte[][] generateBlockComposition(Random rand) {
        return new byte[][]{{this.nextByte(rand), this.nextByte(rand), this.nextByte(rand)}, {this.nextByte(rand), this.nextByte(rand), this.nextByte(rand)}, {this.nextByte(rand), this.nextByte(rand), this.nextByte(rand)}};
    }

    private byte[][] generateBuildingMap(Random rand) {
        return new byte[][]{{this.nextByte(16, rand), this.nextByte(16, rand), this.nextByte(16, rand), this.nextByte(16, rand)}, {this.nextByte(16, rand), this.nextByte(16, rand), this.nextByte(16, rand), this.nextByte(16, rand)}, {this.nextByte(16, rand), this.nextByte(16, rand), this.nextByte(16, rand), this.nextByte(16, rand)}, {this.nextByte(16, rand), this.nextByte(16, rand), this.nextByte(16, rand), this.nextByte(16, rand)}, {this.nextByte(16, rand), this.nextByte(16, rand), this.nextByte(16, rand), this.nextByte(16, rand)}, {this.nextByte(16, rand), this.nextByte(16, rand), this.nextByte(16, rand), this.nextByte(16, rand)}, {this.nextByte(16, rand), this.nextByte(16, rand), this.nextByte(16, rand), this.nextByte(16, rand)}, {this.nextByte(16, rand), this.nextByte(16, rand), this.nextByte(16, rand), this.nextByte(16, rand)}, {this.nextByte(16, rand), this.nextByte(16, rand), this.nextByte(16, rand), this.nextByte(16, rand)}};
    }

    public byte nextByte(Random rand) {
        return (byte)rand.nextInt(2);
    }

    public byte nextByte(int value, Random rand) {
        return (byte)rand.nextInt(value);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74773_a("mapValues0", this.byteMap[0]);
        tag.func_74773_a("mapValues1", this.byteMap[1]);
        tag.func_74773_a("mapValues2", this.byteMap[2]);
        tag.func_74773_a("map2Values0", this.buildingMap[0]);
        tag.func_74773_a("map2Values1", this.buildingMap[1]);
        tag.func_74773_a("map2Values2", this.buildingMap[2]);
        tag.func_74773_a("map2Values3", this.buildingMap[3]);
        tag.func_74773_a("map2Values4", this.buildingMap[4]);
        tag.func_74773_a("map2Values5", this.buildingMap[5]);
        tag.func_74773_a("map2Values6", this.buildingMap[6]);
        tag.func_74773_a("map2Values7", this.buildingMap[7]);
        tag.func_74773_a("map2Values8", this.buildingMap[8]);
        return tag;
    }

    @Override
    public Schematic readFromNBT(NBTTagCompound tag) {
        int b;
        for (b = 0; b < this.byteMap.length; b = (int)((byte)(b + 1))) {
            this.byteMap[b] = tag.func_74770_j("mapValues" + b);
        }
        for (b = 0; b < this.buildingMap.length; b = (int)((byte)(b + 1))) {
            this.buildingMap[b] = tag.func_74770_j("map2Values" + b);
        }
        return this;
    }
}

