/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen.schematic;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicBlocks;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.util.ChestHooks;
import tragicneko.tragicmc.util.WorldHelper;
import tragicneko.tragicmc.worldgen.schematic.Schematic;
import tragicneko.tragicmc.worldgen.structure.Structure;

public class SchematicLightSpire
extends Schematic {
    public SchematicLightSpire(BlockPos pos, Structure str, World world) {
        super(pos, str, world, 24, 6, 6);
    }

    @Override
    public Schematic generateStructure(World world, Random rand, int x, int y, int z) {
        int height = rand.nextInt(30) + 36;
        for (int y1 = 0; y1 < height && y + y1 < 256; ++y1) {
            ArrayList<BlockPos> list = WorldHelper.getBlocksInCircularRange(world, 4.25, x + rand.nextInt(3) - rand.nextInt(3), y + y1, z + rand.nextInt(3) - rand.nextInt(3));
            for (BlockPos coords : list) {
                this.setBlock(world, coords.func_177958_n(), coords.func_177956_o(), coords.func_177952_p(), TragicBlocks.StringLight, 0, 2);
            }
            list = WorldHelper.getBlocksInCircularRange(world, 3.25, x + rand.nextInt(3) - rand.nextInt(3), y + y1, z + rand.nextInt(3) - rand.nextInt(3));
            for (BlockPos coords : list) {
                this.setBlockToAir(world, coords.func_177958_n(), coords.func_177956_o(), coords.func_177952_p());
            }
            if (rand.nextInt(32) == 0) {
                int xr = x + rand.nextInt(3) - rand.nextInt(3);
                int zr = z + rand.nextInt(3) - rand.nextInt(3);
                this.setBlock(world, xr, y + y1, zr, (Block)Blocks.field_150486_ae, 0, 2, ChestHooks.uncommonHook);
                continue;
            }
            if (rand.nextInt(16) != 0) continue;
            int xr = x + rand.nextInt(3) - rand.nextInt(3);
            int zr = z + rand.nextInt(3) - rand.nextInt(3);
            this.setBlock(world, xr, y + y1, zr, Blocks.field_150474_ac, 0, 2, TragicConfig.getBoolean("allowArchangel") ? "TragicMC.Archangel" : "Ghast");
        }
        return this;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        return tag;
    }

    @Override
    public Schematic readFromNBT(NBTTagCompound tag) {
        return this;
    }
}

