/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen.schematic;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicBlocks;
import tragicneko.tragicmc.util.ChestHooks;
import tragicneko.tragicmc.util.WorldHelper;
import tragicneko.tragicmc.worldgen.schematic.Schematic;
import tragicneko.tragicmc.worldgen.structure.Structure;

public class SchematicCelestialTemple
extends Schematic {
    private static Block quartz = TragicBlocks.DarkenedQuartz;
    private static Block obs = TragicBlocks.DarkStone;
    private static Block glow = TragicBlocks.StarCrystal;
    private static Block chest = Blocks.field_150486_ae;
    private static Block stone = TragicBlocks.DarkStone;
    private static Block summon = TragicBlocks.SummonBlock;
    private int variant = 0;

    public SchematicCelestialTemple(BlockPos origin, Structure str, World world) {
        super(origin, str, world, 12, 25, 25);
        this.variant = world.field_73012_v.nextInt(4);
    }

    @Override
    public Schematic generateStructure(World world, Random rand, int x, int y, int z) {
        int i;
        byte relays = (byte)(6 + (rand.nextInt(this.variant + 1) + 1) * (rand.nextInt(this.variant + 1) + 1));
        double regression = 0.88977745;
        double cutoff = 0.48943755;
        ArrayList<BlockPos> cands = new ArrayList<BlockPos>();
        for (byte buzza = 0; buzza < relays; buzza = (byte)(buzza + 1)) {
            int Ycoord;
            int Zcoord;
            int Xcoord;
            double size;
            if (buzza == 0) {
                size = 15.0;
                Xcoord = x + 4;
                Zcoord = z + 4;
                Ycoord = y;
                cutoff = 0.6278;
                regression = 0.8876;
            } else {
                size = rand.nextDouble() * 5.5 + 4.5;
                Xcoord = x + 4 + rand.nextInt(10) - rand.nextInt(10);
                Zcoord = z + 4 + rand.nextInt(10) - rand.nextInt(10);
                Ycoord = y - rand.nextInt(2);
                regression = 0.88977745;
                cutoff = 0.68943755;
            }
            int yMax = Ycoord;
            for (int y1 = 0; y1 > -32 && !(size < cutoff); y1 = (int)((byte)(y1 - 1))) {
                size *= regression;
                if (rand.nextInt(12) == 0) {
                    Xcoord += rand.nextInt(2) - rand.nextInt(2);
                    Zcoord += rand.nextInt(2) - rand.nextInt(2);
                }
                ArrayList<BlockPos> list = WorldHelper.getBlocksInCircularRange(world, size, Xcoord, Ycoord + y1, Zcoord);
                for (BlockPos coords2 : list) {
                    if (cands.contains(coords2)) continue;
                    if (yMax < coords2.func_177956_o()) {
                        yMax = coords2.func_177956_o();
                    }
                    cands.add(coords2);
                }
            }
            byte rnd = (byte)(rand.nextInt(3) + 1);
            for (BlockPos coords2 : cands) {
                if (coords2.func_177956_o() >= yMax) {
                    this.setBlock(world, coords2.func_177958_n(), coords2.func_177956_o(), coords2.func_177952_p(), TragicBlocks.AshenGrass, 0, 2);
                    continue;
                }
                if (coords2.func_177956_o() >= yMax - rnd - rand.nextInt(2)) {
                    this.setBlock(world, coords2.func_177958_n(), coords2.func_177956_o(), coords2.func_177952_p(), TragicBlocks.DeadDirt, 0, 2);
                    continue;
                }
                this.setBlock(world, coords2.func_177958_n(), coords2.func_177956_o(), coords2.func_177952_p(), TragicBlocks.DarkStone, 0, 2);
            }
        }
        for (int y1 = 0; y1 < 10; y1 = (int)((byte)(y1 + 1))) {
            for (int x1 = -8; x1 < 17; x1 = (int)((byte)(x1 + 1))) {
                for (int z1 = -6; z1 < 15; z1 = (int)((byte)(z1 + 1))) {
                    this.setBlockToAir(world, x + x1, y + y1 + 1, z + z1);
                }
            }
        }
        for (i = 2; i < 8; ++i) {
            this.setBlock(world, x - 7, y, z + i, quartz, 0, 2);
        }
        for (i = 1; i < 9; ++i) {
            this.setBlock(world, x - 6, y, z + i, quartz, 0, 2);
        }
        for (i = -1; i < 11; ++i) {
            this.setBlock(world, x - 5, y, z + i, quartz, 0, 2);
        }
        for (i = -2; i < 12; ++i) {
            this.setBlock(world, x - 4, y, z + i, quartz, 0, 2);
        }
        for (i = -2; i < 12; ++i) {
            this.setBlock(world, x - 3, y, z + i, quartz, 0, 2);
        }
        for (i = -3; i < 13; ++i) {
            this.setBlock(world, x - 2, y, z + i, quartz, 0, 2);
        }
        for (i = -4; i < 14; ++i) {
            this.setBlock(world, x - 1, y, z + i, quartz, 0, 2);
        }
        this.setBlock(world, x - 1, y, z, quartz, 1, 2);
        this.setBlock(world, x - 1, y, z + 9, quartz, 1, 2);
        for (i = -5; i < 15; ++i) {
            this.setBlock(world, x, y, z + i, quartz, 0, 2);
        }
        this.setBlock(world, x, y, z + 4, obs, 0, 2);
        this.setBlock(world, x, y, z + 5, obs, 0, 2);
        for (i = -5; i < 15; ++i) {
            this.setBlock(world, x + 1, y, z + i, quartz, 0, 2);
        }
        this.setBlock(world, x + 1, y, z, quartz, 1, 2);
        this.setBlock(world, x + 1, y, z + 3, obs, 0, 2);
        this.setBlock(world, x + 1, y, z + 4, quartz, 1, 2);
        this.setBlock(world, x + 1, y, z + 5, quartz, 1, 2);
        this.setBlock(world, x + 1, y, z + 6, obs, 0, 2);
        this.setBlock(world, x + 1, y, z + 9, quartz, 1, 2);
        for (i = -5; i < 15; ++i) {
            this.setBlock(world, x + 2, y, z + i, quartz, 0, 2);
        }
        this.setBlock(world, x + 2, y, z, quartz, 1, 2);
        this.setBlock(world, x + 2, y, z + 2, obs, 0, 2);
        this.setBlock(world, x + 2, y, z + 3, quartz, 1, 2);
        this.setBlock(world, x + 2, y, z + 4, quartz, 1, 2);
        this.setBlock(world, x + 2, y, z + 5, quartz, 1, 2);
        this.setBlock(world, x + 2, y, z + 6, quartz, 1, 2);
        this.setBlock(world, x + 2, y, z + 7, obs, 0, 2);
        this.setBlock(world, x + 2, y, z + 9, quartz, 1, 2);
        for (i = -5; i < 15; ++i) {
            this.setBlock(world, x + 3, y, z + i, quartz, 0, 2);
        }
        this.setBlock(world, x + 3, y, z, quartz, 1, 2);
        this.setBlock(world, x + 3, y, z + 2, obs, 0, 2);
        this.setBlock(world, x + 3, y, z + 3, quartz, 1, 2);
        this.setBlock(world, x + 3, y, z + 4, obs, 0, 2);
        this.setBlock(world, x + 3, y, z + 5, obs, 0, 2);
        this.setBlock(world, x + 3, y, z + 6, quartz, 1, 2);
        this.setBlock(world, x + 3, y, z + 7, obs, 0, 2);
        this.setBlock(world, x + 3, y, z + 9, quartz, 1, 2);
        for (i = -5; i < 15; ++i) {
            this.setBlock(world, x + 4, y, z + i, quartz, 0, 2);
        }
        this.setBlock(world, x + 4, y, z + 1, obs, 0, 2);
        this.setBlock(world, x + 4, y, z + 2, quartz, 1, 2);
        this.setBlock(world, x + 4, y, z + 3, glow, 0, 2);
        this.setBlock(world, x + 4, y, z + 4, chest, 0, 2, ChestHooks.rareHook);
        this.setBlock(world, x + 4, y, z + 5, chest, 0, 2, ChestHooks.rareHook);
        this.setBlock(world, x + 4, y, z + 6, glow, 0, 2);
        this.setBlock(world, x + 4, y, z + 7, quartz, 1, 2);
        this.setBlock(world, x + 4, y, z + 8, obs, 0, 2);
        for (i = -5; i < 15; ++i) {
            this.setBlock(world, x + 5, y, z + i, quartz, 0, 2);
        }
        this.setBlock(world, x + 5, y, z, quartz, 1, 2);
        this.setBlock(world, x + 5, y, z + 2, obs, 0, 2);
        this.setBlock(world, x + 5, y, z + 3, quartz, 1, 2);
        this.setBlock(world, x + 5, y, z + 4, obs, 0, 2);
        this.setBlock(world, x + 5, y, z + 5, obs, 0, 2);
        this.setBlock(world, x + 5, y, z + 6, quartz, 1, 2);
        this.setBlock(world, x + 5, y, z + 7, obs, 0, 2);
        this.setBlock(world, x + 5, y, z + 9, quartz, 1, 2);
        for (i = -5; i < 15; ++i) {
            this.setBlock(world, x + 6, y, z + i, quartz, 0, 2);
        }
        this.setBlock(world, x + 6, y, z, quartz, 1, 2);
        this.setBlock(world, x + 6, y, z + 2, obs, 0, 2);
        this.setBlock(world, x + 6, y, z + 3, quartz, 1, 2);
        this.setBlock(world, x + 6, y, z + 4, quartz, 1, 2);
        this.setBlock(world, x + 6, y, z + 5, quartz, 1, 2);
        this.setBlock(world, x + 6, y, z + 6, quartz, 1, 2);
        this.setBlock(world, x + 6, y, z + 7, obs, 0, 2);
        this.setBlock(world, x + 6, y, z + 9, quartz, 1, 2);
        for (i = -5; i < 15; ++i) {
            this.setBlock(world, x + 7, y, z + i, quartz, 0, 2);
        }
        this.setBlock(world, x + 7, y, z, quartz, 1, 2);
        this.setBlock(world, x + 7, y, z + 3, obs, 0, 2);
        this.setBlock(world, x + 7, y, z + 4, quartz, 1, 2);
        this.setBlock(world, x + 7, y, z + 5, quartz, 1, 2);
        this.setBlock(world, x + 7, y, z + 6, obs, 0, 2);
        this.setBlock(world, x + 7, y, z + 9, quartz, 1, 2);
        for (i = -5; i < 15; ++i) {
            this.setBlock(world, x + 8, y, z + i, quartz, 0, 2);
        }
        this.setBlock(world, x + 8, y, z + 4, obs, 0, 2);
        this.setBlock(world, x + 8, y, z + 5, obs, 0, 2);
        for (i = -4; i < 14; ++i) {
            this.setBlock(world, x + 9, y, z + i, quartz, 0, 2);
        }
        this.setBlock(world, x + 9, y, z, quartz, 1, 2);
        this.setBlock(world, x + 9, y, z + 9, quartz, 1, 2);
        for (i = -3; i < 13; ++i) {
            this.setBlock(world, x + 10, y, z + i, quartz, 0, 2);
        }
        for (i = -2; i < 12; ++i) {
            this.setBlock(world, x + 11, y, z + i, quartz, 0, 2);
        }
        for (i = -2; i < 12; ++i) {
            this.setBlock(world, x + 12, y, z + i, quartz, 0, 2);
        }
        for (i = -1; i < 11; ++i) {
            this.setBlock(world, x + 13, y, z + i, quartz, 0, 2);
        }
        for (i = 1; i < 9; ++i) {
            this.setBlock(world, x + 14, y, z + i, quartz, 0, 2);
        }
        for (i = 2; i < 8; ++i) {
            this.setBlock(world, x + 15, y, z + i, quartz, 0, 2);
        }
        this.setBlock(world, --x - 6, ++y, z + 2, quartz, 1, 2);
        this.setBlock(world, x - 6, y, z + 7, quartz, 1, 2);
        this.setBlock(world, x - 5, y, z + 1, quartz, 1, 2);
        this.setBlock(world, x - 5, y, z + 2, quartz, 1, 2);
        this.setBlock(world, x - 5, y, z + 3, quartz, 1, 2);
        this.setBlock(world, x - 5, y, z + 6, quartz, 1, 2);
        this.setBlock(world, x - 5, y, z + 7, quartz, 1, 2);
        this.setBlock(world, x - 5, y, z + 8, quartz, 1, 2);
        this.setBlock(world, x - 4, y, z - 1, quartz, 1, 2);
        this.setBlock(world, x - 4, y, z, quartz, 1, 2);
        this.setBlock(world, x - 4, y, z + 1, quartz, 1, 2);
        this.setBlock(world, x - 4, y, z + 2, quartz, 1, 2);
        this.setBlock(world, x - 4, y, z + 3, quartz, 1, 2);
        this.setBlock(world, x - 4, y, z + 6, quartz, 1, 2);
        this.setBlock(world, x - 4, y, z + 7, quartz, 1, 2);
        this.setBlock(world, x - 4, y, z + 8, quartz, 1, 2);
        this.setBlock(world, x - 4, y, z + 9, quartz, 1, 2);
        this.setBlock(world, x - 4, y, z + 10, quartz, 1, 2);
        this.setBlock(world, x - 3, y, z - 2, quartz, 1, 2);
        this.setBlock(world, x - 3, y, z - 1, quartz, 1, 2);
        this.setBlock(world, x - 3, y, z + 10, quartz, 1, 2);
        this.setBlock(world, x - 3, y, z + 11, quartz, 1, 2);
        this.setBlock(world, x - 2, y, z - 3, quartz, 1, 2);
        this.setBlock(world, x - 2, y, z - 2, quartz, 1, 2);
        this.setBlock(world, x - 2, y, z - 1, quartz, 1, 2);
        this.setBlock(world, x - 2, y, z + 10, quartz, 1, 2);
        this.setBlock(world, x - 2, y, z + 11, quartz, 1, 2);
        this.setBlock(world, x - 2, y, z + 12, quartz, 1, 2);
        this.setBlock(world, x - 1, y, z - 3, quartz, 1, 2);
        this.setBlock(world, x - 1, y, z - 2, quartz, 1, 2);
        this.setBlock(world, x - 1, y, z - 1, quartz, 1, 2);
        this.setBlock(world, x - 1, y, z + 10, quartz, 1, 2);
        this.setBlock(world, x - 1, y, z + 11, quartz, 1, 2);
        this.setBlock(world, x - 1, y, z + 12, quartz, 1, 2);
        this.setBlock(world, x, y, z - 3, quartz, 1, 2);
        this.setBlock(world, x, y, z - 2, quartz, 1, 2);
        this.setBlock(world, x, y, z, quartz, 1, 2);
        this.setBlock(world, x, y, z + 9, quartz, 1, 2);
        this.setBlock(world, x, y, z + 11, quartz, 1, 2);
        this.setBlock(world, x, y, z + 12, quartz, 1, 2);
        this.setBlock(world, x + 1, y, z - 4, quartz, 1, 2);
        this.setBlock(world, x + 1, y, z - 3, quartz, 1, 2);
        this.setBlock(world, x + 1, y, z + 12, quartz, 1, 2);
        this.setBlock(world, x + 1, y, z + 13, quartz, 1, 2);
        this.setBlock(world, x + 2, y, z - 5, quartz, 1, 2);
        this.setBlock(world, x + 2, y, z - 4, quartz, 1, 2);
        this.setBlock(world, x + 2, y, z - 3, quartz, 1, 2);
        this.setBlock(world, x + 2, y, z + 12, quartz, 1, 2);
        this.setBlock(world, x + 2, y, z + 13, quartz, 1, 2);
        this.setBlock(world, x + 2, y, z + 14, quartz, 1, 2);
        this.setBlock(world, x + 3, y, z - 4, quartz, 1, 2);
        this.setBlock(world, x + 3, y, z - 3, quartz, 1, 2);
        this.setBlock(world, x + 3, y, z + 12, quartz, 1, 2);
        this.setBlock(world, x + 3, y, z + 13, quartz, 1, 2);
        this.setBlock(world, x + 5, y, z + 4, obs, 0, 2);
        this.setBlock(world, x + 5, y, z + 5, obs, 0, 2);
        this.setBlock(world, x + 7, y, z - 4, quartz, 1, 2);
        this.setBlock(world, x + 7, y, z - 3, quartz, 1, 2);
        this.setBlock(world, x + 7, y, z + 12, quartz, 1, 2);
        this.setBlock(world, x + 7, y, z + 13, quartz, 1, 2);
        this.setBlock(world, x + 8, y, z - 5, quartz, 1, 2);
        this.setBlock(world, x + 8, y, z - 4, quartz, 1, 2);
        this.setBlock(world, x + 8, y, z - 3, quartz, 1, 2);
        this.setBlock(world, x + 8, y, z + 12, quartz, 1, 2);
        this.setBlock(world, x + 8, y, z + 13, quartz, 1, 2);
        this.setBlock(world, x + 8, y, z + 14, quartz, 1, 2);
        this.setBlock(world, x + 9, y, z - 4, quartz, 1, 2);
        this.setBlock(world, x + 9, y, z - 3, quartz, 1, 2);
        this.setBlock(world, x + 9, y, z + 12, quartz, 1, 2);
        this.setBlock(world, x + 9, y, z + 13, quartz, 1, 2);
        this.setBlock(world, x + 10, y, z - 3, quartz, 1, 2);
        this.setBlock(world, x + 10, y, z - 2, quartz, 1, 2);
        this.setBlock(world, x + 10, y, z, quartz, 1, 2);
        this.setBlock(world, x + 10, y, z + 9, quartz, 1, 2);
        this.setBlock(world, x + 10, y, z + 11, quartz, 1, 2);
        this.setBlock(world, x + 10, y, z + 12, quartz, 1, 2);
        this.setBlock(world, x + 11, y, z - 3, quartz, 1, 2);
        this.setBlock(world, x + 11, y, z - 2, quartz, 1, 2);
        this.setBlock(world, x + 11, y, z - 1, quartz, 1, 2);
        this.setBlock(world, x + 11, y, z + 10, quartz, 1, 2);
        this.setBlock(world, x + 11, y, z + 11, quartz, 1, 2);
        this.setBlock(world, x + 11, y, z + 12, quartz, 1, 2);
        this.setBlock(world, x + 12, y, z - 3, quartz, 1, 2);
        this.setBlock(world, x + 12, y, z - 2, quartz, 1, 2);
        this.setBlock(world, x + 12, y, z - 1, quartz, 1, 2);
        this.setBlock(world, x + 12, y, z + 10, quartz, 1, 2);
        this.setBlock(world, x + 12, y, z + 11, quartz, 1, 2);
        this.setBlock(world, x + 12, y, z + 12, quartz, 1, 2);
        this.setBlock(world, x + 13, y, z - 2, quartz, 1, 2);
        this.setBlock(world, x + 13, y, z - 1, quartz, 1, 2);
        this.setBlock(world, x + 13, y, z + 10, quartz, 1, 2);
        this.setBlock(world, x + 13, y, z + 11, quartz, 1, 2);
        this.setBlock(world, x + 14, y, z - 1, quartz, 1, 2);
        this.setBlock(world, x + 14, y, z, quartz, 1, 2);
        this.setBlock(world, x + 14, y, z + 1, quartz, 1, 2);
        this.setBlock(world, x + 14, y, z + 2, quartz, 1, 2);
        this.setBlock(world, x + 14, y, z + 3, quartz, 1, 2);
        this.setBlock(world, x + 14, y, z + 6, quartz, 1, 2);
        this.setBlock(world, x + 14, y, z + 7, quartz, 1, 2);
        this.setBlock(world, x + 14, y, z + 8, quartz, 1, 2);
        this.setBlock(world, x + 14, y, z + 9, quartz, 1, 2);
        this.setBlock(world, x + 14, y, z + 10, quartz, 1, 2);
        this.setBlock(world, x + 15, y, z + 1, quartz, 1, 2);
        this.setBlock(world, x + 15, y, z + 2, quartz, 1, 2);
        this.setBlock(world, x + 15, y, z + 3, quartz, 1, 2);
        this.setBlock(world, x + 15, y, z + 6, quartz, 1, 2);
        this.setBlock(world, x + 15, y, z + 7, quartz, 1, 2);
        this.setBlock(world, x + 15, y, z + 8, quartz, 1, 2);
        this.setBlock(world, x + 16, y, z + 2, quartz, 1, 2);
        this.setBlock(world, x + 16, y, z + 7, quartz, 1, 2);
        this.setBlock(world, x - 5, ++y, z + 2, quartz, 1, 2);
        this.setBlock(world, x - 5, y, z + 3, stone, 0, 2);
        this.setBlock(world, x - 5, y, z + 6, stone, 0, 2);
        this.setBlock(world, x - 5, y, z + 7, quartz, 1, 2);
        this.setBlock(world, x - 4, y, z - 1, quartz, 1, 2);
        this.setBlock(world, x - 4, y, z, quartz, 1, 2);
        this.setBlock(world, x - 4, y, z + 1, quartz, 1, 2);
        this.setBlock(world, x - 4, y, z + 2, quartz, 1, 2);
        this.setBlock(world, x - 4, y, z + 3, stone, 0, 2);
        this.setBlock(world, x - 4, y, z + 6, stone, 0, 2);
        this.setBlock(world, x - 4, y, z + 7, quartz, 1, 2);
        this.setBlock(world, x - 4, y, z + 8, quartz, 1, 2);
        this.setBlock(world, x - 4, y, z + 9, quartz, 1, 2);
        this.setBlock(world, x - 4, y, z + 10, quartz, 1, 2);
        this.setBlock(world, x - 3, y, z - 2, quartz, 1, 2);
        this.setBlock(world, x - 3, y, z - 1, quartz, 1, 2);
        this.setBlock(world, x - 3, y, z + 10, quartz, 1, 2);
        this.setBlock(world, x - 3, y, z + 11, quartz, 1, 2);
        this.setBlock(world, x - 2, y, z - 2, quartz, 1, 2);
        this.setBlock(world, x - 2, y, z - 1, quartz, 1, 2);
        this.setBlock(world, x - 2, y, z + 10, quartz, 1, 2);
        this.setBlock(world, x - 2, y, z + 11, quartz, 1, 2);
        this.setBlock(world, x - 1, y, z - 3, quartz, 1, 2);
        this.setBlock(world, x - 1, y, z - 2, quartz, 1, 2);
        this.setBlock(world, x - 1, y, z - 1, quartz, 1, 2);
        this.setBlock(world, x - 1, y, z + 10, quartz, 1, 2);
        this.setBlock(world, x - 1, y, z + 11, quartz, 1, 2);
        this.setBlock(world, x - 1, y, z + 12, quartz, 1, 2);
        this.setBlock(world, x, y, z - 3, quartz, 1, 2);
        this.setBlock(world, x, y, z - 2, quartz, 1, 2);
        this.setBlock(world, x, y, z, quartz, 1, 2);
        this.setBlock(world, x, y, z + 9, quartz, 1, 2);
        this.setBlock(world, x, y, z + 11, quartz, 1, 2);
        this.setBlock(world, x, y, z + 12, quartz, 1, 2);
        this.setBlock(world, x + 1, y, z - 3, quartz, 1, 2);
        this.setBlock(world, x + 1, y, z + 12, quartz, 1, 2);
        this.setBlock(world, x + 2, y, z - 4, quartz, 1, 2);
        this.setBlock(world, x + 2, y, z - 3, quartz, 1, 2);
        this.setBlock(world, x + 2, y, z + 12, quartz, 1, 2);
        this.setBlock(world, x + 2, y, z + 13, quartz, 1, 2);
        this.setBlock(world, x + 3, y, z - 4, stone, 0, 2);
        this.setBlock(world, x + 3, y, z - 3, stone, 0, 2);
        this.setBlock(world, x + 3, y, z + 12, stone, 0, 2);
        this.setBlock(world, x + 3, y, z + 13, stone, 0, 2);
        if (this.variant == 1) {
            this.setBlock(world, x + 5, y, z + 4, summon, 5, 2);
            this.setBlockToAir(world, x + 5, y, z + 5);
        } else if (this.variant == 2) {
            this.setBlock(world, x + 5, y, z + 4, summon, 5, 2);
            this.setBlock(world, x + 5, y, z + 5, summon, 5, 2);
        } else {
            this.setBlockToAir(world, x + 5, y, z + 4);
            this.setBlock(world, x + 5, y, z + 5, summon, 5, 2);
        }
        this.setBlock(world, x + 7, y, z - 4, stone, 0, 2);
        this.setBlock(world, x + 7, y, z - 3, stone, 0, 2);
        this.setBlock(world, x + 7, y, z + 12, stone, 0, 2);
        this.setBlock(world, x + 7, y, z + 13, stone, 0, 2);
        this.setBlock(world, x + 8, y, z - 4, quartz, 1, 2);
        this.setBlock(world, x + 8, y, z - 3, quartz, 1, 2);
        this.setBlock(world, x + 8, y, z + 12, quartz, 1, 2);
        this.setBlock(world, x + 8, y, z + 13, quartz, 1, 2);
        this.setBlock(world, x + 9, y, z - 3, quartz, 1, 2);
        this.setBlock(world, x + 9, y, z + 12, quartz, 1, 2);
        this.setBlock(world, x + 10, y, z - 3, quartz, 1, 2);
        this.setBlock(world, x + 10, y, z - 2, quartz, 1, 2);
        this.setBlock(world, x + 10, y, z, quartz, 1, 2);
        this.setBlock(world, x + 10, y, z + 9, quartz, 1, 2);
        this.setBlock(world, x + 10, y, z + 11, quartz, 1, 2);
        this.setBlock(world, x + 10, y, z + 12, quartz, 1, 2);
        this.setBlock(world, x + 11, y, z - 3, quartz, 1, 2);
        this.setBlock(world, x + 11, y, z - 2, quartz, 1, 2);
        this.setBlock(world, x + 11, y, z - 1, quartz, 1, 2);
        this.setBlock(world, x + 11, y, z + 10, quartz, 1, 2);
        this.setBlock(world, x + 11, y, z + 11, quartz, 1, 2);
        this.setBlock(world, x + 11, y, z + 12, quartz, 1, 2);
        this.setBlock(world, x + 12, y, z - 2, quartz, 1, 2);
        this.setBlock(world, x + 12, y, z - 1, quartz, 1, 2);
        this.setBlock(world, x + 12, y, z + 10, quartz, 1, 2);
        this.setBlock(world, x + 12, y, z + 11, quartz, 1, 2);
        this.setBlock(world, x + 13, y, z - 2, quartz, 1, 2);
        this.setBlock(world, x + 13, y, z - 1, quartz, 1, 2);
        this.setBlock(world, x + 13, y, z + 10, quartz, 1, 2);
        this.setBlock(world, x + 13, y, z + 11, quartz, 1, 2);
        this.setBlock(world, x + 14, y, z - 1, quartz, 1, 2);
        this.setBlock(world, x + 14, y, z, quartz, 1, 2);
        this.setBlock(world, x + 14, y, z + 1, quartz, 1, 2);
        this.setBlock(world, x + 14, y, z + 2, quartz, 1, 2);
        this.setBlock(world, x + 14, y, z + 3, stone, 0, 2);
        this.setBlock(world, x + 14, y, z + 6, stone, 0, 2);
        this.setBlock(world, x + 14, y, z + 7, quartz, 1, 2);
        this.setBlock(world, x + 14, y, z + 8, quartz, 1, 2);
        this.setBlock(world, x + 14, y, z + 9, quartz, 1, 2);
        this.setBlock(world, x + 14, y, z + 10, quartz, 1, 2);
        this.setBlock(world, x + 15, y, z + 2, quartz, 1, 2);
        this.setBlock(world, x + 15, y, z + 3, stone, 0, 2);
        this.setBlock(world, x + 15, y, z + 6, stone, 0, 2);
        this.setBlock(world, x + 15, y, z + 7, quartz, 1, 2);
        this.setBlock(world, x - 5, ++y, z + 3, stone, 0, 2);
        this.setBlock(world, x - 5, y, z + 6, stone, 0, 2);
        this.setBlock(world, x - 4, y, z - 1, quartz, 1, 2);
        this.setBlock(world, x - 4, y, z, quartz, 1, 2);
        this.setBlock(world, x - 4, y, z + 1, quartz, 1, 2);
        this.setBlock(world, x - 4, y, z + 2, quartz, 1, 2);
        this.setBlock(world, x - 4, y, z + 3, stone, 0, 2);
        this.setBlock(world, x - 4, y, z + 6, stone, 0, 2);
        this.setBlock(world, x - 4, y, z + 7, quartz, 1, 2);
        this.setBlock(world, x - 4, y, z + 8, quartz, 1, 2);
        this.setBlock(world, x - 4, y, z + 9, quartz, 1, 2);
        this.setBlock(world, x - 4, y, z + 10, quartz, 1, 2);
        this.setBlock(world, x - 3, y, z - 1, quartz, 1, 2);
        this.setBlock(world, x - 3, y, z + 10, quartz, 1, 2);
        this.setBlock(world, x - 2, y, z - 1, quartz, 1, 2);
        this.setBlock(world, x - 2, y, z + 10, quartz, 1, 2);
        this.setBlock(world, x - 1, y, z - 3, quartz, 1, 2);
        this.setBlock(world, x - 1, y, z - 2, quartz, 1, 2);
        this.setBlock(world, x - 1, y, z - 1, quartz, 1, 2);
        this.setBlock(world, x - 1, y, z + 10, quartz, 1, 2);
        this.setBlock(world, x - 1, y, z + 11, quartz, 1, 2);
        this.setBlock(world, x - 1, y, z + 12, quartz, 1, 2);
        this.setBlock(world, x, y, z - 3, quartz, 1, 2);
        this.setBlock(world, x, y, z - 2, quartz, 1, 2);
        this.setBlock(world, x, y, z, quartz, 1, 2);
        this.setBlock(world, x, y, z + 9, quartz, 1, 2);
        this.setBlock(world, x, y, z + 11, quartz, 1, 2);
        this.setBlock(world, x, y, z + 12, quartz, 1, 2);
        this.setBlock(world, x + 1, y, z - 3, quartz, 1, 2);
        this.setBlock(world, x + 1, y, z + 12, quartz, 1, 2);
        this.setBlock(world, x + 2, y, z - 3, quartz, 1, 2);
        this.setBlock(world, x + 2, y, z + 12, quartz, 1, 2);
        this.setBlock(world, x + 3, y, z - 4, stone, 0, 2);
        this.setBlock(world, x + 3, y, z - 3, stone, 0, 2);
        this.setBlock(world, x + 3, y, z + 12, stone, 0, 2);
        this.setBlock(world, x + 3, y, z + 13, stone, 0, 2);
        this.setBlock(world, x + 7, y, z - 4, stone, 0, 2);
        this.setBlock(world, x + 7, y, z - 3, stone, 0, 2);
        this.setBlock(world, x + 7, y, z + 12, stone, 0, 2);
        this.setBlock(world, x + 7, y, z + 13, stone, 0, 2);
        this.setBlock(world, x + 8, y, z - 3, quartz, 1, 2);
        this.setBlock(world, x + 8, y, z + 12, quartz, 1, 2);
        this.setBlock(world, x + 9, y, z - 3, quartz, 1, 2);
        this.setBlock(world, x + 9, y, z + 12, quartz, 1, 2);
        this.setBlock(world, x + 10, y, z - 3, quartz, 1, 2);
        this.setBlock(world, x + 10, y, z - 2, quartz, 1, 2);
        this.setBlock(world, x + 10, y, z, quartz, 1, 2);
        this.setBlock(world, x + 10, y, z + 9, quartz, 1, 2);
        this.setBlock(world, x + 10, y, z + 11, quartz, 1, 2);
        this.setBlock(world, x + 10, y, z + 12, quartz, 1, 2);
        this.setBlock(world, x + 11, y, z - 3, quartz, 1, 2);
        this.setBlock(world, x + 11, y, z - 2, quartz, 1, 2);
        this.setBlock(world, x + 11, y, z - 1, quartz, 1, 2);
        this.setBlock(world, x + 11, y, z + 10, quartz, 1, 2);
        this.setBlock(world, x + 11, y, z + 11, quartz, 1, 2);
        this.setBlock(world, x + 11, y, z + 12, quartz, 1, 2);
        this.setBlock(world, x + 12, y, z - 1, quartz, 1, 2);
        this.setBlock(world, x + 12, y, z + 10, quartz, 1, 2);
        this.setBlock(world, x + 13, y, z - 1, quartz, 1, 2);
        this.setBlock(world, x + 13, y, z + 10, quartz, 1, 2);
        this.setBlock(world, x + 14, y, z - 1, quartz, 1, 2);
        this.setBlock(world, x + 14, y, z, quartz, 1, 2);
        this.setBlock(world, x + 14, y, z + 1, quartz, 1, 2);
        this.setBlock(world, x + 14, y, z + 2, quartz, 1, 2);
        this.setBlock(world, x + 14, y, z + 3, stone, 0, 2);
        this.setBlock(world, x + 14, y, z + 6, stone, 0, 2);
        this.setBlock(world, x + 14, y, z + 7, quartz, 1, 2);
        this.setBlock(world, x + 14, y, z + 8, quartz, 1, 2);
        this.setBlock(world, x + 14, y, z + 9, quartz, 1, 2);
        this.setBlock(world, x + 14, y, z + 10, quartz, 1, 2);
        this.setBlock(world, x + 15, y, z + 3, stone, 0, 2);
        this.setBlock(world, x + 15, y, z + 6, stone, 0, 2);
        this.setBlock(world, x - 5, ++y, z + 3, quartz, 1, 2);
        this.setBlock(world, x - 5, y, z + 4, stone, 0, 2);
        this.setBlock(world, x - 5, y, z + 5, stone, 0, 2);
        this.setBlock(world, x - 5, y, z + 6, quartz, 1, 2);
        this.setBlock(world, x - 4, y, z, quartz, 1, 2);
        this.setBlock(world, x - 4, y, z + 1, quartz, 1, 2);
        this.setBlock(world, x - 4, y, z + 2, quartz, 1, 2);
        this.setBlock(world, x - 4, y, z + 3, quartz, 1, 2);
        this.setBlock(world, x - 4, y, z + 4, stone, 0, 2);
        this.setBlock(world, x - 4, y, z + 5, stone, 0, 2);
        this.setBlock(world, x - 4, y, z + 6, quartz, 1, 2);
        this.setBlock(world, x - 4, y, z + 7, quartz, 1, 2);
        this.setBlock(world, x - 4, y, z + 8, quartz, 1, 2);
        this.setBlock(world, x - 4, y, z + 9, quartz, 1, 2);
        this.setBlock(world, x - 3, y, z - 1, quartz, 1, 2);
        this.setBlock(world, x - 3, y, z, quartz, 1, 2);
        this.setBlock(world, x - 3, y, z + 9, quartz, 1, 2);
        this.setBlock(world, x - 3, y, z + 10, quartz, 1, 2);
        this.setBlock(world, x - 2, y, z - 1, quartz, 1, 2);
        this.setBlock(world, x - 2, y, z + 10, quartz, 1, 2);
        this.setBlock(world, x - 1, y, z - 2, quartz, 1, 2);
        this.setBlock(world, x - 1, y, z - 1, quartz, 1, 2);
        this.setBlock(world, x - 1, y, z + 10, quartz, 1, 2);
        this.setBlock(world, x - 1, y, z + 11, quartz, 1, 2);
        this.setBlock(world, x, y, z - 3, quartz, 1, 2);
        this.setBlock(world, x, y, z - 2, quartz, 1, 2);
        this.setBlock(world, x, y, z, quartz, 1, 2);
        this.setBlock(world, x, y, z + 9, quartz, 1, 2);
        this.setBlock(world, x, y, z + 11, quartz, 1, 2);
        this.setBlock(world, x, y, z + 12, quartz, 1, 2);
        this.setBlock(world, x + 1, y, z - 3, quartz, 1, 2);
        this.setBlock(world, x + 1, y, z + 12, quartz, 1, 2);
        this.setBlock(world, x + 2, y, z - 3, quartz, 1, 2);
        this.setBlock(world, x + 2, y, z + 12, quartz, 1, 2);
        this.setBlock(world, x + 3, y, z - 4, quartz, 1, 2);
        this.setBlock(world, x + 3, y, z - 3, quartz, 1, 2);
        this.setBlock(world, x + 3, y, z + 12, quartz, 1, 2);
        this.setBlock(world, x + 3, y, z + 13, quartz, 1, 2);
        this.setBlock(world, x + 4, y, z - 4, stone, 0, 2);
        this.setBlock(world, x + 4, y, z - 3, stone, 0, 2);
        this.setBlock(world, x + 4, y, z + 12, stone, 0, 2);
        this.setBlock(world, x + 4, y, z + 13, stone, 0, 2);
        this.setBlock(world, x + 5, y, z - 4, stone, 0, 2);
        this.setBlock(world, x + 5, y, z - 3, stone, 0, 2);
        this.setBlock(world, x + 5, y, z + 12, stone, 0, 2);
        this.setBlock(world, x + 5, y, z + 13, stone, 0, 2);
        this.setBlock(world, x + 6, y, z - 4, stone, 0, 2);
        this.setBlock(world, x + 6, y, z - 3, stone, 0, 2);
        this.setBlock(world, x + 6, y, z + 12, stone, 0, 2);
        this.setBlock(world, x + 6, y, z + 13, stone, 0, 2);
        this.setBlock(world, x + 7, y, z - 4, quartz, 1, 2);
        this.setBlock(world, x + 7, y, z - 3, quartz, 1, 2);
        this.setBlock(world, x + 7, y, z + 12, quartz, 1, 2);
        this.setBlock(world, x + 7, y, z + 13, quartz, 1, 2);
        this.setBlock(world, x + 8, y, z - 3, quartz, 1, 2);
        this.setBlock(world, x + 8, y, z + 12, quartz, 1, 2);
        this.setBlock(world, x + 9, y, z - 3, quartz, 1, 2);
        this.setBlock(world, x + 9, y, z + 12, quartz, 1, 2);
        this.setBlock(world, x + 10, y, z - 3, quartz, 1, 2);
        this.setBlock(world, x + 10, y, z - 2, quartz, 1, 2);
        this.setBlock(world, x + 10, y, z, quartz, 1, 2);
        this.setBlock(world, x + 10, y, z + 9, quartz, 1, 2);
        this.setBlock(world, x + 10, y, z + 11, quartz, 1, 2);
        this.setBlock(world, x + 10, y, z + 12, quartz, 1, 2);
        this.setBlock(world, x + 11, y, z - 2, quartz, 1, 2);
        this.setBlock(world, x + 11, y, z - 1, quartz, 1, 2);
        this.setBlock(world, x + 11, y, z + 10, quartz, 1, 2);
        this.setBlock(world, x + 11, y, z + 11, quartz, 1, 2);
        this.setBlock(world, x + 12, y, z - 1, quartz, 1, 2);
        this.setBlock(world, x + 12, y, z + 10, quartz, 1, 2);
        this.setBlock(world, x + 13, y, z - 1, quartz, 1, 2);
        this.setBlock(world, x + 13, y, z, quartz, 1, 2);
        this.setBlock(world, x + 13, y, z + 9, quartz, 1, 2);
        this.setBlock(world, x + 13, y, z + 10, quartz, 1, 2);
        this.setBlock(world, x + 14, y, z, quartz, 1, 2);
        this.setBlock(world, x + 14, y, z + 1, quartz, 1, 2);
        this.setBlock(world, x + 14, y, z + 2, quartz, 1, 2);
        this.setBlock(world, x + 14, y, z + 3, stone, 0, 2);
        this.setBlock(world, x + 14, y, z + 6, stone, 0, 2);
        this.setBlock(world, x + 14, y, z + 7, quartz, 1, 2);
        this.setBlock(world, x + 14, y, z + 8, quartz, 1, 2);
        this.setBlock(world, x + 14, y, z + 9, quartz, 1, 2);
        this.setBlock(world, x + 15, y, z + 3, quartz, 1, 2);
        this.setBlock(world, x + 15, y, z + 4, stone, 0, 2);
        this.setBlock(world, x + 15, y, z + 5, stone, 0, 2);
        this.setBlock(world, x + 15, y, z + 6, quartz, 1, 2);
        this.setBlock(world, x - 4, ++y, z + 1, quartz, 1, 2);
        this.setBlock(world, x - 4, y, z + 2, quartz, 1, 2);
        this.setBlock(world, x - 4, y, z + 3, quartz, 1, 2);
        this.setBlock(world, x - 4, y, z + 4, quartz, 1, 2);
        this.setBlock(world, x - 4, y, z + 5, quartz, 1, 2);
        this.setBlock(world, x - 4, y, z + 6, quartz, 1, 2);
        this.setBlock(world, x - 4, y, z + 7, quartz, 1, 2);
        this.setBlock(world, x - 4, y, z + 8, quartz, 1, 2);
        this.setBlock(world, x - 3, y, z, quartz, 1, 2);
        this.setBlock(world, x - 3, y, z + 9, quartz, 1, 2);
        this.setBlock(world, x - 2, y, z - 1, quartz, 1, 2);
        this.setBlock(world, x - 2, y, z + 10, quartz, 1, 2);
        this.setBlock(world, x - 1, y, z - 1, quartz, 1, 2);
        this.setBlock(world, x - 1, y, z + 10, quartz, 1, 2);
        this.setBlock(world, x, y, z - 2, quartz, 1, 2);
        this.setBlock(world, x, y, z, quartz, 1, 2);
        this.setBlock(world, x, y, z + 9, quartz, 1, 2);
        this.setBlock(world, x, y, z + 11, quartz, 1, 2);
        this.setBlock(world, x + 1, y, z - 3, quartz, 1, 2);
        this.setBlock(world, x + 1, y, z + 12, quartz, 1, 2);
        this.setBlock(world, x + 2, y, z - 3, quartz, 1, 2);
        this.setBlock(world, x + 2, y, z + 12, quartz, 1, 2);
        this.setBlock(world, x + 3, y, z - 3, quartz, 1, 2);
        this.setBlock(world, x + 3, y, z + 12, quartz, 1, 2);
        this.setBlock(world, x + 4, y, z - 3, quartz, 1, 2);
        this.setBlock(world, x + 4, y, z + 12, quartz, 1, 2);
        this.setBlock(world, x + 5, y, z - 3, quartz, 1, 2);
        this.setBlock(world, x + 5, y, z + 12, quartz, 1, 2);
        this.setBlock(world, x + 6, y, z - 3, quartz, 1, 2);
        this.setBlock(world, x + 6, y, z + 12, quartz, 1, 2);
        this.setBlock(world, x + 7, y, z - 3, quartz, 1, 2);
        this.setBlock(world, x + 7, y, z + 12, quartz, 1, 2);
        this.setBlock(world, x + 8, y, z - 3, quartz, 1, 2);
        this.setBlock(world, x + 8, y, z + 12, quartz, 1, 2);
        this.setBlock(world, x + 9, y, z - 3, quartz, 1, 2);
        this.setBlock(world, x + 9, y, z + 12, quartz, 1, 2);
        this.setBlock(world, x + 10, y, z - 2, quartz, 1, 2);
        this.setBlock(world, x + 10, y, z, quartz, 1, 2);
        this.setBlock(world, x + 10, y, z + 9, quartz, 1, 2);
        this.setBlock(world, x + 10, y, z + 11, quartz, 1, 2);
        this.setBlock(world, x + 11, y, z - 1, quartz, 1, 2);
        this.setBlock(world, x + 11, y, z + 10, quartz, 1, 2);
        this.setBlock(world, x + 12, y, z - 1, quartz, 1, 2);
        this.setBlock(world, x + 12, y, z + 10, quartz, 1, 2);
        this.setBlock(world, x + 13, y, z, quartz, 1, 2);
        this.setBlock(world, x + 13, y, z + 9, quartz, 1, 2);
        this.setBlock(world, x + 14, y, z, quartz, 1, 2);
        this.setBlock(world, x + 14, y, z + 1, quartz, 1, 2);
        this.setBlock(world, x + 14, y, z + 2, quartz, 1, 2);
        this.setBlock(world, x + 14, y, z + 3, quartz, 1, 2);
        this.setBlock(world, x + 14, y, z + 4, quartz, 1, 2);
        this.setBlock(world, x + 14, y, z + 5, quartz, 1, 2);
        this.setBlock(world, x + 14, y, z + 6, quartz, 1, 2);
        this.setBlock(world, x + 14, y, z + 7, quartz, 1, 2);
        this.setBlock(world, x + 14, y, z + 8, quartz, 1, 2);
        this.setBlock(world, x + 14, y, z + 9, quartz, 1, 2);
        this.setBlock(world, x, ++y, z, quartz, 1, 2);
        this.setBlock(world, x, y, z + 1, quartz, 1, 2);
        this.setBlock(world, x, y, z + 2, quartz, 1, 2);
        this.setBlock(world, x, y, z + 3, quartz, 1, 2);
        this.setBlock(world, x, y, z + 4, quartz, 1, 2);
        this.setBlock(world, x, y, z + 5, quartz, 1, 2);
        this.setBlock(world, x, y, z + 6, quartz, 1, 2);
        this.setBlock(world, x, y, z + 7, quartz, 1, 2);
        this.setBlock(world, x, y, z + 8, quartz, 1, 2);
        this.setBlock(world, x, y, z + 9, quartz, 1, 2);
        this.setBlock(world, x + 1, y, z, quartz, 1, 2);
        this.setBlock(world, x + 1, y, z + 9, quartz, 1, 2);
        this.setBlock(world, x + 2, y, z, quartz, 1, 2);
        this.setBlock(world, x + 2, y, z + 9, quartz, 1, 2);
        this.setBlock(world, x + 3, y, z, quartz, 1, 2);
        this.setBlock(world, x + 3, y, z + 9, quartz, 1, 2);
        this.setBlock(world, x + 4, y, z, quartz, 1, 2);
        this.setBlock(world, x + 4, y, z + 9, quartz, 1, 2);
        this.setBlock(world, x + 5, y, z, quartz, 1, 2);
        this.setBlock(world, x + 5, y, z + 9, quartz, 1, 2);
        this.setBlock(world, x + 6, y, z, quartz, 1, 2);
        this.setBlock(world, x + 6, y, z + 9, quartz, 1, 2);
        this.setBlock(world, x + 7, y, z, quartz, 1, 2);
        this.setBlock(world, x + 7, y, z + 9, quartz, 1, 2);
        this.setBlock(world, x + 8, y, z, quartz, 1, 2);
        this.setBlock(world, x + 8, y, z + 9, quartz, 1, 2);
        this.setBlock(world, x + 9, y, z, quartz, 1, 2);
        this.setBlock(world, x + 9, y, z + 9, quartz, 1, 2);
        this.setBlock(world, x + 10, y, z, quartz, 1, 2);
        this.setBlock(world, x + 10, y, z + 1, quartz, 1, 2);
        this.setBlock(world, x + 10, y, z + 2, quartz, 1, 2);
        this.setBlock(world, x + 10, y, z + 3, quartz, 1, 2);
        this.setBlock(world, x + 10, y, z + 4, quartz, 1, 2);
        this.setBlock(world, x + 10, y, z + 5, quartz, 1, 2);
        this.setBlock(world, x + 10, y, z + 6, quartz, 1, 2);
        this.setBlock(world, x + 10, y, z + 7, quartz, 1, 2);
        this.setBlock(world, x + 10, y, z + 8, quartz, 1, 2);
        this.setBlock(world, x + 10, y, z + 9, quartz, 1, 2);
        return this;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("variant", this.variant);
        return tag;
    }

    @Override
    public Schematic readFromNBT(NBTTagCompound tag) {
        this.variant = tag.func_74762_e("variant");
        return this;
    }
}

