/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen.schematic;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockMobSpawner;
import net.minecraft.block.BlockSign;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.Vec3i;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicMC;
import tragicneko.tragicmc.util.Tuple;
import tragicneko.tragicmc.worldgen.structure.Structure;

public abstract class Schematic {
    public HashMap<BlockPos, PosPreset> map;
    public List<Tuple<BlockPos, Entity>> entityList;
    public LinkedList<PosPreset> list;
    public int width;
    public int depth;
    public int height;
    public int placedBlocks = 0;
    public final BlockPos origin;
    public World worldObj;
    public final Structure structure;
    public ArrayList<Schematic> childSchematics = new ArrayList();

    public Schematic(BlockPos origin, Structure structure, World world, int h, int w, int d) {
        this.map = new LinkedHashMap<BlockPos, PosPreset>();
        this.origin = origin;
        this.structure = structure;
        this.worldObj = world;
        this.height = h;
        this.width = w;
        this.depth = d;
    }

    public void setChild(Schematic sch) {
        this.childSchematics.add(sch);
    }

    public boolean hasChildren() {
        return !this.childSchematics.isEmpty();
    }

    public void retrogradeBuildProgress() {
        int b = 0;
        int i = 0;
        boolean hasContinued = false;
        for (int j = 0; j < this.list.size(); ++j) {
            PosPreset pos = this.list.get(j);
            if (i++ < this.placedBlocks && !hasContinued) {
                pos.placed = true;
                ++b;
                continue;
            }
            hasContinued = true;
            if (!pos.placed) continue;
            ++b;
        }
    }

    public int getPlacedBlocks() {
        return this.placedBlocks;
    }

    public int getTotalBlocks() {
        return this.list.size();
    }

    public boolean hasFinished() {
        return this.placedBlocks >= this.getTotalBlocks();
    }

    public void setMappedBlock(World world, PosPreset preset) {
        world.func_180501_a(this.origin.func_177971_a((Vec3i)preset.pos), preset.state, 3);
        if (preset.tileEntity) {
            preset.handleTileEntity(world, this.origin);
        }
        preset.placed = true;
    }

    public abstract Schematic generateStructure(World var1, Random var2, int var3, int var4, int var5);

    private static boolean applyChestContents(World world, Random rand, BlockPos pos, ChestGenHooks hook) {
        if (world.field_72995_K || pos.func_177956_o() <= 0 || pos.func_177956_o() >= 256) {
            return false;
        }
        TileEntityChest tileentity = (TileEntityChest)world.func_175625_s(pos);
        if (tileentity != null) {
            WeightedRandomChestContent.func_177630_a((Random)rand, (List)hook.getItems(rand), (IInventory)tileentity, (int)hook.getCount(rand));
            return true;
        }
        TragicMC.logWarning("Chest generation failed. The tile entity was null.");
        return false;
    }

    private static boolean applyFurnaceContents(World world, Random rand, BlockPos pos, ItemStack fuel, ItemStack toCook, ItemStack result) {
        if (world.field_72995_K || pos.func_177956_o() <= 0 || pos.func_177956_o() >= 256) {
            return false;
        }
        TileEntityFurnace tileentity = (TileEntityFurnace)world.func_175625_s(pos);
        if (tileentity != null) {
            tileentity.func_70299_a(0, toCook);
            tileentity.func_70299_a(1, fuel);
            tileentity.func_70299_a(2, result);
            return true;
        }
        TragicMC.logWarning("Furnace generation failed. The tile entity was null.");
        return false;
    }

    private static boolean addSignContents(World world, BlockPos pos, int line, String text) {
        TileEntitySign sign = (TileEntitySign)world.func_175625_s(pos);
        if (sign == null || line > 4) {
            TragicMC.logWarning("Sign text setup failed. The tile entity was null or an improper text line was chosen.");
            return false;
        }
        sign.field_145915_a[line] = new ChatComponentText(text);
        return true;
    }

    private static boolean setSpawnerMob(World world, BlockPos pos, String mobName, boolean limit) {
        TileEntityMobSpawner spawner = (TileEntityMobSpawner)world.func_175625_s(pos);
        if (spawner == null || mobName == null) {
            TragicMC.logWarning("Spawner setup failed. The tile entity was null or mobName was null.");
            return false;
        }
        if (limit) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("EntityId", mobName);
            tag.func_74777_a("Delay", (short)120);
            tag.func_74777_a("MinSpawnDelay", (short)600);
            tag.func_74777_a("MaxSpawnDelay", (short)1600);
            tag.func_74777_a("SpawnCount", (short)2);
            tag.func_74777_a("MaxNearbyEntities", (short)4);
            tag.func_74777_a("RequiredPlayerRange", (short)8);
            spawner.func_145881_a().func_98270_a(tag);
        } else {
            spawner.func_145881_a().func_98272_a(mobName);
        }
        return true;
    }

    public void setBlockToAir(World world, int x, int y, int z) {
        this.setBlock(world, x, y, z, Blocks.field_150350_a);
    }

    public void setBlock(World world, int x, int y, int z, Block block) {
        this.setBlock(world, x, y, z, block, 0, 3);
    }

    public void setBlock(World world, int x, int y, int z, Block block, int meta, int flag) {
        this.setBlock(world, x, y, z, block, meta, 3, new Object[0]);
    }

    public void setBlock(World world, int x, int y, int z, Block block, int meta, int flag, Object ... params) {
        this.setBlock(world, new BlockPos(x, y, z), block.func_176203_a(meta), params);
    }

    public void setBlock(World world, BlockPos pos, IBlockState state) {
        this.setBlock(world, pos, state, new Object[0]);
    }

    public void setBlock(World world, BlockPos pos, IBlockState state, Object ... params) {
        if (TragicConfig.getBoolean("allowTickBuilder")) {
            this.setBlockToMap(pos, state, params);
        } else {
            world.func_180501_a(pos, state, 3);
            if (state.func_177230_c() instanceof BlockSign) {
                if (params[0] instanceof String) {
                    new SignPreset(pos.func_177973_b((Vec3i)this.origin), state, (String)params[0]).handleTileEntity(world, this.origin);
                } else {
                    new SignPreset(pos.func_177973_b((Vec3i)this.origin), state, (String[])params[0]).handleTileEntity(world, this.origin);
                }
            } else if (state.func_177230_c() instanceof BlockMobSpawner) {
                new SpawnerPreset(pos.func_177973_b((Vec3i)this.origin), state, (String)params[0], this.shouldLimitSpawnerRate()).handleTileEntity(world, this.origin);
            } else if (state.func_177230_c() instanceof BlockChest) {
                new ChestPreset(pos.func_177973_b((Vec3i)this.origin), state, (ChestGenHooks)params[0]).handleTileEntity(world, this.origin);
            } else if (state.func_177230_c() instanceof BlockFurnace) {
                new FurnacePreset(pos.func_177973_b((Vec3i)this.origin), state, (ItemStack)params[0], (ItemStack)params[1], (ItemStack)params[2]).handleTileEntity(world, this.origin);
            }
        }
    }

    public void setBlockToMap(BlockPos pos, IBlockState state, Object[] params) {
        pos = pos.func_177973_b((Vec3i)this.origin);
        if (state.func_177230_c() instanceof BlockSign) {
            if (params[0] instanceof String) {
                this.map.put(pos, new SignPreset(pos, state, (String)params[0]));
            } else {
                this.map.put(pos, new SignPreset(pos, state, (String[])params[0]));
            }
        } else if (state.func_177230_c() instanceof BlockMobSpawner) {
            this.map.put(pos, new SpawnerPreset(pos, state, (String)params[0], this.shouldLimitSpawnerRate()));
        } else if (state.func_177230_c() instanceof BlockChest) {
            this.map.put(pos, new ChestPreset(pos, state, (ChestGenHooks)params[0]));
        } else if (state.func_177230_c() instanceof BlockFurnace) {
            this.map.put(pos, new FurnacePreset(pos, state, (ItemStack)params[0], (ItemStack)params[1], (ItemStack)params[2]));
        } else {
            this.map.put(pos, new PosPreset(pos, state));
        }
    }

    public void spawnEntity(World world, BlockPos pos, Entity entity) {
        if (TragicConfig.getBoolean("allowTickBuilder")) {
            if (this.entityList == null) {
                this.entityList = new ArrayList<Tuple<BlockPos, Entity>>();
            }
            this.entityList.add(new Tuple<BlockPos, Entity>(pos, entity));
        } else {
            entity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            world.func_72838_d(entity);
        }
    }

    public boolean shouldLimitSpawnerRate() {
        return false;
    }

    public Schematic sortIntoList() {
        if (this.hasChildren()) {
            for (int i = 0; i < this.childSchematics.size(); ++i) {
                Schematic child = this.childSchematics.get(i);
                BlockPos diff = child.origin.func_177973_b((Vec3i)this.origin);
                for (Map.Entry<BlockPos, PosPreset> entry : child.map.entrySet()) {
                    PosPreset pre = entry.getValue();
                    pre.pos = pre.pos.func_177971_a((Vec3i)diff);
                    this.map.put(entry.getKey().func_177971_a((Vec3i)diff), pre);
                }
                this.childSchematics.get((int)i).map.clear();
            }
        }
        this.list = new LinkedList();
        for (Map.Entry<BlockPos, PosPreset> entry : this.map.entrySet()) {
            this.list.add(entry.getValue());
        }
        this.map.clear();
        return this;
    }

    public abstract NBTTagCompound writeToNBT(NBTTagCompound var1);

    public abstract Schematic readFromNBT(NBTTagCompound var1);

    public static class FurnacePreset
    extends PosPreset {
        private final ItemStack fuel;
        private final ItemStack toCook;
        private final ItemStack result;

        public FurnacePreset(BlockPos pos, IBlockState state, ItemStack fuel, ItemStack toCook, ItemStack result) {
            super(pos, state, true);
            this.fuel = fuel;
            this.toCook = toCook;
            this.result = result;
        }

        @Override
        public void handleTileEntity(World world, BlockPos pos) {
            pos = pos.func_177971_a((Vec3i)this.pos);
            Schematic.applyFurnaceContents(world, world.field_73012_v, pos, this.fuel, this.toCook, this.result);
        }
    }

    public static class ChestPreset
    extends PosPreset {
        public final ChestGenHooks hook;

        public ChestPreset(BlockPos pos, IBlockState state, ChestGenHooks hook) {
            super(pos, state, true);
            this.hook = hook;
        }

        @Override
        public void handleTileEntity(World world, BlockPos pos) {
            pos = pos.func_177971_a((Vec3i)this.pos);
            Schematic.applyChestContents(world, world.field_73012_v, pos, this.hook);
        }
    }

    public static class SignPreset
    extends PosPreset {
        public final String[] signContents;

        public SignPreset(BlockPos pos, IBlockState state, String signContent) {
            this(pos, state, new String[]{signContent});
        }

        public SignPreset(BlockPos pos, IBlockState state, String[] signContent) {
            super(pos, state, true);
            this.signContents = signContent;
        }

        @Override
        public void handleTileEntity(World world, BlockPos pos) {
            pos = pos.func_177971_a((Vec3i)this.pos);
            for (int i = 0; i < this.signContents.length; ++i) {
                Schematic.addSignContents(world, pos, i, this.signContents[i]);
            }
        }
    }

    public static class SpawnerPreset
    extends PosPreset {
        public final String mobName;
        public final boolean limitSpawnRate;

        public SpawnerPreset(BlockPos pos, IBlockState state, String mobName, boolean limitSpawnRate) {
            super(pos, state, true);
            this.mobName = mobName;
            this.limitSpawnRate = limitSpawnRate;
        }

        @Override
        public void handleTileEntity(World world, BlockPos pos) {
            pos = pos.func_177971_a((Vec3i)this.pos);
            Schematic.setSpawnerMob(world, pos, this.mobName, this.limitSpawnRate);
        }
    }

    public static class PosPreset
    implements Comparable {
        public BlockPos pos;
        public final boolean tileEntity;
        public final IBlockState state;
        public boolean placed = false;

        public PosPreset(BlockPos pos, IBlockState state, boolean isTileEntity) {
            this.pos = pos;
            this.state = state;
            this.tileEntity = isTileEntity;
        }

        public PosPreset(BlockPos pos, IBlockState state) {
            this(pos, state, false);
        }

        public int getX() {
            return this.pos.func_177958_n();
        }

        public int getY() {
            return this.pos.func_177956_o();
        }

        public int getZ() {
            return this.pos.func_177952_p();
        }

        public void handleTileEntity(World world, BlockPos origin) {
        }

        public String toString() {
            return new String("preset:[" + this.pos + "," + this.state + ",tileentity=" + this.tileEntity + "]");
        }

        public int compareTo(Object o) {
            return this.compare((PosPreset)o);
        }

        public int compare(PosPreset pre) {
            if (this.tileEntity || this.state.func_177230_c() instanceof BlockLadder) {
                if (this.tileEntity && pre.state.func_177230_c() instanceof BlockLadder) {
                    return 1;
                }
                if (pre.tileEntity && this.state.func_177230_c() instanceof BlockLadder) {
                    return -1;
                }
                if (this.tileEntity && pre.tileEntity || this.state.func_177230_c() instanceof BlockLadder && pre.state.func_177230_c() instanceof BlockLadder) {
                    if (this.getY() >= pre.getY()) {
                        if (this.getX() >= pre.getX()) {
                            if (this.getZ() > pre.getZ()) {
                                return 1;
                            }
                            if (this.getZ() == pre.getZ()) {
                                return 0;
                            }
                            return -1;
                        }
                        return -1;
                    }
                    return -1;
                }
                return -1;
            }
            if (pre.tileEntity || pre.state.func_177230_c() instanceof BlockLadder) {
                return 1;
            }
            if (this.getY() >= pre.getY()) {
                if (this.getX() >= pre.getX()) {
                    if (this.getZ() > pre.getZ()) {
                        return 1;
                    }
                    if (this.getZ() == pre.getZ()) {
                        return 0;
                    }
                    return -1;
                }
                return -1;
            }
            return -1;
        }
    }

    public static class PosComparator
    implements Comparator<PosPreset> {
        @Override
        public int compare(PosPreset o1, PosPreset o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1.equals(o2)) {
                return 0;
            }
            int comp = o1.compareTo(o2);
            if (comp != 0) {
                return comp;
            }
            return o1.hashCode() - o2.hashCode() > 0 ? 1 : -1;
        }
    }
}

