/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen.biome;

import java.util.Random;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import tragicneko.tragicmc.TragicBiome;
import tragicneko.tragicmc.TragicBlocks;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.entity.mob.EntityPsygote;
import tragicneko.tragicmc.entity.mob.EntityStin;
import tragicneko.tragicmc.worldgen.CustomSpikesWorldGen;
import tragicneko.tragicmc.worldgen.InvertedSpikeWorldGen;
import tragicneko.tragicmc.worldgen.IsleWorldGen;
import tragicneko.tragicmc.worldgen.RuggedTerrainWorldGen;

public class BiomeGenTaintedSpikes
extends TragicBiome {
    private final CustomSpikesWorldGen spikeWorldGen;
    private final InvertedSpikeWorldGen scarGen;
    private final RuggedTerrainWorldGen ruggedGen;
    private final IsleWorldGen isleGen;
    public static final float[][] heights = new float[][]{{0.45f, 0.05f}, {0.35f, -0.95f}, {1.85f, 0.45f}, {0.05f, 0.65f}, {0.25f, -0.65f}};

    public BiomeGenTaintedSpikes(int par1, byte par2) {
        super(par1, par2);
        if (TragicConfig.getBoolean("allowPsygote")) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityPsygote.class, TragicConfig.getInt("psygoteSpawnChance"), TragicConfig.getIntArray("psygoteGroupSize")[0], TragicConfig.getIntArray("psygoteGroupSize")[1]));
        }
        if (TragicConfig.getBoolean("allowStin")) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityStin.class, TragicConfig.getInt("stinSpawnChance"), TragicConfig.getIntArray("stinGroupSize")[0], TragicConfig.getIntArray("stinGroupSize")[1]));
        }
        if (TragicConfig.getBoolean("allowGreaterStin")) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityStin.class, TragicConfig.getInt("greaterStinSpawnChance"), TragicConfig.getIntArray("greaterStinGroupSize")[0], TragicConfig.getIntArray("greaterStinGroupSize")[1]));
        }
        this.field_76766_R = false;
        this.field_76750_F = 1.8f;
        this.field_76751_G = 2.0f;
        this.field_76760_I.field_76798_D = this.variant == 1 ? 16 : 2;
        this.field_76749_E = heights[this.variant][0];
        this.field_76748_D = heights[this.variant][1];
        this.field_76753_B = TragicBlocks.DarkStone.func_176223_P();
        this.field_76752_A = TragicBlocks.ErodedStone.func_176223_P();
        this.spikeWorldGen = new CustomSpikesWorldGen((byte)(this.variant == 0 ? 3 : 1), TragicBlocks.Spike, 0, 0.93477745, 0.42943755, 1.5, 1.0);
        this.scarGen = new InvertedSpikeWorldGen(4, 1.5, 2.5, 0.91977745, 0.48943755);
        this.ruggedGen = new RuggedTerrainWorldGen(TragicBlocks.ErodedStone, 2, TragicBlocks.ErodedStone, 3, 2.0, 2.5, true, 8);
        this.isleGen = new IsleWorldGen();
    }

    public void func_180624_a(World world, Random rand, BlockPos pos) {
        super.func_180624_a(world, rand, pos);
        if (this.variant == 4 && rand.nextInt(3) == 0) {
            this.isleGen.generate(rand, pos.func_177958_n() / 16, pos.func_177952_p() / 16, world);
        }
        if (this.variant < 3 && rand.nextInt(100) >= 3 && rand.nextBoolean()) {
            this.spikeWorldGen.generate(rand, pos.func_177958_n() / 16, pos.func_177952_p() / 16, world);
        }
        if (this.variant == 3) {
            if (rand.nextInt(100) > 5 && rand.nextInt(3) != 0) {
                this.scarGen.generate(rand, pos.func_177958_n() / 16, pos.func_177952_p() / 16, world);
            }
            this.ruggedGen.generate(rand, pos.func_177958_n() / 16, pos.func_177952_p() / 16, world);
        }
    }
}

